require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_MVME68K_INTR_H_)) {
    eval 'sub _MVME68K_INTR_H_ () {1;}' unless defined(&_MVME68K_INTR_H_);
    require 'machine/psl.ph';
    if(defined(&_KERNEL)) {
	eval 'sub SIR_NET () {0x1;}' unless defined(&SIR_NET);
	eval 'sub SIR_CLOCK () {0x2;}' unless defined(&SIR_CLOCK);
	eval 'sub siron {
	    my($mask) = @_;
    	    eval q( &__asm  &__volatile ( \\"orb %1,%0\\" : \\"=m\\" ( &ssir) : \\"ir\\" ($mask)));
	}' unless defined(&siron);
	eval 'sub siroff {
	    my($mask) = @_;
    	    eval q( &__asm  &__volatile ( \\"andb %1,%0\\" : \\"=m\\" ( &ssir) : \\"ir\\" (~($mask))));
	}' unless defined(&siroff);
	eval 'sub setsoftint {
	    my($s) = @_;
    	    eval q( &siron($s));
	}' unless defined(&setsoftint);
	eval 'sub setsoftnet () {
	    eval q( &siron( &SIR_NET));
	}' unless defined(&setsoftnet);
	eval 'sub setsoftclock () {
	    eval q( &siron( &SIR_CLOCK));
	}' unless defined(&setsoftclock);
	eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
	eval 'sub IPL_SOFTNET () {1;}' unless defined(&IPL_SOFTNET);
	eval 'sub IPL_SOFTCLOCK () {1;}' unless defined(&IPL_SOFTCLOCK);
	eval 'sub IPL_BIO () {2;}' unless defined(&IPL_BIO);
	eval 'sub IPL_NET () {3;}' unless defined(&IPL_NET);
	eval 'sub IPL_TTY () {3;}' unless defined(&IPL_TTY);
	eval 'sub IPL_VM () {3;}' unless defined(&IPL_VM);
	eval 'sub IPL_CLOCK () {5;}' unless defined(&IPL_CLOCK);
	eval 'sub IPL_STATCLOCK () {5;}' unless defined(&IPL_STATCLOCK);
	eval 'sub IPL_HIGH () {7;}' unless defined(&IPL_HIGH);
	eval 'sub splsoft () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL1));
	}' unless defined(&splsoft);
	eval 'sub splsoftclock () {
	    eval q( &splsoft());
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splsoft());
	}' unless defined(&splsoftnet);
	eval 'sub splbio () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL2));
	}' unless defined(&splbio);
	eval 'sub splnet () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL3));
	}' unless defined(&splnet);
	eval 'sub spltty () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL3));
	}' unless defined(&spltty);
	eval 'sub splvm () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL3));
	}' unless defined(&splvm);
	eval 'sub splclock () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL5));
	}' unless defined(&splclock);
	eval 'sub splstatclock () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL5));
	}' unless defined(&splstatclock);
	eval 'sub splhigh () {
	    eval q( &_spl( &PSL_S |  &PSL_IPL7));
	}' unless defined(&splhigh);
	eval 'sub splsched () {
	    eval q( &splhigh());
	}' unless defined(&splsched);
	eval 'sub splx {
	    my($s) = @_;
    	    eval q((($s) &  &PSL_IPL ?  &_spl($s) :  &spl0()));
	}' unless defined(&splx);
    }
}
1;
