require '_h2ph_pre.ph';

no warnings 'redefine';

if(defined(&_KERNEL)) {
    if(defined(&_LOCORE)) {
	require 'machine/psl.ph';
    } else {
	require 'machine/cpu.ph';
    }
}
unless(defined(&_MACHINE)) {
    sub _MACHINE () {	 &i386;}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"i386";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	 &i386;}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"i386";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_I386;}
}
unless(defined(&ALIGNBYTES)) {
    sub ALIGNBYTES () {	($sizeof{'int'} - 1);}
}
unless(defined(&ALIGN)) {
    sub ALIGN {
	my($p) = @_;
	eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }
}
unless(defined(&ALIGNED_POINTER)) {
    sub ALIGNED_POINTER {
	my($p,$t) = @_;
	eval q(1);
    }
}
unless(defined(&PGSHIFT)) {
    sub PGSHIFT () {	12;}
}
unless(defined(&NBPG)) {
    sub NBPG () {	(1<<  &PGSHIFT);}
}
unless(defined(&PGOFSET)) {
    sub PGOFSET () {	( &NBPG-1);}
}
unless(defined(&PAGE_SHIFT)) {
    sub PAGE_SHIFT () {	12;}
}
unless(defined(&PAGE_SIZE)) {
    sub PAGE_SIZE () {	(1<<  &PAGE_SHIFT);}
}
unless(defined(&PAGE_MASK)) {
    sub PAGE_MASK () {	( &PAGE_SIZE - 1);}
}
unless(defined(&NPTEPG)) {
    sub NPTEPG () {	( &NBPG/($sizeof{ &pt_entry_t}));}
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0xd0000000;}
}
unless(defined(&KERNTEXTOFF)) {
    sub KERNTEXTOFF () {	( &KERNBASE+0x200000);}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	(1<<  &DEV_BSHIFT);}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
}
unless(defined(&UPAGES)) {
    sub UPAGES () {	2;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	( &UPAGES *  &NBPG);}
}
unless(defined(&USPACE_ALIGN)) {
    sub USPACE_ALIGN () {	(0);}
}
unless(defined(&MSGBUFSIZE)) {
    eval 'sub MSGBUFSIZE () {4* &NBPG;}' unless defined(&MSGBUFSIZE);
}
unless(defined(&NMBCLUSTERS)) {
    sub NMBCLUSTERS () {	6144;}
}
unless(defined(&NKMEMPAGES_MIN_DEFAULT)) {
    sub NKMEMPAGES_MIN_DEFAULT () {	((8* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&NKMEMPAGES_MAX_DEFAULT)) {
    sub NKMEMPAGES_MAX_DEFAULT () {	((64* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&ctod)) {
    sub ctod {
	my($x) = @_;
	eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dtoc)) {
    sub dtoc {
	my($x) = @_;
	eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dbtob)) {
    sub dbtob {
	my($x) = @_;
	eval q((($x) <<  &DEV_BSHIFT));
    }
}
unless(defined(&btodb)) {
    sub btodb {
	my($x) = @_;
	eval q((($x) >>  &DEV_BSHIFT));
    }
}
unless(defined(&i386_round_pdr)) {
    sub i386_round_pdr {
	my($x) = @_;
	eval q((((($x)) +  &PDOFSET) & ~ &PDOFSET));
    }
}
unless(defined(&i386_trunc_pdr)) {
    sub i386_trunc_pdr {
	my($x) = @_;
	eval q((($x) & ~ &PDOFSET));
    }
}
1;
