require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&BOOT_ELF)) {
    sub BOOT_ELF () {	1;}
}
unless(defined(&BOOT_ELF32)) {
    sub BOOT_ELF32 () {	1;}
}
unless(defined(&BOOT_ELF64)) {
    sub BOOT_ELF64 () {	1;}
}
unless(defined(&ELFSIZE)) {
    sub ELFSIZE () {	32;}
}
unless(defined(&LOAD_KERNEL)) {
    sub LOAD_KERNEL () {	( &LOAD_ALL & ~ &LOAD_TEXTA);}
}
unless(defined(&COUNT_KERNEL)) {
    sub COUNT_KERNEL () {	( &COUNT_ALL & ~ &COUNT_TEXTA);}
}
unless(defined(&LOADADDR)) {
    sub LOADADDR {
	my($a) = @_;
	eval q((((($a)) +  &offset)&0xfffffff));
    }
}
unless(defined(&ALIGNENTRY)) {
    sub ALIGNENTRY {
	my($a) = @_;
	eval q((($a)));
    }
}
unless(defined(&READ)) {
    sub READ {
	my($f, $b, $c) = @_;
	eval q( &read(($f), ( &void *) &LOADADDR, ($c)));
    }
}
unless(defined(&BCOPY)) {
    sub BCOPY {
	my($s, $d, $c) = @_;
	eval q( &memcpy(( &void *) &LOADADDR($d), ( &void *)($s), ($c)));
    }
}
unless(defined(&BZERO)) {
    sub BZERO {
	my($d, $c) = @_;
	eval q( &memset(( &void *) &LOADADDR($d), 0, ($c)));
    }
}
unless(defined(&WARN)) {
    sub WARN {
	my($a) = @_;
	eval q(( &void)( &printf $a,  &printf(( &errno ? \": %s\\n\" : \"\\n\"),  &strerror( &errno))));
    }
}
unless(defined(&PROGRESS)) {
    sub PROGRESS {
	my($a) = @_;
	eval q(( &void)  &printf $a);
    }
}
unless(defined(&ALLOC)) {
    sub ALLOC {
	my($a) = @_;
	eval q( &alloc($a));
    }
}
unless(defined(&FREE)) {
    sub FREE {
	my($a, $b) = @_;
	eval q( &free($a, $b));
    }
}
unless(defined(&OKMAGIC)) {
    sub OKMAGIC {
	my($a) = @_;
	eval q((($a) ==  &OMAGIC));
    }
}
1;
