require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_BUS_H_)) {
    eval 'sub _I386_BUS_H_ () {1;}' unless defined(&_I386_BUS_H_);
    require 'machine/pio.ph';
    eval 'sub I386_BUS_SPACE_IO () {0;}' unless defined(&I386_BUS_SPACE_IO);
    eval 'sub I386_BUS_SPACE_MEM () {1;}' unless defined(&I386_BUS_SPACE_MEM);
    eval 'sub bus_space_read_1 {
        my($t, $h, $o) = @_;
	    eval q((($t) ==  &I386_BUS_SPACE_IO ? ( &inb(($h) + ($o))) : (*( &volatile  &u_int8_t *)(($h) + ($o)))));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_read_2 {
        my($t, $h, $o) = @_;
	    eval q((($t) ==  &I386_BUS_SPACE_IO ? ( &inw(($h) + ($o))) : (*( &volatile  &u_int16_t *)(($h) + ($o)))));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        my($t, $h, $o) = @_;
	    eval q((($t) ==  &I386_BUS_SPACE_IO ? ( &inl(($h) + ($o))) : (*( &volatile  &u_int32_t *)(($h) + ($o)))));
    }' unless defined(&bus_space_read_4);
    if(0) {
	eval 'sub bus_space_read_8 {
	    my($t, $h, $o) = @_;
    	    eval q(!!!  &bus_space_read_8  &unimplemented !!!);
	}' unless defined(&bus_space_read_8);
    }
    eval 'sub bus_space_read_multi_1 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &insb(($h) + ($o), ($a), ($cnt)); }  &else { &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	movb (%2),%%al				;				stosb					;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_read_multi_1);
    eval 'sub bus_space_read_multi_2 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &insw(($h) + ($o), ($a), ($cnt)); }  &else { &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	movw (%2),%%ax				;				stosw					;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_read_multi_2);
    eval 'sub bus_space_read_multi_4 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &insl(($h) + ($o), ($a), ($cnt)); }  &else { &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	movl (%2),%%eax				;				stosl					;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_read_multi_4);
    if(0) {
	eval 'sub bus_space_read_multi_8 () {!!!  &bus_space_read_multi_8  &unimplemented !!!;}' unless defined(&bus_space_read_multi_8);
    }
    eval 'sub bus_space_read_raw_multi_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_multi_2(($t), ($h), ($o), ( &u_int16_t *)($a), ($c) >> 1));
    }' unless defined(&bus_space_read_raw_multi_2);
    eval 'sub bus_space_read_raw_multi_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_multi_4(($t), ($h), ($o), ( &u_int32_t *)($a), ($c) >> 2));
    }' unless defined(&bus_space_read_raw_multi_4);
    if(0) {
	eval 'sub bus_space_read_raw_multi_8 () {!!!  &bus_space_read_raw_multi_8  &unimplemented !!!;}' unless defined(&bus_space_read_raw_multi_8);
    }
    eval 'sub bus_space_read_region_1 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt = ($cnt);  &void * &_addr = ($a); \'int\'  &_port = ($h)+($o);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	inb %w2,%%al				;				stosb					;				incl %2					;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt), \\"+d\\" ( &_port) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_port,  &_addr, 1,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_read_region_1);
    eval 'sub bus_space_read_region_2 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt = ($cnt);  &void * &_addr = ($a); \'int\'  &_port = ($h)+($o);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	inw %w2,%%ax				;				stosw					;				addl $2,%2				;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt), \\"+d\\" ( &_port) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_port,  &_addr, 2,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_read_region_2);
    eval 'sub bus_space_read_region_4 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt = ($cnt);  &void * &_addr = ($a); \'int\'  &_port = ($h)+($o);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	inl %w2,%%eax				;				stosl					;				addl $4,%2				;				loop 1b\\" : \\"+D\\" ( &_addr), \\"+c\\" ( &_cnt), \\"+d\\" ( &_port) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_port,  &_addr, 4,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_read_region_4);
    if(0) {
	eval 'sub bus_space_read_region_8 () {!!!  &bus_space_read_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_region_8);
    }
    eval 'sub bus_space_read_raw_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_region_2(($t), ($h), ($o), ( &u_int16_t *)($a), ($c) >> 1));
    }' unless defined(&bus_space_read_raw_region_2);
    eval 'sub bus_space_read_raw_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_region_4(($t), ($h), ($o), ( &u_int32_t *)($a), ($c) >> 2));
    }' unless defined(&bus_space_read_raw_region_4);
    if(0) {
	eval 'sub bus_space_read_raw_region_8 () {!!!  &bus_space_read_raw_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_raw_region_8);
    }
    eval 'sub bus_space_write_1 {
        my($t, $h, $o, $v) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO)  &outb(($h) + ($o), ($v));  &else (( &void)(*( &volatile  &u_int8_t *)(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_write_2 {
        my($t, $h, $o, $v) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO)  &outw(($h) + ($o), ($v));  &else (( &void)(*( &volatile  &u_int16_t *)(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        my($t, $h, $o, $v) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO)  &outl(($h) + ($o), ($v));  &else (( &void)(*( &volatile  &u_int32_t *)(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_4);
    if(0) {
	eval 'sub bus_space_write_8 () {!!!  &bus_space_write_8  &not  &implemented !!!;}' unless defined(&bus_space_write_8);
    }
    eval 'sub bus_space_write_multi_1 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &outsb(($h) + ($o), ($a), ($cnt)); }  &else { &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	lodsb					;				movb %%al,(%2)				;				loop 1b\\" : \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_write_multi_1);
    eval 'sub bus_space_write_multi_2 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &outsw(($h) + ($o), ($a), ($cnt)); }  &else { &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	lodsw					;				movw %%ax,(%2)				;				loop 1b\\" : \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_write_multi_2);
    eval 'sub bus_space_write_multi_4 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &I386_BUS_SPACE_IO) {  &outsl(($h) + ($o), ($a), ($cnt)); }  &else { &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &__asm  &__volatile(\\"								cld					;			1:	lodsl					;				movl %%eax,(%2)				;				loop 1b\\" : \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) : \\"r\\" (($h) + ($o)) : \\"%eax\\", \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_write_multi_4);
    if(0) {
	eval 'sub bus_space_write_multi_8 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q(!!!  &bus_space_write_multi_8  &unimplemented !!!);
	}' unless defined(&bus_space_write_multi_8);
    }
    eval 'sub bus_space_write_raw_multi_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_multi_2(($t), ($h), ($o), ( &const  &u_int16_t *)($a), ($c) >> 1));
    }' unless defined(&bus_space_write_raw_multi_2);
    eval 'sub bus_space_write_raw_multi_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_multi_4(($t), ($h), ($o), ( &const  &u_int32_t *)($a), ($c) >> 2));
    }' unless defined(&bus_space_write_raw_multi_4);
    if(0) {
	eval 'sub bus_space_write_raw_multi_8 () {!!!  &bus_space_write_raw_multi_8  &unimplemented !!!;}' unless defined(&bus_space_write_raw_multi_8);
    }
    eval 'sub bus_space_write_region_1 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o);  &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	lodsb					;				outb %%al,%w0				;				incl %0					;				loop 1b\\" : \\"+d\\" ( &_port), \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_addr,  &_port, 1,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_write_region_1);
    eval 'sub bus_space_write_region_2 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o);  &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	lodsw					;				outw %%ax,%w0				;				addl $2,%0				;				loop 1b\\" : \\"+d\\" ( &_port), \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_addr,  &_port, 2,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_write_region_2);
    eval 'sub bus_space_write_region_4 {
        my($t, $h, $o, $a, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o);  &const  &void * &_addr=($a); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	lodsl					;				outl %%eax,%w0				;				addl $4,%0				;				loop 1b\\" : \\"+d\\" ( &_port), \\"+S\\" ( &_addr), \\"+c\\" ( &_cnt) :: \\"%eax\\", \\"memory\\", \\"cc\\"); }  &else  &i386_space_copy( &_addr,  &_port, 4,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_write_region_4);
    if(0) {
	eval 'sub bus_space_write_region_8 () {!!!  &bus_space_write_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_region_8);
    }
    eval 'sub bus_space_write_raw_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_region_2(($t), ($h), ($o), ( &const  &u_int16_t *)($a), ($c) >> 1));
    }' unless defined(&bus_space_write_raw_region_2);
    eval 'sub bus_space_write_raw_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_region_4(($t), ($h), ($o), ( &const  &u_int32_t *)($a), ($c) >> 2));
    }' unless defined(&bus_space_write_raw_region_4);
    if(0) {
	eval 'sub bus_space_write_raw_region_8 () {!!!  &bus_space_write_raw_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_raw_region_8);
    }
    eval 'sub bus_space_set_multi_1 {
        my($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	outb %b2, %w1				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"d\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;			1:	movb %b2, (%1)				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"D\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\", \\"memory\\"); } }  &while (0));
    }' unless defined(&bus_space_set_multi_1);
    eval 'sub bus_space_set_multi_2 {
        my($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	outw %w2, %w1				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"d\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;			1:	movw %w2, (%1)				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"D\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\", \\"memory\\"); } }  &while (0));
    }' unless defined(&bus_space_set_multi_2);
    eval 'sub bus_space_set_multi_4 {
        my($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"								cld					;			1:	outl %2,%w1				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"d\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;			1:	movl %2,(%1)				;				loop 1b\\" : \\"+c\\" ( &_cnt) : \\"D\\" (($h) + ($o)), \\"a\\" (($v)) : \\"cc\\", \\"memory\\"); } }  &while (0));
    }' unless defined(&bus_space_set_multi_4);
    if(0) {
	eval 'sub bus_space_set_multi_8 () {!!!  &bus_space_set_multi_8  &unimplemented !!!;}' unless defined(&bus_space_set_multi_8);
    }
    eval 'sub bus_space_set_region_1 {
        my($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o); \'int\'  &_cnt = ($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	outb %%al,%w0				;				incl %0					;				loop 1b\\" : \\"+d\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;				repne					;				stosb\\" : \\"+D\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_set_region_1);
    eval 'sub bus_space_set_region_2 {
        my($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o); \'int\'  &_cnt = ($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	outw %%ax,%w0				;				addl $2, %0				;				loop 1b\\" : \\"+d\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;				repne					;				stosw\\" : \\"+D\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_set_region_2);
    eval 'sub bus_space_set_region_4 {
        my($t, $h, $o, $v, $cnt) = @_;
	    eval q( &do { \'int\'  &_port = ($h)+($o); \'int\'  &_cnt = ($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	outl %%eax,%w0				;				addl $4, %0				;				loop 1b\\" : \\"+d\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"cc\\"); }  &else {  &__asm  &__volatile(\\"								cld					;				repne					;				stosl\\" : \\"+D\\" ( &_port), \\"+c\\" ( &_cnt) : \\"a\\" (($v)) : \\"memory\\", \\"cc\\"); } }  &while (0));
    }' unless defined(&bus_space_set_region_4);
    if(0) {
	eval 'sub bus_space_set_region_8 () {!!!  &bus_space_set_region_8  &unimplemented !!!;}' unless defined(&bus_space_set_region_8);
    }
    eval 'sub bus_space_copy_1 {
        my($t, $h1, $o1, $h2, $o2, $cnt) = @_;
	    eval q( &do { \'int\'  &_port1 = ($h1)+($o1); \'int\'  &_port2 = ($h2)+($o2); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	movl %k1,%%edx				;				inb  %%dx,%%al				;				movl %k0,%%edx				;				outb %%al,%%dx				;				incl %0					;				incl %1					;				loop 1b\\" : \\"+D\\" ( &_port2), \\"+S\\" ( &_port1), \\"+c\\" (( &_cnt)) :: \\"%edx\\", \\"%eax\\", \\"cc\\"); }  &else  &i386_space_copy( &_port1,  &_port2, 1,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_copy_1);
    eval 'sub bus_space_copy_2 {
        my($t, $h1, $o1, $h2, $o2, $cnt) = @_;
	    eval q( &do { \'int\'  &_port1 = ($h1)+($o1); \'int\'  &_port2 = ($h2)+($o2); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	movl %k1,%%edx				;				inw  %%dx,%%ax				;				movl %k0,%%edx				;				outw %%ax,%%dx				;				addl $2, %0				;				addl $2, %1				;				loop 1b\\" : \\"+D\\" ( &_port2), \\"+ES\\" ( &_port1), \\"+c\\" (( &_cnt)) :: \\"%edx\\", \\"%eax\\", \\"cc\\"); }  &else  &i386_space_copy( &_port1,  &_port2, 2,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_copy_2);
    eval 'sub bus_space_copy_4 {
        my($t, $h1, $o1, $h2, $o2, $cnt) = @_;
	    eval q( &do { \'int\'  &_port1 = ($h1)+($o1); \'int\'  &_port2 = ($h2)+($o2); \'int\'  &_cnt=($cnt);  &if (($t) ==  &I386_BUS_SPACE_IO) {  &__asm  &__volatile(\\"							1:	movl %k1,%%edx				;				inl  %%dx,%%eax				;				movl %k0,%%edx				;				outl %%eax,%%dx				;				addl $4, %0				;				addl $4, %1				;				loop 1b\\" : \\"+D\\" ( &_port2), \\"+ES\\" ( &_port1), \\"+c\\" (( &_cnt)) :: \\"%edx\\", \\"%eax\\", \\"cc\\"); }  &else  &i386_space_copy( &_port1,  &_port2, 4,  &_cnt); }  &while (0));
    }' unless defined(&bus_space_copy_4);
    if(0) {
	eval 'sub bus_space_copy_8 () {!!!  &bus_space_copy_8  &unimplemented !!!;}' unless defined(&bus_space_copy_8);
    }
    eval 'sub i386_space_copy1 {
        my($a1, $a2, $cnt, $movs, $df) = @_;
	    eval q( &__asm  &__volatile($df \\"\\\\n\\\\trep\\\\n\\\\t\\" $movs : \\"+S\\" ($a1), \\"+D\\" ($a2), \\"+c\\" ($cnt) :: \\"memory\\", \\"cc\\"););
    }' unless defined(&i386_space_copy1);
    eval 'sub i386_space_copy {
        my($a1, $a2, $sz, $cnt) = @_;
	    eval q( &do {  &if (( &void *)($a1) < ( &void *)($a2)) { $a1 += (($cnt) - 1) * ($sz); $a2 += (($cnt) - 1) * ($sz);  &switch ($sz) {  &case 1:  &i386_space_copy1($a1,$a2,$cnt,\\"movsb\\",\\"std\\"); &break;  &case 2:  &i386_space_copy1($a1,$a2,$cnt,\\"movsw\\",\\"std\\"); &break;  &case 4:  &i386_space_copy1($a1,$a2,$cnt,\\"movsl\\",\\"std\\"); &break; } }  &else  &switch ($sz) {  &case 1:  &i386_space_copy1($a1,$a2,$cnt,\\"movsb\\",\\"cld\\"); &break;  &case 2:  &i386_space_copy1($a1,$a2,$cnt,\\"movsw\\",\\"cld\\"); &break;  &case 4:  &i386_space_copy1($a1,$a2,$cnt,\\"movsl\\",\\"cld\\"); &break; } }  &while (0));
    }' unless defined(&i386_space_copy);
    eval 'sub bus_space_barrier {
        my($t, $h, $o, $l, $f) = @_;
	    eval q((( &void)(( &void)($t), ( &void)($h), ( &void)($o), ( &void)($l), ( &void)($f))));
    }' unless defined(&bus_space_barrier);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x1;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x2;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub BUS_BARRIER_READ () { &BUS_SPACE_BARRIER_READ;}' unless defined(&BUS_BARRIER_READ);
    eval 'sub BUS_BARRIER_WRITE () { &BUS_SPACE_BARRIER_WRITE;}' unless defined(&BUS_BARRIER_WRITE);
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x1;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x2;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub BUS_SPACE_MAP_PREFETCHABLE () {0x8;}' unless defined(&BUS_SPACE_MAP_PREFETCHABLE);
    eval 'sub bus_space_vaddr {
        my($t, $h) = @_;
	    eval q((($t) ==  &I386_BUS_SPACE_IO ? ( &void *)( &NULL) : ( &void *)($h)));
    }' unless defined(&bus_space_vaddr);
    eval 'sub BUS_DMA_WAITOK () {0x;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x1;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x2;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x4;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMA_BUS1 () {0x10;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x20;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x40;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_24BIT () {0x80;}' unless defined(&BUS_DMA_24BIT);
    eval 'sub BUS_DMA_STREAMING () {0x100;}' unless defined(&BUS_DMA_STREAMING);
    eval 'sub BUS_DMA_READ () {0x200;}' unless defined(&BUS_DMA_READ);
    eval 'sub BUS_DMA_WRITE () {0x400;}' unless defined(&BUS_DMA_WRITE);
    eval 'sub BUS_DMASYNC_PREREAD () {0x1;}' unless defined(&BUS_DMASYNC_PREREAD);
    eval 'sub BUS_DMASYNC_POSTREAD () {0x2;}' unless defined(&BUS_DMASYNC_POSTREAD);
    eval 'sub BUS_DMASYNC_PREWRITE () {0x4;}' unless defined(&BUS_DMASYNC_PREWRITE);
    eval 'sub BUS_DMASYNC_POSTWRITE () {0x8;}' unless defined(&BUS_DMASYNC_POSTWRITE);
    eval 'sub bus_dmamap_create {
        my($t, $s, $n, $m, $b, $f, $p) = @_;
	    eval q((*($t)-> &_dmamap_create)(($t), ($s), ($n), ($m), ($b), ($f), ($p)));
    }' unless defined(&bus_dmamap_create);
    eval 'sub bus_dmamap_destroy {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_destroy)(($t), ($p)));
    }' unless defined(&bus_dmamap_destroy);
    eval 'sub bus_dmamap_load {
        my($t, $m, $b, $s, $p, $f) = @_;
	    eval q((*($t)-> &_dmamap_load)(($t), ($m), ($b), ($s), ($p), ($f)));
    }' unless defined(&bus_dmamap_load);
    eval 'sub bus_dmamap_load_mbuf {
        my($t, $m, $b, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_mbuf)(($t), ($m), ($b), ($f)));
    }' unless defined(&bus_dmamap_load_mbuf);
    eval 'sub bus_dmamap_load_uio {
        my($t, $m, $u, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_uio)(($t), ($m), ($u), ($f)));
    }' unless defined(&bus_dmamap_load_uio);
    eval 'sub bus_dmamap_load_raw {
        my($t, $m, $sg, $n, $s, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_raw)(($t), ($m), ($sg), ($n), ($s), ($f)));
    }' unless defined(&bus_dmamap_load_raw);
    eval 'sub bus_dmamap_unload {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_unload)(($t), ($p)));
    }' unless defined(&bus_dmamap_unload);
    eval 'sub bus_dmamap_sync {
        my($t, $p, $o, $l, $ops) = @_;
	    eval q(( &void)(($t)-> &_dmamap_sync ? (*($t)-> &_dmamap_sync)(($t), ($p), ($o), ($l), ($ops)) : ( &void)0));
    }' unless defined(&bus_dmamap_sync);
    eval 'sub bus_dmamem_alloc {
        my($t, $s, $a, $b, $sg, $n, $r, $f) = @_;
	    eval q((*($t)-> &_dmamem_alloc)(($t), ($s), ($a), ($b), ($sg), ($n), ($r), ($f)));
    }' unless defined(&bus_dmamem_alloc);
    eval 'sub bus_dmamem_free {
        my($t, $sg, $n) = @_;
	    eval q((*($t)-> &_dmamem_free)(($t), ($sg), ($n)));
    }' unless defined(&bus_dmamem_free);
    eval 'sub bus_dmamem_map {
        my($t, $sg, $n, $s, $k, $f) = @_;
	    eval q((*($t)-> &_dmamem_map)(($t), ($sg), ($n), ($s), ($k), ($f)));
    }' unless defined(&bus_dmamem_map);
    eval 'sub bus_dmamem_unmap {
        my($t, $k, $s) = @_;
	    eval q((*($t)-> &_dmamem_unmap)(($t), ($k), ($s)));
    }' unless defined(&bus_dmamem_unmap);
    eval 'sub bus_dmamem_mmap {
        my($t, $sg, $n, $o, $p, $f) = @_;
	    eval q((*($t)-> &_dmamem_mmap)(($t), ($sg), ($n), ($o), ($p), ($f)));
    }' unless defined(&bus_dmamem_mmap);
    if(defined(&_I386_BUS_DMA_PRIVATE)) {
    }
}
1;
