require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&NOCT_RNG_QLEN)) {
    sub NOCT_RNG_QLEN () {	15;}
}
unless(defined(&NOCT_RNG_ENTRIES)) {
    sub NOCT_RNG_ENTRIES () {	(1<<  &NOCT_RNG_QLEN);}
}
unless(defined(&NOCT_RNG_BUFSIZE)) {
    sub NOCT_RNG_BUFSIZE () {	( &NOCT_RNG_ENTRIES * $sizeof{ &u_int64_t});}
}
unless(defined(&NOCT_PKH_QLEN)) {
    sub NOCT_PKH_QLEN () {	15;}
}
unless(defined(&NOCT_PKH_ENTRIES)) {
    sub NOCT_PKH_ENTRIES () {	(1<<  &NOCT_PKH_QLEN);}
}
unless(defined(&NOCT_PKH_BUFSIZE)) {
    sub NOCT_PKH_BUFSIZE () {	( &NOCT_PKH_ENTRIES * $sizeof{'union noct_pkh_cmd'});}
}
unless(defined(&NOCT_EA_QLEN)) {
    sub NOCT_EA_QLEN () {	15;}
}
unless(defined(&NOCT_EA_ENTRIES)) {
    sub NOCT_EA_ENTRIES () {	(1<<  &NOCT_EA_QLEN);}
}
unless(defined(&NOCT_EA_BUFSIZE)) {
    sub NOCT_EA_BUFSIZE () {	( &NOCT_EA_ENTRIES * $sizeof{'struct noct_ea_cmd'});}
}
unless(defined(&NOCT_BN_CACHE_SIZE)) {
    sub NOCT_BN_CACHE_SIZE () {	((256) * (128/ 8));}
}
unless(defined(&NOCT_READ_4)) {
    sub NOCT_READ_4 {
	my($sc,$r) = @_;
	eval q( &noct_read_4(($sc), ($r)));
    }
}
unless(defined(&NOCT_WRITE_4)) {
    sub NOCT_WRITE_4 {
	my($sc,$r,$v) = @_;
	eval q( &noct_write_4(($sc), ($r), ($v)));
    }
}
unless(defined(&NOCT_READ_8)) {
    sub NOCT_READ_8 {
	my($sc,$r) = @_;
	eval q( &noct_read_8(($sc), ($r)));
    }
}
unless(defined(&NOCT_WRITE_8)) {
    sub NOCT_WRITE_8 {
	my($sc,$r,$v) = @_;
	eval q( &noct_write_8(($sc), ($r), ($v)));
    }
}
unless(defined(&NOCT_CARD)) {
    sub NOCT_CARD {
	my($sid) = @_;
	eval q(((($sid) & 0xf0000000) >> 28));
    }
}
unless(defined(&NOCT_SESSION)) {
    sub NOCT_SESSION {
	my($sid) = @_;
	eval q(( ($sid) & 0xfffffff));
    }
}
unless(defined(&NOCT_SID)) {
    sub NOCT_SID {
	my($crd, $sesn) = @_;
	eval q(((($crd) << 28) | (($sesn) & 0xfffffff)));
    }
}
unless(defined(&NOCT_WAKEUP)) {
    sub NOCT_WAKEUP {
	my($sc) = @_;
	eval q( &wakeup(($sc)-> &sc_eawp));
    }
}
unless(defined(&NOCT_SLEEP)) {
    sub NOCT_SLEEP {
	my($sc) = @_;
	eval q( &tsleep(($sc)-> &sc_eawp,  &PWAIT, \"noctea\", 0));
    }
}
1;
