require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__RADEON_DRV_H__)) {
    eval 'sub __RADEON_DRV_H__ () {1;}' unless defined(&__RADEON_DRV_H__);
    eval 'sub DRIVER_AUTHOR () {"Gareth Hughes, Keith Whitwell, others.";}' unless defined(&DRIVER_AUTHOR);
    eval 'sub DRIVER_NAME () {"radeon";}' unless defined(&DRIVER_NAME);
    eval 'sub DRIVER_DESC () {"ATI Radeon";}' unless defined(&DRIVER_DESC);
    eval 'sub DRIVER_DATE () {"20060524";}' unless defined(&DRIVER_DATE);
    eval 'sub DRIVER_MAJOR () {1;}' unless defined(&DRIVER_MAJOR);
    eval 'sub DRIVER_MINOR () {28;}' unless defined(&DRIVER_MINOR);
    eval 'sub DRIVER_PATCHLEVEL () {0;}' unless defined(&DRIVER_PATCHLEVEL);
    eval("sub CHIP_R100 () { 0; }") unless defined(&CHIP_R100);
    eval("sub CHIP_RV100 () { 1; }") unless defined(&CHIP_RV100);
    eval("sub CHIP_RS100 () { 2; }") unless defined(&CHIP_RS100);
    eval("sub CHIP_RV200 () { 3; }") unless defined(&CHIP_RV200);
    eval("sub CHIP_RS200 () { 4; }") unless defined(&CHIP_RS200);
    eval("sub CHIP_R200 () { 5; }") unless defined(&CHIP_R200);
    eval("sub CHIP_RV250 () { 6; }") unless defined(&CHIP_RV250);
    eval("sub CHIP_RS300 () { 7; }") unless defined(&CHIP_RS300);
    eval("sub CHIP_RV280 () { 8; }") unless defined(&CHIP_RV280);
    eval("sub CHIP_R300 () { 9; }") unless defined(&CHIP_R300);
    eval("sub CHIP_R350 () { 10; }") unless defined(&CHIP_R350);
    eval("sub CHIP_RV350 () { 11; }") unless defined(&CHIP_RV350);
    eval("sub CHIP_RV380 () { 12; }") unless defined(&CHIP_RV380);
    eval("sub CHIP_R420 () { 13; }") unless defined(&CHIP_R420);
    eval("sub CHIP_RV410 () { 14; }") unless defined(&CHIP_RV410);
    eval("sub CHIP_RS400 () { 15; }") unless defined(&CHIP_RS400);
    eval("sub CHIP_LAST () { 16; }") unless defined(&CHIP_LAST);
    eval("sub UCODE_R100 () { 0; }") unless defined(&UCODE_R100);
    eval("sub UCODE_R200 () { 1; }") unless defined(&UCODE_R200);
    eval("sub UCODE_R300 () { 2; }") unless defined(&UCODE_R300);
    eval("sub RADEON_FAMILY_MASK () { 0x0000ffffUL; }") unless defined(&RADEON_FAMILY_MASK);
    eval("sub RADEON_FLAGS_MASK () { 0xffff0000UL; }") unless defined(&RADEON_FLAGS_MASK);
    eval("sub RADEON_IS_MOBILITY () { 0x00010000UL; }") unless defined(&RADEON_IS_MOBILITY);
    eval("sub RADEON_IS_IGP () { 0x00020000UL; }") unless defined(&RADEON_IS_IGP);
    eval("sub RADEON_SINGLE_CRTC () { 0x00040000UL; }") unless defined(&RADEON_SINGLE_CRTC);
    eval("sub RADEON_IS_AGP () { 0x00080000UL; }") unless defined(&RADEON_IS_AGP);
    eval("sub RADEON_HAS_HIERZ () { 0x00100000UL; }") unless defined(&RADEON_HAS_HIERZ);
    eval("sub RADEON_IS_PCIE () { 0x00200000UL; }") unless defined(&RADEON_IS_PCIE);
    eval("sub RADEON_NEW_MEMMAP () { 0x00400000UL; }") unless defined(&RADEON_NEW_MEMMAP);
    eval("sub RADEON_IS_PCI () { 0x00800000UL; }") unless defined(&RADEON_IS_PCI);
    eval("sub RADEON_IS_IGPGART () { 0x01000000UL; }") unless defined(&RADEON_IS_IGPGART);
    eval 'sub GET_RING_HEAD {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{writeback_works}) ?  &DRM_READ32( ($dev_priv)-> &ring_rptr, 0) :  &RADEON_READ( &RADEON_CP_RB_RPTR)));
    }' unless defined(&GET_RING_HEAD);
    eval 'sub SET_RING_HEAD {
        my($dev_priv,$val) = @_;
	    eval q( &DRM_WRITE32( ($dev_priv)-> &ring_rptr, 0, ($val) ));
    }' unless defined(&SET_RING_HEAD);
    eval 'sub RADEON_BOX_DMA_IDLE () {0x1;}' unless defined(&RADEON_BOX_DMA_IDLE);
    eval 'sub RADEON_BOX_RING_FULL () {0x2;}' unless defined(&RADEON_BOX_RING_FULL);
    eval 'sub RADEON_BOX_FLIP () {0x4;}' unless defined(&RADEON_BOX_FLIP);
    eval 'sub RADEON_BOX_WAIT_IDLE () {0x8;}' unless defined(&RADEON_BOX_WAIT_IDLE);
    eval 'sub RADEON_BOX_TEXTURE_LOAD () {0x10;}' unless defined(&RADEON_BOX_TEXTURE_LOAD);
    eval 'sub RADEON_AGP_COMMAND () {0xf60;}' unless defined(&RADEON_AGP_COMMAND);
    eval 'sub RADEON_AGP_COMMAND_PCI_CONFIG () {0x60;}' unless defined(&RADEON_AGP_COMMAND_PCI_CONFIG);
    eval 'sub RADEON_AGP_ENABLE () {(1<<8);}' unless defined(&RADEON_AGP_ENABLE);
    eval 'sub RADEON_AUX_SCISSOR_CNTL () {0x26f0;}' unless defined(&RADEON_AUX_SCISSOR_CNTL);
    eval 'sub RADEON_EXCLUSIVE_SCISSOR_0 () {(1<< 24);}' unless defined(&RADEON_EXCLUSIVE_SCISSOR_0);
    eval 'sub RADEON_EXCLUSIVE_SCISSOR_1 () {(1<< 25);}' unless defined(&RADEON_EXCLUSIVE_SCISSOR_1);
    eval 'sub RADEON_EXCLUSIVE_SCISSOR_2 () {(1<< 26);}' unless defined(&RADEON_EXCLUSIVE_SCISSOR_2);
    eval 'sub RADEON_SCISSOR_0_ENABLE () {(1<< 28);}' unless defined(&RADEON_SCISSOR_0_ENABLE);
    eval 'sub RADEON_SCISSOR_1_ENABLE () {(1<< 29);}' unless defined(&RADEON_SCISSOR_1_ENABLE);
    eval 'sub RADEON_SCISSOR_2_ENABLE () {(1<< 30);}' unless defined(&RADEON_SCISSOR_2_ENABLE);
    eval 'sub RADEON_BUS_CNTL () {0x30;}' unless defined(&RADEON_BUS_CNTL);
    eval 'sub RADEON_BUS_MASTER_DIS () {(1<< 6);}' unless defined(&RADEON_BUS_MASTER_DIS);
    eval 'sub RADEON_CLOCK_CNTL_DATA () {0xc;}' unless defined(&RADEON_CLOCK_CNTL_DATA);
    eval 'sub RADEON_PLL_WR_EN () {(1<< 7);}' unless defined(&RADEON_PLL_WR_EN);
    eval 'sub RADEON_CLOCK_CNTL_INDEX () {0x8;}' unless defined(&RADEON_CLOCK_CNTL_INDEX);
    eval 'sub RADEON_CONFIG_APER_SIZE () {0x108;}' unless defined(&RADEON_CONFIG_APER_SIZE);
    eval 'sub RADEON_CONFIG_MEMSIZE () {0xf8;}' unless defined(&RADEON_CONFIG_MEMSIZE);
    eval 'sub RADEON_CRTC_OFFSET () {0x224;}' unless defined(&RADEON_CRTC_OFFSET);
    eval 'sub RADEON_CRTC_OFFSET_CNTL () {0x228;}' unless defined(&RADEON_CRTC_OFFSET_CNTL);
    eval 'sub RADEON_CRTC_TILE_EN () {(1<< 15);}' unless defined(&RADEON_CRTC_TILE_EN);
    eval 'sub RADEON_CRTC_OFFSET_FLIP_CNTL () {(1<< 16);}' unless defined(&RADEON_CRTC_OFFSET_FLIP_CNTL);
    eval 'sub RADEON_CRTC2_OFFSET () {0x324;}' unless defined(&RADEON_CRTC2_OFFSET);
    eval 'sub RADEON_CRTC2_OFFSET_CNTL () {0x328;}' unless defined(&RADEON_CRTC2_OFFSET_CNTL);
    eval 'sub RADEON_PCIE_INDEX () {0x30;}' unless defined(&RADEON_PCIE_INDEX);
    eval 'sub RADEON_PCIE_DATA () {0x34;}' unless defined(&RADEON_PCIE_DATA);
    eval 'sub RADEON_PCIE_TX_GART_CNTL () {0x10;}' unless defined(&RADEON_PCIE_TX_GART_CNTL);
    eval 'sub RADEON_PCIE_TX_GART_EN () {(1<< 0);}' unless defined(&RADEON_PCIE_TX_GART_EN);
    eval 'sub RADEON_PCIE_TX_GART_UNMAPPED_ACCESS_PASS_THRU () {(0<<1);}' unless defined(&RADEON_PCIE_TX_GART_UNMAPPED_ACCESS_PASS_THRU);
    eval 'sub RADEON_PCIE_TX_GART_UNMAPPED_ACCESS_CLAMP_LO () {(1<<1);}' unless defined(&RADEON_PCIE_TX_GART_UNMAPPED_ACCESS_CLAMP_LO);
    eval 'sub RADEON_PCIE_TX_GART_UNMAPPED_ACCESS_DISCARD () {(3<<1);}' unless defined(&RADEON_PCIE_TX_GART_UNMAPPED_ACCESS_DISCARD);
    eval 'sub RADEON_PCIE_TX_GART_MODE_32_128_CACHE () {(0<<3);}' unless defined(&RADEON_PCIE_TX_GART_MODE_32_128_CACHE);
    eval 'sub RADEON_PCIE_TX_GART_MODE_8_4_128_CACHE () {(1<<3);}' unless defined(&RADEON_PCIE_TX_GART_MODE_8_4_128_CACHE);
    eval 'sub RADEON_PCIE_TX_GART_CHK_RW_VALID_EN () {(1<<5);}' unless defined(&RADEON_PCIE_TX_GART_CHK_RW_VALID_EN);
    eval 'sub RADEON_PCIE_TX_GART_INVALIDATE_TLB () {(1<<8);}' unless defined(&RADEON_PCIE_TX_GART_INVALIDATE_TLB);
    eval 'sub RADEON_PCIE_TX_DISCARD_RD_ADDR_LO () {0x11;}' unless defined(&RADEON_PCIE_TX_DISCARD_RD_ADDR_LO);
    eval 'sub RADEON_PCIE_TX_DISCARD_RD_ADDR_HI () {0x12;}' unless defined(&RADEON_PCIE_TX_DISCARD_RD_ADDR_HI);
    eval 'sub RADEON_PCIE_TX_GART_BASE () {0x13;}' unless defined(&RADEON_PCIE_TX_GART_BASE);
    eval 'sub RADEON_PCIE_TX_GART_START_LO () {0x14;}' unless defined(&RADEON_PCIE_TX_GART_START_LO);
    eval 'sub RADEON_PCIE_TX_GART_START_HI () {0x15;}' unless defined(&RADEON_PCIE_TX_GART_START_HI);
    eval 'sub RADEON_PCIE_TX_GART_END_LO () {0x16;}' unless defined(&RADEON_PCIE_TX_GART_END_LO);
    eval 'sub RADEON_PCIE_TX_GART_END_HI () {0x17;}' unless defined(&RADEON_PCIE_TX_GART_END_HI);
    eval 'sub RADEON_IGPGART_INDEX () {0x168;}' unless defined(&RADEON_IGPGART_INDEX);
    eval 'sub RADEON_IGPGART_DATA () {0x16c;}' unless defined(&RADEON_IGPGART_DATA);
    eval 'sub RADEON_IGPGART_UNK_18 () {0x18;}' unless defined(&RADEON_IGPGART_UNK_18);
    eval 'sub RADEON_IGPGART_CTRL () {0x2b;}' unless defined(&RADEON_IGPGART_CTRL);
    eval 'sub RADEON_IGPGART_BASE_ADDR () {0x2c;}' unless defined(&RADEON_IGPGART_BASE_ADDR);
    eval 'sub RADEON_IGPGART_FLUSH () {0x2e;}' unless defined(&RADEON_IGPGART_FLUSH);
    eval 'sub RADEON_IGPGART_ENABLE () {0x38;}' unless defined(&RADEON_IGPGART_ENABLE);
    eval 'sub RADEON_IGPGART_UNK_39 () {0x39;}' unless defined(&RADEON_IGPGART_UNK_39);
    eval 'sub RADEON_MPP_TB_CONFIG () {0x1c0;}' unless defined(&RADEON_MPP_TB_CONFIG);
    eval 'sub RADEON_MEM_CNTL () {0x140;}' unless defined(&RADEON_MEM_CNTL);
    eval 'sub RADEON_MEM_SDRAM_MODE_REG () {0x158;}' unless defined(&RADEON_MEM_SDRAM_MODE_REG);
    eval 'sub RADEON_AGP_BASE () {0x170;}' unless defined(&RADEON_AGP_BASE);
    eval 'sub RADEON_RB3D_COLOROFFSET () {0x1c40;}' unless defined(&RADEON_RB3D_COLOROFFSET);
    eval 'sub RADEON_RB3D_COLORPITCH () {0x1c48;}' unless defined(&RADEON_RB3D_COLORPITCH);
    eval 'sub RADEON_SRC_X_Y () {0x1590;}' unless defined(&RADEON_SRC_X_Y);
    eval 'sub RADEON_DP_GUI_MASTER_CNTL () {0x146c;}' unless defined(&RADEON_DP_GUI_MASTER_CNTL);
    eval 'sub RADEON_GMC_SRC_PITCH_OFFSET_CNTL () {(1<< 0);}' unless defined(&RADEON_GMC_SRC_PITCH_OFFSET_CNTL);
    eval 'sub RADEON_GMC_DST_PITCH_OFFSET_CNTL () {(1<< 1);}' unless defined(&RADEON_GMC_DST_PITCH_OFFSET_CNTL);
    eval 'sub RADEON_GMC_BRUSH_SOLID_COLOR () {(13<< 4);}' unless defined(&RADEON_GMC_BRUSH_SOLID_COLOR);
    eval 'sub RADEON_GMC_BRUSH_NONE () {(15<< 4);}' unless defined(&RADEON_GMC_BRUSH_NONE);
    eval 'sub RADEON_GMC_DST_16BPP () {(4<< 8);}' unless defined(&RADEON_GMC_DST_16BPP);
    eval 'sub RADEON_GMC_DST_24BPP () {(5<< 8);}' unless defined(&RADEON_GMC_DST_24BPP);
    eval 'sub RADEON_GMC_DST_32BPP () {(6<< 8);}' unless defined(&RADEON_GMC_DST_32BPP);
    eval 'sub RADEON_GMC_DST_DATATYPE_SHIFT () {8;}' unless defined(&RADEON_GMC_DST_DATATYPE_SHIFT);
    eval 'sub RADEON_GMC_SRC_DATATYPE_COLOR () {(3<< 12);}' unless defined(&RADEON_GMC_SRC_DATATYPE_COLOR);
    eval 'sub RADEON_DP_SRC_SOURCE_MEMORY () {(2<< 24);}' unless defined(&RADEON_DP_SRC_SOURCE_MEMORY);
    eval 'sub RADEON_DP_SRC_SOURCE_HOST_DATA () {(3<< 24);}' unless defined(&RADEON_DP_SRC_SOURCE_HOST_DATA);
    eval 'sub RADEON_GMC_CLR_CMP_CNTL_DIS () {(1<< 28);}' unless defined(&RADEON_GMC_CLR_CMP_CNTL_DIS);
    eval 'sub RADEON_GMC_WR_MSK_DIS () {(1<< 30);}' unless defined(&RADEON_GMC_WR_MSK_DIS);
    eval 'sub RADEON_ROP3_S () {0xcc0000;}' unless defined(&RADEON_ROP3_S);
    eval 'sub RADEON_ROP3_P () {0xf00000;}' unless defined(&RADEON_ROP3_P);
    eval 'sub RADEON_DP_WRITE_MASK () {0x16cc;}' unless defined(&RADEON_DP_WRITE_MASK);
    eval 'sub RADEON_SRC_PITCH_OFFSET () {0x1428;}' unless defined(&RADEON_SRC_PITCH_OFFSET);
    eval 'sub RADEON_DST_PITCH_OFFSET () {0x142c;}' unless defined(&RADEON_DST_PITCH_OFFSET);
    eval 'sub RADEON_DST_PITCH_OFFSET_C () {0x1c80;}' unless defined(&RADEON_DST_PITCH_OFFSET_C);
    eval 'sub RADEON_DST_TILE_LINEAR () {(0<< 30);}' unless defined(&RADEON_DST_TILE_LINEAR);
    eval 'sub RADEON_DST_TILE_MACRO () {(1<< 30);}' unless defined(&RADEON_DST_TILE_MACRO);
    eval 'sub RADEON_DST_TILE_MICRO () {(2<< 30);}' unless defined(&RADEON_DST_TILE_MICRO);
    eval 'sub RADEON_DST_TILE_BOTH () {(3<< 30);}' unless defined(&RADEON_DST_TILE_BOTH);
    eval 'sub RADEON_SCRATCH_REG0 () {0x15e0;}' unless defined(&RADEON_SCRATCH_REG0);
    eval 'sub RADEON_SCRATCH_REG1 () {0x15e4;}' unless defined(&RADEON_SCRATCH_REG1);
    eval 'sub RADEON_SCRATCH_REG2 () {0x15e8;}' unless defined(&RADEON_SCRATCH_REG2);
    eval 'sub RADEON_SCRATCH_REG3 () {0x15ec;}' unless defined(&RADEON_SCRATCH_REG3);
    eval 'sub RADEON_SCRATCH_REG4 () {0x15f0;}' unless defined(&RADEON_SCRATCH_REG4);
    eval 'sub RADEON_SCRATCH_REG5 () {0x15f4;}' unless defined(&RADEON_SCRATCH_REG5);
    eval 'sub RADEON_SCRATCH_UMSK () {0x770;}' unless defined(&RADEON_SCRATCH_UMSK);
    eval 'sub RADEON_SCRATCH_ADDR () {0x774;}' unless defined(&RADEON_SCRATCH_ADDR);
    eval 'sub RADEON_SCRATCHOFF {
        my( $x ) = @_;
	    eval q(( &RADEON_SCRATCH_REG_OFFSET + 4*( &x)));
    }' unless defined(&RADEON_SCRATCHOFF);
    eval 'sub GET_SCRATCH {
        my( $x ) = @_;
	    eval q(( ($dev_priv->{writeback_works})	 ?  &DRM_READ32(  ($dev_priv->{ring_rptr}),  &RADEON_SCRATCHOFF( &x) ) :  &RADEON_READ(  &RADEON_SCRATCH_REG0 + 4*( &x) ) ));
    }' unless defined(&GET_SCRATCH);
    eval 'sub RADEON_GEN_INT_CNTL () {0x40;}' unless defined(&RADEON_GEN_INT_CNTL);
    eval 'sub RADEON_CRTC_VBLANK_MASK () {(1<< 0);}' unless defined(&RADEON_CRTC_VBLANK_MASK);
    eval 'sub RADEON_CRTC2_VBLANK_MASK () {(1<< 9);}' unless defined(&RADEON_CRTC2_VBLANK_MASK);
    eval 'sub RADEON_GUI_IDLE_INT_ENABLE () {(1<< 19);}' unless defined(&RADEON_GUI_IDLE_INT_ENABLE);
    eval 'sub RADEON_SW_INT_ENABLE () {(1<< 25);}' unless defined(&RADEON_SW_INT_ENABLE);
    eval 'sub RADEON_GEN_INT_STATUS () {0x44;}' unless defined(&RADEON_GEN_INT_STATUS);
    eval 'sub RADEON_CRTC_VBLANK_STAT () {(1<< 0);}' unless defined(&RADEON_CRTC_VBLANK_STAT);
    eval 'sub RADEON_CRTC_VBLANK_STAT_ACK () {(1<< 0);}' unless defined(&RADEON_CRTC_VBLANK_STAT_ACK);
    eval 'sub RADEON_CRTC2_VBLANK_STAT () {(1<< 9);}' unless defined(&RADEON_CRTC2_VBLANK_STAT);
    eval 'sub RADEON_CRTC2_VBLANK_STAT_ACK () {(1<< 9);}' unless defined(&RADEON_CRTC2_VBLANK_STAT_ACK);
    eval 'sub RADEON_GUI_IDLE_INT_TEST_ACK () {(1<< 19);}' unless defined(&RADEON_GUI_IDLE_INT_TEST_ACK);
    eval 'sub RADEON_SW_INT_TEST () {(1<< 25);}' unless defined(&RADEON_SW_INT_TEST);
    eval 'sub RADEON_SW_INT_TEST_ACK () {(1<< 25);}' unless defined(&RADEON_SW_INT_TEST_ACK);
    eval 'sub RADEON_SW_INT_FIRE () {(1<< 26);}' unless defined(&RADEON_SW_INT_FIRE);
    eval 'sub RADEON_HOST_PATH_CNTL () {0x130;}' unless defined(&RADEON_HOST_PATH_CNTL);
    eval 'sub RADEON_HDP_SOFT_RESET () {(1<< 26);}' unless defined(&RADEON_HDP_SOFT_RESET);
    eval 'sub RADEON_HDP_WC_TIMEOUT_MASK () {(7<< 28);}' unless defined(&RADEON_HDP_WC_TIMEOUT_MASK);
    eval 'sub RADEON_HDP_WC_TIMEOUT_28BCLK () {(7<< 28);}' unless defined(&RADEON_HDP_WC_TIMEOUT_28BCLK);
    eval 'sub RADEON_ISYNC_CNTL () {0x1724;}' unless defined(&RADEON_ISYNC_CNTL);
    eval 'sub RADEON_ISYNC_ANY2D_IDLE3D () {(1<< 0);}' unless defined(&RADEON_ISYNC_ANY2D_IDLE3D);
    eval 'sub RADEON_ISYNC_ANY3D_IDLE2D () {(1<< 1);}' unless defined(&RADEON_ISYNC_ANY3D_IDLE2D);
    eval 'sub RADEON_ISYNC_TRIG2D_IDLE3D () {(1<< 2);}' unless defined(&RADEON_ISYNC_TRIG2D_IDLE3D);
    eval 'sub RADEON_ISYNC_TRIG3D_IDLE2D () {(1<< 3);}' unless defined(&RADEON_ISYNC_TRIG3D_IDLE2D);
    eval 'sub RADEON_ISYNC_WAIT_IDLEGUI () {(1<< 4);}' unless defined(&RADEON_ISYNC_WAIT_IDLEGUI);
    eval 'sub RADEON_ISYNC_CPSCRATCH_IDLEGUI () {(1<< 5);}' unless defined(&RADEON_ISYNC_CPSCRATCH_IDLEGUI);
    eval 'sub RADEON_RBBM_GUICNTL () {0x172c;}' unless defined(&RADEON_RBBM_GUICNTL);
    eval 'sub RADEON_HOST_DATA_SWAP_NONE () {(0<< 0);}' unless defined(&RADEON_HOST_DATA_SWAP_NONE);
    eval 'sub RADEON_HOST_DATA_SWAP_16BIT () {(1<< 0);}' unless defined(&RADEON_HOST_DATA_SWAP_16BIT);
    eval 'sub RADEON_HOST_DATA_SWAP_32BIT () {(2<< 0);}' unless defined(&RADEON_HOST_DATA_SWAP_32BIT);
    eval 'sub RADEON_HOST_DATA_SWAP_HDW () {(3<< 0);}' unless defined(&RADEON_HOST_DATA_SWAP_HDW);
    eval 'sub RADEON_MC_AGP_LOCATION () {0x14c;}' unless defined(&RADEON_MC_AGP_LOCATION);
    eval 'sub RADEON_MC_FB_LOCATION () {0x148;}' unless defined(&RADEON_MC_FB_LOCATION);
    eval 'sub RADEON_MCLK_CNTL () {0x12;}' unless defined(&RADEON_MCLK_CNTL);
    eval 'sub RADEON_FORCEON_MCLKA () {(1<< 16);}' unless defined(&RADEON_FORCEON_MCLKA);
    eval 'sub RADEON_FORCEON_MCLKB () {(1<< 17);}' unless defined(&RADEON_FORCEON_MCLKB);
    eval 'sub RADEON_FORCEON_YCLKA () {(1<< 18);}' unless defined(&RADEON_FORCEON_YCLKA);
    eval 'sub RADEON_FORCEON_YCLKB () {(1<< 19);}' unless defined(&RADEON_FORCEON_YCLKB);
    eval 'sub RADEON_FORCEON_MC () {(1<< 20);}' unless defined(&RADEON_FORCEON_MC);
    eval 'sub RADEON_FORCEON_AIC () {(1<< 21);}' unless defined(&RADEON_FORCEON_AIC);
    eval 'sub RADEON_PP_BORDER_COLOR_0 () {0x1d40;}' unless defined(&RADEON_PP_BORDER_COLOR_0);
    eval 'sub RADEON_PP_BORDER_COLOR_1 () {0x1d44;}' unless defined(&RADEON_PP_BORDER_COLOR_1);
    eval 'sub RADEON_PP_BORDER_COLOR_2 () {0x1d48;}' unless defined(&RADEON_PP_BORDER_COLOR_2);
    eval 'sub RADEON_PP_CNTL () {0x1c38;}' unless defined(&RADEON_PP_CNTL);
    eval 'sub RADEON_SCISSOR_ENABLE () {(1<< 1);}' unless defined(&RADEON_SCISSOR_ENABLE);
    eval 'sub RADEON_PP_LUM_MATRIX () {0x1d00;}' unless defined(&RADEON_PP_LUM_MATRIX);
    eval 'sub RADEON_PP_MISC () {0x1c14;}' unless defined(&RADEON_PP_MISC);
    eval 'sub RADEON_PP_ROT_MATRIX_0 () {0x1d58;}' unless defined(&RADEON_PP_ROT_MATRIX_0);
    eval 'sub RADEON_PP_TXFILTER_0 () {0x1c54;}' unless defined(&RADEON_PP_TXFILTER_0);
    eval 'sub RADEON_PP_TXOFFSET_0 () {0x1c5c;}' unless defined(&RADEON_PP_TXOFFSET_0);
    eval 'sub RADEON_PP_TXFILTER_1 () {0x1c6c;}' unless defined(&RADEON_PP_TXFILTER_1);
    eval 'sub RADEON_PP_TXFILTER_2 () {0x1c84;}' unless defined(&RADEON_PP_TXFILTER_2);
    eval 'sub RADEON_RB2D_DSTCACHE_CTLSTAT () {0x342c;}' unless defined(&RADEON_RB2D_DSTCACHE_CTLSTAT);
    eval 'sub RADEON_RB2D_DC_FLUSH () {(3<< 0);}' unless defined(&RADEON_RB2D_DC_FLUSH);
    eval 'sub RADEON_RB2D_DC_FREE () {(3<< 2);}' unless defined(&RADEON_RB2D_DC_FREE);
    eval 'sub RADEON_RB2D_DC_FLUSH_ALL () {0xf;}' unless defined(&RADEON_RB2D_DC_FLUSH_ALL);
    eval 'sub RADEON_RB2D_DC_BUSY () {(1<< 31);}' unless defined(&RADEON_RB2D_DC_BUSY);
    eval 'sub RADEON_RB3D_CNTL () {0x1c3c;}' unless defined(&RADEON_RB3D_CNTL);
    eval 'sub RADEON_ALPHA_BLEND_ENABLE () {(1<< 0);}' unless defined(&RADEON_ALPHA_BLEND_ENABLE);
    eval 'sub RADEON_PLANE_MASK_ENABLE () {(1<< 1);}' unless defined(&RADEON_PLANE_MASK_ENABLE);
    eval 'sub RADEON_DITHER_ENABLE () {(1<< 2);}' unless defined(&RADEON_DITHER_ENABLE);
    eval 'sub RADEON_ROUND_ENABLE () {(1<< 3);}' unless defined(&RADEON_ROUND_ENABLE);
    eval 'sub RADEON_SCALE_DITHER_ENABLE () {(1<< 4);}' unless defined(&RADEON_SCALE_DITHER_ENABLE);
    eval 'sub RADEON_DITHER_INIT () {(1<< 5);}' unless defined(&RADEON_DITHER_INIT);
    eval 'sub RADEON_ROP_ENABLE () {(1<< 6);}' unless defined(&RADEON_ROP_ENABLE);
    eval 'sub RADEON_STENCIL_ENABLE () {(1<< 7);}' unless defined(&RADEON_STENCIL_ENABLE);
    eval 'sub RADEON_Z_ENABLE () {(1<< 8);}' unless defined(&RADEON_Z_ENABLE);
    eval 'sub RADEON_ZBLOCK16 () {(1<< 15);}' unless defined(&RADEON_ZBLOCK16);
    eval 'sub RADEON_RB3D_DEPTHOFFSET () {0x1c24;}' unless defined(&RADEON_RB3D_DEPTHOFFSET);
    eval 'sub RADEON_RB3D_DEPTHCLEARVALUE () {0x3230;}' unless defined(&RADEON_RB3D_DEPTHCLEARVALUE);
    eval 'sub RADEON_RB3D_DEPTHPITCH () {0x1c28;}' unless defined(&RADEON_RB3D_DEPTHPITCH);
    eval 'sub RADEON_RB3D_PLANEMASK () {0x1d84;}' unless defined(&RADEON_RB3D_PLANEMASK);
    eval 'sub RADEON_RB3D_STENCILREFMASK () {0x1d7c;}' unless defined(&RADEON_RB3D_STENCILREFMASK);
    eval 'sub RADEON_RB3D_ZCACHE_MODE () {0x3250;}' unless defined(&RADEON_RB3D_ZCACHE_MODE);
    eval 'sub RADEON_RB3D_ZCACHE_CTLSTAT () {0x3254;}' unless defined(&RADEON_RB3D_ZCACHE_CTLSTAT);
    eval 'sub RADEON_RB3D_ZC_FLUSH () {(1<< 0);}' unless defined(&RADEON_RB3D_ZC_FLUSH);
    eval 'sub RADEON_RB3D_ZC_FREE () {(1<< 2);}' unless defined(&RADEON_RB3D_ZC_FREE);
    eval 'sub RADEON_RB3D_ZC_FLUSH_ALL () {0x5;}' unless defined(&RADEON_RB3D_ZC_FLUSH_ALL);
    eval 'sub RADEON_RB3D_ZC_BUSY () {(1<< 31);}' unless defined(&RADEON_RB3D_ZC_BUSY);
    eval 'sub RADEON_RB3D_DSTCACHE_CTLSTAT () {0x325c;}' unless defined(&RADEON_RB3D_DSTCACHE_CTLSTAT);
    eval 'sub RADEON_RB3D_DC_FLUSH () {(3<< 0);}' unless defined(&RADEON_RB3D_DC_FLUSH);
    eval 'sub RADEON_RB3D_DC_FREE () {(3<< 2);}' unless defined(&RADEON_RB3D_DC_FREE);
    eval 'sub RADEON_RB3D_DC_FLUSH_ALL () {0xf;}' unless defined(&RADEON_RB3D_DC_FLUSH_ALL);
    eval 'sub RADEON_RB3D_DC_BUSY () {(1<< 31);}' unless defined(&RADEON_RB3D_DC_BUSY);
    eval 'sub RADEON_RB3D_ZSTENCILCNTL () {0x1c2c;}' unless defined(&RADEON_RB3D_ZSTENCILCNTL);
    eval 'sub RADEON_Z_TEST_MASK () {(7<< 4);}' unless defined(&RADEON_Z_TEST_MASK);
    eval 'sub RADEON_Z_TEST_ALWAYS () {(7<< 4);}' unless defined(&RADEON_Z_TEST_ALWAYS);
    eval 'sub RADEON_Z_HIERARCHY_ENABLE () {(1<< 8);}' unless defined(&RADEON_Z_HIERARCHY_ENABLE);
    eval 'sub RADEON_STENCIL_TEST_ALWAYS () {(7<< 12);}' unless defined(&RADEON_STENCIL_TEST_ALWAYS);
    eval 'sub RADEON_STENCIL_S_FAIL_REPLACE () {(2<< 16);}' unless defined(&RADEON_STENCIL_S_FAIL_REPLACE);
    eval 'sub RADEON_STENCIL_ZPASS_REPLACE () {(2<< 20);}' unless defined(&RADEON_STENCIL_ZPASS_REPLACE);
    eval 'sub RADEON_STENCIL_ZFAIL_REPLACE () {(2<< 24);}' unless defined(&RADEON_STENCIL_ZFAIL_REPLACE);
    eval 'sub RADEON_Z_COMPRESSION_ENABLE () {(1<< 28);}' unless defined(&RADEON_Z_COMPRESSION_ENABLE);
    eval 'sub RADEON_FORCE_Z_DIRTY () {(1<< 29);}' unless defined(&RADEON_FORCE_Z_DIRTY);
    eval 'sub RADEON_Z_WRITE_ENABLE () {(1<< 30);}' unless defined(&RADEON_Z_WRITE_ENABLE);
    eval 'sub RADEON_Z_DECOMPRESSION_ENABLE () {(1<< 31);}' unless defined(&RADEON_Z_DECOMPRESSION_ENABLE);
    eval 'sub RADEON_RBBM_SOFT_RESET () {0xf0;}' unless defined(&RADEON_RBBM_SOFT_RESET);
    eval 'sub RADEON_SOFT_RESET_CP () {(1<< 0);}' unless defined(&RADEON_SOFT_RESET_CP);
    eval 'sub RADEON_SOFT_RESET_HI () {(1<< 1);}' unless defined(&RADEON_SOFT_RESET_HI);
    eval 'sub RADEON_SOFT_RESET_SE () {(1<< 2);}' unless defined(&RADEON_SOFT_RESET_SE);
    eval 'sub RADEON_SOFT_RESET_RE () {(1<< 3);}' unless defined(&RADEON_SOFT_RESET_RE);
    eval 'sub RADEON_SOFT_RESET_PP () {(1<< 4);}' unless defined(&RADEON_SOFT_RESET_PP);
    eval 'sub RADEON_SOFT_RESET_E2 () {(1<< 5);}' unless defined(&RADEON_SOFT_RESET_E2);
    eval 'sub RADEON_SOFT_RESET_RB () {(1<< 6);}' unless defined(&RADEON_SOFT_RESET_RB);
    eval 'sub RADEON_SOFT_RESET_HDP () {(1<< 7);}' unless defined(&RADEON_SOFT_RESET_HDP);
    eval 'sub RADEON_RBBM_STATUS () {0xe40;}' unless defined(&RADEON_RBBM_STATUS);
    eval 'sub RADEON_RBBM_FIFOCNT_MASK () {0x7f;}' unless defined(&RADEON_RBBM_FIFOCNT_MASK);
    eval 'sub RADEON_HIRQ_ON_RBB () {(1<< 8);}' unless defined(&RADEON_HIRQ_ON_RBB);
    eval 'sub RADEON_CPRQ_ON_RBB () {(1<< 9);}' unless defined(&RADEON_CPRQ_ON_RBB);
    eval 'sub RADEON_CFRQ_ON_RBB () {(1<< 10);}' unless defined(&RADEON_CFRQ_ON_RBB);
    eval 'sub RADEON_HIRQ_IN_RTBUF () {(1<< 11);}' unless defined(&RADEON_HIRQ_IN_RTBUF);
    eval 'sub RADEON_CPRQ_IN_RTBUF () {(1<< 12);}' unless defined(&RADEON_CPRQ_IN_RTBUF);
    eval 'sub RADEON_CFRQ_IN_RTBUF () {(1<< 13);}' unless defined(&RADEON_CFRQ_IN_RTBUF);
    eval 'sub RADEON_PIPE_BUSY () {(1<< 14);}' unless defined(&RADEON_PIPE_BUSY);
    eval 'sub RADEON_ENG_EV_BUSY () {(1<< 15);}' unless defined(&RADEON_ENG_EV_BUSY);
    eval 'sub RADEON_CP_CMDSTRM_BUSY () {(1<< 16);}' unless defined(&RADEON_CP_CMDSTRM_BUSY);
    eval 'sub RADEON_E2_BUSY () {(1<< 17);}' unless defined(&RADEON_E2_BUSY);
    eval 'sub RADEON_RB2D_BUSY () {(1<< 18);}' unless defined(&RADEON_RB2D_BUSY);
    eval 'sub RADEON_RB3D_BUSY () {(1<< 19);}' unless defined(&RADEON_RB3D_BUSY);
    eval 'sub RADEON_VAP_BUSY () {(1<< 20);}' unless defined(&RADEON_VAP_BUSY);
    eval 'sub RADEON_RE_BUSY () {(1<< 21);}' unless defined(&RADEON_RE_BUSY);
    eval 'sub RADEON_TAM_BUSY () {(1<< 22);}' unless defined(&RADEON_TAM_BUSY);
    eval 'sub RADEON_TDM_BUSY () {(1<< 23);}' unless defined(&RADEON_TDM_BUSY);
    eval 'sub RADEON_PB_BUSY () {(1<< 24);}' unless defined(&RADEON_PB_BUSY);
    eval 'sub RADEON_TIM_BUSY () {(1<< 25);}' unless defined(&RADEON_TIM_BUSY);
    eval 'sub RADEON_GA_BUSY () {(1<< 26);}' unless defined(&RADEON_GA_BUSY);
    eval 'sub RADEON_CBA2D_BUSY () {(1<< 27);}' unless defined(&RADEON_CBA2D_BUSY);
    eval 'sub RADEON_RBBM_ACTIVE () {(1<< 31);}' unless defined(&RADEON_RBBM_ACTIVE);
    eval 'sub RADEON_RE_LINE_PATTERN () {0x1cd0;}' unless defined(&RADEON_RE_LINE_PATTERN);
    eval 'sub RADEON_RE_MISC () {0x26c4;}' unless defined(&RADEON_RE_MISC);
    eval 'sub RADEON_RE_TOP_LEFT () {0x26c0;}' unless defined(&RADEON_RE_TOP_LEFT);
    eval 'sub RADEON_RE_WIDTH_HEIGHT () {0x1c44;}' unless defined(&RADEON_RE_WIDTH_HEIGHT);
    eval 'sub RADEON_RE_STIPPLE_ADDR () {0x1cc8;}' unless defined(&RADEON_RE_STIPPLE_ADDR);
    eval 'sub RADEON_RE_STIPPLE_DATA () {0x1ccc;}' unless defined(&RADEON_RE_STIPPLE_DATA);
    eval 'sub RADEON_SCISSOR_TL_0 () {0x1cd8;}' unless defined(&RADEON_SCISSOR_TL_0);
    eval 'sub RADEON_SCISSOR_BR_0 () {0x1cdc;}' unless defined(&RADEON_SCISSOR_BR_0);
    eval 'sub RADEON_SCISSOR_TL_1 () {0x1ce0;}' unless defined(&RADEON_SCISSOR_TL_1);
    eval 'sub RADEON_SCISSOR_BR_1 () {0x1ce4;}' unless defined(&RADEON_SCISSOR_BR_1);
    eval 'sub RADEON_SCISSOR_TL_2 () {0x1ce8;}' unless defined(&RADEON_SCISSOR_TL_2);
    eval 'sub RADEON_SCISSOR_BR_2 () {0x1cec;}' unless defined(&RADEON_SCISSOR_BR_2);
    eval 'sub RADEON_SE_COORD_FMT () {0x1c50;}' unless defined(&RADEON_SE_COORD_FMT);
    eval 'sub RADEON_SE_CNTL () {0x1c4c;}' unless defined(&RADEON_SE_CNTL);
    eval 'sub RADEON_FFACE_CULL_CW () {(0<< 0);}' unless defined(&RADEON_FFACE_CULL_CW);
    eval 'sub RADEON_BFACE_SOLID () {(3<< 1);}' unless defined(&RADEON_BFACE_SOLID);
    eval 'sub RADEON_FFACE_SOLID () {(3<< 3);}' unless defined(&RADEON_FFACE_SOLID);
    eval 'sub RADEON_FLAT_SHADE_VTX_LAST () {(3<< 6);}' unless defined(&RADEON_FLAT_SHADE_VTX_LAST);
    eval 'sub RADEON_DIFFUSE_SHADE_FLAT () {(1<< 8);}' unless defined(&RADEON_DIFFUSE_SHADE_FLAT);
    eval 'sub RADEON_DIFFUSE_SHADE_GOURAUD () {(2<< 8);}' unless defined(&RADEON_DIFFUSE_SHADE_GOURAUD);
    eval 'sub RADEON_ALPHA_SHADE_FLAT () {(1<< 10);}' unless defined(&RADEON_ALPHA_SHADE_FLAT);
    eval 'sub RADEON_ALPHA_SHADE_GOURAUD () {(2<< 10);}' unless defined(&RADEON_ALPHA_SHADE_GOURAUD);
    eval 'sub RADEON_SPECULAR_SHADE_FLAT () {(1<< 12);}' unless defined(&RADEON_SPECULAR_SHADE_FLAT);
    eval 'sub RADEON_SPECULAR_SHADE_GOURAUD () {(2<< 12);}' unless defined(&RADEON_SPECULAR_SHADE_GOURAUD);
    eval 'sub RADEON_FOG_SHADE_FLAT () {(1<< 14);}' unless defined(&RADEON_FOG_SHADE_FLAT);
    eval 'sub RADEON_FOG_SHADE_GOURAUD () {(2<< 14);}' unless defined(&RADEON_FOG_SHADE_GOURAUD);
    eval 'sub RADEON_VPORT_XY_XFORM_ENABLE () {(1<< 24);}' unless defined(&RADEON_VPORT_XY_XFORM_ENABLE);
    eval 'sub RADEON_VPORT_Z_XFORM_ENABLE () {(1<< 25);}' unless defined(&RADEON_VPORT_Z_XFORM_ENABLE);
    eval 'sub RADEON_VTX_PIX_CENTER_OGL () {(1<< 27);}' unless defined(&RADEON_VTX_PIX_CENTER_OGL);
    eval 'sub RADEON_ROUND_MODE_TRUNC () {(0<< 28);}' unless defined(&RADEON_ROUND_MODE_TRUNC);
    eval 'sub RADEON_ROUND_PREC_8TH_PIX () {(1<< 30);}' unless defined(&RADEON_ROUND_PREC_8TH_PIX);
    eval 'sub RADEON_SE_CNTL_STATUS () {0x2140;}' unless defined(&RADEON_SE_CNTL_STATUS);
    eval 'sub RADEON_SE_LINE_WIDTH () {0x1db8;}' unless defined(&RADEON_SE_LINE_WIDTH);
    eval 'sub RADEON_SE_VPORT_XSCALE () {0x1d98;}' unless defined(&RADEON_SE_VPORT_XSCALE);
    eval 'sub RADEON_SE_ZBIAS_FACTOR () {0x1db0;}' unless defined(&RADEON_SE_ZBIAS_FACTOR);
    eval 'sub RADEON_SE_TCL_MATERIAL_EMMISSIVE_RED () {0x2210;}' unless defined(&RADEON_SE_TCL_MATERIAL_EMMISSIVE_RED);
    eval 'sub RADEON_SE_TCL_OUTPUT_VTX_FMT () {0x2254;}' unless defined(&RADEON_SE_TCL_OUTPUT_VTX_FMT);
    eval 'sub RADEON_SE_TCL_VECTOR_INDX_REG () {0x2200;}' unless defined(&RADEON_SE_TCL_VECTOR_INDX_REG);
    eval 'sub RADEON_VEC_INDX_OCTWORD_STRIDE_SHIFT () {16;}' unless defined(&RADEON_VEC_INDX_OCTWORD_STRIDE_SHIFT);
    eval 'sub RADEON_VEC_INDX_DWORD_COUNT_SHIFT () {28;}' unless defined(&RADEON_VEC_INDX_DWORD_COUNT_SHIFT);
    eval 'sub RADEON_SE_TCL_VECTOR_DATA_REG () {0x2204;}' unless defined(&RADEON_SE_TCL_VECTOR_DATA_REG);
    eval 'sub RADEON_SE_TCL_SCALAR_INDX_REG () {0x2208;}' unless defined(&RADEON_SE_TCL_SCALAR_INDX_REG);
    eval 'sub RADEON_SCAL_INDX_DWORD_STRIDE_SHIFT () {16;}' unless defined(&RADEON_SCAL_INDX_DWORD_STRIDE_SHIFT);
    eval 'sub RADEON_SE_TCL_SCALAR_DATA_REG () {0x220c;}' unless defined(&RADEON_SE_TCL_SCALAR_DATA_REG);
    eval 'sub RADEON_SURFACE_ACCESS_FLAGS () {0xbf8;}' unless defined(&RADEON_SURFACE_ACCESS_FLAGS);
    eval 'sub RADEON_SURFACE_ACCESS_CLR () {0xbfc;}' unless defined(&RADEON_SURFACE_ACCESS_CLR);
    eval 'sub RADEON_SURFACE_CNTL () {0xb00;}' unless defined(&RADEON_SURFACE_CNTL);
    eval 'sub RADEON_SURF_TRANSLATION_DIS () {(1<< 8);}' unless defined(&RADEON_SURF_TRANSLATION_DIS);
    eval 'sub RADEON_NONSURF_AP0_SWP_MASK () {(3<< 20);}' unless defined(&RADEON_NONSURF_AP0_SWP_MASK);
    eval 'sub RADEON_NONSURF_AP0_SWP_LITTLE () {(0<< 20);}' unless defined(&RADEON_NONSURF_AP0_SWP_LITTLE);
    eval 'sub RADEON_NONSURF_AP0_SWP_BIG16 () {(1<< 20);}' unless defined(&RADEON_NONSURF_AP0_SWP_BIG16);
    eval 'sub RADEON_NONSURF_AP0_SWP_BIG32 () {(2<< 20);}' unless defined(&RADEON_NONSURF_AP0_SWP_BIG32);
    eval 'sub RADEON_NONSURF_AP1_SWP_MASK () {(3<< 22);}' unless defined(&RADEON_NONSURF_AP1_SWP_MASK);
    eval 'sub RADEON_NONSURF_AP1_SWP_LITTLE () {(0<< 22);}' unless defined(&RADEON_NONSURF_AP1_SWP_LITTLE);
    eval 'sub RADEON_NONSURF_AP1_SWP_BIG16 () {(1<< 22);}' unless defined(&RADEON_NONSURF_AP1_SWP_BIG16);
    eval 'sub RADEON_NONSURF_AP1_SWP_BIG32 () {(2<< 22);}' unless defined(&RADEON_NONSURF_AP1_SWP_BIG32);
    eval 'sub RADEON_SURFACE0_INFO () {0xb0c;}' unless defined(&RADEON_SURFACE0_INFO);
    eval 'sub RADEON_SURF_PITCHSEL_MASK () {(0x1ff << 0);}' unless defined(&RADEON_SURF_PITCHSEL_MASK);
    eval 'sub RADEON_SURF_TILE_MODE_MASK () {(3<< 16);}' unless defined(&RADEON_SURF_TILE_MODE_MASK);
    eval 'sub RADEON_SURF_TILE_MODE_MACRO () {(0<< 16);}' unless defined(&RADEON_SURF_TILE_MODE_MACRO);
    eval 'sub RADEON_SURF_TILE_MODE_MICRO () {(1<< 16);}' unless defined(&RADEON_SURF_TILE_MODE_MICRO);
    eval 'sub RADEON_SURF_TILE_MODE_32BIT_Z () {(2<< 16);}' unless defined(&RADEON_SURF_TILE_MODE_32BIT_Z);
    eval 'sub RADEON_SURF_TILE_MODE_16BIT_Z () {(3<< 16);}' unless defined(&RADEON_SURF_TILE_MODE_16BIT_Z);
    eval 'sub RADEON_SURFACE0_LOWER_BOUND () {0xb04;}' unless defined(&RADEON_SURFACE0_LOWER_BOUND);
    eval 'sub RADEON_SURFACE0_UPPER_BOUND () {0xb08;}' unless defined(&RADEON_SURFACE0_UPPER_BOUND);
    eval 'sub RADEON_SURF_ADDRESS_FIXED_MASK () {(0x3ff << 0);}' unless defined(&RADEON_SURF_ADDRESS_FIXED_MASK);
    eval 'sub RADEON_SURFACE1_INFO () {0xb1c;}' unless defined(&RADEON_SURFACE1_INFO);
    eval 'sub RADEON_SURFACE1_LOWER_BOUND () {0xb14;}' unless defined(&RADEON_SURFACE1_LOWER_BOUND);
    eval 'sub RADEON_SURFACE1_UPPER_BOUND () {0xb18;}' unless defined(&RADEON_SURFACE1_UPPER_BOUND);
    eval 'sub RADEON_SURFACE2_INFO () {0xb2c;}' unless defined(&RADEON_SURFACE2_INFO);
    eval 'sub RADEON_SURFACE2_LOWER_BOUND () {0xb24;}' unless defined(&RADEON_SURFACE2_LOWER_BOUND);
    eval 'sub RADEON_SURFACE2_UPPER_BOUND () {0xb28;}' unless defined(&RADEON_SURFACE2_UPPER_BOUND);
    eval 'sub RADEON_SURFACE3_INFO () {0xb3c;}' unless defined(&RADEON_SURFACE3_INFO);
    eval 'sub RADEON_SURFACE3_LOWER_BOUND () {0xb34;}' unless defined(&RADEON_SURFACE3_LOWER_BOUND);
    eval 'sub RADEON_SURFACE3_UPPER_BOUND () {0xb38;}' unless defined(&RADEON_SURFACE3_UPPER_BOUND);
    eval 'sub RADEON_SURFACE4_INFO () {0xb4c;}' unless defined(&RADEON_SURFACE4_INFO);
    eval 'sub RADEON_SURFACE4_LOWER_BOUND () {0xb44;}' unless defined(&RADEON_SURFACE4_LOWER_BOUND);
    eval 'sub RADEON_SURFACE4_UPPER_BOUND () {0xb48;}' unless defined(&RADEON_SURFACE4_UPPER_BOUND);
    eval 'sub RADEON_SURFACE5_INFO () {0xb5c;}' unless defined(&RADEON_SURFACE5_INFO);
    eval 'sub RADEON_SURFACE5_LOWER_BOUND () {0xb54;}' unless defined(&RADEON_SURFACE5_LOWER_BOUND);
    eval 'sub RADEON_SURFACE5_UPPER_BOUND () {0xb58;}' unless defined(&RADEON_SURFACE5_UPPER_BOUND);
    eval 'sub RADEON_SURFACE6_INFO () {0xb6c;}' unless defined(&RADEON_SURFACE6_INFO);
    eval 'sub RADEON_SURFACE6_LOWER_BOUND () {0xb64;}' unless defined(&RADEON_SURFACE6_LOWER_BOUND);
    eval 'sub RADEON_SURFACE6_UPPER_BOUND () {0xb68;}' unless defined(&RADEON_SURFACE6_UPPER_BOUND);
    eval 'sub RADEON_SURFACE7_INFO () {0xb7c;}' unless defined(&RADEON_SURFACE7_INFO);
    eval 'sub RADEON_SURFACE7_LOWER_BOUND () {0xb74;}' unless defined(&RADEON_SURFACE7_LOWER_BOUND);
    eval 'sub RADEON_SURFACE7_UPPER_BOUND () {0xb78;}' unless defined(&RADEON_SURFACE7_UPPER_BOUND);
    eval 'sub RADEON_SW_SEMAPHORE () {0x13c;}' unless defined(&RADEON_SW_SEMAPHORE);
    eval 'sub RADEON_WAIT_UNTIL () {0x1720;}' unless defined(&RADEON_WAIT_UNTIL);
    eval 'sub RADEON_WAIT_CRTC_PFLIP () {(1<< 0);}' unless defined(&RADEON_WAIT_CRTC_PFLIP);
    eval 'sub RADEON_WAIT_2D_IDLE () {(1<< 14);}' unless defined(&RADEON_WAIT_2D_IDLE);
    eval 'sub RADEON_WAIT_3D_IDLE () {(1<< 15);}' unless defined(&RADEON_WAIT_3D_IDLE);
    eval 'sub RADEON_WAIT_2D_IDLECLEAN () {(1<< 16);}' unless defined(&RADEON_WAIT_2D_IDLECLEAN);
    eval 'sub RADEON_WAIT_3D_IDLECLEAN () {(1<< 17);}' unless defined(&RADEON_WAIT_3D_IDLECLEAN);
    eval 'sub RADEON_WAIT_HOST_IDLECLEAN () {(1<< 18);}' unless defined(&RADEON_WAIT_HOST_IDLECLEAN);
    eval 'sub RADEON_RB3D_ZMASKOFFSET () {0x3234;}' unless defined(&RADEON_RB3D_ZMASKOFFSET);
    eval 'sub RADEON_RB3D_ZSTENCILCNTL () {0x1c2c;}' unless defined(&RADEON_RB3D_ZSTENCILCNTL);
    eval 'sub RADEON_DEPTH_FORMAT_16BIT_INT_Z () {(0<< 0);}' unless defined(&RADEON_DEPTH_FORMAT_16BIT_INT_Z);
    eval 'sub RADEON_DEPTH_FORMAT_24BIT_INT_Z () {(2<< 0);}' unless defined(&RADEON_DEPTH_FORMAT_24BIT_INT_Z);
    eval 'sub RADEON_CP_ME_RAM_ADDR () {0x7d4;}' unless defined(&RADEON_CP_ME_RAM_ADDR);
    eval 'sub RADEON_CP_ME_RAM_RADDR () {0x7d8;}' unless defined(&RADEON_CP_ME_RAM_RADDR);
    eval 'sub RADEON_CP_ME_RAM_DATAH () {0x7dc;}' unless defined(&RADEON_CP_ME_RAM_DATAH);
    eval 'sub RADEON_CP_ME_RAM_DATAL () {0x7e0;}' unless defined(&RADEON_CP_ME_RAM_DATAL);
    eval 'sub RADEON_CP_RB_BASE () {0x700;}' unless defined(&RADEON_CP_RB_BASE);
    eval 'sub RADEON_CP_RB_CNTL () {0x704;}' unless defined(&RADEON_CP_RB_CNTL);
    eval 'sub RADEON_BUF_SWAP_32BIT () {(2<< 16);}' unless defined(&RADEON_BUF_SWAP_32BIT);
    eval 'sub RADEON_RB_NO_UPDATE () {(1<< 27);}' unless defined(&RADEON_RB_NO_UPDATE);
    eval 'sub RADEON_CP_RB_RPTR_ADDR () {0x70c;}' unless defined(&RADEON_CP_RB_RPTR_ADDR);
    eval 'sub RADEON_CP_RB_RPTR () {0x710;}' unless defined(&RADEON_CP_RB_RPTR);
    eval 'sub RADEON_CP_RB_WPTR () {0x714;}' unless defined(&RADEON_CP_RB_WPTR);
    eval 'sub RADEON_CP_RB_WPTR_DELAY () {0x718;}' unless defined(&RADEON_CP_RB_WPTR_DELAY);
    eval 'sub RADEON_PRE_WRITE_TIMER_SHIFT () {0;}' unless defined(&RADEON_PRE_WRITE_TIMER_SHIFT);
    eval 'sub RADEON_PRE_WRITE_LIMIT_SHIFT () {23;}' unless defined(&RADEON_PRE_WRITE_LIMIT_SHIFT);
    eval 'sub RADEON_CP_IB_BASE () {0x738;}' unless defined(&RADEON_CP_IB_BASE);
    eval 'sub RADEON_CP_CSQ_CNTL () {0x740;}' unless defined(&RADEON_CP_CSQ_CNTL);
    eval 'sub RADEON_CSQ_CNT_PRIMARY_MASK () {(0xff << 0);}' unless defined(&RADEON_CSQ_CNT_PRIMARY_MASK);
    eval 'sub RADEON_CSQ_PRIDIS_INDDIS () {(0<< 28);}' unless defined(&RADEON_CSQ_PRIDIS_INDDIS);
    eval 'sub RADEON_CSQ_PRIPIO_INDDIS () {(1<< 28);}' unless defined(&RADEON_CSQ_PRIPIO_INDDIS);
    eval 'sub RADEON_CSQ_PRIBM_INDDIS () {(2<< 28);}' unless defined(&RADEON_CSQ_PRIBM_INDDIS);
    eval 'sub RADEON_CSQ_PRIPIO_INDBM () {(3<< 28);}' unless defined(&RADEON_CSQ_PRIPIO_INDBM);
    eval 'sub RADEON_CSQ_PRIBM_INDBM () {(4<< 28);}' unless defined(&RADEON_CSQ_PRIBM_INDBM);
    eval 'sub RADEON_CSQ_PRIPIO_INDPIO () {(15<< 28);}' unless defined(&RADEON_CSQ_PRIPIO_INDPIO);
    eval 'sub RADEON_AIC_CNTL () {0x1d0;}' unless defined(&RADEON_AIC_CNTL);
    eval 'sub RADEON_PCIGART_TRANSLATE_EN () {(1<< 0);}' unless defined(&RADEON_PCIGART_TRANSLATE_EN);
    eval 'sub RADEON_AIC_STAT () {0x1d4;}' unless defined(&RADEON_AIC_STAT);
    eval 'sub RADEON_AIC_PT_BASE () {0x1d8;}' unless defined(&RADEON_AIC_PT_BASE);
    eval 'sub RADEON_AIC_LO_ADDR () {0x1dc;}' unless defined(&RADEON_AIC_LO_ADDR);
    eval 'sub RADEON_AIC_HI_ADDR () {0x1e0;}' unless defined(&RADEON_AIC_HI_ADDR);
    eval 'sub RADEON_AIC_TLB_ADDR () {0x1e4;}' unless defined(&RADEON_AIC_TLB_ADDR);
    eval 'sub RADEON_AIC_TLB_DATA () {0x1e8;}' unless defined(&RADEON_AIC_TLB_DATA);
    eval 'sub RADEON_CP_PACKET0 () {0x;}' unless defined(&RADEON_CP_PACKET0);
    eval 'sub RADEON_ONE_REG_WR () {(1<< 15);}' unless defined(&RADEON_ONE_REG_WR);
    eval 'sub RADEON_CP_PACKET1 () {0x40000000;}' unless defined(&RADEON_CP_PACKET1);
    eval 'sub RADEON_CP_PACKET2 () {0x80000000;}' unless defined(&RADEON_CP_PACKET2);
    eval 'sub RADEON_CP_PACKET3 () {0xc0000000;}' unless defined(&RADEON_CP_PACKET3);
    eval 'sub RADEON_CP_NOP () {0x1000;}' unless defined(&RADEON_CP_NOP);
    eval 'sub RADEON_CP_NEXT_CHAR () {0x1900;}' unless defined(&RADEON_CP_NEXT_CHAR);
    eval 'sub RADEON_CP_PLY_NEXTSCAN () {0x1d00;}' unless defined(&RADEON_CP_PLY_NEXTSCAN);
    eval 'sub RADEON_CP_SET_SCISSORS () {0x1e00;}' unless defined(&RADEON_CP_SET_SCISSORS);
    eval 'sub RADEON_3D_RNDR_GEN_INDX_PRIM () {0x2300;}' unless defined(&RADEON_3D_RNDR_GEN_INDX_PRIM);
    eval 'sub RADEON_WAIT_FOR_IDLE () {0x2600;}' unless defined(&RADEON_WAIT_FOR_IDLE);
    eval 'sub RADEON_3D_DRAW_VBUF () {0x2800;}' unless defined(&RADEON_3D_DRAW_VBUF);
    eval 'sub RADEON_3D_DRAW_IMMD () {0x2900;}' unless defined(&RADEON_3D_DRAW_IMMD);
    eval 'sub RADEON_3D_DRAW_INDX () {0x2a00;}' unless defined(&RADEON_3D_DRAW_INDX);
    eval 'sub RADEON_CP_LOAD_PALETTE () {0x2c00;}' unless defined(&RADEON_CP_LOAD_PALETTE);
    eval 'sub RADEON_3D_LOAD_VBPNTR () {0x2f00;}' unless defined(&RADEON_3D_LOAD_VBPNTR);
    eval 'sub RADEON_MPEG_IDCT_MACROBLOCK () {0x3000;}' unless defined(&RADEON_MPEG_IDCT_MACROBLOCK);
    eval 'sub RADEON_MPEG_IDCT_MACROBLOCK_REV () {0x3100;}' unless defined(&RADEON_MPEG_IDCT_MACROBLOCK_REV);
    eval 'sub RADEON_3D_CLEAR_ZMASK () {0x3200;}' unless defined(&RADEON_3D_CLEAR_ZMASK);
    eval 'sub RADEON_CP_INDX_BUFFER () {0x3300;}' unless defined(&RADEON_CP_INDX_BUFFER);
    eval 'sub RADEON_CP_3D_DRAW_VBUF_2 () {0x3400;}' unless defined(&RADEON_CP_3D_DRAW_VBUF_2);
    eval 'sub RADEON_CP_3D_DRAW_IMMD_2 () {0x3500;}' unless defined(&RADEON_CP_3D_DRAW_IMMD_2);
    eval 'sub RADEON_CP_3D_DRAW_INDX_2 () {0x3600;}' unless defined(&RADEON_CP_3D_DRAW_INDX_2);
    eval 'sub RADEON_3D_CLEAR_HIZ () {0x3700;}' unless defined(&RADEON_3D_CLEAR_HIZ);
    eval 'sub RADEON_CP_3D_CLEAR_CMASK () {0x3802;}' unless defined(&RADEON_CP_3D_CLEAR_CMASK);
    eval 'sub RADEON_CNTL_HOSTDATA_BLT () {0x9400;}' unless defined(&RADEON_CNTL_HOSTDATA_BLT);
    eval 'sub RADEON_CNTL_PAINT_MULTI () {0x9a00;}' unless defined(&RADEON_CNTL_PAINT_MULTI);
    eval 'sub RADEON_CNTL_BITBLT_MULTI () {0x9b00;}' unless defined(&RADEON_CNTL_BITBLT_MULTI);
    eval 'sub RADEON_CNTL_SET_SCISSORS () {0xc0001e00;}' unless defined(&RADEON_CNTL_SET_SCISSORS);
    eval 'sub RADEON_CP_PACKET_MASK () {0xc0000000;}' unless defined(&RADEON_CP_PACKET_MASK);
    eval 'sub RADEON_CP_PACKET_COUNT_MASK () {0x3fff0000;}' unless defined(&RADEON_CP_PACKET_COUNT_MASK);
    eval 'sub RADEON_CP_PACKET0_REG_MASK () {0x7ff;}' unless defined(&RADEON_CP_PACKET0_REG_MASK);
    eval 'sub RADEON_CP_PACKET1_REG0_MASK () {0x7ff;}' unless defined(&RADEON_CP_PACKET1_REG0_MASK);
    eval 'sub RADEON_CP_PACKET1_REG1_MASK () {0x3ff800;}' unless defined(&RADEON_CP_PACKET1_REG1_MASK);
    eval 'sub RADEON_VTX_Z_PRESENT () {(1<< 31);}' unless defined(&RADEON_VTX_Z_PRESENT);
    eval 'sub RADEON_VTX_PKCOLOR_PRESENT () {(1<< 3);}' unless defined(&RADEON_VTX_PKCOLOR_PRESENT);
    eval 'sub RADEON_PRIM_TYPE_NONE () {(0<< 0);}' unless defined(&RADEON_PRIM_TYPE_NONE);
    eval 'sub RADEON_PRIM_TYPE_POINT () {(1<< 0);}' unless defined(&RADEON_PRIM_TYPE_POINT);
    eval 'sub RADEON_PRIM_TYPE_LINE () {(2<< 0);}' unless defined(&RADEON_PRIM_TYPE_LINE);
    eval 'sub RADEON_PRIM_TYPE_LINE_STRIP () {(3<< 0);}' unless defined(&RADEON_PRIM_TYPE_LINE_STRIP);
    eval 'sub RADEON_PRIM_TYPE_TRI_LIST () {(4<< 0);}' unless defined(&RADEON_PRIM_TYPE_TRI_LIST);
    eval 'sub RADEON_PRIM_TYPE_TRI_FAN () {(5<< 0);}' unless defined(&RADEON_PRIM_TYPE_TRI_FAN);
    eval 'sub RADEON_PRIM_TYPE_TRI_STRIP () {(6<< 0);}' unless defined(&RADEON_PRIM_TYPE_TRI_STRIP);
    eval 'sub RADEON_PRIM_TYPE_TRI_TYPE2 () {(7<< 0);}' unless defined(&RADEON_PRIM_TYPE_TRI_TYPE2);
    eval 'sub RADEON_PRIM_TYPE_RECT_LIST () {(8<< 0);}' unless defined(&RADEON_PRIM_TYPE_RECT_LIST);
    eval 'sub RADEON_PRIM_TYPE_3VRT_POINT_LIST () {(9<< 0);}' unless defined(&RADEON_PRIM_TYPE_3VRT_POINT_LIST);
    eval 'sub RADEON_PRIM_TYPE_3VRT_LINE_LIST () {(10<< 0);}' unless defined(&RADEON_PRIM_TYPE_3VRT_LINE_LIST);
    eval 'sub RADEON_PRIM_TYPE_MASK () {0xf;}' unless defined(&RADEON_PRIM_TYPE_MASK);
    eval 'sub RADEON_PRIM_WALK_IND () {(1<< 4);}' unless defined(&RADEON_PRIM_WALK_IND);
    eval 'sub RADEON_PRIM_WALK_LIST () {(2<< 4);}' unless defined(&RADEON_PRIM_WALK_LIST);
    eval 'sub RADEON_PRIM_WALK_RING () {(3<< 4);}' unless defined(&RADEON_PRIM_WALK_RING);
    eval 'sub RADEON_COLOR_ORDER_BGRA () {(0<< 6);}' unless defined(&RADEON_COLOR_ORDER_BGRA);
    eval 'sub RADEON_COLOR_ORDER_RGBA () {(1<< 6);}' unless defined(&RADEON_COLOR_ORDER_RGBA);
    eval 'sub RADEON_MAOS_ENABLE () {(1<< 7);}' unless defined(&RADEON_MAOS_ENABLE);
    eval 'sub RADEON_VTX_FMT_R128_MODE () {(0<< 8);}' unless defined(&RADEON_VTX_FMT_R128_MODE);
    eval 'sub RADEON_VTX_FMT_RADEON_MODE () {(1<< 8);}' unless defined(&RADEON_VTX_FMT_RADEON_MODE);
    eval 'sub RADEON_NUM_VERTICES_SHIFT () {16;}' unless defined(&RADEON_NUM_VERTICES_SHIFT);
    eval 'sub RADEON_COLOR_FORMAT_CI8 () {2;}' unless defined(&RADEON_COLOR_FORMAT_CI8);
    eval 'sub RADEON_COLOR_FORMAT_ARGB1555 () {3;}' unless defined(&RADEON_COLOR_FORMAT_ARGB1555);
    eval 'sub RADEON_COLOR_FORMAT_RGB565 () {4;}' unless defined(&RADEON_COLOR_FORMAT_RGB565);
    eval 'sub RADEON_COLOR_FORMAT_ARGB8888 () {6;}' unless defined(&RADEON_COLOR_FORMAT_ARGB8888);
    eval 'sub RADEON_COLOR_FORMAT_RGB332 () {7;}' unless defined(&RADEON_COLOR_FORMAT_RGB332);
    eval 'sub RADEON_COLOR_FORMAT_RGB8 () {9;}' unless defined(&RADEON_COLOR_FORMAT_RGB8);
    eval 'sub RADEON_COLOR_FORMAT_ARGB4444 () {15;}' unless defined(&RADEON_COLOR_FORMAT_ARGB4444);
    eval 'sub RADEON_TXFORMAT_I8 () {0;}' unless defined(&RADEON_TXFORMAT_I8);
    eval 'sub RADEON_TXFORMAT_AI88 () {1;}' unless defined(&RADEON_TXFORMAT_AI88);
    eval 'sub RADEON_TXFORMAT_RGB332 () {2;}' unless defined(&RADEON_TXFORMAT_RGB332);
    eval 'sub RADEON_TXFORMAT_ARGB1555 () {3;}' unless defined(&RADEON_TXFORMAT_ARGB1555);
    eval 'sub RADEON_TXFORMAT_RGB565 () {4;}' unless defined(&RADEON_TXFORMAT_RGB565);
    eval 'sub RADEON_TXFORMAT_ARGB4444 () {5;}' unless defined(&RADEON_TXFORMAT_ARGB4444);
    eval 'sub RADEON_TXFORMAT_ARGB8888 () {6;}' unless defined(&RADEON_TXFORMAT_ARGB8888);
    eval 'sub RADEON_TXFORMAT_RGBA8888 () {7;}' unless defined(&RADEON_TXFORMAT_RGBA8888);
    eval 'sub RADEON_TXFORMAT_Y8 () {8;}' unless defined(&RADEON_TXFORMAT_Y8);
    eval 'sub RADEON_TXFORMAT_VYUY422 () {10;}' unless defined(&RADEON_TXFORMAT_VYUY422);
    eval 'sub RADEON_TXFORMAT_YVYU422 () {11;}' unless defined(&RADEON_TXFORMAT_YVYU422);
    eval 'sub RADEON_TXFORMAT_DXT1 () {12;}' unless defined(&RADEON_TXFORMAT_DXT1);
    eval 'sub RADEON_TXFORMAT_DXT23 () {14;}' unless defined(&RADEON_TXFORMAT_DXT23);
    eval 'sub RADEON_TXFORMAT_DXT45 () {15;}' unless defined(&RADEON_TXFORMAT_DXT45);
    eval 'sub R200_PP_TXCBLEND_0 () {0x2f00;}' unless defined(&R200_PP_TXCBLEND_0);
    eval 'sub R200_PP_TXCBLEND_1 () {0x2f10;}' unless defined(&R200_PP_TXCBLEND_1);
    eval 'sub R200_PP_TXCBLEND_2 () {0x2f20;}' unless defined(&R200_PP_TXCBLEND_2);
    eval 'sub R200_PP_TXCBLEND_3 () {0x2f30;}' unless defined(&R200_PP_TXCBLEND_3);
    eval 'sub R200_PP_TXCBLEND_4 () {0x2f40;}' unless defined(&R200_PP_TXCBLEND_4);
    eval 'sub R200_PP_TXCBLEND_5 () {0x2f50;}' unless defined(&R200_PP_TXCBLEND_5);
    eval 'sub R200_PP_TXCBLEND_6 () {0x2f60;}' unless defined(&R200_PP_TXCBLEND_6);
    eval 'sub R200_PP_TXCBLEND_7 () {0x2f70;}' unless defined(&R200_PP_TXCBLEND_7);
    eval 'sub R200_SE_TCL_LIGHT_MODEL_CTL_0 () {0x2268;}' unless defined(&R200_SE_TCL_LIGHT_MODEL_CTL_0);
    eval 'sub R200_PP_TFACTOR_0 () {0x2ee0;}' unless defined(&R200_PP_TFACTOR_0);
    eval 'sub R200_SE_VTX_FMT_0 () {0x2088;}' unless defined(&R200_SE_VTX_FMT_0);
    eval 'sub R200_SE_VAP_CNTL () {0x2080;}' unless defined(&R200_SE_VAP_CNTL);
    eval 'sub R200_SE_TCL_MATRIX_SEL_0 () {0x2230;}' unless defined(&R200_SE_TCL_MATRIX_SEL_0);
    eval 'sub R200_SE_TCL_TEX_PROC_CTL_2 () {0x22a8;}' unless defined(&R200_SE_TCL_TEX_PROC_CTL_2);
    eval 'sub R200_SE_TCL_UCP_VERT_BLEND_CTL () {0x22c0;}' unless defined(&R200_SE_TCL_UCP_VERT_BLEND_CTL);
    eval 'sub R200_PP_TXFILTER_5 () {0x2ca0;}' unless defined(&R200_PP_TXFILTER_5);
    eval 'sub R200_PP_TXFILTER_4 () {0x2c80;}' unless defined(&R200_PP_TXFILTER_4);
    eval 'sub R200_PP_TXFILTER_3 () {0x2c60;}' unless defined(&R200_PP_TXFILTER_3);
    eval 'sub R200_PP_TXFILTER_2 () {0x2c40;}' unless defined(&R200_PP_TXFILTER_2);
    eval 'sub R200_PP_TXFILTER_1 () {0x2c20;}' unless defined(&R200_PP_TXFILTER_1);
    eval 'sub R200_PP_TXFILTER_0 () {0x2c00;}' unless defined(&R200_PP_TXFILTER_0);
    eval 'sub R200_PP_TXOFFSET_5 () {0x2d78;}' unless defined(&R200_PP_TXOFFSET_5);
    eval 'sub R200_PP_TXOFFSET_4 () {0x2d60;}' unless defined(&R200_PP_TXOFFSET_4);
    eval 'sub R200_PP_TXOFFSET_3 () {0x2d48;}' unless defined(&R200_PP_TXOFFSET_3);
    eval 'sub R200_PP_TXOFFSET_2 () {0x2d30;}' unless defined(&R200_PP_TXOFFSET_2);
    eval 'sub R200_PP_TXOFFSET_1 () {0x2d18;}' unless defined(&R200_PP_TXOFFSET_1);
    eval 'sub R200_PP_TXOFFSET_0 () {0x2d00;}' unless defined(&R200_PP_TXOFFSET_0);
    eval 'sub R200_PP_CUBIC_FACES_0 () {0x2c18;}' unless defined(&R200_PP_CUBIC_FACES_0);
    eval 'sub R200_PP_CUBIC_FACES_1 () {0x2c38;}' unless defined(&R200_PP_CUBIC_FACES_1);
    eval 'sub R200_PP_CUBIC_FACES_2 () {0x2c58;}' unless defined(&R200_PP_CUBIC_FACES_2);
    eval 'sub R200_PP_CUBIC_FACES_3 () {0x2c78;}' unless defined(&R200_PP_CUBIC_FACES_3);
    eval 'sub R200_PP_CUBIC_FACES_4 () {0x2c98;}' unless defined(&R200_PP_CUBIC_FACES_4);
    eval 'sub R200_PP_CUBIC_FACES_5 () {0x2cb8;}' unless defined(&R200_PP_CUBIC_FACES_5);
    eval 'sub R200_PP_CUBIC_OFFSET_F1_0 () {0x2d04;}' unless defined(&R200_PP_CUBIC_OFFSET_F1_0);
    eval 'sub R200_PP_CUBIC_OFFSET_F2_0 () {0x2d08;}' unless defined(&R200_PP_CUBIC_OFFSET_F2_0);
    eval 'sub R200_PP_CUBIC_OFFSET_F3_0 () {0x2d0c;}' unless defined(&R200_PP_CUBIC_OFFSET_F3_0);
    eval 'sub R200_PP_CUBIC_OFFSET_F4_0 () {0x2d10;}' unless defined(&R200_PP_CUBIC_OFFSET_F4_0);
    eval 'sub R200_PP_CUBIC_OFFSET_F5_0 () {0x2d14;}' unless defined(&R200_PP_CUBIC_OFFSET_F5_0);
    eval 'sub R200_PP_CUBIC_OFFSET_F1_1 () {0x2d1c;}' unless defined(&R200_PP_CUBIC_OFFSET_F1_1);
    eval 'sub R200_PP_CUBIC_OFFSET_F2_1 () {0x2d20;}' unless defined(&R200_PP_CUBIC_OFFSET_F2_1);
    eval 'sub R200_PP_CUBIC_OFFSET_F3_1 () {0x2d24;}' unless defined(&R200_PP_CUBIC_OFFSET_F3_1);
    eval 'sub R200_PP_CUBIC_OFFSET_F4_1 () {0x2d28;}' unless defined(&R200_PP_CUBIC_OFFSET_F4_1);
    eval 'sub R200_PP_CUBIC_OFFSET_F5_1 () {0x2d2c;}' unless defined(&R200_PP_CUBIC_OFFSET_F5_1);
    eval 'sub R200_PP_CUBIC_OFFSET_F1_2 () {0x2d34;}' unless defined(&R200_PP_CUBIC_OFFSET_F1_2);
    eval 'sub R200_PP_CUBIC_OFFSET_F2_2 () {0x2d38;}' unless defined(&R200_PP_CUBIC_OFFSET_F2_2);
    eval 'sub R200_PP_CUBIC_OFFSET_F3_2 () {0x2d3c;}' unless defined(&R200_PP_CUBIC_OFFSET_F3_2);
    eval 'sub R200_PP_CUBIC_OFFSET_F4_2 () {0x2d40;}' unless defined(&R200_PP_CUBIC_OFFSET_F4_2);
    eval 'sub R200_PP_CUBIC_OFFSET_F5_2 () {0x2d44;}' unless defined(&R200_PP_CUBIC_OFFSET_F5_2);
    eval 'sub R200_PP_CUBIC_OFFSET_F1_3 () {0x2d4c;}' unless defined(&R200_PP_CUBIC_OFFSET_F1_3);
    eval 'sub R200_PP_CUBIC_OFFSET_F2_3 () {0x2d50;}' unless defined(&R200_PP_CUBIC_OFFSET_F2_3);
    eval 'sub R200_PP_CUBIC_OFFSET_F3_3 () {0x2d54;}' unless defined(&R200_PP_CUBIC_OFFSET_F3_3);
    eval 'sub R200_PP_CUBIC_OFFSET_F4_3 () {0x2d58;}' unless defined(&R200_PP_CUBIC_OFFSET_F4_3);
    eval 'sub R200_PP_CUBIC_OFFSET_F5_3 () {0x2d5c;}' unless defined(&R200_PP_CUBIC_OFFSET_F5_3);
    eval 'sub R200_PP_CUBIC_OFFSET_F1_4 () {0x2d64;}' unless defined(&R200_PP_CUBIC_OFFSET_F1_4);
    eval 'sub R200_PP_CUBIC_OFFSET_F2_4 () {0x2d68;}' unless defined(&R200_PP_CUBIC_OFFSET_F2_4);
    eval 'sub R200_PP_CUBIC_OFFSET_F3_4 () {0x2d6c;}' unless defined(&R200_PP_CUBIC_OFFSET_F3_4);
    eval 'sub R200_PP_CUBIC_OFFSET_F4_4 () {0x2d70;}' unless defined(&R200_PP_CUBIC_OFFSET_F4_4);
    eval 'sub R200_PP_CUBIC_OFFSET_F5_4 () {0x2d74;}' unless defined(&R200_PP_CUBIC_OFFSET_F5_4);
    eval 'sub R200_PP_CUBIC_OFFSET_F1_5 () {0x2d7c;}' unless defined(&R200_PP_CUBIC_OFFSET_F1_5);
    eval 'sub R200_PP_CUBIC_OFFSET_F2_5 () {0x2d80;}' unless defined(&R200_PP_CUBIC_OFFSET_F2_5);
    eval 'sub R200_PP_CUBIC_OFFSET_F3_5 () {0x2d84;}' unless defined(&R200_PP_CUBIC_OFFSET_F3_5);
    eval 'sub R200_PP_CUBIC_OFFSET_F4_5 () {0x2d88;}' unless defined(&R200_PP_CUBIC_OFFSET_F4_5);
    eval 'sub R200_PP_CUBIC_OFFSET_F5_5 () {0x2d8c;}' unless defined(&R200_PP_CUBIC_OFFSET_F5_5);
    eval 'sub R200_RE_AUX_SCISSOR_CNTL () {0x26f0;}' unless defined(&R200_RE_AUX_SCISSOR_CNTL);
    eval 'sub R200_SE_VTE_CNTL () {0x20b0;}' unless defined(&R200_SE_VTE_CNTL);
    eval 'sub R200_SE_TCL_OUTPUT_VTX_COMP_SEL () {0x2250;}' unless defined(&R200_SE_TCL_OUTPUT_VTX_COMP_SEL);
    eval 'sub R200_PP_TAM_DEBUG3 () {0x2d9c;}' unless defined(&R200_PP_TAM_DEBUG3);
    eval 'sub R200_PP_CNTL_X () {0x2cc4;}' unless defined(&R200_PP_CNTL_X);
    eval 'sub R200_SE_VAP_CNTL_STATUS () {0x2140;}' unless defined(&R200_SE_VAP_CNTL_STATUS);
    eval 'sub R200_RE_SCISSOR_TL_0 () {0x1cd8;}' unless defined(&R200_RE_SCISSOR_TL_0);
    eval 'sub R200_RE_SCISSOR_TL_1 () {0x1ce0;}' unless defined(&R200_RE_SCISSOR_TL_1);
    eval 'sub R200_RE_SCISSOR_TL_2 () {0x1ce8;}' unless defined(&R200_RE_SCISSOR_TL_2);
    eval 'sub R200_RB3D_DEPTHXY_OFFSET () {0x1d60;}' unless defined(&R200_RB3D_DEPTHXY_OFFSET);
    eval 'sub R200_RE_AUX_SCISSOR_CNTL () {0x26f0;}' unless defined(&R200_RE_AUX_SCISSOR_CNTL);
    eval 'sub R200_SE_VTX_STATE_CNTL () {0x2180;}' unless defined(&R200_SE_VTX_STATE_CNTL);
    eval 'sub R200_RE_POINTSIZE () {0x2648;}' unless defined(&R200_RE_POINTSIZE);
    eval 'sub R200_SE_TCL_INPUT_VTX_VECTOR_ADDR_0 () {0x2254;}' unless defined(&R200_SE_TCL_INPUT_VTX_VECTOR_ADDR_0);
    eval 'sub RADEON_PP_TEX_SIZE_0 () {0x1d04;}' unless defined(&RADEON_PP_TEX_SIZE_0);
    eval 'sub RADEON_PP_TEX_SIZE_1 () {0x1d0c;}' unless defined(&RADEON_PP_TEX_SIZE_1);
    eval 'sub RADEON_PP_TEX_SIZE_2 () {0x1d14;}' unless defined(&RADEON_PP_TEX_SIZE_2);
    eval 'sub RADEON_PP_CUBIC_FACES_0 () {0x1d24;}' unless defined(&RADEON_PP_CUBIC_FACES_0);
    eval 'sub RADEON_PP_CUBIC_FACES_1 () {0x1d28;}' unless defined(&RADEON_PP_CUBIC_FACES_1);
    eval 'sub RADEON_PP_CUBIC_FACES_2 () {0x1d2c;}' unless defined(&RADEON_PP_CUBIC_FACES_2);
    eval 'sub RADEON_PP_CUBIC_OFFSET_T0_0 () {0x1dd0;}' unless defined(&RADEON_PP_CUBIC_OFFSET_T0_0);
    eval 'sub RADEON_PP_CUBIC_OFFSET_T1_0 () {0x1e00;}' unless defined(&RADEON_PP_CUBIC_OFFSET_T1_0);
    eval 'sub RADEON_PP_CUBIC_OFFSET_T2_0 () {0x1e14;}' unless defined(&RADEON_PP_CUBIC_OFFSET_T2_0);
    eval 'sub RADEON_SE_TCL_STATE_FLUSH () {0x2284;}' unless defined(&RADEON_SE_TCL_STATE_FLUSH);
    eval 'sub SE_VAP_CNTL__TCL_ENA_MASK () {0x1;}' unless defined(&SE_VAP_CNTL__TCL_ENA_MASK);
    eval 'sub SE_VAP_CNTL__FORCE_W_TO_ONE_MASK () {0x10000;}' unless defined(&SE_VAP_CNTL__FORCE_W_TO_ONE_MASK);
    eval 'sub SE_VAP_CNTL__VF_MAX_VTX_NUM__SHIFT () {0x12;}' unless defined(&SE_VAP_CNTL__VF_MAX_VTX_NUM__SHIFT);
    eval 'sub SE_VTE_CNTL__VTX_XY_FMT_MASK () {0x100;}' unless defined(&SE_VTE_CNTL__VTX_XY_FMT_MASK);
    eval 'sub SE_VTE_CNTL__VTX_Z_FMT_MASK () {0x200;}' unless defined(&SE_VTE_CNTL__VTX_Z_FMT_MASK);
    eval 'sub SE_VTX_FMT_0__VTX_Z0_PRESENT_MASK () {0x1;}' unless defined(&SE_VTX_FMT_0__VTX_Z0_PRESENT_MASK);
    eval 'sub SE_VTX_FMT_0__VTX_W0_PRESENT_MASK () {0x2;}' unless defined(&SE_VTX_FMT_0__VTX_W0_PRESENT_MASK);
    eval 'sub SE_VTX_FMT_0__VTX_COLOR_0_FMT__SHIFT () {0xb;}' unless defined(&SE_VTX_FMT_0__VTX_COLOR_0_FMT__SHIFT);
    eval 'sub R200_3D_DRAW_IMMD_2 () {0xc0003500;}' unless defined(&R200_3D_DRAW_IMMD_2);
    eval 'sub R200_SE_VTX_FMT_1 () {0x208c;}' unless defined(&R200_SE_VTX_FMT_1);
    eval 'sub R200_RE_CNTL () {0x1c50;}' unless defined(&R200_RE_CNTL);
    eval 'sub R200_RB3D_BLENDCOLOR () {0x3218;}' unless defined(&R200_RB3D_BLENDCOLOR);
    eval 'sub R200_SE_TCL_POINT_SPRITE_CNTL () {0x22c4;}' unless defined(&R200_SE_TCL_POINT_SPRITE_CNTL);
    eval 'sub R200_PP_TRI_PERF () {0x2cf8;}' unless defined(&R200_PP_TRI_PERF);
    eval 'sub R200_PP_AFS_0 () {0x2f80;}' unless defined(&R200_PP_AFS_0);
    eval 'sub R200_PP_AFS_1 () {0x2f00;}' unless defined(&R200_PP_AFS_1);
    eval 'sub R200_VAP_PVS_CNTL_1 () {0x22d0;}' unless defined(&R200_VAP_PVS_CNTL_1);
    eval 'sub RADEON_VHA_SETTO16_1 () {0x2694;}' unless defined(&RADEON_VHA_SETTO16_1);
    eval 'sub RADEON_VHA_SETTO16_2 () {0x2680;}' unless defined(&RADEON_VHA_SETTO16_2);
    eval 'sub RADEON_VHA_SETTO0_1 () {0x1840;}' unless defined(&RADEON_VHA_SETTO0_1);
    eval 'sub RADEON_VHA_FB_OFFSET () {0x19e4;}' unless defined(&RADEON_VHA_FB_OFFSET);
    eval 'sub RADEON_VHA_SETTO1AND70S () {0x19d8;}' unless defined(&RADEON_VHA_SETTO1AND70S);
    eval 'sub RADEON_VHA_DST_PITCH () {0x1408;}' unless defined(&RADEON_VHA_DST_PITCH);
    eval 'sub RADEON_VHA_BACKFRAME0_OFF_Y () {0x1840;}' unless defined(&RADEON_VHA_BACKFRAME0_OFF_Y);
    eval 'sub RADEON_VHA_BACKFRAME1_OFF_PITCH_Y () {0x1844;}' unless defined(&RADEON_VHA_BACKFRAME1_OFF_PITCH_Y);
    eval 'sub RADEON_VHA_BACKFRAME0_OFF_U () {0x1848;}' unless defined(&RADEON_VHA_BACKFRAME0_OFF_U);
    eval 'sub RADEON_VHA_BACKFRAME1_OFF_PITCH_U () {0x184c;}' unless defined(&RADEON_VHA_BACKFRAME1_OFF_PITCH_U);
    eval 'sub RADOEN_VHA_BACKFRAME0_OFF_V () {0x1850;}' unless defined(&RADOEN_VHA_BACKFRAME0_OFF_V);
    eval 'sub RADEON_VHA_BACKFRAME1_OFF_PITCH_V () {0x1854;}' unless defined(&RADEON_VHA_BACKFRAME1_OFF_PITCH_V);
    eval 'sub RADEON_VHA_FORWFRAME0_OFF_Y () {0x1858;}' unless defined(&RADEON_VHA_FORWFRAME0_OFF_Y);
    eval 'sub RADEON_VHA_FORWFRAME1_OFF_PITCH_Y () {0x185c;}' unless defined(&RADEON_VHA_FORWFRAME1_OFF_PITCH_Y);
    eval 'sub RADEON_VHA_FORWFRAME0_OFF_U () {0x1860;}' unless defined(&RADEON_VHA_FORWFRAME0_OFF_U);
    eval 'sub RADEON_VHA_FORWFRAME1_OFF_PITCH_U () {0x1864;}' unless defined(&RADEON_VHA_FORWFRAME1_OFF_PITCH_U);
    eval 'sub RADEON_VHA_FORWFRAME0_OFF_V () {0x1868;}' unless defined(&RADEON_VHA_FORWFRAME0_OFF_V);
    eval 'sub RADEON_VHA_FORWFRAME0_OFF_PITCH_V () {0x1880;}' unless defined(&RADEON_VHA_FORWFRAME0_OFF_PITCH_V);
    eval 'sub RADEON_VHA_BACKFRAME0_OFF_Y_2 () {0x1884;}' unless defined(&RADEON_VHA_BACKFRAME0_OFF_Y_2);
    eval 'sub RADEON_VHA_BACKFRAME1_OFF_PITCH_Y_2 () {0x1888;}' unless defined(&RADEON_VHA_BACKFRAME1_OFF_PITCH_Y_2);
    eval 'sub RADEON_VHA_BACKFRAME0_OFF_U_2 () {0x188c;}' unless defined(&RADEON_VHA_BACKFRAME0_OFF_U_2);
    eval 'sub RADEON_VHA_BACKFRAME1_OFF_PITCH_U_2 () {0x1890;}' unless defined(&RADEON_VHA_BACKFRAME1_OFF_PITCH_U_2);
    eval 'sub RADEON_VHA_BACKFRAME0_OFF_V_2 () {0x1894;}' unless defined(&RADEON_VHA_BACKFRAME0_OFF_V_2);
    eval 'sub RADEON_VHA_BACKFRAME1_OFF_PITCH_V_2 () {0x1898;}' unless defined(&RADEON_VHA_BACKFRAME1_OFF_PITCH_V_2);
    eval 'sub RADEON_MAX_USEC_TIMEOUT () {100000;}' unless defined(&RADEON_MAX_USEC_TIMEOUT);
    eval 'sub RADEON_LAST_FRAME_REG () { &RADEON_SCRATCH_REG0;}' unless defined(&RADEON_LAST_FRAME_REG);
    eval 'sub RADEON_LAST_DISPATCH_REG () { &RADEON_SCRATCH_REG1;}' unless defined(&RADEON_LAST_DISPATCH_REG);
    eval 'sub RADEON_LAST_CLEAR_REG () { &RADEON_SCRATCH_REG2;}' unless defined(&RADEON_LAST_CLEAR_REG);
    eval 'sub RADEON_LAST_SWI_REG () { &RADEON_SCRATCH_REG3;}' unless defined(&RADEON_LAST_SWI_REG);
    eval 'sub RADEON_LAST_DISPATCH () {1;}' unless defined(&RADEON_LAST_DISPATCH);
    eval 'sub RADEON_MAX_VB_AGE () {0x7fffffff;}' unless defined(&RADEON_MAX_VB_AGE);
    eval 'sub RADEON_MAX_VB_VERTS () {(0xffff);}' unless defined(&RADEON_MAX_VB_VERTS);
    eval 'sub RADEON_RING_HIGH_MARK () {128;}' unless defined(&RADEON_RING_HIGH_MARK);
    eval 'sub RADEON_PCIGART_TABLE_SIZE () {(32*1024);}' unless defined(&RADEON_PCIGART_TABLE_SIZE);
    eval 'sub RADEON_READ {
        my($reg) = @_;
	    eval q( &DRM_READ32(  ($dev_priv->{mmio}), ($reg) ));
    }' unless defined(&RADEON_READ);
    eval 'sub RADEON_WRITE {
        my($reg,$val) = @_;
	    eval q( &DRM_WRITE32(  ($dev_priv->{mmio}), ($reg), ($val) ));
    }' unless defined(&RADEON_WRITE);
    eval 'sub RADEON_READ8 {
        my($reg) = @_;
	    eval q( &DRM_READ8(  ($dev_priv->{mmio}), ($reg) ));
    }' unless defined(&RADEON_READ8);
    eval 'sub RADEON_WRITE8 {
        my($reg,$val) = @_;
	    eval q( &DRM_WRITE8(  ($dev_priv->{mmio}), ($reg), ($val) ));
    }' unless defined(&RADEON_WRITE8);
    eval 'sub RADEON_WRITE_PLL {
        my( $addr, $val ) = @_;
	    eval q( &do {  &RADEON_WRITE8(  &RADEON_CLOCK_CNTL_INDEX, (($addr) & 0x1f) |  &RADEON_PLL_WR_EN );  &RADEON_WRITE(  &RADEON_CLOCK_CNTL_DATA, ($val) ); }  &while (0));
    }' unless defined(&RADEON_WRITE_PLL);
    eval 'sub RADEON_WRITE_IGPGART {
        my( $addr, $val ) = @_;
	    eval q( &do {  &RADEON_WRITE(  &RADEON_IGPGART_INDEX, (($addr) & 0x7f) | (1<< 8));  &RADEON_WRITE(  &RADEON_IGPGART_DATA, ($val) );  &RADEON_WRITE(  &RADEON_IGPGART_INDEX, 0x7f ); }  &while (0));
    }' unless defined(&RADEON_WRITE_IGPGART);
    eval 'sub RADEON_WRITE_PCIE {
        my( $addr, $val ) = @_;
	    eval q( &do {  &RADEON_WRITE8(  &RADEON_PCIE_INDEX, (($addr) & 0xff));  &RADEON_WRITE(  &RADEON_PCIE_DATA, ($val) ); }  &while (0));
    }' unless defined(&RADEON_WRITE_PCIE);
    eval 'sub CP_PACKET0 {
        my( $reg, $n ) = @_;
	    eval q(( &RADEON_CP_PACKET0 | (( &n) << 16) | (($reg) >> 2)));
    }' unless defined(&CP_PACKET0);
    eval 'sub CP_PACKET0_TABLE {
        my( $reg, $n ) = @_;
	    eval q(( &RADEON_CP_PACKET0 |  &RADEON_ONE_REG_WR | (( &n) << 16) | (($reg) >> 2)));
    }' unless defined(&CP_PACKET0_TABLE);
    eval 'sub CP_PACKET1 {
        my( $reg0, $reg1 ) = @_;
	    eval q(( &RADEON_CP_PACKET1 | ((($reg1) >> 2) << 15) | (($reg0) >> 2)));
    }' unless defined(&CP_PACKET1);
    eval 'sub CP_PACKET2 () {
        eval q(( &RADEON_CP_PACKET2));
    }' unless defined(&CP_PACKET2);
    eval 'sub CP_PACKET3 {
        my( $pkt, $n ) = @_;
	    eval q(( &RADEON_CP_PACKET3 | ($pkt) | (( &n) << 16)));
    }' unless defined(&CP_PACKET3);
    eval 'sub RADEON_WAIT_UNTIL_2D_IDLE () {
        eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_WAIT_UNTIL, 0) );  &OUT_RING( ( &RADEON_WAIT_2D_IDLECLEAN |  &RADEON_WAIT_HOST_IDLECLEAN) ); }  &while (0));
    }' unless defined(&RADEON_WAIT_UNTIL_2D_IDLE);
    eval 'sub RADEON_WAIT_UNTIL_3D_IDLE () {
        eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_WAIT_UNTIL, 0) );  &OUT_RING( ( &RADEON_WAIT_3D_IDLECLEAN |  &RADEON_WAIT_HOST_IDLECLEAN) ); }  &while (0));
    }' unless defined(&RADEON_WAIT_UNTIL_3D_IDLE);
    eval 'sub RADEON_WAIT_UNTIL_IDLE () {
        eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_WAIT_UNTIL, 0) );  &OUT_RING( ( &RADEON_WAIT_2D_IDLECLEAN |  &RADEON_WAIT_3D_IDLECLEAN |  &RADEON_WAIT_HOST_IDLECLEAN) ); }  &while (0));
    }' unless defined(&RADEON_WAIT_UNTIL_IDLE);
    eval 'sub RADEON_WAIT_UNTIL_PAGE_FLIPPED () {
        eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_WAIT_UNTIL, 0) );  &OUT_RING(  &RADEON_WAIT_CRTC_PFLIP ); }  &while (0));
    }' unless defined(&RADEON_WAIT_UNTIL_PAGE_FLIPPED);
    eval 'sub RADEON_FLUSH_CACHE () {
        eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_RB3D_DSTCACHE_CTLSTAT, 0) );  &OUT_RING(  &RADEON_RB3D_DC_FLUSH ); }  &while (0));
    }' unless defined(&RADEON_FLUSH_CACHE);
    eval 'sub RADEON_PURGE_CACHE () {
        eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_RB3D_DSTCACHE_CTLSTAT, 0) );  &OUT_RING(  &RADEON_RB3D_DC_FLUSH_ALL ); }  &while (0));
    }' unless defined(&RADEON_PURGE_CACHE);
    eval 'sub RADEON_FLUSH_ZCACHE () {
        eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_RB3D_ZCACHE_CTLSTAT, 0) );  &OUT_RING(  &RADEON_RB3D_ZC_FLUSH ); }  &while (0));
    }' unless defined(&RADEON_FLUSH_ZCACHE);
    eval 'sub RADEON_PURGE_ZCACHE () {
        eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_RB3D_ZCACHE_CTLSTAT, 0) );  &OUT_RING(  &RADEON_RB3D_ZC_FLUSH_ALL ); }  &while (0));
    }' unless defined(&RADEON_PURGE_ZCACHE);
    eval 'sub RING_SPACE_TEST_WITH_RETURN {
        my( $dev_priv ) = @_;
	    eval q( &do {  &if (!( ($dev_priv->{stats}->{boxes}) &  &RADEON_BOX_DMA_IDLE)) {  &u32  &head =  &GET_RING_HEAD( $dev_priv );  &if ( &head ==  ($dev_priv->{ring}->{tail}))  ($dev_priv->{stats}->{boxes}) |=  &RADEON_BOX_DMA_IDLE; } }  &while (0));
    }' unless defined(&RING_SPACE_TEST_WITH_RETURN);
    eval 'sub VB_AGE_TEST_WITH_RETURN {
        my( $dev_priv ) = @_;
	    eval q( &do {  &drm_radeon_sarea_t * &sarea_priv =  ($dev_priv->{sarea_priv});  &if (  ($sarea_priv->{last_dispatch}) >=  &RADEON_MAX_VB_AGE ) { \'int\'  &__ret =  &radeon_do_cp_idle( $dev_priv );  &if (  &__ret )  &return  &__ret;  ($sarea_priv->{last_dispatch}) = 0;  &radeon_freelist_reset(  &dev ); } }  &while (0));
    }' unless defined(&VB_AGE_TEST_WITH_RETURN);
    eval 'sub RADEON_DISPATCH_AGE {
        my( $age ) = @_;
	    eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_LAST_DISPATCH_REG, 0) );  &OUT_RING( $age ); }  &while (0));
    }' unless defined(&RADEON_DISPATCH_AGE);
    eval 'sub RADEON_FRAME_AGE {
        my( $age ) = @_;
	    eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_LAST_FRAME_REG, 0) );  &OUT_RING( $age ); }  &while (0));
    }' unless defined(&RADEON_FRAME_AGE);
    eval 'sub RADEON_CLEAR_AGE {
        my( $age ) = @_;
	    eval q( &do {  &OUT_RING(  &CP_PACKET0(  &RADEON_LAST_CLEAR_REG, 0) );  &OUT_RING( $age ); }  &while (0));
    }' unless defined(&RADEON_CLEAR_AGE);
    eval 'sub RADEON_VERBOSE () {0;}' unless defined(&RADEON_VERBOSE);
    eval 'sub RING_LOCALS () {\'int\'  &write,  &_nr; \'unsigned int mask\';  &u32 * &ring;;}' unless defined(&RING_LOCALS);
    eval 'sub BEGIN_RING {
        my( $n ) = @_;
	    eval q( &do {  &if (  &RADEON_VERBOSE ) {  &DRM_INFO( \\"BEGIN_RING( %d ) in %s\\\\n\\",  &n,  &__FUNCTION__ ); }  &if (  ($dev_priv->{ring}->{space}) <= ( &n) * $sizeof{ &u32} ) {  &COMMIT_RING();  &radeon_wait_ring(  &dev_priv, ( &n) * $sizeof{ &u32} ); }  &_nr =  &n;  ($dev_priv->{ring}->{space}) -= ( &n) * $sizeof{ &u32};  &ring =  ($dev_priv->{ring}->{start});  &write =  ($dev_priv->{ring}->{tail});  &mask =  ($dev_priv->{ring}->{tail_mask}); }  &while (0));
    }' unless defined(&BEGIN_RING);
    eval 'sub ADVANCE_RING () {
        eval q( &do {  &if (  &RADEON_VERBOSE ) {  &DRM_INFO( \\"ADVANCE_RING() wr=0x%06x tail=0x%06x\\\\n\\",  &write,  ($dev_priv->{ring}->{tail}) ); }  &if ((( ($dev_priv->{ring}->{tail}) +  &_nr) &  &mask) !=  &write) {  &DRM_ERROR( \\"ADVANCE_RING(): mismatch: nr: %x write: %x line: %d\\\\n\\", (( ($dev_priv->{ring}->{tail}) +  &_nr) &  &mask),  &write,  &__LINE__); }  &else  ($dev_priv->{ring}->{tail}) =  &write; }  &while (0));
    }' unless defined(&ADVANCE_RING);
    eval 'sub COMMIT_RING () {
        eval q( &do {  &DRM_MEMORYBARRIER();  &GET_RING_HEAD(  &dev_priv );  &RADEON_WRITE(  &RADEON_CP_RB_WPTR,  ($dev_priv->{ring}->{tail}) );  &RADEON_READ(  &RADEON_CP_RB_RPTR ); }  &while (0));
    }' unless defined(&COMMIT_RING);
    eval 'sub OUT_RING {
        my( $x ) = @_;
	    eval q( &do {  &if {  &DRM_INFO( \\"   OUT_RING( 0x%08x ) at 0x%x\\\\n\\", ( &x),  &write ); }  $ring[ &write++] = ( &x);  &write &=  &mask; }  &while (0));
    }' unless defined(&OUT_RING);
    eval 'sub OUT_RING_REG {
        my( $reg, $val ) = @_;
	    eval q( &do {  &OUT_RING(  &CP_PACKET0( $reg, 0) );  &OUT_RING( $val ); }  &while (0));
    }' unless defined(&OUT_RING_REG);
    eval 'sub OUT_RING_TABLE {
        my( $tab, $sz ) = @_;
	    eval q( &do { \'int\'  &_size = ; \'int\' * &_tab = ;  &if ( &write +  &_size >  &mask) { \'int\'  &_i = ( &mask+1) -  &write;  &_size -=  &_i;  &while ( &_i > 0) { *( &ring +  &write) = * &_tab++;  &write++;  &_i--; }  &write = 0;  &_tab +=  &_i; }  &while ( &_size > 0) { *( &ring +  &write) = * &_tab++;  &write++;  &_size--; }  &write &=  &mask; }  &while (0));
    }' unless defined(&OUT_RING_TABLE);
}
1;
