require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ARM_PARAM_H_)) {
    eval 'sub _ARM_PARAM_H_ () {1;}' unless defined(&_ARM_PARAM_H_);
    eval 'sub MACHINE_ARCH () {"arm";}' unless defined(&MACHINE_ARCH);
    eval 'sub _MACHINE_ARCH () { &arm;}' unless defined(&_MACHINE_ARCH);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub NBPG () {(1<<  &PAGE_SHIFT);}' unless defined(&NBPG);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub PGOFSET () {( &PAGE_SIZE - 1);}' unless defined(&PGOFSET);
    eval 'sub NPTEPG () {( &PAGE_SIZE/($sizeof{ &pt_entry_t}));}' unless defined(&NPTEPG);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES *  &PAGE_SIZE);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    unless(defined(&MSGBUFSIZE)) {
	eval 'sub MSGBUFSIZE () { &PAGE_SIZE;}' unless defined(&MSGBUFSIZE);
    }
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((64* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub FPCONTEXTSIZE () {(0x100);}' unless defined(&FPCONTEXTSIZE);
    eval 'sub USPACE_SVC_STACK_TOP () {( &USPACE);}' unless defined(&USPACE_SVC_STACK_TOP);
    eval 'sub USPACE_SVC_STACK_BOTTOM () {( &USPACE_SVC_STACK_TOP - 0x1000);}' unless defined(&USPACE_SVC_STACK_BOTTOM);
    eval 'sub USPACE_UNDEF_STACK_TOP () {( &USPACE_SVC_STACK_BOTTOM - 0x10);}' unless defined(&USPACE_UNDEF_STACK_TOP);
    eval 'sub USPACE_UNDEF_STACK_BOTTOM () {($sizeof{\'struct user\'} +  &FPCONTEXTSIZE + 10);}' unless defined(&USPACE_UNDEF_STACK_BOTTOM);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    eval 'sub DELAY {
	        my($x) = @_;
    		eval q( &delay($x));
	    }' unless defined(&DELAY);
	}
    }
    eval 'sub MID_MACHINE () { &MID_ARM6;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () {($sizeof{\'int\'} - 1);}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub STACKALIGNBYTES () {(8- 1);}' unless defined(&STACKALIGNBYTES);
    eval 'sub STACKALIGN {
        my($p) = @_;
	    eval q((($p) &~  &STACKALIGNBYTES));
    }' unless defined(&STACKALIGN);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    unless(defined(&MAXPHYS)) {
	eval 'sub MAXPHYS () {65536;}' unless defined(&MAXPHYS);
    }
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PAGE_SHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PAGE_SHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        my($x) = @_;
	    eval q((($x) <<  &PAGE_SHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        my($x) = @_;
	    eval q(((($x) +  &PAGE_MASK) >>  &PAGE_SHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        my($bytes) = @_;
	    eval q((($bytes) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($db) = @_;
	    eval q((($db) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub NMBCLUSTERS () {4096;}' unless defined(&NMBCLUSTERS);
    eval 'sub ovbcopy () { &bcopy;}' unless defined(&ovbcopy);
    if(defined(&_KERNEL)) {
	if(defined(&_LOCORE)) {
	    require 'machine/psl.ph';
	} else {
	    require 'sys/param.ph';
	    require 'machine/cpu.ph';
	}
    }
}
1;
