interaction.plot            package:stats            R Documentation

_T_w_o-_w_a_y _I_n_t_e_r_a_c_t_i_o_n _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     Plots the mean (or other summary) of the response for two-way
     combinations of factors, thereby illustrating possible
     interactions.

_U_s_a_g_e:

     interaction.plot(x.factor, trace.factor, response, fun = mean,
                      type = c("l", "p", "b"), legend = TRUE,
                      trace.label = deparse(substitute(trace.factor)),
                      fixed = FALSE,
                      xlab = deparse(substitute(x.factor)),
                      ylab = ylabel,
                      ylim = range(cells, na.rm=TRUE),
                      lty = nc:1, col = 1, pch = c(1:9, 0, letters),
                      xpd = NULL, leg.bg = par("bg"), leg.bty = "n",
                      xtick = FALSE, xaxt = par("xaxt"), axes = TRUE,
                      ...)

_A_r_g_u_m_e_n_t_s:

x.factor: a factor whose levels will form the x axis.

trace.factor: another factor whose levels will form the traces.

response: a numeric variable giving the response

     fun: the function to compute the summary. Should return a single
          real value.

    type: the type of plot: lines or points.

  legend: logical. Should a legend be included?

trace.label: overall label for the legend.

   fixed: logical.  Should the legend be in the order of the levels of
          'trace.factor' or in the order of the traces at their
          right-hand ends?

xlab,ylab: the x and y label of the plot each with a sensible default.

    ylim: numeric of length 2 giving the y limits for the plot.

     lty: line type for the lines drawn, with sensible default.

     col: the color to be used for plotting.

     pch: a vector of plotting symbols or characters, with sensible
          default.

     xpd: determines clipping behaviour for the 'legend' used, see
          'par(xpd)'.  Per default, the legend is _not_ clipped at the
          figure border.

leg.bg, leg.bty: arguments passed to 'legend()'.

   xtick: logical. Should tick marks be used on the x axis?

xaxt, axes, ...: graphics parameters to be passed to the plotting
          routines.

_D_e_t_a_i_l_s:

     By default the levels of 'x.factor' are plotted on the x axis in
     their given order, with extra space left at the right for the
     legend (if specified). If 'x.factor' is an ordered factor and the
     levels are numeric, these numeric values are used for the x axis.

     The response and hence its summary can contain missing values. If
     so, the missing values and the line segments joining them are
     omitted from the plot (and this can be somewhat disconcerting).

     The graphics parameters 'xlab', 'ylab', 'ylim', 'lty', 'col' and
     'pch' are given suitable defaults (and 'xlim' and 'xaxs' are set
     and cannot be overridden). The defaults are to cycle through the
     line types, use the foreground colour, and to use the symbols 1:9,
     0, and the capital letters to plot the traces.

_N_o_t_e:

     Some of the argument names and the precise behaviour are chosen
     for S-compatibility.

_R_e_f_e_r_e_n_c_e_s:

     Chambers, J. M., Freeny, A and Heiberger, R. M. (1992) _Analysis
     of variance; designed experiments._ Chapter 5 of _Statistical
     Models in S_ eds J. M. Chambers and T. J. Hastie, Wadsworth &
     Brooks/Cole.

_E_x_a_m_p_l_e_s:

     with(ToothGrowth, {
     interaction.plot(dose, supp, len, fixed=TRUE)
     dose <- ordered(dose)
     interaction.plot(dose, supp, len, fixed=TRUE, col = 2:3, leg.bty = "o")
     interaction.plot(dose, supp, len, fixed=TRUE, col = 2:3, type = "p")
     })

     with(OrchardSprays, {
       interaction.plot(treatment, rowpos, decrease)
       interaction.plot(rowpos, treatment, decrease, cex.axis=0.8)
       ## order the rows by their mean effect
       rowpos <- factor(rowpos, levels=sort.list(tapply(decrease, rowpos, mean)))
       interaction.plot(rowpos, treatment, decrease, col = 2:9, lty = 1)
     })

     with(esoph, {
       interaction.plot(agegp, alcgp, ncases/ncontrols, main = "'esoph' Data")
       interaction.plot(agegp, tobgp, ncases/ncontrols, trace.label="tobacco",
                        fixed=TRUE, xaxt = "n")
     })
     ## deal with NAs:
     esoph[66,] # second to last age group: 65-74
     esophNA <- esoph; esophNA$ncases[66] <- NA
     with(esophNA, {
       interaction.plot(agegp, alcgp, ncases/ncontrols, col= 2:5)
                                     # doesn't show *last* group either
       interaction.plot(agegp, alcgp, ncases/ncontrols, col= 2:5, type = "b")
       ## alternative take non-NA's  {"cheating"}
       interaction.plot(agegp, alcgp, ncases/ncontrols, col= 2:5,
                        fun = function(x) mean(x, na.rm=TRUE),
                        sub = "function(x) mean(x, na.rm=TRUE)")
     })
     rm(esophNA) # to clear up

