### Name: seemsS4Object
### Title: Heuristic test for an object from an S4 class
### Aliases: seemsS4Object
### Keywords: programming classes

### ** Examples

seemsS4Object(1) # FALSE

seemsS4Object(getClass(class(1)))  #TRUE

## how to test for an S4 object that is not a vector

S4NotVector <- function(object) seemsS4Object(object) && !is(object, "vector")

setClass("classNotNumeric", representation(x="numeric", y="numeric"))

setClass("classWithNumeric", representation(y="numeric"), contains = "numeric")

obj1 <- new("classNotNumeric", x=1, y=2)

obj2 <- new("classWithNumeric", 1, y=2)

seemsS4Object(obj1); seemsS4Object(obj2)  # TRUE, TRUE
S4NotVector(obj1); S4NotVector(obj2)  # TRUE, FALSE

## Don't show: 
removeClass("classNotNumeric")
removeClass("classWithNumeric")
## End Don't show




