/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-intf.h                                                      *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : m-intf.c header file                                     *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-intf.h,v 1.1.1.1 2000/10/28 16:52:11 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __M_INTF_H__
#define __M_INTF_H__

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

#define MDC_INTF_SIG    "interfile"

#define MDC_INTF_SUPP_VERS   3.3
#define MDC_INTF_SUPP_DATE   "1992:01:01"

#define MDC_INTF_MAXKEYCHARS 256

#define MDC_INTF_UNKNOWN 0

#define MDC_CNTRL_Z 0x0a1a

/* the  data type */
#define MDC_INTF_STATIC      1
#define MDC_INTF_DYNAMIC     2
#define MDC_INTF_GATED       3
#define MDC_INTF_TOMOGRAPH   4
#define MDC_INTF_CURVE       5
#define MDC_INTF_ROI         6

/* the process status */
#define MDC_INTF_ACQUIRED      1
#define MDC_INTF_RECONSTRUCTED 2

typedef struct MdcInterFile_t {
 
  int data_type, process_status, pixel_type;
  Uint32 width, height, images_per_dimension;
  Uint32 data_offset, data_blocks, imagesize, number_images;
  Uint32 energy_windows, frame_groups, time_windows, detector_heads;
  float pixel_xsize, pixel_ysize, slice_thickness, centre_centre_separation;
  float study_duration, image_duration, image_pause, group_pause, ext_rot;
  Int8 patient_rot, patient_orient, slice_orient;
  double version;

} MDC_INTERFILE;

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

int MdcCheckINTF(FILEINFO *fi);
int MdcGetIntfKey(FILE *fp);
void MdcInitIntf(MDC_INTERFILE *intf);
int MdcIsEmptyKeyValue(void);
int MdcThisString(char *string);
int MdcGetIntKey(void);
int MdcGetYesNoKey(void);
double MdcGetFloatKey(void);
void MdcGetStrKey(char *str);
int MdcGetDataType(void);
int MdcGetProcessStatus(void);
int MdcGePatientRot(void);
int MdcGetPatientOrient(void);
int MdcGetSliceOrient(void);
int MdcGetPatSlOrient(MDC_INTERFILE *intf);
int MdcGetPixelType(void);
int MdcGetRotation(void);
int MdcGetMotion(void);
int MdcSpecifyPixelType(MDC_INTERFILE *intf);
char *MdcReadIntfHeader(FILEINFO *fi, MDC_INTERFILE *intf);
char *MdcReadIntfImages(FILEINFO *fi, MDC_INTERFILE *intf);
char *MdcReadINTF(FILEINFO *fi);
char *MdcType2Intf(int type);
char *MdcGetProgramDate(void);
char *MdcWriteGenImgData(FILEINFO *fi);
char *MdcWriteWindows(FILEINFO *fi);
char *MdcWriteMatrixInfo(FILEINFO *fi, Uint32 img);
char *MdcWriteIntfStatic(FILEINFO *fi);
char *MdcWriteIntfDynamic(FILEINFO *fi);
char *MdcWriteIntfTomo(FILEINFO *fi);
char *MdcWriteIntfHeader(FILEINFO *fi);
char *MdcWriteIntfImages(FILEINFO *fi);
char *MdcWriteINTF(FILEINFO *fi);
 
#endif

