/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-defs.h                                                      *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : project variables, structs & datatypes                   *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-defs.h,v 1.1.1.1 2000/10/28 16:52:05 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __M_DEFS_H__
#define __M_DEFS_H__


/****************************************************************************
                     G N U   C O N F I G U R A T I O N  
****************************************************************************/

#ifdef HAVE_CONFIG_H                /* yes, we have configuration header */
#define MDC_DEPEND_H
#endif


#ifdef MDC_DEPEND_H

#include "depend.h"
#include "m-config.h"


/**************************
  COMPILATION CONDITIONALS
 **************************/

/* MDC_DOS like path slashes */
#ifdef _WIN32
#ifndef MDC_DOS
#define MDC_DOS 1
#endif
#endif

/* Use slice_spacing instead of slice_width which  */
/* results in slice gaps/overlaps of zero. Very    */
/* neat for formats without slice_spacing param.   */
/* better for volumes <=> losing true slice_width  */
/* Comment out following line when not wanted.     */ 
#define MDC_USE_SLICE_SPACING 1


/*******************
  PORTABILITY TYPES
 *******************/

/* machine endian */
#ifdef WORDS_BIGENDIAN
# define ENLF_BIGENDIAN
#else
# define ENLF_LITTLEENDIAN
#endif


/* 16 bit type */
#if     (SIZEOF_INT   == 2)
# define INT_2BYTE
#elif   (SIZEOF_SHORT == 2)
# define SHORT_2BYTE
#else
# error "What!?  No 16-bit integer type available!"
#endif
/* 32 bit type */
#if     (SIZEOF_INT   == 4)
# define INT_4BYTE
#elif   (SIZEOF_LONG  == 4)
# define LONG_4BYTE
#else
# error "What!?  No 32-bit integer type available!"
#endif
/* 64 bit type */
#ifdef SIZEOF_LONG_LONG
#if     (SIZEOF_LONG_LONG == 8)
# define LONG_LONG_8BYTE
#endif
#else
#if     (SIZEOF_LONG == 8)
# define LONG_8BYTE
#endif
#endif

#else

#error "Sorry, you must run `configure` properly!"

#endif

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

#define MDC_INSTITUTION "UZ-GENT/RUG"
#define MDC_SHORTINSTIT "UZ/RUG"

#define MDC_UNKNOWN       0

#define MDC_LITTLE_ENDIAN 1
#define MDC_BIG_ENDIAN    0

#define MDC_1KB_OFFSET     1024
#define MDC_2KB_OFFSET     2048

#define MDC_INPUT_NORM_STYLE   1
#define MDC_INPUT_ECAT_STYLE   2

#define MDC_MAX_PATH  256

#define MDC_YES    1 
#define MDC_NO     0

#define MDC_ARG_FILE  0
#define MDC_ARG_CONV  1

#define MDC_FILES     0
#define MDC_CONVS     1

/* passess */
#define MDC_PASS0     0
#define MDC_PASS1     1
#define MDC_PASS2     2

/* supported color maps */
#define MDC_MAP_PRESENT   0       /* 256 RGB   colormap */
#define MDC_MAP_GRAY      1       /* grayscale colormap */
#define MDC_MAP_RAINBOW   2       /* rainbow   colormap */
#define MDC_MAP_COMBINED  3       /* combined  colormap */
#define MDC_MAP_HOTMETAL  4       /* hotmetal  colormap */

#define MDC_MAP_LOADED    5       /* loaded    colormap */ 

/* supported formats */
#define MDC_FRMT_BAD     0
#define MDC_FRMT_RAW     1
#define MDC_FRMT_ASCII   2
#define MDC_FRMT_GIF     3 
#define MDC_FRMT_ACR     4 
#define MDC_FRMT_INW     5 
#define MDC_FRMT_ECAT    6 
#define MDC_FRMT_INTF    7 
#define MDC_FRMT_ANLZ    8 
#define MDC_FRMT_DICM    9 

#define MDC_MAX_FRMTS 10    /* total+1 conversion formats supported */

/* acquisition types */               /*  InterFile and DICOM   */
#define MDC_ACQUISITION_UNKNOWN    0  /* unknown = static       */
#define MDC_ACQUISITION_STATIC     1  /* static, simple default */
#define MDC_ACQUISITION_DYNAMIC    2  /* dynamic                */
#define MDC_ACQUISITION_TOMO       3  /* tomographic            */

/* pat_orient */
#define MDC_LEFT         1
#define MDC_RIGHT        2
#define MDC_ANTERIOR     3
#define MDC_POSTERIOR    4
#define MDC_HEAD         5
#define MDC_FEET         6

/* patient rotation */
#define MDC_SUPINE      1             /* on the back            */
#define MDC_PRONE       2             /* on the face            */

/* patient orientation */
#define MDC_HEADFIRST   1             /* head first in scanner  */
#define MDC_FEETFIRST   2             /* feet first in scanner  */

/* slice orientation */               /* consider a patient on  */
                                      /* his back on the table, */
                                      /* then the direction is: */ 
#define MDC_TRANSVERSAL 1             /* //  device ;_|_ ground */
#define MDC_SAGITTAL    2             /* _|_ device ;_|_ ground */
#define MDC_CORONAL     3             /* _|_ device ; // ground */ 

/* patient/slice combined */
#define MDC_SUPINE_HEADFIRST_TRANSVERSAL 1
#define MDC_SUPINE_HEADFIRST_SAGITTAL    2
#define MDC_SUPINE_HEADFIRST_CORONAL     3
#define MDC_SUPINE_FEETFIRST_TRANSVERSAL 4
#define MDC_SUPINE_FEETFIRST_SAGITTAL    5
#define MDC_SUPINE_FEETFIRST_CORONAL     6
#define MDC_PRONE_HEADFIRST_TRANSVERSAL  7
#define MDC_PRONE_HEADFIRST_SAGITTAL     8
#define MDC_PRONE_HEADFIRST_CORONAL      9
#define MDC_PRONE_FEETFIRST_TRANSVERSAL 10
#define MDC_PRONE_FEETFIRST_SAGITTAL    11
#define MDC_PRONE_FEETFIRST_CORONAL     12

/* detector rotation */
#define MDC_ROTATION_CW   1   /* clockwise               */
#define MDC_ROTATION_CC   2   /* counter-clocwise        */

/* detector motion   */
#define MDC_MOTION_STEP   1   /* stepped                 */
#define MDC_MOTION_CONT   2   /* continuous              */
#define MDC_MOTION_DRNG   3   /* during step             */

/* some maximum limits */
#define MDC_MAX_FILES 1036 /* maximum files handled      */

#define MDC_MAXSTR    35   /* max length of strings      */ 

#define MDC_BUF_ITMS  10   /* realloc per BUF_ITMS items */

#define MDC_CHAR_BUF  100  /* max chars for string buffer*/

#define MDC_MAX_PREFIX  5  /* max chars for prefix       */

/* pixel types                             */
#define BIT1      1    /*  1-bit           */
#define BIT8_S    2    /*  8-bit signed    */
#define BIT8_U    3    /*  8-bit unsigned  */
#define BIT16_S   4    /* 16-bit signed    */
#define BIT16_U   5    /* 16-bit unsigned  */
#define BIT32_S   6    /* 32-bit signed    */
#define BIT32_U   7    /* 32-bit unsigned  */
#define BIT64_S   8    /* 64-bit signed    */
#define BIT64_U   9    /* 64-bit unsigned  */
#define FLT32    10    /* 32-bit float     */
#define FLT64    11    /* 64-bit double    */
#define ASCII    12    /* ascii            */
#define VAXFL32  13    /* 32-bit vaxfloat  */

/* define maximum integer values */
#define MDC_MAX_BIT8_U    255
#define MDC_MAX_BIT16_S   ((1<<16)/2) - 1

/* file compression type */
#define MDC_COMPRESS  1
#define MDC_GZIP      2

/*  8 bit type */
typedef          char Int8;
typedef unsigned char Uint8;

/* 16 bit type */
#ifdef SHORT_2BYTE
 typedef          short Int16;
 typedef unsigned short Uint16;
#elif  INT_2BYTE
 typedef          int   Int16;
 typedef unsigned int   Uint16;
#endif

/* 32 bit type */
#ifdef INT_4BYTE
 typedef          int  Int32;
 typedef unsigned int Uint32;
#elif  LONG_4BYTE
 typedef          long Int32;
 typedef unsigned long Uint32;
#endif

/* 64 bit type */
#ifdef LONG_8BYTE
#define HAVE_8BYTE_INT
 typedef          long Int64;
 typedef unsigned long Uint64;
#else
#ifdef LONG_LONG_8BYTE
#define HAVE_8BYTE_INT
 typedef          long long Int64;
 typedef unsigned long long Uint64;
#endif
#endif

typedef struct Acquisition_Data_t {

  Int16 rotation_direction;      /* direction of rotation  */
  Int16 detector_motion;         /* type detector motion   */
  float angle_start;             /* start angle            */
  float angle_step;              /* angular step           */
  float scan_arc;                /* angular range          */

} ACQ_DATA;

typedef struct Image_Data_t {

  /*             **   general data   **                    */
  Uint32 width,height;           /* image dimension        */
  Int16 bits,type;               /* bits/pixel & datatype  */
  Uint16 flags;		         /* extra flag             */
  double min, max;               /* min/max pixelvalue     */
  double qmin, qmax;             /* quantified min/max     */
  double fmin, fmax;             /* min/max in whole frame */ 
  double qfmin, qfmax;           /* in whole frame (quant) */
  float rescale_fctr;            /* quantify rescale fctr  */
  Uint8 *buf;                    /* pointer to raw image   */

  /*             **  internal items  **                    */
  Int8   rescaled;               /* rescaled image?        */ 
  double rescaled_min;           /* new rescaled max       */
  double rescaled_max;           /* new rescaled min       */ 
  double rescaled_fctr;          /* new rescale  fctr      */

  /*             **   ecat64 items   **                    */
  Int16 quant_units;             /* quantification units   */
  Int16 calibr_units;            /* calibration units      */
  float quant_scale;             /* quantification scale   */
  float calibr_fctr;             /* calibration factor     */
  float pixel_xsize;             /* pixel size X      (mm) */
  float pixel_ysize;             /* pixel size Y      (mm) */
  float slice_width;             /* slice width       (mm) */
  float frame_start;             /* start of frame    (ms) */
  float frame_duration;          /* duration of frame (ms) */ 
  float recon_scale;             /* recon magnification    */

  /*            **  Acr/Nema items   **                    */

  Int8  pat_slice_orient;        /* combined flag          */
  char  pat_pos[MDC_MAXSTR];     /* patient position       */
  char  pat_orient[MDC_MAXSTR];  /* patient orientation    */
  char  image_mod[3];            /* images modality        */
  float image_pos_dev[3];        /* image posit  dev  (mm) */
  float image_orient_dev[6];     /* image orient dev  (mm) */
  float image_pos_pat[3];        /* image posit  pat  (mm) */
  float image_orient_pat[6];     /* image orient pat  (mm) */
  float slice_spacing;           /* space btw centres (mm) */
  float ct_zoom_fctr;            /* CT image zoom factor   */

} IMG_DATA;

typedef struct File_Info_t {

  FILE *ifp;                     /* pointer to input file  */
  FILE *ofp;                     /* pointer to output file */
  char ipath[MDC_MAX_PATH+1];    /* path to input  file    */
  char opath[MDC_MAX_PATH+1];    /* path to output file    */
  char *idir;                    /* dir to input  file     */
  char *odir;                    /* dir to output file     */
  char *ifname;                  /* name of input file     */ 
  char *ofname;                  /* name of output file    */
  int  format;                   /* image format of file   */
  Int8 rawconv;                  /* FRMT_RAW | FRMT_ASCII  */
  Int8 endian;                   /* endian of file         */
  Int8 compression;              /* file compression       */
  Int8 truncated;                /* truncated file?        */
  Int8 diff_type;                /* images with diff type? */  
  Int8 diff_size;                /* images with diff size? */
  Uint32 number;                 /* total number of images */
  Uint32 mwidth,mheight;         /* global max dimensions  */
  Uint16 bits, type;             /* global bits & datatype */
  Int16 dim[8];                  /* [0] = # of dimensions  */
                                 /* [1] = X-dim (pixels)   */
                                 /* [2] = Y-dim (pixels)   */
                                 /* [3] = Z-dim (planes)   */
                                 /* [4] =       (frames)   */
                                 /* [5] =       (gates)    */
                                 /* [6] =       (beds)     */
                                 /* ...                    */
                                 /* values must be 1-based */

  float pixdim[8];               /* [0] = # of dimensions  */
                                 /* [1] = X-dim (mm)       */
                                 /* [2] = Y-dim (mm)       */
                                 /* [3] = Z-dim (mm)       */
                                 /* [4] = time  (ms)       */
                                 /* ...                    */ 

  double glmin, glmax;           /* global min/max value   */
  double qglmin, qglmax;         /* quantified min/max     */

  char patient_sex[MDC_MAXSTR];  /* sex of patient         */
  char patient_name[MDC_MAXSTR]; /* name of patient        */
  char patient_id[MDC_MAXSTR];   /* id   of patient        */
  char study_descr[MDC_MAXSTR];  /* study description      */
  char study_name[MDC_MAXSTR];   /* study name             */
  Int16 study_date_day;          /* day of study           */
  Int16 study_date_month;        /* month of study         */
  Int16 study_date_year;         /* year of study          */
  Int16 study_time_hour;         /* hour of study          */
  Int16 study_time_minute;       /* minute of study        */
  Int16 study_time_second;       /* second of study        */
  Int16 acquisition_type;        /* acquisition type       */
  Int16 decay_corrected;         /* decay corrected ?      */
  Int16 flood_corrected;         /* flood corrected ?      */

  Int16 reconstructed;           /* reconstructed ?        */
  char recon_method[MDC_MAXSTR]; /* reconstruction method  */

  char radiopharma[MDC_MAXSTR];  /* radiopharmaceutical    */
  char filter_type[MDC_MAXSTR];  /* filter type            */
  char isotope_code[MDC_MAXSTR]; /* isotope                */
  float isotope_halflife;        /* halflife of isotope    */
  float gantry_tilt;             /* gantry tilt            */

  Uint16 map;                    /* GIF89 colormap         */
  Uint8 palette[768];            /* global palette         */
  char *comment;                 /* whatever comment       */
  Uint32 comm_length;            /* length of comment      */

  Uint32 acqnr;                  /* number acq. entries    */
  ACQ_DATA *acqdata;             /* array ACQ_DATA entries */

  IMG_DATA *image;               /* array IMG_DATA images  */

} FILEINFO;

#endif
   
