<?php
/**
 * Define the messages structure in the messages file, for a future automated rewriting.
 *
 * @package MediaWiki
 * @subpackage Maintenance
 */

/** The structure of the messages, divided to blocks */
$wgMessageStrucutre = array(
	'sidebar' => array(
		'sidebar',
	),
	'toggles' => array(
		'tog-underline',
		'tog-highlightbroken',
		'tog-justify',
		'tog-hideminor',
		'tog-extendwatchlist',
		'tog-usenewrc',
		'tog-numberheadings',
		'tog-showtoolbar',
		'tog-editondblclick',
		'tog-editsection',
		'tog-editsectiononrightclick',
		'tog-showtoc',
		'tog-rememberpassword',
		'tog-editwidth',
		'tog-watchcreations',
		'tog-watchdefault',
		'tog-watchmoves',
		'tog-watchdeletion',
		'tog-minordefault',
		'tog-previewontop',
		'tog-previewonfirst',
		'tog-nocache',
		'tog-enotifwatchlistpages',
		'tog-enotifusertalkpages',
		'tog-enotifminoredits',
		'tog-enotifrevealaddr',
		'tog-shownumberswatching',
		'tog-fancysig',
		'tog-externaleditor',
		'tog-externaldiff',
		'tog-showjumplinks',
		'tog-uselivepreview',
		'tog-forceeditsummary',
		'tog-watchlisthideown',
		'tog-watchlisthidebots',
		'tog-watchlisthideminor',
		'tog-nolangconversion',
		'tog-ccmeonemails',
	),
	'underline' => array(
		'underline-always',
		'underline-never',
		'underline-default',
	),
	'skinpreview' => array(
		'skinpreview',
	),
	'dates' => array(
		'sunday',
		'monday',
		'tuesday',
		'wednesday',
		'thursday',
		'friday',
		'saturday',
		'sun',
		'mon',
		'tue',
		'wed',
		'thu',
		'fri',
		'sat',
		'january',
		'february',
		'march',
		'april',
		'may_long',
		'june',
		'july',
		'august',
		'september',
		'october',
		'november',
		'december',
		'january-gen',
		'february-gen',
		'march-gen',
		'april-gen',
		'may-gen',
		'june-gen',
		'july-gen',
		'august-gen',
		'september-gen',
		'october-gen',
		'november-gen',
		'december-gen',
		'jan',
		'feb',
		'mar',
		'apr',
		'may',
		'jun',
		'jul',
		'aug',
		'sep',
		'oct',
		'nov',
		'dec',
	),
	'categories' => array(
		'categories',
		'pagecategories',
		'pagecategorieslink',
		'category_header',
		'subcategories',
		'category-media-header',
	),
	'mainpage' => array(
		'linkprefix',
		'mainpage',
		'mainpagetext',
		'mainpagedocfooter',
	),
	'miscellaneous1' => array(
		'portal',
		'portal-url',
		'about',
		'aboutsite',
		'aboutpage',
		'article',
		'help',
		'helppage',
		'bugreports',
		'bugreportspage',
		'sitesupport',
		'sitesupport-url',
		'faq',
		'faqpage',
		'edithelp',
		'newwindow',
		'edithelppage',
		'cancel',
		'qbfind',
		'qbbrowse',
		'qbedit',
		'qbpageoptions',
		'qbpageinfo',
		'qbmyoptions',
		'qbspecialpages',
		'moredotdotdot',
		'mypage',
		'mytalk',
		'anontalk',
		'navigation',
	),
	'metadata_help' => array(
		'metadata_help',
	),
	'currentevents' => array(
		'currentevents',
		'currentevents-url',
	),
	'miscellaneous2' => array(
		'disclaimers',
		'disclaimerpage',
		'privacy',
		'privacypage',
		'errorpagetitle',
		'returnto',
		'tagline',
		'help',
		'search',
		'searchbutton',
		'go',
		'searcharticle',
		'history',
		'history_short',
		'updatedmarker',
		'info_short',
		'printableversion',
		'permalink',
		'print',
		'edit',
		'editthispage',
		'delete',
		'deletethispage',
		'undelete_short',
		'protect',
		'protectthispage',
		'unprotect',
		'unprotectthispage',
		'newpage',
		'talkpage',
		'specialpage',
		'personaltools',
		'postcomment',
		'addsection',
		'articlepage',
		'talk',
		'views',
		'toolbox',
		'userpage',
		'projectpage',
		'imagepage',
		'mediawikipage',
		'templatepage',
		'viewhelppage',
		'categorypage',
		'viewtalkpage',
		'otherlanguages',
		'redirectedfrom',
		'redirectpagesub',
		'lastmodifiedat',
		'viewcount',
		'copyright',
		'protectedpage',
		'jumpto',
		'jumptonavigation',
		'jumptosearch',
	),
	'badaccess' => array(
		'badaccess',
		'badaccess-group0',
		'badaccess-group1',
		'badaccess-group2',
		'badaccess-groups',
	),
	'versionrequired' => array(
		'versionrequired',
		'versionrequiredtext',
	),
	'miscellaneous3' => array(
		'widthheight',
		'ok',
		'sitetitle',
		'pagetitle',
		'sitesubtitle',
		'retrievedfrom',
		'youhavenewmessages',
		'newmessageslink',
		'newmessagesdifflink',
		'editsection',
		'editold',
		'editsectionhint',
		'toc',
		'showtoc',
		'hidetoc',
		'thisisdeleted',
		'viewdeleted',
		'restorelink',
		'feedlinks',
		'feed-invalid',
		'feed-atom',
		'feed-rss',
		'sitenotice',
		'anonnotice',
	),
	'nstab' => array(
		'nstab-main',
		'nstab-user',
		'nstab-media',
		'nstab-special',
		'nstab-project',
		'nstab-image',
		'nstab-mediawiki',
		'nstab-template',
		'nstab-help',
		'nstab-category',
	),
	'main' => array(
		'nosuchaction',
		'nosuchactiontext',
		'nosuchspecialpage',
		'nospecialpagetext',
	),
	'errors' => array(
		'error',
		'databaseerror',
		'dberrortext',
		'dberrortextcl',
		'noconnect',
		'nodb',
		'cachederror',
		'laggedslavemode',
		'readonly',
		'enterlockreason',
		'readonlytext',
		'missingarticle',
		'readonly_lag',
		'internalerror',
		'filecopyerror',
		'filerenameerror',
		'filedeleteerror',
		'filenotfound',
		'unexpected',
		'formerror',
		'badarticleerror',
		'cannotdelete',
		'badtitle',
		'badtitletext',
		'perfdisabled',
		'perfdisabledsub',
		'perfcached',
		'perfcachedts',
		'querypage-no-updates',
		'wrong_wfQuery_params',
		'viewsource',
		'viewsourcefor',
		'protectedpagetext',
		'viewsourcetext',
		'protectedinterface',
		'editinginterface',
		'sqlhidden',
	),
	'login' => array(
		'logouttitle',
		'logouttext',
		'welcomecreation',
		'loginpagetitle',
		'yourname',
		'yourpassword',
		'yourpasswordagain',
		'remembermypassword',
		'yourdomainname',
		'externaldberror',
		'loginproblem',
		'alreadyloggedin',
		'login',
		'loginprompt',
		'userlogin',
		'logout',
		'userlogout',
		'notloggedin',
		'nologin',
		'nologinlink',
		'createaccount',
		'gotaccount',
		'gotaccountlink',
		'createaccountmail',
		'badretype',
		'userexists',
		'youremail',
		'username',
		'uid',
		'yourrealname',
		'yourlanguage',
		'yourvariant',
		'yournick',
		'badsig',
		'email',
		'prefs-help-email-enotif',
		'prefs-help-realname',
		'loginerror',
		'prefs-help-email',
		'nocookiesnew',
		'nocookieslogin',
		'noname',
		'loginsuccesstitle',
		'loginsuccess',
		'nosuchuser',
		'nosuchusershort',
		'nouserspecified',
		'wrongpassword',
		'wrongpasswordempty',
		'mailmypassword',
		'passwordremindertitle',
		'passwordremindertext',
		'noemail',
		'passwordsent',
		'blocked-mailpassword',
		'eauthentsent',
		'throttled-mailpassword',
		'loginend',
		'signupend',
		'mailerror',
		'acct_creation_throttle_hit',
		'emailauthenticated',
		'emailnotauthenticated',
		'noemailprefs',
		'emailconfirmlink',
		'invalidemailaddress',
		'accountcreated',
		'accountcreatedtext',
	),
	'resetpass' => array(
		'resetpass',
		'resetpass_announce',
		'resetpass_text',
		'resetpass_header',
		'resetpass_submit',
		'resetpass_success',
		'resetpass_bad_temporary',
		'resetpass_forbidden',
		'resetpass_missing',
	),
	'toolbar' => array(
		'bold_sample',
		'bold_tip',
		'italic_sample',
		'italic_tip',
		'link_sample',
		'link_tip',
		'extlink_sample',
		'extlink_tip',
		'headline_sample',
		'headline_tip',
		'math_sample',
		'math_tip',
		'nowiki_sample',
		'nowiki_tip',
		'image_sample',
		'image_tip',
		'media_sample',
		'media_tip',
		'sig_tip',
		'hr_tip',
	),
	'edit' => array(
		'summary',
		'subject',
		'minoredit',
		'watchthis',
		'savearticle',
		'preview',
		'showpreview',
		'showlivepreview',
		'showdiff',
		'anoneditwarning',
		'missingsummary',
		'missingcommenttext',
		'missingcommentheader',
		'summary-preview',
		'subject-preview',
		'blockedtitle',
		'blockedtext',
		'blockedoriginalsource',
		'blockededitsource',
		'whitelistedittitle',
		'whitelistedittext',
		'whitelistreadtitle',
		'whitelistreadtext',
		'whitelistacctitle',
		'whitelistacctext',
		'confirmedittitle',
		'confirmedittext',
		'loginreqtitle',
		'loginreqlink',
		'loginreqpagetext',
		'accmailtitle',
		'accmailtext',
		'newarticle',
		'newarticletext',
		'newarticletextanon',
		'talkpagetext',
		'anontalkpagetext',
		'noarticletext',
		'noarticletextanon',
		'clearyourcache',
		'usercssjsyoucanpreview',
		'usercsspreview',
		'userjspreview',
		'userinvalidcssjstitle',
		'updated',
		'note',
		'previewnote',
		'previewconflict',
		'session_fail_preview',
		'session_fail_preview_html',
		'importing',
		'editing',
		'editinguser',
		'editingsection',
		'editingcomment',
		'editconflict',
		'explainconflict',
		'yourtext',
		'storedversion',
		'nonunicodebrowser',
		'editingold',
		'yourdiff',
		'copyrightwarning',
		'copyrightwarning2',
		'longpagewarning',
		'longpageerror',
		'readonlywarning',
		'protectedpagewarning',
		'semiprotectedpagewarning',
		'templatesused',
		'templatesusedpreview',
		'templatesusedsection',
		'template-protected',
		'template-semiprotected',
		'edittools',
		'nocreatetitle',
		'nocreatetext',
	),
	'undo' => array(
		'undo-success',
		'undo-failure',
		'undo-summary',
	),
	'cantcreateaccount' => array(
		'cantcreateaccounttitle',
		'cantcreateaccounttext',
	),
	'history' => array(
		'revhistory',
		'viewpagelogs',
		'nohistory',
		'revnotfound',
		'revnotfoundtext',
		'loadhist',
		'currentrev',
		'revisionasof',
		'revision-info',
		'revision-nav',
		'previousrevision',
		'nextrevision',
		'currentrevisionlink',
		'cur',
		'next',
		'last',
		'orig',
		'histlegend',
		'history_copyright',
		'deletedrev',
		'histfirst',
		'histlast',
		'rev-deleted-comment',
		'rev-deleted-user',
		'rev-deleted-text-permission',
		'rev-deleted-text-view',
		'rev-delundel',
	),
	'history-feed' => array(
		'history-feed-title',
		'history-feed-description',
		'history-feed-item-nocomment',
		'history-feed-empty',
	),
	'revdelete' => array(
		'revisiondelete',
		'revdelete-nooldid-title',
		'revdelete-nooldid-text',
		'revdelete-selected',
		'revdelete-text',
		'revdelete-legend',
		'revdelete-hide-text',
		'revdelete-hide-comment',
		'revdelete-hide-user',
		'revdelete-hide-restricted',
		'revdelete-log',
		'revdelete-submit',
		'revdelete-logentry',
	),
	'diffs' => array(
		'difference',
		'loadingrev',
		'lineno',
		'editcurrent',
		'selectnewerversionfordiff',
		'selectolderversionfordiff',
		'compareselectedversions',
		'editundo',
		'diff-multi',
	),
	'search' => array(
		'searchresults',
		'searchresulttext',
		'searchsubtitle',
		'searchsubtitleinvalid',
		'badquery',
		'badquerytext',
		'matchtotals',
		'noexactmatch',
		'titlematches',
		'notitlematches',
		'textmatches',
		'notextmatches',
		'prevn',
		'nextn',
		'viewprevnext',
		'showingresults',
		'showingresultsnum',
		'nonefound',
		'powersearch',
		'powersearchtext',
		'searchdisabled',
		'googlesearch',
		'blanknamespace',
	),
	'preferences' => array(
		'preferences',
		'preferences-summary',
		'mypreferences',
		'prefsnologin',
		'prefsnologintext',
		'prefsreset',
		'qbsettings',
		'changepassword',
		'skin',
		'math',
		'dateformat',
		'datedefault',
		'datetime',
		'math_failure',
		'math_unknown_error',
		'math_unknown_function',
		'math_lexing_error',
		'math_syntax_error',
		'math_image_error',
		'math_bad_tmpdir',
		'math_bad_output',
		'math_notexvc',
		'prefs-personal',
		'prefs-rc',
		'prefs-watchlist',
		'prefs-watchlist-days',
		'prefs-watchlist-edits',
		'prefs-misc',
		'saveprefs',
		'resetprefs',
		'oldpassword',
		'newpassword',
		'retypenew',
		'textboxsize',
		'rows',
		'columns',
		'searchresultshead',
		'resultsperpage',
		'contextlines',
		'contextchars',
		'stubthreshold',
		'recentchangescount',
		'savedprefs',
		'timezonelegend',
		'timezonetext',
		'localtime',
		'timezoneoffset',
		'servertime',
		'guesstimezone',
		'allowemail',
		'defaultns',
		'default',
		'files',
	),
	'userrights' => array(
		'userrights-lookup-user',
		'userrights-user-editname',
		'editusergroup',
		'userrights-editusergroup',
		'saveusergroups',
		'userrights-groupsmember',
		'userrights-groupsavailable',
		'userrights-groupshelp',
	),
	'group' => array(
		'group',
		'group-bot',
		'group-sysop',
		'group-bureaucrat',
		'group-all',
	),
	'group-member' => array(
		'group-bot-member',
		'group-sysop-member',
		'group-bureaucrat-member',
	),
	'grouppage' => array(
		'grouppage-bot',
		'grouppage-sysop',
		'grouppage-bureaucrat',
	),
	'recentchanges' => array(
		'changes',
		'recentchanges',
		'recentchanges-url',
		'recentchangestext',
		'recentchanges-feed-description',
		'rcnote',
		'rcnotefrom',
		'rclistfrom',
		'rcshowhideminor',
		'rcshowhidebots',
		'rcshowhideliu',
		'rcshowhideanons',
		'rcshowhidepatr',
		'rcshowhidemine',
		'rclinks',
		'diff',
		'hist',
		'hide',
		'show',
		'minoreditletter',
		'newpageletter',
		'boteditletter',
		'sectionlink',
		'number_of_watching_users_RCview',
		'number_of_watching_users_pageview',
		'rc_categories',
		'rc_categories_any',
		'rc-change-size',
	),
	'upload' => array(
		'upload',
		'uploadbtn',
		'reupload',
		'reuploaddesc',
		'uploadnologin',
		'uploadnologintext',
		'upload_directory_read_only',
		'uploaderror',
		'uploadtext',
		'uploadlog',
		'uploadlogpage',
		'uploadlogpagetext',
		'filename',
		'filedesc',
		'fileuploadsummary',
		'filestatus',
		'filesource',
		'copyrightpage',
		'copyrightpagename',
		'uploadedfiles',
		'ignorewarning',
		'ignorewarnings',
		'minlength',
		'illegalfilename',
		'badfilename',
		'badfiletype',
		'large-file',
		'largefileserver',
		'emptyfile',
		'fileexists',
		'fileexists-forbidden',
		'fileexists-shared-forbidden',
		'successfulupload',
		'fileuploaded',
		'uploadwarning',
		'savefile',
		'uploadedimage',
		'uploaddisabled',
		'uploaddisabledtext',
		'uploadscripted',
		'uploadcorrupt',
		'uploadvirus',
		'sourcefilename',
		'destfilename',
		'watchthisupload',
		'filewasdeleted',
	),
	'upload-errors' => array(
		'upload-proto-error',
		'upload-proto-error-text',
		'upload-file-error',
		'upload-file-error-text',
		'upload-misc-error',
		'upload-misc-error-text',
	),
	'upload-curl-errors' => array(
		'upload-curl-error6',
		'upload-curl-error6-text',
		'upload-curl-error28',
		'upload-curl-error28-text',
	),
	'licenses' => array(
		'license',
		'nolicense',
		'licenses',
		'upload_source_url',
		'upload_source_file',
	),
	'imagelist' => array(
		'imagelist',
		'imagelist-summary',
		'imagelisttext',
		'imagelistforuser',
		'getimagelist',
		'ilsubmit',
		'showlast',
		'byname',
		'bydate',
		'bysize',
		'imgdelete',
		'imgdesc',
		'imgfile',
		'imglegend',
		'imghistory',
		'revertimg',
		'deleteimg',
		'deleteimgcompletely',
		'imghistlegend',
		'imagelinks',
		'linkstoimage',
		'nolinkstoimage',
		'sharedupload',
		'shareduploadwiki',
		'shareduploadwiki-linktext',
		'shareddescriptionfollows',
		'noimage',
		'noimage-linktext',
		'uploadnewversion-linktext',
		'imagelist_date',
		'imagelist_name',
		'imagelist_user',
		'imagelist_size',
		'imagelist_description',
		'imagelist_search_for',
	),
	'mimesearch' => array(
		'mimesearch',
		'mimesearch-summary',
		'mimetype',
		'download',
	),
	'unwatchedpages' => array(
		'unwatchedpages',
		'unwatchedpages-summary',
	),
	'listredirects' => array(
		'listredirects',
		'listredirects-summary',
	),
	'unusedtemplates' => array(
		'unusedtemplates',
		'unusedtemplates-summary',
		'unusedtemplatestext',
		'unusedtemplateswlh',
	),
	'randomredirect' => array(
		'randomredirect',
	),
	'statistics' => array(
		'statistics',
		'sitestats',
		'userstats',
		'sitestatstext',
		'userstatstext',
		'statistics-mostpopular',
	),
	'disambiguations' => array(
		'disambiguations',
		'disambiguations-summary',
		'disambiguationspage',
		'disambiguationstext',
	),
	'doubleredirects' => array(
		'doubleredirects',
		'doubleredirects-summary',
		'doubleredirectstext',
	),
	'brokenredirects' => array(
		'brokenredirects',
		'brokenredirects-summary',
		'brokenredirectstext',
	),
	'specialpages' => array(
		'nbytes',
		'ncategories',
		'nlinks',
		'nmembers',
		'nrevisions',
		'nviews',
		'lonelypages',
		'lonelypages-summary',
		'lonelypagestext',
		'uncategorizedpages',
		'uncategorizedpages-summary',
		'uncategorizedcategories',
		'uncategorizedcategories-summary',
		'uncategorizedimages',
		'uncategorizedimages-summary',
		'unusedcategories',
		'unusedimages',
		'popularpages',
		'popularpages-summary',
		'wantedcategories',
		'wantedcategories-summary',
		'wantedpages',
		'wantedpages-summary',
		'mostlinked',
		'mostlinked-summary',
		'mostlinkedcategories',
		'mostlinkedcategories-summary',
		'mostcategories',
		'mostcategories-summary',
		'mostimages',
		'mostimages-summary',
		'mostrevisions',
		'mostrevisions-summary',
		'allpages',
		'allpages-summary',
		'prefixindex',
		'prefixindex-summary',
		'randompage',
		'randompage-url',
		'shortpages',
		'shortpages-summary',
		'longpages',
		'longpages-summary',
		'deadendpages',
		'deadendpages-summary',
		'deadendpagestext',
		'listusers',
		'listusers-summary',
		'specialpages',
		'specialpages-summary',
		'spheading',
		'restrictedpheading',
		'recentchangeslinked',
		'rclsub',
		'newpages',
		'newpages-summary',
		'newpages-username',
		'ancientpages',
		'ancientpages-summary',
		'intl',
		'move',
		'movethispage',
		'unusedimagestext',
		'unusedcategoriestext',
	),
	'booksources' => array(
		'booksources',
		'booksources-summary',
		'booksources-search-legend',
		'booksources-isbn',
		'booksources-go',
		'booksources-text',
	),
	'specialpages2' => array(
		'categoriespagetext',
		'data',
		'userrights',
		'userrights-summary',
		'groups',
		'isbn',
		'rfcurl',
		'pubmedurl',
		'alphaindexline',
		'version',
		'log',
		'alllogstext',
		'logempty',
	),
	'allpages' => array(
		'nextpage',
		'prevpage',
		'allpagesfrom',
		'allarticles',
		'allinnamespace',
		'allnotinnamespace',
		'allpagesprev',
		'allpagesnext',
		'allpagessubmit',
		'allpagesprefix',
		'allpagesbadtitle',
	),
	'listusers' => array(
		'listusersfrom',
	),
	'emailuser' => array(
		'mailnologin',
		'mailnologintext',
		'emailuser',
		'emailpage',
		'emailpagetext',
		'usermailererror',
		'defemailsubject',
		'noemailtitle',
		'noemailtext',
		'emailfrom',
		'emailto',
		'emailsubject',
		'emailmessage',
		'emailsend',
		'emailccme',
		'emailccsubject',
		'emailsent',
		'emailsenttext',
	),
	'watchlist' => array(
		'watchlist',
		'watchlistfor',
		'nowatchlist',
		'watchlistanontext',
		'watchlistcount',
		'clearwatchlist',
		'watchlistcleartext',
		'watchlistclearbutton',
		'watchlistcleardone',
		'watchnologin',
		'watchnologintext',
		'addedwatch',
		'addedwatchtext',
		'removedwatch',
		'removedwatchtext',
		'watch',
		'watchthispage',
		'unwatch',
		'unwatchthispage',
		'notanarticle',
		'watchnochange',
		'watchdetails',
		'wlheader-enotif',
		'wlheader-showupdated',
		'watchmethod-recent',
		'watchmethod-list',
		'removechecked',
		'watchlistcontains',
		'watcheditlist',
		'removingchecked',
		'couldntremove',
		'iteminvalidname',
		'wlnote',
		'wlshowlast',
		'wlsaved',
		'watchlist-show-bots',
		'watchlist-hide-bots',
		'watchlist-show-own',
		'watchlist-hide-own',
		'watchlist-show-minor',
		'watchlist-hide-minor',
		'wldone',
	),
	'watching' => array(
		'watching',
		'unwatching',
	),
	'enotif' => array(
		'enotif_mailer',
		'enotif_reset',
		'enotif_newpagetext',
		'changed',
		'created',
		'enotif_subject',
		'enotif_lastvisited',
		'enotif_body',
	),
	'deleteprotectrev' => array(
		'deletepage',
		'confirm',
		'excontent',
		'excontentauthor',
		'exbeforeblank',
		'exblank',
		'confirmdelete',
		'deletesub',
		'historywarning',
		'confirmdeletetext',
		'actioncomplete',
		'deletedtext',
		'deletedarticle',
		'dellogpage',
		'dellogpagetext',
		'deletionlog',
		'reverted',
		'deletecomment',
		'imagereverted',
		'rollback',
		'rollback_short',
		'rollbacklink',
		'rollbackfailed',
		'cantrollback',
		'alreadyrolled',
		'editcomment',
		'revertpage',
		'sessionfailure',
		'protectlogpage',
		'protectlogtext',
		'protectedarticle',
		'unprotectedarticle',
		'protectsub',
		'confirmprotecttext',
		'confirmprotect',
		'protectmoveonly',
		'protectcomment',
		'unprotectsub',
		'confirmunprotecttext',
		'confirmunprotect',
		'unprotectcomment',
		'protect-unchain',
		'protect-text',
		'protect-viewtext',
		'protect-default',
		'protect-level-autoconfirmed',
		'protect-level-sysop',
	),
	'restrictions' => array(
		'restriction-edit',
		'restriction-move',
	),
	'undelete' => array(
		'undelete',
		'undeletepage',
		'viewdeletedpage',
		'undeletepagetext',
		'undeleteextrahelp',
		'undeletearticle',
		'undeleterevisions',
		'undeletehistory',
		'undeletehistorynoadmin',
		'undeleterevision',
		'undeleterevision-missing',
		'undeletebtn',
		'undeletereset',
		'undeletecomment',
		'undeletedarticle',
		'undeletedrevisions',
		'undeletedrevisions-files',
		'undeletedfiles',
		'cannotundelete',
		'undeletedpage',
	),
	'nsform' => array(
		'namespace',
		'invert',
	),
	'contributions' => array(
		'contributions',
		'mycontris',
		'contribsub',
		'nocontribs',
		'ucnote',
		'uclinks',
		'uctop',
		'newbies',
	),
	'sp-contributions' => array(
		'sp-contributions-newest',
		'sp-contributions-oldest',
		'sp-contributions-newer',
		'sp-contributions-older',
		'sp-contributions-newbies-sub',
		'sp-contributions-blocklog',
	),
	'newimages-showfrom' => array(
		'sp-newimages-showfrom',
	),
	'whatlinkshere' => array(
		'whatlinkshere',
		'whatlinkshere-summary',
		'whatlinkshere-barrow',
		'notargettitle',
		'notargettext',
		'linklistsub',
		'linkshere',
		'nolinkshere',
		'isredirect',
		'istemplate',
	),
	'block' => array(
		'blockip',
		'blockiptext',
		'ipaddress',
		'ipadressorusername',
		'ipbexpiry',
		'ipbreason',
		'ipbanononly',
		'ipbcreateaccount',
		'ipbenableautoblock',
		'ipbsubmit',
		'ipbother',
		'ipboptions',
		'ipbotheroption',
		'badipaddress',
		'blockipsuccesssub',
		'blockipsuccesstext',
		'unblockip',
		'unblockiptext',
		'ipusubmit',
		'unblocked',
		'ipblocklist',
		'ipblocklist-summary',
		'blocklistline',
		'infiniteblock',
		'expiringblock',
		'anononlyblock',
		'noautoblockblock',
		'createaccountblock',
		'ipblocklistempty',
		'blocklink',
		'unblocklink',
		'contribslink',
		'autoblocker',
		'blocklogpage',
		'blocklogentry',
		'blocklogtext',
		'unblocklogentry',
		'range_block_disabled',
		'ipb_expiry_invalid',
		'ipb_already_blocked',
		'ip_range_invalid',
		'proxyblocker',
		'ipb_cant_unblock',
		'proxyblockreason',
		'proxyblocksuccess',
		'sorbs',
		'sorbsreason',
		'sorbs_create_account_reason',
	),
	'developertools' => array(
		'lockdb',
		'unlockdb',
		'lockdbtext',
		'unlockdbtext',
		'lockconfirm',
		'unlockconfirm',
		'lockbtn',
		'unlockbtn',
		'locknoconfirm',
		'lockdbsuccesssub',
		'unlockdbsuccesssub',
		'lockdbsuccesstext',
		'unlockdbsuccesstext',
		'lockfilenotwritable',
		'databasenotlocked',
	),
	'makesysop' => array(
		'makesysoptitle',
		'makesysoptext',
		'makesysopname',
		'makesysopsubmit',
		'makesysopok',
		'makesysopfail',
		'setbureaucratflag',
		'rightslog',
		'rightslogtext',
		'rightslogentry',
		'rights',
		'set_user_rights',
		'user_rights_set',
		'set_rights_fail',
		'makesysop',
		'already_sysop',
		'already_bureaucrat',
		'rightsnone',
	),
	'movepage' => array(
		'movepage',
		'movepagetext',
		'movepagetalktext',
		'movearticle',
		'movenologin',
		'movenologintext',
		'newtitle',
		'move-watch',
		'movepagebtn',
		'pagemovedsub',
		'pagemovedtext',
		'articleexists',
		'talkexists',
		'movedto',
		'movetalk',
		'talkpagemoved',
		'talkpagenotmoved',
		'1movedto2',
		'1movedto2_redir',
		'movelogpage',
		'movelogpagetext',
		'movereason',
		'revertmove',
		'delete_and_move',
		'delete_and_move_text',
		'delete_and_move_confirm',
		'delete_and_move_reason',
		'selfmove',
		'immobile_namespace',
	),
	'export' => array(
		'export',
		'exporttext',
		'exportcuronly',
		'exportnohistory',
		'export-submit',
	),
	'allmessages' => array(
		'allmessages',
		'allmessagesname',
		'allmessagesdefault',
		'allmessagescurrent',
		'allmessagestext',
		'allmessagesnotsupportedUI',
		'allmessagesnotsupportedDB',
		'allmessagesfilter',
		'allmessagesmodified',
	),
	'thumbnails' => array(
		'thumbnail-more',
		'missingimage',
		'filemissing',
		'thumbnail_error',
	),
	'import' => array(
		'import',
		'importinterwiki',
		'import-interwiki-text',
		'import-interwiki-history',
		'import-interwiki-submit',
		'import-interwiki-namespace',
		'importtext',
		'importstart',
		'import-revision-count',
		'importnopages',
		'importfailed',
		'importunknownsource',
		'importcantopen',
		'importbadinterwiki',
		'importnotext',
		'importsuccess',
		'importhistoryconflict',
		'importnosources',
		'importnofile',
		'importuploaderror',
	),
	'importlog' => array(
		'importlogpage',
		'importlogpagetext',
		'import-logentry-upload',
		'import-logentry-upload-detail',
		'import-logentry-interwiki',
		'import-logentry-interwiki-detail',
	),
	'accesskeys' => array(
		'accesskey-search',
		'accesskey-minoredit',
		'accesskey-save',
		'accesskey-preview',
		'accesskey-diff',
		'accesskey-compareselectedversions',
		'accesskey-watch',
	),
	'tooltips' => array(
		'tooltip-search',
		'tooltip-minoredit',
		'tooltip-save',
		'tooltip-preview',
		'tooltip-diff',
		'tooltip-compareselectedversions',
		'tooltip-watch',
	),
	'stylesheets' => array(
		'common.css',
		'monobook.css',
	),
	'metadata_cc' => array(
		'nodublincore',
		'nocreativecommons',
		'notacceptable',
	),
	'attribution' => array(
		'anonymous',
		'siteuser',
		'lastmodifiedatby',
		'and',
		'othercontribs',
		'others',
		'siteusers',
		'creditspage',
		'nocredits',
	),
	'spamprotection' => array(
		'spamprotectiontitle',
		'spamprotectiontext',
		'spamprotectionmatch',
		'subcategorycount',
		'categoryarticlecount',
		'category-media-count',
		'listingcontinuesabbrev',
		'spambot_username',
		'spam_reverting',
		'spam_blanking',
	),
	'info' => array(
		'infosubtitle',
		'numedits',
		'numtalkedits',
		'numwatchers',
		'numauthors',
		'numtalkauthors',
	),
	'math' => array(
		'mw_math_png',
		'mw_math_simple',
		'mw_math_html',
		'mw_math_source',
		'mw_math_modern',
		'mw_math_mathml',
	),
	'patrolling' => array(
		'markaspatrolleddiff',
		'markaspatrolledlink',
		'markaspatrolledtext',
		'markedaspatrolled',
		'markedaspatrolledtext',
		'rcpatroldisabled',
		'rcpatroldisabledtext',
		'markedaspatrollederror',
		'markedaspatrollederrortext',
		'markedaspatrollederror-noautopatrol',
	),
	'monobook.js' => array(
		'monobook.js',
	),
	'common.js' => array(
		'common.js',
	),
	'imagedeletion' => array(
		'deletedrevision',
	),
	'browsediffs' => array(
		'previousdiff',
		'nextdiff',
	),
	'imagesize' => array(
		'imagemaxsize',
		'thumbsize',
		'showbigimage',
	),
	'newimages' => array(
		'newimages',
		'newimages-summary',
		'showhidebots',
		'noimages',
	),
	'variantname-zh' => array(
		'variantname-zh-cn',
		'variantname-zh-tw',
		'variantname-zh-hk',
		'variantname-zh-sg',
		'variantname-zh',
	),
	'variantname-sr' => array(
		'variantname-sr-ec',
		'variantname-sr-el',
		'variantname-sr-jc',
		'variantname-sr-jl',
		'variantname-sr',
	),
	'variantname-kk' => array(
		'variantname-kk-tr',
		'variantname-kk-kz',
		'variantname-kk-cn',
		'variantname-kk',
	),
	'specialloglabels' => array(
		'specialloguserlabel',
		'speciallogtitlelabel',
	),
	'passwordtooshort' => array(
		'passwordtooshort',
	),
	'mediawarning' => array(
		'mediawarning',
	),
	'fileinfo' => array(
		'fileinfo',
	),
	'metadata' => array(
		'metadata',
		'metadata-help',
		'metadata-expand',
		'metadata-collapse',
		'metadata-fields',
	),
	'exif' => array(
		'exif-imagewidth',
		'exif-imagelength',
		'exif-bitspersample',
		'exif-compression',
		'exif-photometricinterpretation',
		'exif-orientation',
		'exif-samplesperpixel',
		'exif-planarconfiguration',
		'exif-ycbcrsubsampling',
		'exif-ycbcrpositioning',
		'exif-xresolution',
		'exif-yresolution',
		'exif-resolutionunit',
		'exif-stripoffsets',
		'exif-rowsperstrip',
		'exif-stripbytecounts',
		'exif-jpeginterchangeformat',
		'exif-jpeginterchangeformatlength',
		'exif-transferfunction',
		'exif-whitepoint',
		'exif-primarychromaticities',
		'exif-ycbcrcoefficients',
		'exif-referenceblackwhite',
		'exif-datetime',
		'exif-imagedescription',
		'exif-make',
		'exif-model',
		'exif-software',
		'exif-artist',
		'exif-copyright',
		'exif-exifversion',
		'exif-flashpixversion',
		'exif-colorspace',
		'exif-componentsconfiguration',
		'exif-compressedbitsperpixel',
		'exif-pixelydimension',
		'exif-pixelxdimension',
		'exif-makernote',
		'exif-usercomment',
		'exif-relatedsoundfile',
		'exif-datetimeoriginal',
		'exif-datetimedigitized',
		'exif-subsectime',
		'exif-subsectimeoriginal',
		'exif-subsectimedigitized',
		'exif-exposuretime',
		'exif-exposuretime-format',
		'exif-fnumber',
		'exif-fnumber-format',
		'exif-exposureprogram',
		'exif-spectralsensitivity',
		'exif-isospeedratings',
		'exif-oecf',
		'exif-shutterspeedvalue',
		'exif-aperturevalue',
		'exif-brightnessvalue',
		'exif-exposurebiasvalue',
		'exif-maxaperturevalue',
		'exif-subjectdistance',
		'exif-meteringmode',
		'exif-lightsource',
		'exif-flash',
		'exif-focallength',
		'exif-focallength-format',
		'exif-subjectarea',
		'exif-flashenergy',
		'exif-spatialfrequencyresponse',
		'exif-focalplanexresolution',
		'exif-focalplaneyresolution',
		'exif-focalplaneresolutionunit',
		'exif-subjectlocation',
		'exif-exposureindex',
		'exif-sensingmethod',
		'exif-filesource',
		'exif-scenetype',
		'exif-cfapattern',
		'exif-customrendered',
		'exif-exposuremode',
		'exif-whitebalance',
		'exif-digitalzoomratio',
		'exif-focallengthin35mmfilm',
		'exif-scenecapturetype',
		'exif-gaincontrol',
		'exif-contrast',
		'exif-saturation',
		'exif-sharpness',
		'exif-devicesettingdescription',
		'exif-subjectdistancerange',
		'exif-imageuniqueid',
		'exif-gpsversionid',
		'exif-gpslatituderef',
		'exif-gpslatitude',
		'exif-gpslongituderef',
		'exif-gpslongitude',
		'exif-gpsaltituderef',
		'exif-gpsaltitude',
		'exif-gpstimestamp',
		'exif-gpssatellites',
		'exif-gpsstatus',
		'exif-gpsmeasuremode',
		'exif-gpsdop',
		'exif-gpsspeedref',
		'exif-gpsspeed',
		'exif-gpstrackref',
		'exif-gpstrack',
		'exif-gpsimgdirectionref',
		'exif-gpsimgdirection',
		'exif-gpsmapdatum',
		'exif-gpsdestlatituderef',
		'exif-gpsdestlatitude',
		'exif-gpsdestlongituderef',
		'exif-gpsdestlongitude',
		'exif-gpsdestbearingref',
		'exif-gpsdestbearing',
		'exif-gpsdestdistanceref',
		'exif-gpsdestdistance',
		'exif-gpsprocessingmethod',
		'exif-gpsareainformation',
		'exif-gpsdatestamp',
		'exif-gpsdifferential',
	),
	'exif-values' => array(
		'exif-make-value',
		'exif-model-value',
		'exif-software-value',
	),
	'exif-compression' => array(
		'exif-compression-1',
		'exif-compression-6',
	),
	'exif-photometricinterpretation' => array(
		'exif-photometricinterpretation-2',
		'exif-photometricinterpretation-6',
	),
	'exif-unknowndate' => array(
		'exif-unknowndate',
	),
	'exif-orientation' => array(
		'exif-orientation-1',
		'exif-orientation-2',
		'exif-orientation-3',
		'exif-orientation-4',
		'exif-orientation-5',
		'exif-orientation-6',
		'exif-orientation-7',
		'exif-orientation-8',
	),
	'exif-planarconfiguration' => array(
		'exif-planarconfiguration-1',
		'exif-planarconfiguration-2',
	),
	'exif-xyresolution' => array(
		'exif-xyresolution-i',
		'exif-xyresolution-c',
	),
	'exif-colorspace' => array(
		'exif-colorspace-1',
		'exif-colorspace-ffff.h',
	),
	'exif-componentsconfiguration' => array(
		'exif-componentsconfiguration-0',
		'exif-componentsconfiguration-1',
		'exif-componentsconfiguration-2',
		'exif-componentsconfiguration-3',
		'exif-componentsconfiguration-4',
		'exif-componentsconfiguration-5',
		'exif-componentsconfiguration-6',
	),
	'exif-exposureprogram' => array(
		'exif-exposureprogram-0',
		'exif-exposureprogram-1',
		'exif-exposureprogram-2',
		'exif-exposureprogram-3',
		'exif-exposureprogram-4',
		'exif-exposureprogram-5',
		'exif-exposureprogram-6',
		'exif-exposureprogram-7',
		'exif-exposureprogram-8',
	),
	'exif-subjectdistance-value' => array(
		'exif-subjectdistance-value',
	),
	'exif-meteringmode' => array(
		'exif-meteringmode-0',
		'exif-meteringmode-1',
		'exif-meteringmode-2',
		'exif-meteringmode-3',
		'exif-meteringmode-4',
		'exif-meteringmode-5',
		'exif-meteringmode-6',
		'exif-meteringmode-255',
	),
	'exif-lightsource' => array(
		'exif-lightsource-0',
		'exif-lightsource-1',
		'exif-lightsource-2',
		'exif-lightsource-3',
		'exif-lightsource-4',
		'exif-lightsource-9',
		'exif-lightsource-10',
		'exif-lightsource-11',
		'exif-lightsource-12',
		'exif-lightsource-13',
		'exif-lightsource-14',
		'exif-lightsource-15',
		'exif-lightsource-17',
		'exif-lightsource-18',
		'exif-lightsource-19',
		'exif-lightsource-20',
		'exif-lightsource-21',
		'exif-lightsource-22',
		'exif-lightsource-23',
		'exif-lightsource-24',
		'exif-lightsource-255',
	),
	'exif-focalplaneresolutionunit' => array(
		'exif-focalplaneresolutionunit-2',
	),
	'exif-sensingmethod' => array(
		'exif-sensingmethod-1',
		'exif-sensingmethod-2',
		'exif-sensingmethod-3',
		'exif-sensingmethod-4',
		'exif-sensingmethod-5',
		'exif-sensingmethod-7',
		'exif-sensingmethod-8',
	),
	'exif-filesource' => array(
		'exif-filesource-3',
	),
	'exif-scenetype' => array(
		'exif-scenetype-1',
	),
	'exif-customrendered' => array(
		'exif-customrendered-0',
		'exif-customrendered-1',
	),
	'exif-exposuremode' => array(
		'exif-exposuremode-0',
		'exif-exposuremode-1',
		'exif-exposuremode-2',
	),
	'exif-whitebalance' => array(
		'exif-whitebalance-0',
		'exif-whitebalance-1',
	),
	'exif-scenecapturetype' => array(
		'exif-scenecapturetype-0',
		'exif-scenecapturetype-1',
		'exif-scenecapturetype-2',
		'exif-scenecapturetype-3',
	),
	'exif-gaincontrol' => array(
		'exif-gaincontrol-0',
		'exif-gaincontrol-1',
		'exif-gaincontrol-2',
		'exif-gaincontrol-3',
		'exif-gaincontrol-4',
	),
	'exif-contrast' => array(
		'exif-contrast-0',
		'exif-contrast-1',
		'exif-contrast-2',
	),
	'exif-saturation' => array(
		'exif-saturation-0',
		'exif-saturation-1',
		'exif-saturation-2',
	),
	'exif-sharpness' => array(
		'exif-sharpness-0',
		'exif-sharpness-1',
		'exif-sharpness-2',
	),
	'exif-subjectdistancerange' => array(
		'exif-subjectdistancerange-0',
		'exif-subjectdistancerange-1',
		'exif-subjectdistancerange-2',
		'exif-subjectdistancerange-3',
	),
	'exif-gpslatitude' => array(
		'exif-gpslatitude-n',
		'exif-gpslatitude-s',
	),
	'exif-gpslongitude' => array(
		'exif-gpslongitude-e',
		'exif-gpslongitude-w',
	),
	'exif-gpsstatus' => array(
		'exif-gpsstatus-a',
		'exif-gpsstatus-v',
	),
	'exif-gpsmeasuremode' => array(
		'exif-gpsmeasuremode-2',
		'exif-gpsmeasuremode-3',
	),
	'exif-gpsspeed' => array(
		'exif-gpsspeed-k',
		'exif-gpsspeed-m',
		'exif-gpsspeed-n',
	),
	'exif-gpsdirection' => array(
		'exif-gpsdirection-t',
		'exif-gpsdirection-m',
	),
	'edit-externally' => array(
		'edit-externally',
		'edit-externally-help',
	),
	'all' => array(
		'recentchangesall',
		'imagelistall',
		'watchlistall1',
		'watchlistall2',
		'namespacesall',
	),
	'confirmemail' => array(
		'confirmemail',
		'confirmemail_noemail',
		'confirmemail_text',
		'confirmemail_pending',
		'confirmemail_send',
		'confirmemail_sent',
		'confirmemail_oncreate',
		'confirmemail_sendfailed',
		'confirmemail_invalid',
		'confirmemail_needlogin',
		'confirmemail_success',
		'confirmemail_loggedin',
		'confirmemail_error',
		'confirmemail_subject',
		'confirmemail_body',
	),
	'inputbox' => array(
		'tryexact',
		'searchfulltext',
		'createarticle',
	),
	'scarytransclusion' => array(
		'scarytranscludedisabled',
		'scarytranscludefailed',
		'scarytranscludetoolong',
	),
	'trackbacks' => array(
		'trackbackbox',
		'trackback',
		'trackbackexcerpt',
		'trackbackremove',
		'trackbacklink',
		'trackbackdeleteok',
	),
	'deleteconflict' => array(
		'deletedwhileediting',
		'confirmrecreate',
		'recreate',
		'tooltip-recreate',
	),
	'unit-pixel' => array(
		'unit-pixel',
	),
	'htmldump' => array(
		'redirectingto',
	),
	'purge' => array(
		'confirm_purge',
		'confirm_purge_button',
	),
	'newmessagesmulti' => array(
		'youhavenewmessagesmulti',
		'newtalkseperator',
	),
	'search2' => array(
		'searchcontaining',
		'searchnamed',
		'articletitles',
		'hideresults',
	),
	'displaytitle' => array(
		'displaytitle',
	),
	'catseparator' => array(
		'catseparator',
	),
	'loginlanguage' => array(
		'loginlanguagelabel',
		'loginlanguagelinks',
	),
	'imgmulti' => array(
		'imgmultipageprev',
		'imgmultipagenext',
		'imgmultigo',
		'imgmultigotopre',
		'imgmultigotopost',
	),
	'tablepager' => array(
		'ascending_abbrev',
		'descending_abbrev',
		'table_pager_next',
		'table_pager_prev',
		'table_pager_first',
		'table_pager_last',
		'table_pager_limit',
		'table_pager_limit_submit',
		'table_pager_empty',
	),
	'autosumm' => array(
		'autosumm-blank',
		'autosumm-replace',
		'autoredircomment',
		'autosumm-new',
	),
	'autoblock_whitelist' => array(
		'autoblock_whitelist',
	),
	'sizeunits' => array(
		'size-bytes',
		'size-kilobytes',
		'size-megabytes',
		'size-gigabytes',
	),
);
/** Comments for each block */
$wgBlockComments = array(
	'sidebar'             => "The sidebar for MonoBook is generated from this message, lines that do not
begin with * or ** are discarded, furthermore lines that do begin with ** and
do not contain | are also discarded, but don't depend on this behaviour for
future releases. Also note that since each list value is wrapped in a unique
XHTML id it should only appear once and include characters that are legal
XHTML id names.",
	'toggles'             => 'User preference toggles',
	'underline'           => '',
	'skinpreview'         => '',
	'dates'               => 'Dates',
	'categories'          => 'Bits of text used by many pages',
	'mainpage'            => '',
	'miscellaneous1'      => '',
	'metadata_help'       => 'Metadata in edit box',
	'currentevents'       => '',
	'miscellaneous2'      => '',
	'badaccess'           => '',
	'versionrequired'     => '',
	'miscellaneous3'      => '',
	'nstab'               => "Short words for each namespace, by default used in the 'article' tab in monobook",
	'main'                => 'Main script and global functions',
	'errors'              => 'General errors',
	'login'               => 'Login and logout pages',
	'resetpass'           => 'Password reset dialog',
	'toolbar'             => 'Edit page toolbar',
	'edit'                => 'Edit pages',
	'undo'                => '"Undo" feature',
	'cantcreateaccount'   => 'Account creation failure',
	'history'             => 'History pages',
	'history-feed'        => '',
	'revdelete'           => 'Revision deletion',
	'diffs'               => 'Diffs',
	'search'              => 'Search results',
	'preferences'         => 'Preferences page',
	'userrights'          => 'User rights',
	'group'               => 'Groups',
	'group-member'        => '',
	'grouppage'           => '',
	'recentchanges'       => 'Recent changes',
	'upload'              => 'Upload',
	'upload-errors'       => '',
	'upload-curl-errors'  => 'Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>',
	'licenses'            => '',
	'imagelist'           => 'Image list',
	'mimesearch'          => 'MIME search',
	'unwatchedpages'      => 'Unwatched pages',
	'listredirects'       => 'List redirects',
	'unusedtemplates'     => 'Unused templates',
	'randomredirect'      => 'Random redirect',
	'statistics'          => 'Statistics',
	'disambiguations'     => '',
	'doubleredirects'     => '',
	'brokenredirects'     => '',
	'specialpages'        => 'Miscellaneous special pages',
	'booksources'         => 'Book sources',
	'specialpages2'       => '',
	'allpages'            => 'Special:Allpages',
	'listusers'           => 'Special:Listusers',
	'emailuser'           => 'E-mail user',
	'watchlist'           => 'Watchlist',
	'watching'            => 'Displayed when you click the "watch" button and it\'s in the process of watching',
	'enotif'              => '',
	'deleteprotectrev'    => 'Delete/protect/revert',
	'restrictions'        => 'Restrictions (nouns)',
	'undelete'            => 'Undelete',
	'nsform'              => 'Namespace form on various pages',
	'contributions'       => 'Contributions',
	'sp-contributions'    => '',
	'newimages-showfrom'  => '',
	'whatlinkshere'       => 'What links here',
	'block'               => 'Block/unblock',
	'developertools'      => 'Developer tools',
	'makesysop'           => 'Make sysop',
	'movepage'            => 'Move page',
	'export'              => 'Export',
	'allmessages'         => 'Namespace 8 related',
	'thumbnails'          => 'Thumbnails',
	'import'              => 'Special:Import',
	'importlog'           => 'Import log',
	'accesskeys'          => 'Keyboard access keys for power users',
	'tooltips'            => 'Tooltip help for some actions, most are in Monobook.js',
	'stylesheets'         => 'Stylesheets',
	'metadata_cc'         => 'Metadata',
	'attribution'         => 'Attribution',
	'spamprotection'      => 'Spam protection',
	'info'                => 'Info page',
	'math'                => 'Math options',
	'patrolling'          => 'Patrolling',
	'monobook.js'         => 'Monobook.js: tooltips and access keys for monobook',
	'common.js'           => 'Common.js: contains nothing but a placeholder comment',
	'imagedeletion'       => 'Image deletion',
	'browsediffs'         => 'Browsing diffs',
	'imagesize'           => '',
	'newimages'           => '',
	'variantname-zh'      => "Short names for language variants used for language conversion links.
To disable showing a particular link, set it to 'disable', e.g.
'variantname-zh-sg' => 'disable',
Variants for Chinese language",
	'variantname-sr'      => 'Variants for Serbian language',
	'variantname-kk'      => 'Variants for Kazakh language',
	'specialloglabels'    => 'Labels for User: and Title: on Special:Log pages',
	'passwordtooshort'    => '',
	'mediawarning'        => 'Media Warning',
	'fileinfo'            => '',
	'metadata'            => 'Metadata',
	'exif'                           => 'EXIF tags',
	'exif-values'                    => 'Make & model, can be wikified in order to link to the camera and model name',
	'exif-compression'               => 'EXIF attributes',
	'exif-unknowndate'               => '',
	'exif-photometricinterpretation' => '',
	'exif-orientation'               => '',
	'exif-planarconfiguration'       => '',
	'exif-xyresolution'              => '',
	'exif-colorspace'                => '',
	'exif-componentsconfiguration'   => '',
	'exif-exposureprogram'           => '',
	'exif-subjectdistance-value'     => '',
	'exif-meteringmode'              => '',
	'exif-lightsource'               => '',
	'exif-focalplaneresolutionunit'  => '',
	'exif-sensingmethod'             => '',
	'exif-filesource'                => '',
	'exif-scenetype'                 => '',
	'exif-customrendered'            => '',
	'exif-exposuremode'              => '',
	'exif-whitebalance'              => '',
	'exif-scenecapturetype'          => '',
	'exif-gaincontrol'               => '',
	'exif-contrast'                  => '',
	'exif-saturation'                => '',
	'exif-sharpness'                 => '',
	'exif-subjectdistancerange'      => '',
	'exif-gpslatitude'               => 'Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef',
	'exif-gpslongitude'              => 'Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef',
	'exif-gpsstatus'                 => '',
	'exif-gpsmeasuremode'            => '',
	'exif-gpsspeed'                  => 'Pseudotags used for GPSSpeedRef and GPSDestDistanceRef',
	'exif-gpsdirection'              => 'Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef',
	'edit-externally'     => 'External editor support',
	'all'                 => "'all' in various places, this might be different for inflected languages",
	'confirmemail'        => 'E-mail address confirmation',
	'inputbox'            => 'Inputbox extension, may be useful in other contexts as well',
	'scarytransclusion'   => 'Scary transclusion',
	'trackbacks'          => 'Trackbacks',
	'deleteconflict'      => 'Delete conflict',
	'unit-pixel'          => '',
	'htmldump'            => 'HTML dump',
	'purge'               => 'action=purge',
	'newmessagesmulti'    => '',
	'search2'             => '',
	'displaytitle'        => 'DISPLAYTITLE',
	'catseparator'        => 'Separator for categories in page lists',
	'loginlanguage'       => '',
	'imgmulti'            => 'Multipage image navigation',
	'tablepager'          => 'Table pager',
	'autosumm'            => 'Auto-summaries',
	'autoblock_whitelist' => 'Autoblock whitelist',
	'sizeunits'           => 'Size units',
);

/** Short comments for standalone messages */
$wgMessageComments = array(
	'lastmodifiedat'              => '$1 date, $2 time',
	'sitenotice'                  => 'the equivalent to wgSiteNotice',
	'perfdisabledsub'             => 'obsolete?',
	'history-feed-item-nocomment' => 'user at time',
	'editcomment'                 => 'only shown if there is an edit comment',
	'lastmodifiedatby'            => '$1 date, $2 time, $3 user',
	'exif-orientation-1'          => '0th row: top; 0th column: left',
	'exif-orientation-2'          => '0th row: top; 0th column: right',
	'exif-orientation-3'          => '0th row: bottom; 0th column: right',
	'exif-orientation-4'          => '0th row: bottom; 0th column: left',
	'exif-orientation-5'          => '0th row: left; 0th column: top',
	'exif-orientation-6'          => '0th row: right; 0th column: top',
	'exif-orientation-7'          => '0th row: right; 0th column: bottom',
	'exif-orientation-8'          => '0th row: left; 0th column: bottom',
	'autoredircomment'            => 'This should be changed to the new naming convention, but existed beforehand',
);

/** Messages which contain dollar signs (which are not followed by numbers), and therefore should use a single apostrophe */
$wgMessagseWithDollarSigns = array(
	'linkprefix',
	'enotif_subject',
	'enotif_body',
	'allmessagesnotsupportedDB',
);

?>
