/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _TERMINAL_H
#define _TERMINAL_H

#include "multilineedit.h"

namespace uta {

///
class Terminal : public MultiLineEdit
{
 public:

  ///
  Terminal(Widget* parent, 
	    int x, int y, int w, int h,
	    const Font *font=0, bool readonly = true);
  ///
  virtual ~Terminal();

  ///
  void scrollUp(int);
  ///
  void scrollDown(int);
  ///
  void scrollTo(int);
  ///
  void scroll2Top();
  ///
  void scroll2Bottom();
  ///
  unsigned linesCount() const;
  ///
  unsigned currentLine() const;
  ///
  SigC::Signal0<void> scrolled;

 protected:
  ///
  virtual void create();
  ///
  unsigned scrollTo_;
  ///
  unsigned currentLine_;
  ///
  unsigned allLines_;
};

}
#endif // _MULTILINEDIT_

