%% Generated by the Erlang ASN.1 BER_V2-compiler version, utilizing bit-syntax:1.4.5
%% Purpose: encoder and decoder to the types in mod PKIX1Explicit88

-module('PKIX1Explicit88').
-include("PKIX1Explicit88.hrl").
-define('RT_BER',asn1rt_ber_bin_v2).
-asn1_info([{vsn,'1.4.5'},
            {module,'PKIX1Explicit88'},
            {options,[ber_bin_v2,report_errors,{cwd,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,115,115,108,47,112,107,105,120]},{outdir,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,115,115,108,47,112,107,105,120]},noobj,optimize,compact_bit_string,der,{i,[46]},{i,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,115,115,108,47,112,107,105,120]}]}]).

-export([encoding_rule/0]).
-export([
'enc_Attribute'/2,
'enc_AttributeType'/2,
'enc_AttributeValue'/2,
'enc_AttributeTypeAndValue'/2,
'enc_X520name'/2,
'enc_X520CommonName'/2,
'enc_X520LocalityName'/2,
'enc_X520StateOrProvinceName'/2,
'enc_X520OrganizationName'/2,
'enc_X520OrganizationalUnitName'/2,
'enc_X520Title'/2,
'enc_X520dnQualifier'/2,
'enc_X520countryName'/2,
'enc_X520SerialNumber'/2,
'enc_X520Pseudonym'/2,
'enc_DomainComponent'/2,
'enc_EmailAddress'/2,
'enc_Name'/2,
'enc_RDNSequence'/2,
'enc_DistinguishedName'/2,
'enc_RelativeDistinguishedName'/2,
'enc_DirectoryString'/2,
'enc_Certificate'/2,
'enc_TBSCertificate'/2,
'enc_Version'/2,
'enc_CertificateSerialNumber'/2,
'enc_Validity'/2,
'enc_Time'/2,
'enc_UniqueIdentifier'/2,
'enc_SubjectPublicKeyInfo'/2,
'enc_Extensions'/2,
'enc_Extension'/2,
'enc_CertificateList'/2,
'enc_TBSCertList'/2,
'enc_AlgorithmIdentifier'/2,
'enc_ORAddress'/2,
'enc_BuiltInStandardAttributes'/2,
'enc_CountryName'/2,
'enc_AdministrationDomainName'/2,
'enc_NetworkAddress'/2,
'enc_X121Address'/2,
'enc_TerminalIdentifier'/2,
'enc_PrivateDomainName'/2,
'enc_OrganizationName'/2,
'enc_NumericUserIdentifier'/2,
'enc_PersonalName'/2,
'enc_OrganizationalUnitNames'/2,
'enc_OrganizationalUnitName'/2,
'enc_BuiltInDomainDefinedAttributes'/2,
'enc_BuiltInDomainDefinedAttribute'/2,
'enc_ExtensionAttributes'/2,
'enc_ExtensionAttribute'/2,
'enc_CommonName'/2,
'enc_TeletexCommonName'/2,
'enc_TeletexOrganizationName'/2,
'enc_TeletexPersonalName'/2,
'enc_TeletexOrganizationalUnitNames'/2,
'enc_TeletexOrganizationalUnitName'/2,
'enc_PDSName'/2,
'enc_PhysicalDeliveryCountryName'/2,
'enc_PostalCode'/2,
'enc_PhysicalDeliveryOfficeName'/2,
'enc_PhysicalDeliveryOfficeNumber'/2,
'enc_ExtensionORAddressComponents'/2,
'enc_PhysicalDeliveryPersonalName'/2,
'enc_PhysicalDeliveryOrganizationName'/2,
'enc_ExtensionPhysicalDeliveryAddressComponents'/2,
'enc_UnformattedPostalAddress'/2,
'enc_StreetAddress'/2,
'enc_PostOfficeBoxAddress'/2,
'enc_PosteRestanteAddress'/2,
'enc_UniquePostalName'/2,
'enc_LocalPostalAttributes'/2,
'enc_PDSParameter'/2,
'enc_ExtendedNetworkAddress'/2,
'enc_PresentationAddress'/2,
'enc_TerminalType'/2,
'enc_TeletexDomainDefinedAttributes'/2,
'enc_TeletexDomainDefinedAttribute'/2
]).

-export([
'dec_Attribute'/2,
'dec_AttributeType'/2,
'dec_AttributeValue'/2,
'dec_AttributeTypeAndValue'/2,
'dec_X520name'/2,
'dec_X520CommonName'/2,
'dec_X520LocalityName'/2,
'dec_X520StateOrProvinceName'/2,
'dec_X520OrganizationName'/2,
'dec_X520OrganizationalUnitName'/2,
'dec_X520Title'/2,
'dec_X520dnQualifier'/2,
'dec_X520countryName'/2,
'dec_X520SerialNumber'/2,
'dec_X520Pseudonym'/2,
'dec_DomainComponent'/2,
'dec_EmailAddress'/2,
'dec_Name'/2,
'dec_RDNSequence'/2,
'dec_DistinguishedName'/2,
'dec_RelativeDistinguishedName'/2,
'dec_DirectoryString'/2,
'dec_Certificate'/2,
'dec_TBSCertificate'/2,
'dec_Version'/2,
'dec_CertificateSerialNumber'/2,
'dec_Validity'/2,
'dec_Time'/2,
'dec_UniqueIdentifier'/2,
'dec_SubjectPublicKeyInfo'/2,
'dec_Extensions'/2,
'dec_Extension'/2,
'dec_CertificateList'/2,
'dec_TBSCertList'/2,
'dec_AlgorithmIdentifier'/2,
'dec_ORAddress'/2,
'dec_BuiltInStandardAttributes'/2,
'dec_CountryName'/2,
'dec_AdministrationDomainName'/2,
'dec_NetworkAddress'/2,
'dec_X121Address'/2,
'dec_TerminalIdentifier'/2,
'dec_PrivateDomainName'/2,
'dec_OrganizationName'/2,
'dec_NumericUserIdentifier'/2,
'dec_PersonalName'/2,
'dec_OrganizationalUnitNames'/2,
'dec_OrganizationalUnitName'/2,
'dec_BuiltInDomainDefinedAttributes'/2,
'dec_BuiltInDomainDefinedAttribute'/2,
'dec_ExtensionAttributes'/2,
'dec_ExtensionAttribute'/2,
'dec_CommonName'/2,
'dec_TeletexCommonName'/2,
'dec_TeletexOrganizationName'/2,
'dec_TeletexPersonalName'/2,
'dec_TeletexOrganizationalUnitNames'/2,
'dec_TeletexOrganizationalUnitName'/2,
'dec_PDSName'/2,
'dec_PhysicalDeliveryCountryName'/2,
'dec_PostalCode'/2,
'dec_PhysicalDeliveryOfficeName'/2,
'dec_PhysicalDeliveryOfficeNumber'/2,
'dec_ExtensionORAddressComponents'/2,
'dec_PhysicalDeliveryPersonalName'/2,
'dec_PhysicalDeliveryOrganizationName'/2,
'dec_ExtensionPhysicalDeliveryAddressComponents'/2,
'dec_UnformattedPostalAddress'/2,
'dec_StreetAddress'/2,
'dec_PostOfficeBoxAddress'/2,
'dec_PosteRestanteAddress'/2,
'dec_UniquePostalName'/2,
'dec_LocalPostalAttributes'/2,
'dec_PDSParameter'/2,
'dec_ExtendedNetworkAddress'/2,
'dec_PresentationAddress'/2,
'dec_TerminalType'/2,
'dec_TeletexDomainDefinedAttributes'/2,
'dec_TeletexDomainDefinedAttribute'/2
]).

-export([
'id-pkix'/0,
'id-pe'/0,
'id-qt'/0,
'id-kp'/0,
'id-ad'/0,
'id-qt-cps'/0,
'id-qt-unotice'/0,
'id-ad-ocsp'/0,
'id-ad-caIssuers'/0,
'id-ad-timeStamping'/0,
'id-ad-caRepository'/0,
'id-at'/0,
'id-at-name'/0,
'id-at-surname'/0,
'id-at-givenName'/0,
'id-at-initials'/0,
'id-at-generationQualifier'/0,
'id-at-commonName'/0,
'id-at-localityName'/0,
'id-at-stateOrProvinceName'/0,
'id-at-organizationName'/0,
'id-at-organizationalUnitName'/0,
'id-at-title'/0,
'id-at-dnQualifier'/0,
'id-at-countryName'/0,
'id-at-serialNumber'/0,
'id-at-pseudonym'/0,
'id-domainComponent'/0,
'pkcs-9'/0,
'id-emailAddress'/0,
'common-name'/0,
'teletex-common-name'/0,
'teletex-organization-name'/0,
'teletex-personal-name'/0,
'teletex-organizational-unit-names'/0,
'pds-name'/0,
'physical-delivery-country-name'/0,
'postal-code'/0,
'physical-delivery-office-name'/0,
'physical-delivery-office-number'/0,
'extension-OR-address-components'/0,
'physical-delivery-personal-name'/0,
'physical-delivery-organization-name'/0,
'extension-physical-delivery-address-components'/0,
'unformatted-postal-address'/0,
'street-address'/0,
'post-office-box-address'/0,
'poste-restante-address'/0,
'unique-postal-name'/0,
'local-postal-attributes'/0,
'extended-network-address'/0,
'terminal-type'/0,
'teletex-domain-defined-attributes'/0,
'ub-name'/0,
'ub-common-name'/0,
'ub-locality-name'/0,
'ub-state-name'/0,
'ub-organization-name'/0,
'ub-organizational-unit-name'/0,
'ub-title'/0,
'ub-serial-number'/0,
'ub-match'/0,
'ub-emailaddress-length'/0,
'ub-common-name-length'/0,
'ub-country-name-alpha-length'/0,
'ub-country-name-numeric-length'/0,
'ub-domain-defined-attributes'/0,
'ub-domain-defined-attribute-type-length'/0,
'ub-domain-defined-attribute-value-length'/0,
'ub-domain-name-length'/0,
'ub-extension-attributes'/0,
'ub-e163-4-number-length'/0,
'ub-e163-4-sub-address-length'/0,
'ub-generation-qualifier-length'/0,
'ub-given-name-length'/0,
'ub-initials-length'/0,
'ub-integer-options'/0,
'ub-numeric-user-id-length'/0,
'ub-organization-name-length'/0,
'ub-organizational-unit-name-length'/0,
'ub-organizational-units'/0,
'ub-pds-name-length'/0,
'ub-pds-parameter-length'/0,
'ub-pds-physical-address-lines'/0,
'ub-postal-code-length'/0,
'ub-pseudonym'/0,
'ub-surname-length'/0,
'ub-terminal-id-length'/0,
'ub-unformatted-address-length'/0,
'ub-x121-address-length'/0
]).

-export([info/0]).


-export([encode/2,decode/2,encode_disp/2,decode_disp/2]).

encoding_rule() ->
   ber_bin_v2.

encode(Type,Data) ->
case catch encode_disp(Type,Data) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {Bytes,_Len} ->
    {ok,Bytes};
  Bytes ->
    {ok,Bytes}
end.

decode(Type,Data) ->
case catch decode_disp(Type,element(1,?RT_BER:decode(Data))
) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  Result ->
    {ok,Result}
end.

encode_disp('Attribute',Data) -> 'enc_Attribute'(Data);
encode_disp('AttributeType',Data) -> 'enc_AttributeType'(Data);
encode_disp('AttributeValue',Data) -> 'enc_AttributeValue'(Data);
encode_disp('AttributeTypeAndValue',Data) -> 'enc_AttributeTypeAndValue'(Data);
encode_disp('X520name',Data) -> 'enc_X520name'(Data);
encode_disp('X520CommonName',Data) -> 'enc_X520CommonName'(Data);
encode_disp('X520LocalityName',Data) -> 'enc_X520LocalityName'(Data);
encode_disp('X520StateOrProvinceName',Data) -> 'enc_X520StateOrProvinceName'(Data);
encode_disp('X520OrganizationName',Data) -> 'enc_X520OrganizationName'(Data);
encode_disp('X520OrganizationalUnitName',Data) -> 'enc_X520OrganizationalUnitName'(Data);
encode_disp('X520Title',Data) -> 'enc_X520Title'(Data);
encode_disp('X520dnQualifier',Data) -> 'enc_X520dnQualifier'(Data);
encode_disp('X520countryName',Data) -> 'enc_X520countryName'(Data);
encode_disp('X520SerialNumber',Data) -> 'enc_X520SerialNumber'(Data);
encode_disp('X520Pseudonym',Data) -> 'enc_X520Pseudonym'(Data);
encode_disp('DomainComponent',Data) -> 'enc_DomainComponent'(Data);
encode_disp('EmailAddress',Data) -> 'enc_EmailAddress'(Data);
encode_disp('Name',Data) -> 'enc_Name'(Data);
encode_disp('RDNSequence',Data) -> 'enc_RDNSequence'(Data);
encode_disp('DistinguishedName',Data) -> 'enc_DistinguishedName'(Data);
encode_disp('RelativeDistinguishedName',Data) -> 'enc_RelativeDistinguishedName'(Data);
encode_disp('DirectoryString',Data) -> 'enc_DirectoryString'(Data);
encode_disp('Certificate',Data) -> 'enc_Certificate'(Data);
encode_disp('TBSCertificate',Data) -> 'enc_TBSCertificate'(Data);
encode_disp('Version',Data) -> 'enc_Version'(Data);
encode_disp('CertificateSerialNumber',Data) -> 'enc_CertificateSerialNumber'(Data);
encode_disp('Validity',Data) -> 'enc_Validity'(Data);
encode_disp('Time',Data) -> 'enc_Time'(Data);
encode_disp('UniqueIdentifier',Data) -> 'enc_UniqueIdentifier'(Data);
encode_disp('SubjectPublicKeyInfo',Data) -> 'enc_SubjectPublicKeyInfo'(Data);
encode_disp('Extensions',Data) -> 'enc_Extensions'(Data);
encode_disp('Extension',Data) -> 'enc_Extension'(Data);
encode_disp('CertificateList',Data) -> 'enc_CertificateList'(Data);
encode_disp('TBSCertList',Data) -> 'enc_TBSCertList'(Data);
encode_disp('AlgorithmIdentifier',Data) -> 'enc_AlgorithmIdentifier'(Data);
encode_disp('ORAddress',Data) -> 'enc_ORAddress'(Data);
encode_disp('BuiltInStandardAttributes',Data) -> 'enc_BuiltInStandardAttributes'(Data);
encode_disp('CountryName',Data) -> 'enc_CountryName'(Data);
encode_disp('AdministrationDomainName',Data) -> 'enc_AdministrationDomainName'(Data);
encode_disp('NetworkAddress',Data) -> 'enc_NetworkAddress'(Data);
encode_disp('X121Address',Data) -> 'enc_X121Address'(Data);
encode_disp('TerminalIdentifier',Data) -> 'enc_TerminalIdentifier'(Data);
encode_disp('PrivateDomainName',Data) -> 'enc_PrivateDomainName'(Data);
encode_disp('OrganizationName',Data) -> 'enc_OrganizationName'(Data);
encode_disp('NumericUserIdentifier',Data) -> 'enc_NumericUserIdentifier'(Data);
encode_disp('PersonalName',Data) -> 'enc_PersonalName'(Data);
encode_disp('OrganizationalUnitNames',Data) -> 'enc_OrganizationalUnitNames'(Data);
encode_disp('OrganizationalUnitName',Data) -> 'enc_OrganizationalUnitName'(Data);
encode_disp('BuiltInDomainDefinedAttributes',Data) -> 'enc_BuiltInDomainDefinedAttributes'(Data);
encode_disp('BuiltInDomainDefinedAttribute',Data) -> 'enc_BuiltInDomainDefinedAttribute'(Data);
encode_disp('ExtensionAttributes',Data) -> 'enc_ExtensionAttributes'(Data);
encode_disp('ExtensionAttribute',Data) -> 'enc_ExtensionAttribute'(Data);
encode_disp('CommonName',Data) -> 'enc_CommonName'(Data);
encode_disp('TeletexCommonName',Data) -> 'enc_TeletexCommonName'(Data);
encode_disp('TeletexOrganizationName',Data) -> 'enc_TeletexOrganizationName'(Data);
encode_disp('TeletexPersonalName',Data) -> 'enc_TeletexPersonalName'(Data);
encode_disp('TeletexOrganizationalUnitNames',Data) -> 'enc_TeletexOrganizationalUnitNames'(Data);
encode_disp('TeletexOrganizationalUnitName',Data) -> 'enc_TeletexOrganizationalUnitName'(Data);
encode_disp('PDSName',Data) -> 'enc_PDSName'(Data);
encode_disp('PhysicalDeliveryCountryName',Data) -> 'enc_PhysicalDeliveryCountryName'(Data);
encode_disp('PostalCode',Data) -> 'enc_PostalCode'(Data);
encode_disp('PhysicalDeliveryOfficeName',Data) -> 'enc_PhysicalDeliveryOfficeName'(Data);
encode_disp('PhysicalDeliveryOfficeNumber',Data) -> 'enc_PhysicalDeliveryOfficeNumber'(Data);
encode_disp('ExtensionORAddressComponents',Data) -> 'enc_ExtensionORAddressComponents'(Data);
encode_disp('PhysicalDeliveryPersonalName',Data) -> 'enc_PhysicalDeliveryPersonalName'(Data);
encode_disp('PhysicalDeliveryOrganizationName',Data) -> 'enc_PhysicalDeliveryOrganizationName'(Data);
encode_disp('ExtensionPhysicalDeliveryAddressComponents',Data) -> 'enc_ExtensionPhysicalDeliveryAddressComponents'(Data);
encode_disp('UnformattedPostalAddress',Data) -> 'enc_UnformattedPostalAddress'(Data);
encode_disp('StreetAddress',Data) -> 'enc_StreetAddress'(Data);
encode_disp('PostOfficeBoxAddress',Data) -> 'enc_PostOfficeBoxAddress'(Data);
encode_disp('PosteRestanteAddress',Data) -> 'enc_PosteRestanteAddress'(Data);
encode_disp('UniquePostalName',Data) -> 'enc_UniquePostalName'(Data);
encode_disp('LocalPostalAttributes',Data) -> 'enc_LocalPostalAttributes'(Data);
encode_disp('PDSParameter',Data) -> 'enc_PDSParameter'(Data);
encode_disp('ExtendedNetworkAddress',Data) -> 'enc_ExtendedNetworkAddress'(Data);
encode_disp('PresentationAddress',Data) -> 'enc_PresentationAddress'(Data);
encode_disp('TerminalType',Data) -> 'enc_TerminalType'(Data);
encode_disp('TeletexDomainDefinedAttributes',Data) -> 'enc_TeletexDomainDefinedAttributes'(Data);
encode_disp('TeletexDomainDefinedAttribute',Data) -> 'enc_TeletexDomainDefinedAttribute'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('Attribute',Data) -> 'dec_Attribute'(Data);
decode_disp('AttributeType',Data) -> 'dec_AttributeType'(Data);
decode_disp('AttributeValue',Data) -> 'dec_AttributeValue'(Data);
decode_disp('AttributeTypeAndValue',Data) -> 'dec_AttributeTypeAndValue'(Data);
decode_disp('X520name',Data) -> 'dec_X520name'(Data);
decode_disp('X520CommonName',Data) -> 'dec_X520CommonName'(Data);
decode_disp('X520LocalityName',Data) -> 'dec_X520LocalityName'(Data);
decode_disp('X520StateOrProvinceName',Data) -> 'dec_X520StateOrProvinceName'(Data);
decode_disp('X520OrganizationName',Data) -> 'dec_X520OrganizationName'(Data);
decode_disp('X520OrganizationalUnitName',Data) -> 'dec_X520OrganizationalUnitName'(Data);
decode_disp('X520Title',Data) -> 'dec_X520Title'(Data);
decode_disp('X520dnQualifier',Data) -> 'dec_X520dnQualifier'(Data);
decode_disp('X520countryName',Data) -> 'dec_X520countryName'(Data);
decode_disp('X520SerialNumber',Data) -> 'dec_X520SerialNumber'(Data);
decode_disp('X520Pseudonym',Data) -> 'dec_X520Pseudonym'(Data);
decode_disp('DomainComponent',Data) -> 'dec_DomainComponent'(Data);
decode_disp('EmailAddress',Data) -> 'dec_EmailAddress'(Data);
decode_disp('Name',Data) -> 'dec_Name'(Data);
decode_disp('RDNSequence',Data) -> 'dec_RDNSequence'(Data);
decode_disp('DistinguishedName',Data) -> 'dec_DistinguishedName'(Data);
decode_disp('RelativeDistinguishedName',Data) -> 'dec_RelativeDistinguishedName'(Data);
decode_disp('DirectoryString',Data) -> 'dec_DirectoryString'(Data);
decode_disp('Certificate',Data) -> 'dec_Certificate'(Data);
decode_disp('TBSCertificate',Data) -> 'dec_TBSCertificate'(Data);
decode_disp('Version',Data) -> 'dec_Version'(Data);
decode_disp('CertificateSerialNumber',Data) -> 'dec_CertificateSerialNumber'(Data);
decode_disp('Validity',Data) -> 'dec_Validity'(Data);
decode_disp('Time',Data) -> 'dec_Time'(Data);
decode_disp('UniqueIdentifier',Data) -> 'dec_UniqueIdentifier'(Data);
decode_disp('SubjectPublicKeyInfo',Data) -> 'dec_SubjectPublicKeyInfo'(Data);
decode_disp('Extensions',Data) -> 'dec_Extensions'(Data);
decode_disp('Extension',Data) -> 'dec_Extension'(Data);
decode_disp('CertificateList',Data) -> 'dec_CertificateList'(Data);
decode_disp('TBSCertList',Data) -> 'dec_TBSCertList'(Data);
decode_disp('AlgorithmIdentifier',Data) -> 'dec_AlgorithmIdentifier'(Data);
decode_disp('ORAddress',Data) -> 'dec_ORAddress'(Data);
decode_disp('BuiltInStandardAttributes',Data) -> 'dec_BuiltInStandardAttributes'(Data);
decode_disp('CountryName',Data) -> 'dec_CountryName'(Data);
decode_disp('AdministrationDomainName',Data) -> 'dec_AdministrationDomainName'(Data);
decode_disp('NetworkAddress',Data) -> 'dec_NetworkAddress'(Data);
decode_disp('X121Address',Data) -> 'dec_X121Address'(Data);
decode_disp('TerminalIdentifier',Data) -> 'dec_TerminalIdentifier'(Data);
decode_disp('PrivateDomainName',Data) -> 'dec_PrivateDomainName'(Data);
decode_disp('OrganizationName',Data) -> 'dec_OrganizationName'(Data);
decode_disp('NumericUserIdentifier',Data) -> 'dec_NumericUserIdentifier'(Data);
decode_disp('PersonalName',Data) -> 'dec_PersonalName'(Data);
decode_disp('OrganizationalUnitNames',Data) -> 'dec_OrganizationalUnitNames'(Data);
decode_disp('OrganizationalUnitName',Data) -> 'dec_OrganizationalUnitName'(Data);
decode_disp('BuiltInDomainDefinedAttributes',Data) -> 'dec_BuiltInDomainDefinedAttributes'(Data);
decode_disp('BuiltInDomainDefinedAttribute',Data) -> 'dec_BuiltInDomainDefinedAttribute'(Data);
decode_disp('ExtensionAttributes',Data) -> 'dec_ExtensionAttributes'(Data);
decode_disp('ExtensionAttribute',Data) -> 'dec_ExtensionAttribute'(Data);
decode_disp('CommonName',Data) -> 'dec_CommonName'(Data);
decode_disp('TeletexCommonName',Data) -> 'dec_TeletexCommonName'(Data);
decode_disp('TeletexOrganizationName',Data) -> 'dec_TeletexOrganizationName'(Data);
decode_disp('TeletexPersonalName',Data) -> 'dec_TeletexPersonalName'(Data);
decode_disp('TeletexOrganizationalUnitNames',Data) -> 'dec_TeletexOrganizationalUnitNames'(Data);
decode_disp('TeletexOrganizationalUnitName',Data) -> 'dec_TeletexOrganizationalUnitName'(Data);
decode_disp('PDSName',Data) -> 'dec_PDSName'(Data);
decode_disp('PhysicalDeliveryCountryName',Data) -> 'dec_PhysicalDeliveryCountryName'(Data);
decode_disp('PostalCode',Data) -> 'dec_PostalCode'(Data);
decode_disp('PhysicalDeliveryOfficeName',Data) -> 'dec_PhysicalDeliveryOfficeName'(Data);
decode_disp('PhysicalDeliveryOfficeNumber',Data) -> 'dec_PhysicalDeliveryOfficeNumber'(Data);
decode_disp('ExtensionORAddressComponents',Data) -> 'dec_ExtensionORAddressComponents'(Data);
decode_disp('PhysicalDeliveryPersonalName',Data) -> 'dec_PhysicalDeliveryPersonalName'(Data);
decode_disp('PhysicalDeliveryOrganizationName',Data) -> 'dec_PhysicalDeliveryOrganizationName'(Data);
decode_disp('ExtensionPhysicalDeliveryAddressComponents',Data) -> 'dec_ExtensionPhysicalDeliveryAddressComponents'(Data);
decode_disp('UnformattedPostalAddress',Data) -> 'dec_UnformattedPostalAddress'(Data);
decode_disp('StreetAddress',Data) -> 'dec_StreetAddress'(Data);
decode_disp('PostOfficeBoxAddress',Data) -> 'dec_PostOfficeBoxAddress'(Data);
decode_disp('PosteRestanteAddress',Data) -> 'dec_PosteRestanteAddress'(Data);
decode_disp('UniquePostalName',Data) -> 'dec_UniquePostalName'(Data);
decode_disp('LocalPostalAttributes',Data) -> 'dec_LocalPostalAttributes'(Data);
decode_disp('PDSParameter',Data) -> 'dec_PDSParameter'(Data);
decode_disp('ExtendedNetworkAddress',Data) -> 'dec_ExtendedNetworkAddress'(Data);
decode_disp('PresentationAddress',Data) -> 'dec_PresentationAddress'(Data);
decode_disp('TerminalType',Data) -> 'dec_TerminalType'(Data);
decode_disp('TeletexDomainDefinedAttributes',Data) -> 'dec_TeletexDomainDefinedAttributes'(Data);
decode_disp('TeletexDomainDefinedAttribute',Data) -> 'dec_TeletexDomainDefinedAttribute'(Data);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).





info() ->
   case ?MODULE:module_info() of
      MI when is_list(MI) ->
         case lists:keysearch(attributes,1,MI) of
            {value,{_,Attributes}} when is_list(Attributes) ->
               case lists:keysearch(asn1_info,1,Attributes) of
                  {value,{_,Info}} when is_list(Info) ->
                     Info;
                  _ ->
                     []
               end;
            _ ->
               []
         end
   end.


%%================================
%%  Attribute
%%================================
'enc_Attribute'(Val) ->
    'enc_Attribute'(Val, [<<48>>]).

'enc_Attribute'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Attribute_values'(Cindex2, [<<49>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Attribute_values
%%================================

'enc_Attribute_values'({'Attribute_values',Val}, TagIn) ->
   'enc_Attribute_values'(Val, TagIn);

'enc_Attribute_values'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Attribute_values_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_Attribute_values_components'([], AccBytes, AccLen) -> 
   {asn1rt_check:dynamicsort_SETOF(AccBytes),AccLen};

'enc_Attribute_values_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeValue'(H, []),
   'enc_Attribute_values_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_Attribute_values'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_AttributeValue'(V1, []) || V1 <- Tlv1].




'dec_Attribute'(Tlv) ->
   'dec_Attribute'(Tlv, [16]).

'dec_Attribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Attribute_values'(V2, [17]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'Attribute', Term1, Term2}.



%%================================
%%  AttributeType
%%================================
'enc_AttributeType'(Val) ->
    'enc_AttributeType'(Val, [<<6>>]).


'enc_AttributeType'({'AttributeType',Val}, TagIn) ->
   'enc_AttributeType'(Val, TagIn);

'enc_AttributeType'(Val, TagIn) ->
?RT_BER:encode_object_identifier(Val, TagIn).


'dec_AttributeType'(Tlv) ->
   'dec_AttributeType'(Tlv, [6]).

'dec_AttributeType'(Tlv, TagIn) ->
?RT_BER:decode_object_identifier(Tlv,TagIn).



%%================================
%%  AttributeValue
%%================================
'enc_AttributeValue'(Val) ->
    'enc_AttributeValue'(Val, []).


'enc_AttributeValue'({'AttributeValue',Val}, TagIn) ->
   'enc_AttributeValue'(Val, TagIn);

'enc_AttributeValue'(Val, TagIn) ->
%% OPEN TYPE
?RT_BER:encode_open_type(Val, TagIn).


'dec_AttributeValue'(Tlv) ->
   'dec_AttributeValue'(Tlv, []).

'dec_AttributeValue'(Tlv, TagIn) ->
?RT_BER:decode_open_type_as_binary(Tlv,TagIn).



%%================================
%%  AttributeTypeAndValue
%%================================
'enc_AttributeTypeAndValue'(Val) ->
    'enc_AttributeTypeAndValue'(Val, [<<48>>]).

'enc_AttributeTypeAndValue'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2)   External PKIX1Explicit88:AttributeValue
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeValue'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AttributeTypeAndValue'(Tlv) ->
   'dec_AttributeTypeAndValue'(Tlv, [16]).

'dec_AttributeTypeAndValue'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute value(2)   External PKIX1Explicit88:AttributeValue
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeValue'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'AttributeTypeAndValue', Term1, Term2}.



%%================================
%%  X520name
%%================================
'enc_X520name'(Val) ->
    'enc_X520name'(Val, []).


'enc_X520name'({'X520name',Val}, TagIn) ->
   'enc_X520name'(Val, TagIn);

'enc_X520name'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_X520name'(Tlv) ->
   'dec_X520name'(Tlv, []).

'dec_X520name'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,32768},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,32768},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,32768},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,32768},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520CommonName
%%================================
'enc_X520CommonName'(Val) ->
    'enc_X520CommonName'(Val, []).


'enc_X520CommonName'({'X520CommonName',Val}, TagIn) ->
   'enc_X520CommonName'(Val, TagIn);

'enc_X520CommonName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_X520CommonName'(Tlv) ->
   'dec_X520CommonName'(Tlv, []).

'dec_X520CommonName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,64},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,64},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,64},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,64},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520LocalityName
%%================================
'enc_X520LocalityName'(Val) ->
    'enc_X520LocalityName'(Val, []).


'enc_X520LocalityName'({'X520LocalityName',Val}, TagIn) ->
   'enc_X520LocalityName'(Val, TagIn);

'enc_X520LocalityName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_X520LocalityName'(Tlv) ->
   'dec_X520LocalityName'(Tlv, []).

'dec_X520LocalityName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,128},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,128},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,128},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,128},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520StateOrProvinceName
%%================================
'enc_X520StateOrProvinceName'(Val) ->
    'enc_X520StateOrProvinceName'(Val, []).


'enc_X520StateOrProvinceName'({'X520StateOrProvinceName',Val}, TagIn) ->
   'enc_X520StateOrProvinceName'(Val, TagIn);

'enc_X520StateOrProvinceName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_X520StateOrProvinceName'(Tlv) ->
   'dec_X520StateOrProvinceName'(Tlv, []).

'dec_X520StateOrProvinceName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,128},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,128},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,128},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,128},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520OrganizationName
%%================================
'enc_X520OrganizationName'(Val) ->
    'enc_X520OrganizationName'(Val, []).


'enc_X520OrganizationName'({'X520OrganizationName',Val}, TagIn) ->
   'enc_X520OrganizationName'(Val, TagIn);

'enc_X520OrganizationName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_X520OrganizationName'(Tlv) ->
   'dec_X520OrganizationName'(Tlv, []).

'dec_X520OrganizationName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,64},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,64},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,64},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,64},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520OrganizationalUnitName
%%================================
'enc_X520OrganizationalUnitName'(Val) ->
    'enc_X520OrganizationalUnitName'(Val, []).


'enc_X520OrganizationalUnitName'({'X520OrganizationalUnitName',Val}, TagIn) ->
   'enc_X520OrganizationalUnitName'(Val, TagIn);

'enc_X520OrganizationalUnitName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_X520OrganizationalUnitName'(Tlv) ->
   'dec_X520OrganizationalUnitName'(Tlv, []).

'dec_X520OrganizationalUnitName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,64},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,64},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,64},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,64},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520Title
%%================================
'enc_X520Title'(Val) ->
    'enc_X520Title'(Val, []).


'enc_X520Title'({'X520Title',Val}, TagIn) ->
   'enc_X520Title'(Val, TagIn);

'enc_X520Title'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_X520Title'(Tlv) ->
   'dec_X520Title'(Tlv, []).

'dec_X520Title'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,64},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,64},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,64},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,64},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  X520dnQualifier
%%================================
'enc_X520dnQualifier'(Val) ->
    'enc_X520dnQualifier'(Val, [<<19>>]).


'enc_X520dnQualifier'({'X520dnQualifier',Val}, TagIn) ->
   'enc_X520dnQualifier'(Val, TagIn);

'enc_X520dnQualifier'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 19, TagIn).


'dec_X520dnQualifier'(Tlv) ->
   'dec_X520dnQualifier'(Tlv, [19]).

'dec_X520dnQualifier'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,[],19,TagIn).



%%================================
%%  X520countryName
%%================================
'enc_X520countryName'(Val) ->
    'enc_X520countryName'(Val, [<<19>>]).


'enc_X520countryName'({'X520countryName',Val}, TagIn) ->
   'enc_X520countryName'(Val, TagIn);

'enc_X520countryName'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 19, TagIn).


'dec_X520countryName'(Tlv) ->
   'dec_X520countryName'(Tlv, [19]).

'dec_X520countryName'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,2,19,TagIn).



%%================================
%%  X520SerialNumber
%%================================
'enc_X520SerialNumber'(Val) ->
    'enc_X520SerialNumber'(Val, [<<19>>]).


'enc_X520SerialNumber'({'X520SerialNumber',Val}, TagIn) ->
   'enc_X520SerialNumber'(Val, TagIn);

'enc_X520SerialNumber'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 19, TagIn).


'dec_X520SerialNumber'(Tlv) ->
   'dec_X520SerialNumber'(Tlv, [19]).

'dec_X520SerialNumber'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,64},19,TagIn).



%%================================
%%  X520Pseudonym
%%================================
'enc_X520Pseudonym'(Val) ->
    'enc_X520Pseudonym'(Val, []).


'enc_X520Pseudonym'({'X520Pseudonym',Val}, TagIn) ->
   'enc_X520Pseudonym'(Val, TagIn);

'enc_X520Pseudonym'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_X520Pseudonym'(Tlv) ->
   'dec_X520Pseudonym'(Tlv, []).

'dec_X520Pseudonym'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,128},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,128},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,128},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,128},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  DomainComponent
%%================================
'enc_DomainComponent'(Val) ->
    'enc_DomainComponent'(Val, [<<22>>]).


'enc_DomainComponent'({'DomainComponent',Val}, TagIn) ->
   'enc_DomainComponent'(Val, TagIn);

'enc_DomainComponent'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 22, TagIn).


'dec_DomainComponent'(Tlv) ->
   'dec_DomainComponent'(Tlv, [22]).

'dec_DomainComponent'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,[],22,TagIn).



%%================================
%%  EmailAddress
%%================================
'enc_EmailAddress'(Val) ->
    'enc_EmailAddress'(Val, [<<22>>]).


'enc_EmailAddress'({'EmailAddress',Val}, TagIn) ->
   'enc_EmailAddress'(Val, TagIn);

'enc_EmailAddress'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 22, TagIn).


'dec_EmailAddress'(Tlv) ->
   'dec_EmailAddress'(Tlv, [22]).

'dec_EmailAddress'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,128},22,TagIn).



%%================================
%%  Name
%%================================
'enc_Name'(Val) ->
    'enc_Name'(Val, []).


'enc_Name'({'Name',Val}, TagIn) ->
   'enc_Name'(Val, TagIn);

'enc_Name'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      rdnSequence ->
         'enc_RDNSequence'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_Name'(Tlv) ->
   'dec_Name'(Tlv, []).

'dec_Name'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'rdnSequence'
    {16, V1} -> 
        {rdnSequence, 'dec_RDNSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  RDNSequence
%%================================
'enc_RDNSequence'(Val) ->
    'enc_RDNSequence'(Val, [<<48>>]).


'enc_RDNSequence'({'RDNSequence',Val}, TagIn) ->
   'enc_RDNSequence'(Val, TagIn);

'enc_RDNSequence'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RDNSequence_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_RDNSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RDNSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RelativeDistinguishedName'(H, [<<49>>]),
   'enc_RDNSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_RDNSequence'(Tlv) ->
   'dec_RDNSequence'(Tlv, [16]).

'dec_RDNSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_RelativeDistinguishedName'(V1, [17]) || V1 <- Tlv1].




%%================================
%%  DistinguishedName
%%================================
'enc_DistinguishedName'(Val) ->
    'enc_DistinguishedName'(Val, [<<48>>]).


'enc_DistinguishedName'({'DistinguishedName',Val}, TagIn) ->
   'enc_DistinguishedName'(Val, TagIn);

'enc_DistinguishedName'(Val, TagIn) ->
   'enc_RDNSequence'(Val, TagIn).


'dec_DistinguishedName'(Tlv) ->
   'dec_DistinguishedName'(Tlv, [16]).

'dec_DistinguishedName'(Tlv, TagIn) ->
'dec_RDNSequence'(Tlv, TagIn).



%%================================
%%  RelativeDistinguishedName
%%================================
'enc_RelativeDistinguishedName'(Val) ->
    'enc_RelativeDistinguishedName'(Val, [<<49>>]).


'enc_RelativeDistinguishedName'({'RelativeDistinguishedName',Val}, TagIn) ->
   'enc_RelativeDistinguishedName'(Val, TagIn);

'enc_RelativeDistinguishedName'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RelativeDistinguishedName_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_RelativeDistinguishedName_components'([], AccBytes, AccLen) -> 
   {asn1rt_check:dynamicsort_SETOF(AccBytes),AccLen};

'enc_RelativeDistinguishedName_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeTypeAndValue'(H, [<<48>>]),
   'enc_RelativeDistinguishedName_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_RelativeDistinguishedName'(Tlv) ->
   'dec_RelativeDistinguishedName'(Tlv, [17]).

'dec_RelativeDistinguishedName'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_AttributeTypeAndValue'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  DirectoryString
%%================================
'enc_DirectoryString'(Val) ->
    'enc_DirectoryString'(Val, []).


'enc_DirectoryString'({'DirectoryString',Val}, TagIn) ->
   'enc_DirectoryString'(Val, TagIn);

'enc_DirectoryString'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 20, [<<20>>]);
      printableString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      universalString ->
         ?RT_BER:encode_universal_string([], element(2,Val), [<<28>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_DirectoryString'(Tlv) ->
   'dec_DirectoryString'(Tlv, []).

'dec_DirectoryString'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, ?RT_BER:decode_restricted_string(V1,{1,'MAX'},20,[])};


%% 'printableString'
    {19, V1} -> 
        {printableString, ?RT_BER:decode_restricted_string(V1,{1,'MAX'},19,[])};


%% 'universalString'
    {28, V1} -> 
        {universalString, ?RT_BER:decode_universal_string(V1,{1,'MAX'},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,'MAX'},[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  Certificate
%%================================
'enc_Certificate'(Val) ->
    'enc_Certificate'(Val, [<<48>>]).

'enc_Certificate'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External PKIX1Explicit88:TBSCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSCertificate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_bit_string([], Cindex3, [], [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Certificate'(Tlv) ->
   'dec_Certificate'(Tlv, [16]).

'dec_Certificate'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External PKIX1Explicit88:TBSCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSCertificate'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = ?RT_BER:decode_compact_bit_string(V3,[],[],[3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'Certificate', Term1, Term2, Term3}.



%%================================
%%  TBSCertificate
%%================================
'enc_TBSCertificate'(Val) ->
    'enc_TBSCertificate'(Val, [<<48>>]).

'enc_TBSCertificate'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6, Cindex7, Cindex8, Cindex9, Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case catch asn1rt_check:check_int(0, Cindex1, [{v1,0},{v2,1},{v3,2}]) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_integer([], Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_integer([], Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute signature(3)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(4)   External PKIX1Explicit88:Name
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_Name'(Cindex4, []),

%%-------------------------------------------------
%% attribute validity(5)   External PKIX1Explicit88:Validity
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'enc_Validity'(Cindex5, [<<48>>]),

%%-------------------------------------------------
%% attribute subject(6)   External PKIX1Explicit88:Name
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_Name'(Cindex6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External PKIX1Explicit88:SubjectPublicKeyInfo
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_SubjectPublicKeyInfo'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex8, [], [<<129>>])
       end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex9, [], [<<130>>])
       end,

%%-------------------------------------------------
%% attribute extensions(10)   External PKIX1Explicit88:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex10, [<<48>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TBSCertificate'(Tlv) ->
   'dec_TBSCertificate'(Tlv, [16]).

'dec_TBSCertificate'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {?RT_BER:decode_integer(V1,[],[{v1,0},{v2,1},{v3,2}],[2]), TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_integer(V2,[],[2]),

%%-------------------------------------------------
%% attribute signature(3)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_AlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute issuer(4)   External PKIX1Explicit88:Name
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_Name'(V4, []),

%%-------------------------------------------------
%% attribute validity(5)   External PKIX1Explicit88:Validity
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'dec_Validity'(V5, [16]),

%%-------------------------------------------------
%% attribute subject(6)   External PKIX1Explicit88:Name
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_Name'(V6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External PKIX1Explicit88:SubjectPublicKeyInfo
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_SubjectPublicKeyInfo'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131073,V8}|TempTlv9] ->
    {?RT_BER:decode_compact_bit_string(V8,[],[],[]), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131074,V9}|TempTlv10] ->
    {?RT_BER:decode_compact_bit_string(V9,[],[],[]), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute extensions(10)   External PKIX1Explicit88:Extensions OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131075,V10}|TempTlv11] ->
    {'dec_Extensions'(V10, [16]), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

case Tlv11 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv11}}}) % extra fields not allowed
end,
   {'TBSCertificate', Term1, Term2, Term3, Term4, Term5, Term6, Term7, Term8, Term9, Term10}.



%%================================
%%  Version
%%================================
'enc_Version'(Val) ->
    'enc_Version'(Val, [<<2>>]).


'enc_Version'({'Version',Val}, TagIn) ->
   'enc_Version'(Val, TagIn);

'enc_Version'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, [{v1,0},{v2,1},{v3,2}], TagIn).


'dec_Version'(Tlv) ->
   'dec_Version'(Tlv, [2]).

'dec_Version'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,[],[{v1,0},{v2,1},{v3,2}],TagIn).



%%================================
%%  CertificateSerialNumber
%%================================
'enc_CertificateSerialNumber'(Val) ->
    'enc_CertificateSerialNumber'(Val, [<<2>>]).


'enc_CertificateSerialNumber'({'CertificateSerialNumber',Val}, TagIn) ->
   'enc_CertificateSerialNumber'(Val, TagIn);

'enc_CertificateSerialNumber'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn).


'dec_CertificateSerialNumber'(Tlv) ->
   'dec_CertificateSerialNumber'(Tlv, [2]).

'dec_CertificateSerialNumber'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,[],TagIn).



%%================================
%%  Validity
%%================================
'enc_Validity'(Val) ->
    'enc_Validity'(Val, [<<48>>]).

'enc_Validity'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBefore(1)   External PKIX1Explicit88:Time
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_Time'(Cindex1, []),

%%-------------------------------------------------
%% attribute notAfter(2)   External PKIX1Explicit88:Time
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Time'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Validity'(Tlv) ->
   'dec_Validity'(Tlv, [16]).

'dec_Validity'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute notBefore(1)   External PKIX1Explicit88:Time
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_Time'(V1, []),

%%-------------------------------------------------
%% attribute notAfter(2)   External PKIX1Explicit88:Time
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Time'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'Validity', Term1, Term2}.



%%================================
%%  Time
%%================================
'enc_Time'(Val) ->
    'enc_Time'(Val, []).


'enc_Time'({'Time',Val}, TagIn) ->
   'enc_Time'(Val, TagIn);

'enc_Time'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      utcTime ->
         ?RT_BER:encode_utc_time([], element(2,Val), [<<23>>]);
      generalTime ->
         ?RT_BER:encode_generalized_time([], element(2,Val), [<<24>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_Time'(Tlv) ->
   'dec_Time'(Tlv, []).

'dec_Time'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'utcTime'
    {23, V1} -> 
        {utcTime, ?RT_BER:decode_utc_time(V1,[],[])};


%% 'generalTime'
    {24, V1} -> 
        {generalTime, ?RT_BER:decode_generalized_time(V1,[],[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  UniqueIdentifier
%%================================
'enc_UniqueIdentifier'(Val) ->
    'enc_UniqueIdentifier'(Val, [<<3>>]).


'enc_UniqueIdentifier'({'UniqueIdentifier',Val}, TagIn) ->
   'enc_UniqueIdentifier'(Val, TagIn);

'enc_UniqueIdentifier'(Val, TagIn) ->
?RT_BER:encode_bit_string([], Val, [], TagIn).


'dec_UniqueIdentifier'(Tlv) ->
   'dec_UniqueIdentifier'(Tlv, [3]).

'dec_UniqueIdentifier'(Tlv, TagIn) ->
?RT_BER:decode_compact_bit_string(Tlv,[],[],TagIn).



%%================================
%%  SubjectPublicKeyInfo
%%================================
'enc_SubjectPublicKeyInfo'(Val) ->
    'enc_SubjectPublicKeyInfo'(Val, [<<48>>]).

'enc_SubjectPublicKeyInfo'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AlgorithmIdentifier'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_bit_string([], Cindex2, [], [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SubjectPublicKeyInfo'(Tlv) ->
   'dec_SubjectPublicKeyInfo'(Tlv, [16]).

'dec_SubjectPublicKeyInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute algorithm(1)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AlgorithmIdentifier'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_compact_bit_string(V2,[],[],[3]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'SubjectPublicKeyInfo', Term1, Term2}.



%%================================
%%  Extensions
%%================================
'enc_Extensions'(Val) ->
    'enc_Extensions'(Val, [<<48>>]).


'enc_Extensions'({'Extensions',Val}, TagIn) ->
   'enc_Extensions'(Val, TagIn);

'enc_Extensions'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Extensions_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_Extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Extension'(H, [<<48>>]),
   'enc_Extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_Extensions'(Tlv) ->
   'dec_Extensions'(Tlv, [16]).

'dec_Extensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_Extension'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  Extension
%%================================
'enc_Extension'(Val) ->
    'enc_Extension'(Val, [<<48>>]).

'enc_Extension'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case catch asn1rt_check:check_bool(false, Cindex2) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_octet_string([], Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Extension'(Tlv) ->
   'dec_Extension'(Tlv, [16]).

'dec_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {?RT_BER:decode_boolean(V2,[]), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = ?RT_BER:decode_octet_string(V3,[],[4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'Extension', Term1, Term2, Term3}.



%%================================
%%  CertificateList
%%================================
'enc_CertificateList'(Val) ->
    'enc_CertificateList'(Val, [<<48>>]).

'enc_CertificateList'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute tbsCertList(1)   External PKIX1Explicit88:TBSCertList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSCertList'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_bit_string([], Cindex3, [], [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_CertificateList'(Tlv) ->
   'dec_CertificateList'(Tlv, [16]).

'dec_CertificateList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute tbsCertList(1)   External PKIX1Explicit88:TBSCertList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSCertList'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = ?RT_BER:decode_compact_bit_string(V3,[],[],[3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'CertificateList', Term1, Term2, Term3}.



%%================================
%%  TBSCertList
%%================================
'enc_TBSCertList'(Val) ->
    'enc_TBSCertList'(Val, [<<48>>]).

'enc_TBSCertList'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6, Cindex7} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_integer([], Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>])
       end,

%%-------------------------------------------------
%% attribute signature(2)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIX1Explicit88:Name
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_Name'(Cindex3, []),

%%-------------------------------------------------
%% attribute thisUpdate(4)   External PKIX1Explicit88:Time
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_Time'(Cindex4, []),

%%-------------------------------------------------
%% attribute nextUpdate(5)   External PKIX1Explicit88:Time OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Time'(Cindex5, [])
       end,

%%-------------------------------------------------
%% attribute revokedCertificates(6) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TBSCertList_revokedCertificates'(Cindex6, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute crlExtensions(7)   External PKIX1Explicit88:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex7, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSCertList_revokedCertificates
%%================================

'enc_TBSCertList_revokedCertificates'({'TBSCertList_revokedCertificates',Val}, TagIn) ->
   'enc_TBSCertList_revokedCertificates'(Val, TagIn);

'enc_TBSCertList_revokedCertificates'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSCertList_revokedCertificates_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSCertList_revokedCertificates_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSCertList_revokedCertificates_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TBSCertList_revokedCertificates_SEQOF'(H, [<<48>>]),
   'enc_TBSCertList_revokedCertificates_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  TBSCertList_revokedCertificates_SEQOF
%%================================
'enc_TBSCertList_revokedCertificates_SEQOF'(Val, TagIn) ->
   {_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute userCertificate(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_integer([], Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute revocationDate(2)   External PKIX1Explicit88:Time
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Time'(Cindex2, []),

%%-------------------------------------------------
%% attribute crlEntryExtensions(3)   External PKIX1Explicit88:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).
'dec_TBSCertList_revokedCertificates_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute userCertificate(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_integer(V1,[],[2]),

%%-------------------------------------------------
%% attribute revocationDate(2)   External PKIX1Explicit88:Time
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Time'(V2, []),

%%-------------------------------------------------
%% attribute crlEntryExtensions(3)   External PKIX1Explicit88:Extensions OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_Extensions'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'TBSCertList_revokedCertificates_SEQOF', Term1, Term2, Term3}.

'dec_TBSCertList_revokedCertificates'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_TBSCertList_revokedCertificates_SEQOF'(V1, [16]) || V1 <- Tlv1].




'dec_TBSCertList'(Tlv) ->
   'dec_TBSCertList'(Tlv, [16]).

'dec_TBSCertList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute version(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{2,V1}|TempTlv2] ->
    {?RT_BER:decode_integer(V1,[],[{v1,0},{v2,1},{v3,2}],[]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute signature(2)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIX1Explicit88:Name
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_Name'(V3, []),

%%-------------------------------------------------
%% attribute thisUpdate(4)   External PKIX1Explicit88:Time
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_Time'(V4, []),

%%-------------------------------------------------
%% attribute nextUpdate(5)   External PKIX1Explicit88:Time OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[V5 = {23,_}|TempTlv6] ->
    {'dec_Time'(V5, []), TempTlv6};
[V5 = {24,_}|TempTlv6] ->
    {'dec_Time'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute revokedCertificates(6) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{16,V6}|TempTlv7] ->
    {'dec_TBSCertList_revokedCertificates'(V6, []), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute crlExtensions(7)   External PKIX1Explicit88:Extensions OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131072,V7}|TempTlv8] ->
    {'dec_Extensions'(V7, [16]), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

case Tlv8 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv8}}}) % extra fields not allowed
end,
   {'TBSCertList', Term1, Term2, Term3, Term4, Term5, Term6, Term7}.



%%================================
%%  AlgorithmIdentifier
%%================================
'enc_AlgorithmIdentifier'(Val) ->
    'enc_AlgorithmIdentifier'(Val, [<<48>>]).

'enc_AlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_open_type(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AlgorithmIdentifier'(Tlv) ->
   'dec_AlgorithmIdentifier'(Tlv, [16]).

'dec_AlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {?RT_BER:decode_open_type_as_binary(V2,[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'AlgorithmIdentifier', Term1, Term2}.



%%================================
%%  ORAddress
%%================================
'enc_ORAddress'(Val) ->
    'enc_ORAddress'(Val, [<<48>>]).

'enc_ORAddress'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute built-in-standard-attributes(1)   External PKIX1Explicit88:BuiltInStandardAttributes
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_BuiltInStandardAttributes'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute built-in-domain-defined-attributes(2)   External PKIX1Explicit88:BuiltInDomainDefinedAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_BuiltInDomainDefinedAttributes'(Cindex2, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute extension-attributes(3)   External PKIX1Explicit88:ExtensionAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ExtensionAttributes'(Cindex3, [<<49>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ORAddress'(Tlv) ->
   'dec_ORAddress'(Tlv, [16]).

'dec_ORAddress'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute built-in-standard-attributes(1)   External PKIX1Explicit88:BuiltInStandardAttributes
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_BuiltInStandardAttributes'(V1, [16]),

%%-------------------------------------------------
%% attribute built-in-domain-defined-attributes(2)   External PKIX1Explicit88:BuiltInDomainDefinedAttributes OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_BuiltInDomainDefinedAttributes'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute extension-attributes(3)   External PKIX1Explicit88:ExtensionAttributes OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{17,V3}|TempTlv4] ->
    {'dec_ExtensionAttributes'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'ORAddress', Term1, Term2, Term3}.



%%================================
%%  BuiltInStandardAttributes
%%================================
'enc_BuiltInStandardAttributes'(Val) ->
    'enc_BuiltInStandardAttributes'(Val, [<<48>>]).

'enc_BuiltInStandardAttributes'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6, Cindex7, Cindex8, Cindex9} = Val,

%%-------------------------------------------------
%% attribute country-name(1)   External PKIX1Explicit88:CountryName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CountryName'(Cindex1, [<<97>>])
       end,

%%-------------------------------------------------
%% attribute administration-domain-name(2)   External PKIX1Explicit88:AdministrationDomainName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AdministrationDomainName'(Cindex2, [<<98>>])
       end,

%%-------------------------------------------------
%% attribute network-address(3) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex3, 18, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute terminal-identifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex4, 19, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute private-domain-name(5)   External PKIX1Explicit88:PrivateDomainName OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PrivateDomainName'(Cindex5, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute organization-name(6) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex6, 19, [<<131>>])
       end,

%%-------------------------------------------------
%% attribute numeric-user-identifier(7) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex7, 18, [<<132>>])
       end,

%%-------------------------------------------------
%% attribute personal-name(8)   External PKIX1Explicit88:PersonalName OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PersonalName'(Cindex8, [<<165>>])
       end,

%%-------------------------------------------------
%% attribute organizational-unit-names(9)   External PKIX1Explicit88:OrganizationalUnitNames OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OrganizationalUnitNames'(Cindex9, [<<166>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_BuiltInStandardAttributes'(Tlv) ->
   'dec_BuiltInStandardAttributes'(Tlv, [16]).

'dec_BuiltInStandardAttributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute country-name(1)   External PKIX1Explicit88:CountryName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{65537,V1}|TempTlv2] ->
    {'dec_CountryName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute administration-domain-name(2)   External PKIX1Explicit88:AdministrationDomainName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{65538,V2}|TempTlv3] ->
    {'dec_AdministrationDomainName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute network-address(3) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {?RT_BER:decode_restricted_string(V3,{1,16},18,[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute terminal-identifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131073,V4}|TempTlv5] ->
    {?RT_BER:decode_restricted_string(V4,{1,24},19,[]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute private-domain-name(5)   External PKIX1Explicit88:PrivateDomainName OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131074,V5}|TempTlv6] ->
    {'dec_PrivateDomainName'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute organization-name(6) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131075,V6}|TempTlv7] ->
    {?RT_BER:decode_restricted_string(V6,{1,64},19,[]), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute numeric-user-identifier(7) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131076,V7}|TempTlv8] ->
    {?RT_BER:decode_restricted_string(V7,{1,32},18,[]), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

%%-------------------------------------------------
%% attribute personal-name(8)   External PKIX1Explicit88:PersonalName OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131077,V8}|TempTlv9] ->
    {'dec_PersonalName'(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute organizational-unit-names(9)   External PKIX1Explicit88:OrganizationalUnitNames OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131078,V9}|TempTlv10] ->
    {'dec_OrganizationalUnitNames'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

case Tlv10 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv10}}}) % extra fields not allowed
end,
   {'BuiltInStandardAttributes', Term1, Term2, Term3, Term4, Term5, Term6, Term7, Term8, Term9}.



%%================================
%%  CountryName
%%================================
'enc_CountryName'(Val) ->
    'enc_CountryName'(Val, [<<97>>]).


'enc_CountryName'({'CountryName',Val}, TagIn) ->
   'enc_CountryName'(Val, TagIn);

'enc_CountryName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'x121-dcc-code' ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 18, [<<18>>]);
      'iso-3166-alpha2-code' ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_CountryName'(Tlv) ->
   'dec_CountryName'(Tlv, [65537]).

'dec_CountryName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'x121-dcc-code'
    {18, V1} -> 
        {'x121-dcc-code', ?RT_BER:decode_restricted_string(V1,3,18,[])};


%% 'iso-3166-alpha2-code'
    {19, V1} -> 
        {'iso-3166-alpha2-code', ?RT_BER:decode_restricted_string(V1,2,19,[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  AdministrationDomainName
%%================================
'enc_AdministrationDomainName'(Val) ->
    'enc_AdministrationDomainName'(Val, [<<98>>]).


'enc_AdministrationDomainName'({'AdministrationDomainName',Val}, TagIn) ->
   'enc_AdministrationDomainName'(Val, TagIn);

'enc_AdministrationDomainName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      numeric ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 18, [<<18>>]);
      printable ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_AdministrationDomainName'(Tlv) ->
   'dec_AdministrationDomainName'(Tlv, [65538]).

'dec_AdministrationDomainName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric'
    {18, V1} -> 
        {numeric, ?RT_BER:decode_restricted_string(V1,{0,16},18,[])};


%% 'printable'
    {19, V1} -> 
        {printable, ?RT_BER:decode_restricted_string(V1,{0,16},19,[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  NetworkAddress
%%================================
'enc_NetworkAddress'(Val) ->
    'enc_NetworkAddress'(Val, [<<18>>]).


'enc_NetworkAddress'({'NetworkAddress',Val}, TagIn) ->
   'enc_NetworkAddress'(Val, TagIn);

'enc_NetworkAddress'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 18, TagIn).


'dec_NetworkAddress'(Tlv) ->
   'dec_NetworkAddress'(Tlv, [18]).

'dec_NetworkAddress'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,16},18,TagIn).



%%================================
%%  X121Address
%%================================
'enc_X121Address'(Val) ->
    'enc_X121Address'(Val, [<<18>>]).


'enc_X121Address'({'X121Address',Val}, TagIn) ->
   'enc_X121Address'(Val, TagIn);

'enc_X121Address'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 18, TagIn).


'dec_X121Address'(Tlv) ->
   'dec_X121Address'(Tlv, [18]).

'dec_X121Address'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,16},18,TagIn).



%%================================
%%  TerminalIdentifier
%%================================
'enc_TerminalIdentifier'(Val) ->
    'enc_TerminalIdentifier'(Val, [<<19>>]).


'enc_TerminalIdentifier'({'TerminalIdentifier',Val}, TagIn) ->
   'enc_TerminalIdentifier'(Val, TagIn);

'enc_TerminalIdentifier'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 19, TagIn).


'dec_TerminalIdentifier'(Tlv) ->
   'dec_TerminalIdentifier'(Tlv, [19]).

'dec_TerminalIdentifier'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,24},19,TagIn).



%%================================
%%  PrivateDomainName
%%================================
'enc_PrivateDomainName'(Val) ->
    'enc_PrivateDomainName'(Val, []).


'enc_PrivateDomainName'({'PrivateDomainName',Val}, TagIn) ->
   'enc_PrivateDomainName'(Val, TagIn);

'enc_PrivateDomainName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      numeric ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 18, [<<18>>]);
      printable ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_PrivateDomainName'(Tlv) ->
   'dec_PrivateDomainName'(Tlv, []).

'dec_PrivateDomainName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric'
    {18, V1} -> 
        {numeric, ?RT_BER:decode_restricted_string(V1,{1,16},18,[])};


%% 'printable'
    {19, V1} -> 
        {printable, ?RT_BER:decode_restricted_string(V1,{1,16},19,[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  OrganizationName
%%================================
'enc_OrganizationName'(Val) ->
    'enc_OrganizationName'(Val, [<<19>>]).


'enc_OrganizationName'({'OrganizationName',Val}, TagIn) ->
   'enc_OrganizationName'(Val, TagIn);

'enc_OrganizationName'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 19, TagIn).


'dec_OrganizationName'(Tlv) ->
   'dec_OrganizationName'(Tlv, [19]).

'dec_OrganizationName'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,64},19,TagIn).



%%================================
%%  NumericUserIdentifier
%%================================
'enc_NumericUserIdentifier'(Val) ->
    'enc_NumericUserIdentifier'(Val, [<<18>>]).


'enc_NumericUserIdentifier'({'NumericUserIdentifier',Val}, TagIn) ->
   'enc_NumericUserIdentifier'(Val, TagIn);

'enc_NumericUserIdentifier'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 18, TagIn).


'dec_NumericUserIdentifier'(Tlv) ->
   'dec_NumericUserIdentifier'(Tlv, [18]).

'dec_NumericUserIdentifier'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,32},18,TagIn).



%%================================
%%  PersonalName
%%================================
'enc_PersonalName'(Val) ->
    'enc_PersonalName'(Val, [<<49>>]).

'enc_PersonalName'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute surname(1) with type PrintableString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_restricted_string([], Cindex1, 19, [<<128>>]),

%%-------------------------------------------------
%% attribute given-name(2) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex2, 19, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute initials(3) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex3, 19, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex4, 19, [<<131>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PersonalName'(Tlv) ->
   'dec_PersonalName'(Tlv, [17]).

'dec_PersonalName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
SetFun = fun(FunTlv) ->
case FunTlv of 
      %surname
TTlv = {131072,_} ->
    {1, TTlv};
      %given-name
TTlv = {131073,_} ->
    {2, TTlv};
      %initials
TTlv = {131074,_} ->
    {3, TTlv};
      %generation-qualifier
TTlv = {131075,_} ->
    {4, TTlv};
      Else -> 
         {5, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute surname(1) with type PrintableString
%%-------------------------------------------------
[V1|Tlv3] = Tlv2, 
Term1 = ?RT_BER:decode_restricted_string(V1,{1,40},19,[131072]),

%%-------------------------------------------------
%% attribute given-name(2) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{131073,V2}|TempTlv4] ->
    {?RT_BER:decode_restricted_string(V2,{1,16},19,[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute initials(3) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv5} = case Tlv4 of
[{131074,V3}|TempTlv5] ->
    {?RT_BER:decode_restricted_string(V3,{1,5},19,[]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv6} = case Tlv5 of
[{131075,V4}|TempTlv6] ->
    {?RT_BER:decode_restricted_string(V4,{1,3},19,[]), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
   {'PersonalName', Term1, Term2, Term3, Term4}.


%%================================
%%  OrganizationalUnitNames
%%================================
'enc_OrganizationalUnitNames'(Val) ->
    'enc_OrganizationalUnitNames'(Val, [<<48>>]).


'enc_OrganizationalUnitNames'({'OrganizationalUnitNames',Val}, TagIn) ->
   'enc_OrganizationalUnitNames'(Val, TagIn);

'enc_OrganizationalUnitNames'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OrganizationalUnitNames_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_OrganizationalUnitNames_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OrganizationalUnitNames_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_restricted_string([], H, 19, [<<19>>]),
   'enc_OrganizationalUnitNames_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_OrganizationalUnitNames'(Tlv) ->
   'dec_OrganizationalUnitNames'(Tlv, [16]).

'dec_OrganizationalUnitNames'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
[?RT_BER:decode_restricted_string(V1,{1,32},19,[19]) || V1 <- Tlv1].




%%================================
%%  OrganizationalUnitName
%%================================
'enc_OrganizationalUnitName'(Val) ->
    'enc_OrganizationalUnitName'(Val, [<<19>>]).


'enc_OrganizationalUnitName'({'OrganizationalUnitName',Val}, TagIn) ->
   'enc_OrganizationalUnitName'(Val, TagIn);

'enc_OrganizationalUnitName'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 19, TagIn).


'dec_OrganizationalUnitName'(Tlv) ->
   'dec_OrganizationalUnitName'(Tlv, [19]).

'dec_OrganizationalUnitName'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,32},19,TagIn).



%%================================
%%  BuiltInDomainDefinedAttributes
%%================================
'enc_BuiltInDomainDefinedAttributes'(Val) ->
    'enc_BuiltInDomainDefinedAttributes'(Val, [<<48>>]).


'enc_BuiltInDomainDefinedAttributes'({'BuiltInDomainDefinedAttributes',Val}, TagIn) ->
   'enc_BuiltInDomainDefinedAttributes'(Val, TagIn);

'enc_BuiltInDomainDefinedAttributes'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_BuiltInDomainDefinedAttributes_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_BuiltInDomainDefinedAttributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_BuiltInDomainDefinedAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_BuiltInDomainDefinedAttribute'(H, [<<48>>]),
   'enc_BuiltInDomainDefinedAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_BuiltInDomainDefinedAttributes'(Tlv) ->
   'dec_BuiltInDomainDefinedAttributes'(Tlv, [16]).

'dec_BuiltInDomainDefinedAttributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_BuiltInDomainDefinedAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  BuiltInDomainDefinedAttribute
%%================================
'enc_BuiltInDomainDefinedAttribute'(Val) ->
    'enc_BuiltInDomainDefinedAttribute'(Val, [<<48>>]).

'enc_BuiltInDomainDefinedAttribute'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type PrintableString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_restricted_string([], Cindex1, 19, [<<19>>]),

%%-------------------------------------------------
%% attribute value(2) with type PrintableString
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_restricted_string([], Cindex2, 19, [<<19>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_BuiltInDomainDefinedAttribute'(Tlv) ->
   'dec_BuiltInDomainDefinedAttribute'(Tlv, [16]).

'dec_BuiltInDomainDefinedAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute type(1) with type PrintableString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_restricted_string(V1,{1,8},19,[19]),

%%-------------------------------------------------
%% attribute value(2) with type PrintableString
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_restricted_string(V2,{1,128},19,[19]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'BuiltInDomainDefinedAttribute', Term1, Term2}.



%%================================
%%  ExtensionAttributes
%%================================
'enc_ExtensionAttributes'(Val) ->
    'enc_ExtensionAttributes'(Val, [<<49>>]).


'enc_ExtensionAttributes'({'ExtensionAttributes',Val}, TagIn) ->
   'enc_ExtensionAttributes'(Val, TagIn);

'enc_ExtensionAttributes'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttributes_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtensionAttributes_components'([], AccBytes, AccLen) -> 
   {asn1rt_check:dynamicsort_SETOF(AccBytes),AccLen};

'enc_ExtensionAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttribute'(H, [<<48>>]),
   'enc_ExtensionAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ExtensionAttributes'(Tlv) ->
   'dec_ExtensionAttributes'(Tlv, [17]).

'dec_ExtensionAttributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_ExtensionAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ExtensionAttribute
%%================================
'enc_ExtensionAttribute'(Val) ->
    'enc_ExtensionAttribute'(Val, [<<48>>]).

'enc_ExtensionAttribute'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute extension-attribute-type(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_integer([], Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute extension-attribute-value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ExtensionAttribute'(Tlv) ->
   'dec_ExtensionAttribute'(Tlv, [16]).

'dec_ExtensionAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute extension-attribute-type(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_integer(V1,{0,256},[131072]),

%%-------------------------------------------------
%% attribute extension-attribute-value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_open_type_as_binary(V2,[131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'ExtensionAttribute', Term1, Term2}.



%%================================
%%  CommonName
%%================================
'enc_CommonName'(Val) ->
    'enc_CommonName'(Val, [<<19>>]).


'enc_CommonName'({'CommonName',Val}, TagIn) ->
   'enc_CommonName'(Val, TagIn);

'enc_CommonName'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 19, TagIn).


'dec_CommonName'(Tlv) ->
   'dec_CommonName'(Tlv, [19]).

'dec_CommonName'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,64},19,TagIn).



%%================================
%%  TeletexCommonName
%%================================
'enc_TeletexCommonName'(Val) ->
    'enc_TeletexCommonName'(Val, [<<20>>]).


'enc_TeletexCommonName'({'TeletexCommonName',Val}, TagIn) ->
   'enc_TeletexCommonName'(Val, TagIn);

'enc_TeletexCommonName'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 20, TagIn).


'dec_TeletexCommonName'(Tlv) ->
   'dec_TeletexCommonName'(Tlv, [20]).

'dec_TeletexCommonName'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,64},20,TagIn).



%%================================
%%  TeletexOrganizationName
%%================================
'enc_TeletexOrganizationName'(Val) ->
    'enc_TeletexOrganizationName'(Val, [<<20>>]).


'enc_TeletexOrganizationName'({'TeletexOrganizationName',Val}, TagIn) ->
   'enc_TeletexOrganizationName'(Val, TagIn);

'enc_TeletexOrganizationName'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 20, TagIn).


'dec_TeletexOrganizationName'(Tlv) ->
   'dec_TeletexOrganizationName'(Tlv, [20]).

'dec_TeletexOrganizationName'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,64},20,TagIn).



%%================================
%%  TeletexPersonalName
%%================================
'enc_TeletexPersonalName'(Val) ->
    'enc_TeletexPersonalName'(Val, [<<49>>]).

'enc_TeletexPersonalName'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute surname(1) with type TeletexString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_restricted_string([], Cindex1, 20, [<<128>>]),

%%-------------------------------------------------
%% attribute given-name(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex2, 20, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute initials(3) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex3, 20, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex4, 20, [<<131>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TeletexPersonalName'(Tlv) ->
   'dec_TeletexPersonalName'(Tlv, [17]).

'dec_TeletexPersonalName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
SetFun = fun(FunTlv) ->
case FunTlv of 
      %surname
TTlv = {131072,_} ->
    {1, TTlv};
      %given-name
TTlv = {131073,_} ->
    {2, TTlv};
      %initials
TTlv = {131074,_} ->
    {3, TTlv};
      %generation-qualifier
TTlv = {131075,_} ->
    {4, TTlv};
      Else -> 
         {5, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute surname(1) with type TeletexString
%%-------------------------------------------------
[V1|Tlv3] = Tlv2, 
Term1 = ?RT_BER:decode_restricted_string(V1,{1,40},20,[131072]),

%%-------------------------------------------------
%% attribute given-name(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{131073,V2}|TempTlv4] ->
    {?RT_BER:decode_restricted_string(V2,{1,16},20,[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute initials(3) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term3,Tlv5} = case Tlv4 of
[{131074,V3}|TempTlv5] ->
    {?RT_BER:decode_restricted_string(V3,{1,5},20,[]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute generation-qualifier(4) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term4,Tlv6} = case Tlv5 of
[{131075,V4}|TempTlv6] ->
    {?RT_BER:decode_restricted_string(V4,{1,3},20,[]), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
   {'TeletexPersonalName', Term1, Term2, Term3, Term4}.


%%================================
%%  TeletexOrganizationalUnitNames
%%================================
'enc_TeletexOrganizationalUnitNames'(Val) ->
    'enc_TeletexOrganizationalUnitNames'(Val, [<<48>>]).


'enc_TeletexOrganizationalUnitNames'({'TeletexOrganizationalUnitNames',Val}, TagIn) ->
   'enc_TeletexOrganizationalUnitNames'(Val, TagIn);

'enc_TeletexOrganizationalUnitNames'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_TeletexOrganizationalUnitNames_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_TeletexOrganizationalUnitNames_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TeletexOrganizationalUnitNames_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_restricted_string([], H, 20, [<<20>>]),
   'enc_TeletexOrganizationalUnitNames_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TeletexOrganizationalUnitNames'(Tlv) ->
   'dec_TeletexOrganizationalUnitNames'(Tlv, [16]).

'dec_TeletexOrganizationalUnitNames'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
[?RT_BER:decode_restricted_string(V1,{1,32},20,[20]) || V1 <- Tlv1].




%%================================
%%  TeletexOrganizationalUnitName
%%================================
'enc_TeletexOrganizationalUnitName'(Val) ->
    'enc_TeletexOrganizationalUnitName'(Val, [<<20>>]).


'enc_TeletexOrganizationalUnitName'({'TeletexOrganizationalUnitName',Val}, TagIn) ->
   'enc_TeletexOrganizationalUnitName'(Val, TagIn);

'enc_TeletexOrganizationalUnitName'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 20, TagIn).


'dec_TeletexOrganizationalUnitName'(Tlv) ->
   'dec_TeletexOrganizationalUnitName'(Tlv, [20]).

'dec_TeletexOrganizationalUnitName'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,32},20,TagIn).



%%================================
%%  PDSName
%%================================
'enc_PDSName'(Val) ->
    'enc_PDSName'(Val, [<<19>>]).


'enc_PDSName'({'PDSName',Val}, TagIn) ->
   'enc_PDSName'(Val, TagIn);

'enc_PDSName'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 19, TagIn).


'dec_PDSName'(Tlv) ->
   'dec_PDSName'(Tlv, [19]).

'dec_PDSName'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,{1,16},19,TagIn).



%%================================
%%  PhysicalDeliveryCountryName
%%================================
'enc_PhysicalDeliveryCountryName'(Val) ->
    'enc_PhysicalDeliveryCountryName'(Val, []).


'enc_PhysicalDeliveryCountryName'({'PhysicalDeliveryCountryName',Val}, TagIn) ->
   'enc_PhysicalDeliveryCountryName'(Val, TagIn);

'enc_PhysicalDeliveryCountryName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'x121-dcc-code' ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 18, [<<18>>]);
      'iso-3166-alpha2-code' ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_PhysicalDeliveryCountryName'(Tlv) ->
   'dec_PhysicalDeliveryCountryName'(Tlv, []).

'dec_PhysicalDeliveryCountryName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'x121-dcc-code'
    {18, V1} -> 
        {'x121-dcc-code', ?RT_BER:decode_restricted_string(V1,3,18,[])};


%% 'iso-3166-alpha2-code'
    {19, V1} -> 
        {'iso-3166-alpha2-code', ?RT_BER:decode_restricted_string(V1,2,19,[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PostalCode
%%================================
'enc_PostalCode'(Val) ->
    'enc_PostalCode'(Val, []).


'enc_PostalCode'({'PostalCode',Val}, TagIn) ->
   'enc_PostalCode'(Val, TagIn);

'enc_PostalCode'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'numeric-code' ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 18, [<<18>>]);
      'printable-code' ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 19, [<<19>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_PostalCode'(Tlv) ->
   'dec_PostalCode'(Tlv, []).

'dec_PostalCode'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'numeric-code'
    {18, V1} -> 
        {'numeric-code', ?RT_BER:decode_restricted_string(V1,{1,16},18,[])};


%% 'printable-code'
    {19, V1} -> 
        {'printable-code', ?RT_BER:decode_restricted_string(V1,{1,16},19,[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PhysicalDeliveryOfficeName
%%================================
'enc_PhysicalDeliveryOfficeName'(Val) ->
    'enc_PhysicalDeliveryOfficeName'(Val, [<<49>>]).


'enc_PhysicalDeliveryOfficeName'({'PhysicalDeliveryOfficeName',Val}, TagIn) ->
   'enc_PhysicalDeliveryOfficeName'(Val, TagIn);

'enc_PhysicalDeliveryOfficeName'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_PhysicalDeliveryOfficeName'(Tlv) ->
   'dec_PhysicalDeliveryOfficeName'(Tlv, [17]).

'dec_PhysicalDeliveryOfficeName'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PhysicalDeliveryOfficeNumber
%%================================
'enc_PhysicalDeliveryOfficeNumber'(Val) ->
    'enc_PhysicalDeliveryOfficeNumber'(Val, [<<49>>]).


'enc_PhysicalDeliveryOfficeNumber'({'PhysicalDeliveryOfficeNumber',Val}, TagIn) ->
   'enc_PhysicalDeliveryOfficeNumber'(Val, TagIn);

'enc_PhysicalDeliveryOfficeNumber'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_PhysicalDeliveryOfficeNumber'(Tlv) ->
   'dec_PhysicalDeliveryOfficeNumber'(Tlv, [17]).

'dec_PhysicalDeliveryOfficeNumber'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  ExtensionORAddressComponents
%%================================
'enc_ExtensionORAddressComponents'(Val) ->
    'enc_ExtensionORAddressComponents'(Val, [<<49>>]).


'enc_ExtensionORAddressComponents'({'ExtensionORAddressComponents',Val}, TagIn) ->
   'enc_ExtensionORAddressComponents'(Val, TagIn);

'enc_ExtensionORAddressComponents'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_ExtensionORAddressComponents'(Tlv) ->
   'dec_ExtensionORAddressComponents'(Tlv, [17]).

'dec_ExtensionORAddressComponents'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PhysicalDeliveryPersonalName
%%================================
'enc_PhysicalDeliveryPersonalName'(Val) ->
    'enc_PhysicalDeliveryPersonalName'(Val, [<<49>>]).


'enc_PhysicalDeliveryPersonalName'({'PhysicalDeliveryPersonalName',Val}, TagIn) ->
   'enc_PhysicalDeliveryPersonalName'(Val, TagIn);

'enc_PhysicalDeliveryPersonalName'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_PhysicalDeliveryPersonalName'(Tlv) ->
   'dec_PhysicalDeliveryPersonalName'(Tlv, [17]).

'dec_PhysicalDeliveryPersonalName'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PhysicalDeliveryOrganizationName
%%================================
'enc_PhysicalDeliveryOrganizationName'(Val) ->
    'enc_PhysicalDeliveryOrganizationName'(Val, [<<49>>]).


'enc_PhysicalDeliveryOrganizationName'({'PhysicalDeliveryOrganizationName',Val}, TagIn) ->
   'enc_PhysicalDeliveryOrganizationName'(Val, TagIn);

'enc_PhysicalDeliveryOrganizationName'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_PhysicalDeliveryOrganizationName'(Tlv) ->
   'dec_PhysicalDeliveryOrganizationName'(Tlv, [17]).

'dec_PhysicalDeliveryOrganizationName'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  ExtensionPhysicalDeliveryAddressComponents
%%================================
'enc_ExtensionPhysicalDeliveryAddressComponents'(Val) ->
    'enc_ExtensionPhysicalDeliveryAddressComponents'(Val, [<<49>>]).


'enc_ExtensionPhysicalDeliveryAddressComponents'({'ExtensionPhysicalDeliveryAddressComponents',Val}, TagIn) ->
   'enc_ExtensionPhysicalDeliveryAddressComponents'(Val, TagIn);

'enc_ExtensionPhysicalDeliveryAddressComponents'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_ExtensionPhysicalDeliveryAddressComponents'(Tlv) ->
   'dec_ExtensionPhysicalDeliveryAddressComponents'(Tlv, [17]).

'dec_ExtensionPhysicalDeliveryAddressComponents'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  UnformattedPostalAddress
%%================================
'enc_UnformattedPostalAddress'(Val) ->
    'enc_UnformattedPostalAddress'(Val, [<<49>>]).

'enc_UnformattedPostalAddress'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute printable-address(1) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_UnformattedPostalAddress_printable-address'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex2, 20, [<<20>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  UnformattedPostalAddress_printable-address
%%================================

'enc_UnformattedPostalAddress_printable-address'({'UnformattedPostalAddress_printable-address',Val}, TagIn) ->
   'enc_UnformattedPostalAddress_printable-address'(Val, TagIn);

'enc_UnformattedPostalAddress_printable-address'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_UnformattedPostalAddress_printable-address_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_UnformattedPostalAddress_printable-address_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_UnformattedPostalAddress_printable-address_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_restricted_string([], H, 19, [<<19>>]),
   'enc_UnformattedPostalAddress_printable-address_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_UnformattedPostalAddress_printable-address'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
[?RT_BER:decode_restricted_string(V1,{1,30},19,[19]) || V1 <- Tlv1].




'dec_UnformattedPostalAddress'(Tlv) ->
   'dec_UnformattedPostalAddress'(Tlv, [17]).

'dec_UnformattedPostalAddress'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
SetFun = fun(FunTlv) ->
case FunTlv of 
      %printable-address
TTlv = {16,_} ->
    {1, TTlv};
      %teletex-string
TTlv = {20,_} ->
    {2, TTlv};
      Else -> 
         {3, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute printable-address(1) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term1,Tlv3} = case Tlv2 of
[{16,V1}|TempTlv3] ->
    {'dec_UnformattedPostalAddress_printable-address'(V1, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{20,V2}|TempTlv4] ->
    {?RT_BER:decode_restricted_string(V2,{1,180},20,[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'UnformattedPostalAddress', Term1, Term2}.


%%================================
%%  StreetAddress
%%================================
'enc_StreetAddress'(Val) ->
    'enc_StreetAddress'(Val, [<<49>>]).


'enc_StreetAddress'({'StreetAddress',Val}, TagIn) ->
   'enc_StreetAddress'(Val, TagIn);

'enc_StreetAddress'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_StreetAddress'(Tlv) ->
   'dec_StreetAddress'(Tlv, [17]).

'dec_StreetAddress'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PostOfficeBoxAddress
%%================================
'enc_PostOfficeBoxAddress'(Val) ->
    'enc_PostOfficeBoxAddress'(Val, [<<49>>]).


'enc_PostOfficeBoxAddress'({'PostOfficeBoxAddress',Val}, TagIn) ->
   'enc_PostOfficeBoxAddress'(Val, TagIn);

'enc_PostOfficeBoxAddress'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_PostOfficeBoxAddress'(Tlv) ->
   'dec_PostOfficeBoxAddress'(Tlv, [17]).

'dec_PostOfficeBoxAddress'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PosteRestanteAddress
%%================================
'enc_PosteRestanteAddress'(Val) ->
    'enc_PosteRestanteAddress'(Val, [<<49>>]).


'enc_PosteRestanteAddress'({'PosteRestanteAddress',Val}, TagIn) ->
   'enc_PosteRestanteAddress'(Val, TagIn);

'enc_PosteRestanteAddress'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_PosteRestanteAddress'(Tlv) ->
   'dec_PosteRestanteAddress'(Tlv, [17]).

'dec_PosteRestanteAddress'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  UniquePostalName
%%================================
'enc_UniquePostalName'(Val) ->
    'enc_UniquePostalName'(Val, [<<49>>]).


'enc_UniquePostalName'({'UniquePostalName',Val}, TagIn) ->
   'enc_UniquePostalName'(Val, TagIn);

'enc_UniquePostalName'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_UniquePostalName'(Tlv) ->
   'dec_UniquePostalName'(Tlv, [17]).

'dec_UniquePostalName'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  LocalPostalAttributes
%%================================
'enc_LocalPostalAttributes'(Val) ->
    'enc_LocalPostalAttributes'(Val, [<<49>>]).


'enc_LocalPostalAttributes'({'LocalPostalAttributes',Val}, TagIn) ->
   'enc_LocalPostalAttributes'(Val, TagIn);

'enc_LocalPostalAttributes'(Val, TagIn) ->
   'enc_PDSParameter'(Val, TagIn).


'dec_LocalPostalAttributes'(Tlv) ->
   'dec_LocalPostalAttributes'(Tlv, [17]).

'dec_LocalPostalAttributes'(Tlv, TagIn) ->
'dec_PDSParameter'(Tlv, TagIn).



%%================================
%%  PDSParameter
%%================================
'enc_PDSParameter'(Val) ->
    'enc_PDSParameter'(Val, [<<49>>]).

'enc_PDSParameter'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute printable-string(1) with type PrintableString OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex1, 19, [<<19>>])
       end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex2, 20, [<<20>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PDSParameter'(Tlv) ->
   'dec_PDSParameter'(Tlv, [17]).

'dec_PDSParameter'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
SetFun = fun(FunTlv) ->
case FunTlv of 
      %printable-string
TTlv = {19,_} ->
    {1, TTlv};
      %teletex-string
TTlv = {20,_} ->
    {2, TTlv};
      Else -> 
         {3, Else}
   end
   end,
PositionList = [SetFun(TempTlv)|| TempTlv <- Tlv1],
Tlv2 = [Stlv || {_,Stlv} <- lists:sort(PositionList)],

%%-------------------------------------------------
%% attribute printable-string(1) with type PrintableString OPTIONAL
%%-------------------------------------------------
{Term1,Tlv3} = case Tlv2 of
[{19,V1}|TempTlv3] ->
    {?RT_BER:decode_restricted_string(V1,{1,30},19,[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute teletex-string(2) with type TeletexString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv4} = case Tlv3 of
[{20,V2}|TempTlv4] ->
    {?RT_BER:decode_restricted_string(V2,{1,30},20,[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'PDSParameter', Term1, Term2}.


%%================================
%%  ExtendedNetworkAddress
%%================================
'enc_ExtendedNetworkAddress'(Val) ->
    'enc_ExtendedNetworkAddress'(Val, []).


'enc_ExtendedNetworkAddress'({'ExtendedNetworkAddress',Val}, TagIn) ->
   'enc_ExtendedNetworkAddress'(Val, TagIn);

'enc_ExtendedNetworkAddress'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'e163-4-address' ->
         'enc_ExtendedNetworkAddress_e163-4-address'(element(2,Val), [<<48>>]);
      'psap-address' ->
         'enc_PresentationAddress'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  ExtendedNetworkAddress_e163-4-address
%%================================
'enc_ExtendedNetworkAddress_e163-4-address'(Val, TagIn) ->
   {_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute number(1) with type NumericString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_restricted_string([], Cindex1, 18, [<<128>>]),

%%-------------------------------------------------
%% attribute sub-address(2) with type NumericString OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_restricted_string([], Cindex2, 18, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).
'dec_ExtendedNetworkAddress_e163-4-address'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute number(1) with type NumericString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_restricted_string(V1,{1,15},18,[131072]),

%%-------------------------------------------------
%% attribute sub-address(2) with type NumericString OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {?RT_BER:decode_restricted_string(V2,{1,40},18,[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'ExtendedNetworkAddress_e163-4-address', Term1, Term2}.



'dec_ExtendedNetworkAddress'(Tlv) ->
   'dec_ExtendedNetworkAddress'(Tlv, []).

'dec_ExtendedNetworkAddress'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'e163-4-address'
    {16, V1} -> 
        {'e163-4-address', 'dec_ExtendedNetworkAddress_e163-4-address'(V1, [])};


%% 'psap-address'
    {131072, V1} -> 
        {'psap-address', 'dec_PresentationAddress'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PresentationAddress
%%================================
'enc_PresentationAddress'(Val) ->
    'enc_PresentationAddress'(Val, [<<48>>]).

'enc_PresentationAddress'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute pSelector(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], Cindex1, [<<4>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute sSelector(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], Cindex2, [<<4>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute tSelector(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], Cindex3, [<<4>>,<<162>>])
       end,

%%-------------------------------------------------
%% attribute nAddresses(4) with type SET OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_PresentationAddress_nAddresses'(Cindex4, [<<49>>,<<163>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PresentationAddress_nAddresses
%%================================

'enc_PresentationAddress_nAddresses'({'PresentationAddress_nAddresses',Val}, TagIn) ->
   'enc_PresentationAddress_nAddresses'(Val, TagIn);

'enc_PresentationAddress_nAddresses'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PresentationAddress_nAddresses_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_PresentationAddress_nAddresses_components'([], AccBytes, AccLen) -> 
   {asn1rt_check:dynamicsort_SETOF(AccBytes),AccLen};

'enc_PresentationAddress_nAddresses_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_octet_string([], H, [<<4>>]),
   'enc_PresentationAddress_nAddresses_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_PresentationAddress_nAddresses'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
[?RT_BER:decode_octet_string(V1,[],[4]) || V1 <- Tlv1].




'dec_PresentationAddress'(Tlv) ->
   'dec_PresentationAddress'(Tlv, [16]).

'dec_PresentationAddress'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute pSelector(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {?RT_BER:decode_octet_string(V1,[],[4]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute sSelector(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {?RT_BER:decode_octet_string(V2,[],[4]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute tSelector(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {?RT_BER:decode_octet_string(V3,[],[4]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute nAddresses(4) with type SET OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_PresentationAddress_nAddresses'(V4, [131075,17]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
   {'PresentationAddress', Term1, Term2, Term3, Term4}.



%%================================
%%  TerminalType
%%================================
'enc_TerminalType'(Val) ->
    'enc_TerminalType'(Val, [<<2>>]).


'enc_TerminalType'({'TerminalType',Val}, TagIn) ->
   'enc_TerminalType'(Val, TagIn);

'enc_TerminalType'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, [{telex,3},{teletex,4},{'g3-facsimile',5},{'g4-facsimile',6},{'ia5-terminal',7},{videotex,8}], TagIn).


'dec_TerminalType'(Tlv) ->
   'dec_TerminalType'(Tlv, [2]).

'dec_TerminalType'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,{0,256},[{telex,3},{teletex,4},{'g3-facsimile',5},{'g4-facsimile',6},{'ia5-terminal',7},{videotex,8}],TagIn).



%%================================
%%  TeletexDomainDefinedAttributes
%%================================
'enc_TeletexDomainDefinedAttributes'(Val) ->
    'enc_TeletexDomainDefinedAttributes'(Val, [<<48>>]).


'enc_TeletexDomainDefinedAttributes'({'TeletexDomainDefinedAttributes',Val}, TagIn) ->
   'enc_TeletexDomainDefinedAttributes'(Val, TagIn);

'enc_TeletexDomainDefinedAttributes'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_TeletexDomainDefinedAttributes_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_TeletexDomainDefinedAttributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TeletexDomainDefinedAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TeletexDomainDefinedAttribute'(H, [<<48>>]),
   'enc_TeletexDomainDefinedAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TeletexDomainDefinedAttributes'(Tlv) ->
   'dec_TeletexDomainDefinedAttributes'(Tlv, [16]).

'dec_TeletexDomainDefinedAttributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_TeletexDomainDefinedAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  TeletexDomainDefinedAttribute
%%================================
'enc_TeletexDomainDefinedAttribute'(Val) ->
    'enc_TeletexDomainDefinedAttribute'(Val, [<<48>>]).

'enc_TeletexDomainDefinedAttribute'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type TeletexString
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_restricted_string([], Cindex1, 20, [<<20>>]),

%%-------------------------------------------------
%% attribute value(2) with type TeletexString
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_restricted_string([], Cindex2, 20, [<<20>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TeletexDomainDefinedAttribute'(Tlv) ->
   'dec_TeletexDomainDefinedAttribute'(Tlv, [16]).

'dec_TeletexDomainDefinedAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute type(1) with type TeletexString
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_restricted_string(V1,{1,8},20,[20]),

%%-------------------------------------------------
%% attribute value(2) with type TeletexString
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_restricted_string(V2,{1,128},20,[20]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'TeletexDomainDefinedAttribute', Term1, Term2}.

'id-pkix'() ->
{1,3,6,1,5,5,7}.

'id-pe'() ->
{1,3,6,1,5,5,7,1}.

'id-qt'() ->
{1,3,6,1,5,5,7,2}.

'id-kp'() ->
{1,3,6,1,5,5,7,3}.

'id-ad'() ->
{1,3,6,1,5,5,7,48}.

'id-qt-cps'() ->
{1,3,6,1,5,5,7,2,1}.

'id-qt-unotice'() ->
{1,3,6,1,5,5,7,2,2}.

'id-ad-ocsp'() ->
{1,3,6,1,5,5,7,48,1}.

'id-ad-caIssuers'() ->
{1,3,6,1,5,5,7,48,2}.

'id-ad-timeStamping'() ->
{1,3,6,1,5,5,7,48,3}.

'id-ad-caRepository'() ->
{1,3,6,1,5,5,7,48,5}.

'id-at'() ->
{2,5,4}.

'id-at-name'() ->
{2,5,4,41}.

'id-at-surname'() ->
{2,5,4,4}.

'id-at-givenName'() ->
{2,5,4,42}.

'id-at-initials'() ->
{2,5,4,43}.

'id-at-generationQualifier'() ->
{2,5,4,44}.

'id-at-commonName'() ->
{2,5,4,3}.

'id-at-localityName'() ->
{2,5,4,7}.

'id-at-stateOrProvinceName'() ->
{2,5,4,8}.

'id-at-organizationName'() ->
{2,5,4,10}.

'id-at-organizationalUnitName'() ->
{2,5,4,11}.

'id-at-title'() ->
{2,5,4,12}.

'id-at-dnQualifier'() ->
{2,5,4,46}.

'id-at-countryName'() ->
{2,5,4,6}.

'id-at-serialNumber'() ->
{2,5,4,5}.

'id-at-pseudonym'() ->
{2,5,4,65}.

'id-domainComponent'() ->
{0,9,2342,19200300,100,1,25}.

'pkcs-9'() ->
{1,2,840,113549,1,9}.

'id-emailAddress'() ->
{1,2,840,113549,1,9,1}.

'common-name'() ->
1.

'teletex-common-name'() ->
2.

'teletex-organization-name'() ->
3.

'teletex-personal-name'() ->
4.

'teletex-organizational-unit-names'() ->
5.

'pds-name'() ->
7.

'physical-delivery-country-name'() ->
8.

'postal-code'() ->
9.

'physical-delivery-office-name'() ->
10.

'physical-delivery-office-number'() ->
11.

'extension-OR-address-components'() ->
12.

'physical-delivery-personal-name'() ->
13.

'physical-delivery-organization-name'() ->
14.

'extension-physical-delivery-address-components'() ->
15.

'unformatted-postal-address'() ->
16.

'street-address'() ->
17.

'post-office-box-address'() ->
18.

'poste-restante-address'() ->
19.

'unique-postal-name'() ->
20.

'local-postal-attributes'() ->
21.

'extended-network-address'() ->
22.

'terminal-type'() ->
23.

'teletex-domain-defined-attributes'() ->
6.

'ub-name'() ->
32768.

'ub-common-name'() ->
64.

'ub-locality-name'() ->
128.

'ub-state-name'() ->
128.

'ub-organization-name'() ->
64.

'ub-organizational-unit-name'() ->
64.

'ub-title'() ->
64.

'ub-serial-number'() ->
64.

'ub-match'() ->
128.

'ub-emailaddress-length'() ->
128.

'ub-common-name-length'() ->
64.

'ub-country-name-alpha-length'() ->
2.

'ub-country-name-numeric-length'() ->
3.

'ub-domain-defined-attributes'() ->
4.

'ub-domain-defined-attribute-type-length'() ->
8.

'ub-domain-defined-attribute-value-length'() ->
128.

'ub-domain-name-length'() ->
16.

'ub-extension-attributes'() ->
256.

'ub-e163-4-number-length'() ->
15.

'ub-e163-4-sub-address-length'() ->
40.

'ub-generation-qualifier-length'() ->
3.

'ub-given-name-length'() ->
16.

'ub-initials-length'() ->
5.

'ub-integer-options'() ->
256.

'ub-numeric-user-id-length'() ->
32.

'ub-organization-name-length'() ->
64.

'ub-organizational-unit-name-length'() ->
32.

'ub-organizational-units'() ->
4.

'ub-pds-name-length'() ->
16.

'ub-pds-parameter-length'() ->
30.

'ub-pds-physical-address-lines'() ->
6.

'ub-postal-code-length'() ->
16.

'ub-pseudonym'() ->
128.

'ub-surname-length'() ->
40.

'ub-terminal-id-length'() ->
24.

'ub-unformatted-address-length'() ->
180.

'ub-x121-address-length'() ->
16.

