require '_h2ph_pre.ph';

no warnings 'redefine';

require 'machine/endian.ph';
unless(defined(&BBSIZE)) {
    sub BBSIZE () {	1024;}
}
unless(defined(&SBSIZE)) {
    sub SBSIZE () {	1024;}
}
unless(defined(&BBOFF)) {
    sub BBOFF () {	(( &off_t)(0));}
}
unless(defined(&SBOFF)) {
    sub SBOFF () {	(( &off_t)( &BBOFF +  &BBSIZE));}
}
unless(defined(&BBLOCK)) {
    sub BBLOCK () {	(( &ufs1_daddr_t)(0));}
}
unless(defined(&SBLOCK)) {
    sub SBLOCK () {	(( &ufs1_daddr_t)( &BBLOCK +  &BBSIZE /  &DEV_BSIZE));}
}
unless(defined(&LOG_MINBSIZE)) {
    sub LOG_MINBSIZE () {	10;}
}
unless(defined(&MINBSIZE)) {
    sub MINBSIZE () {	(1<<  &LOG_MINBSIZE);}
}
unless(defined(&MAXMNTLEN)) {
    sub MAXMNTLEN () {	512;}
}
unless(defined(&MINFREE)) {
    sub MINFREE () {	5;}
}
unless(defined(&E2FS_MAGIC)) {
    sub E2FS_MAGIC () {	0xef53;}
}
unless(defined(&E2FS_REV0)) {
    sub E2FS_REV0 () {	0;}
}
unless(defined(&E2FS_REV1)) {
    sub E2FS_REV1 () {	1;}
}
unless(defined(&EXT2F_COMPAT_PREALLOC)) {
    sub EXT2F_COMPAT_PREALLOC () {	0x1;}
}
unless(defined(&EXT2F_ROCOMPAT_SPARSESUPER)) {
    sub EXT2F_ROCOMPAT_SPARSESUPER () {	0x1;}
}
unless(defined(&EXT2F_ROCOMPAT_LARGEFILE)) {
    sub EXT2F_ROCOMPAT_LARGEFILE () {	0x2;}
}
unless(defined(&EXT2F_ROCOMPAT_BTREE_DIR)) {
    sub EXT2F_ROCOMPAT_BTREE_DIR () {	0x4;}
}
unless(defined(&EXT2F_INCOMPAT_COMP)) {
    sub EXT2F_INCOMPAT_COMP () {	0x1;}
}
unless(defined(&EXT2F_INCOMPAT_FTYPE)) {
    sub EXT2F_INCOMPAT_FTYPE () {	0x2;}
}
unless(defined(&EXT2F_INCOMPAT_RECOVER)) {
    sub EXT2F_INCOMPAT_RECOVER () {	0x4;}
}
unless(defined(&EXT2F_INCOMPAT_JOURNAL_DEV)) {
    sub EXT2F_INCOMPAT_JOURNAL_DEV () {	0x8;}
}
unless(defined(&EXT2F_COMPAT_SUPP)) {
    sub EXT2F_COMPAT_SUPP () {	0x;}
}
unless(defined(&EXT2F_ROCOMPAT_SUPP)) {
    sub EXT2F_ROCOMPAT_SUPP () {	( &EXT2F_ROCOMPAT_SPARSESUPER |  &EXT2F_ROCOMPAT_LARGEFILE);}
}
unless(defined(&EXT2F_INCOMPAT_SUPP)) {
    sub EXT2F_INCOMPAT_SUPP () {	 &EXT2F_INCOMPAT_FTYPE;}
}
unless(defined(&E2FS_OS_LINUX)) {
    sub E2FS_OS_LINUX () {	0;}
}
unless(defined(&E2FS_OS_HURD)) {
    sub E2FS_OS_HURD () {	1;}
}
unless(defined(&E2FS_OS_MASIX)) {
    sub E2FS_OS_MASIX () {	2;}
}
unless(defined(&E2FS_ISCLEAN)) {
    sub E2FS_ISCLEAN () {	0x1;}
}
unless(defined(&E2FS_ERRORS)) {
    sub E2FS_ERRORS () {	0x2;}
}
unless(defined(&cg_has_sb)) {
    sub cg_has_sb {
	my($i) = @_;
	eval q(; { 'int'  &a3 , &a5 ,  &a7;  &if ($i == 0|| $i == 1) 1;  &for ( &a3 = 3,  &a5 = 5,  &a7 = 7;  &a3 <= $i ||  &a5 <= $i ||  &a7 <= $i;  &a3 *= 3,  &a5 *= 5,  &a7 *= 7)  &if ($i ==  &a3 || $i ==  &a5 || $i ==  &a7) 1; 0; });
    }
}
unless(defined(&h2fs16)) {
    sub h2fs16 {
	my($x) = @_;
	eval q( &htole16($x));
    }
}
unless(defined(&h2fs32)) {
    sub h2fs32 {
	my($x) = @_;
	eval q( &htole32($x));
    }
}
unless(defined(&fs2h16)) {
    sub fs2h16 {
	my($x) = @_;
	eval q( &letoh16($x));
    }
}
unless(defined(&fs2h32)) {
    sub fs2h32 {
	my($x) = @_;
	eval q( &letoh32($x));
    }
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : 0)) {
    eval 'sub e2fs_sbload {
        my($old, $new) = @_;
	    eval q( &memcpy(($new), ($old),  &SBSIZE););
    }' unless defined(&e2fs_sbload);
    eval 'sub e2fs_cgload {
        my($old, $new, $size) = @_;
	    eval q( &memcpy(($new), ($old), ($size)););
    }' unless defined(&e2fs_cgload);
    eval 'sub e2fs_sbsave {
        my($old, $new) = @_;
	    eval q( &memcpy(($new), ($old),  &SBSIZE););
    }' unless defined(&e2fs_sbsave);
    eval 'sub e2fs_cgsave {
        my($old, $new, $size) = @_;
	    eval q( &memcpy(($new), ($old), ($size)););
    }' unless defined(&e2fs_cgsave);
} else {
    eval 'sub e2fs_sbload {
        my($old, $new) = @_;
	    eval q( &e2fs_sb_bswap(($old), ($new)));
    }' unless defined(&e2fs_sbload);
    eval 'sub e2fs_cgload {
        my($old, $new, $size) = @_;
	    eval q( &e2fs_cg_bswap(($old), ($new), ($size)););
    }' unless defined(&e2fs_cgload);
    eval 'sub e2fs_sbsave {
        my($old, $new) = @_;
	    eval q( &e2fs_sb_bswap(($old), ($new)));
    }' unless defined(&e2fs_sbsave);
    eval 'sub e2fs_cgsave {
        my($old, $new, $size) = @_;
	    eval q( &e2fs_cg_bswap(($old), ($new), ($size)););
    }' unless defined(&e2fs_cgsave);
}
unless(defined(&fsbtodb)) {
    sub fsbtodb {
	my($fs, $b) = @_;
	eval q((($b) << ($fs)-> &e2fs_fsbtodb));
    }
}
unless(defined(&dbtofsb)) {
    sub dbtofsb {
	my($fs, $b) = @_;
	eval q((($b) >> ($fs)-> &e2fs_fsbtodb));
    }
}
unless(defined(&ino_to_cg)) {
    sub ino_to_cg {
	my($fs, $x) = @_;
	eval q(((($x) - 1) / ($fs)-> ($e2fs->{e2fs_ipg})));
    }
}
unless(defined(&ino_to_fsba)) {
    sub ino_to_fsba {
	my($fs, $x) = @_;
	eval q((($fs)-> ($e2fs_gd[ino_to_cg($fs, x)]->{e$xt2bgd_i_tables}) + ((($x)-1) % ($fs)-> ($e2fs->{e2fs_ipg}))/($fs)-> &e2fs_ipb));
    }
}
unless(defined(&ino_to_fsbo)) {
    sub ino_to_fsbo {
	my($fs, $x) = @_;
	eval q(((($x)-1) % ($fs)-> &e2fs_ipb));
    }
}
unless(defined(&dtog)) {
    sub dtog {
	my($fs, $d) = @_;
	eval q(((($d) - ($fs)-> ($e2fs->{e2fs_first_dblock})) / ($fs)-> ($e2fs->{e2fs_fpg})));
    }
}
unless(defined(&dtogd)) {
    sub dtogd {
	my($fs, $d) = @_;
	eval q(((($d) - ($fs)-> ($e2fs->{e2fs_first_dblock})) % ($fs)-> ($e2fs->{e2fs_fpg})));
    }
}
unless(defined(&blkoff)) {
    sub blkoff {
	my($fs, $loc) = @_;
	eval q((($loc) & ($fs)-> &e2fs_qbmask));
    }
}
unless(defined(&lblktosize)) {
    sub lblktosize {
	my($fs, $blk) = @_;
	eval q((($blk) << ($fs)-> &e2fs_bshift));
    }
}
unless(defined(&lblkno)) {
    sub lblkno {
	my($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &e2fs_bshift));
    }
}
unless(defined(&blkroundup)) {
    sub blkroundup {
	my($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &e2fs_qbmask) & ($fs)-> &e2fs_bmask));
    }
}
unless(defined(&fragroundup)) {
    sub fragroundup {
	my($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &e2fs_qbmask) & ($fs)-> &e2fs_bmask));
    }
}
unless(defined(&freespace)) {
    sub freespace {
	my($fs) = @_;
	eval q((($fs)-> ($e2fs->{e2fs_fbcount}) - ($fs)-> ($e2fs->{e2fs_rbcount})));
    }
}
unless(defined(&NINDIR)) {
    sub NINDIR {
	my($fs) = @_;
	eval q((($fs)-> &e2fs_bsize / $sizeof{ &u_int32_t}));
    }
}
1;
