### Name: reorder.dendrogram
### Title: Reorder a Dendrogram
### Aliases: reorder.dendrogram
### Keywords: manip

### ** Examples

  set.seed(123)
  x <- rnorm(10)
  hc <- hclust(dist(x))
  dd <- as.dendrogram(hc)
  dd.reorder <- reorder(dd, 10:1)
  plot(dd, main = "random dendrogram `dd'")

  op <- par(mfcol = 1:2)
  plot(dd.reorder, main = "reorder(dd, 10:1)")
  plot(reorder(dd,10:1, agglo.FUN= mean),
       main = "reorder(dd, 10:1, mean)")
  par(op)



