/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.logic.ConditionalTagBase;

public class MatchTag
extends ConditionalTagBase {
    protected String location = null;
    protected String value = null;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void release() {
        super.release();
        this.location = null;
        this.value = null;
    }

    protected boolean condition() throws JspException {
        return this.condition(true);
    }

    protected boolean condition(boolean desired) throws JspException {
        String variable = null;
        if (this.cookie != null) {
            Cookie[] cookies = ((HttpServletRequest)this.pageContext.getRequest()).getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            int i = 0;
            while (i < cookies.length) {
                if (this.cookie.equals(cookies[i].getName())) {
                    variable = cookies[i].getValue();
                    break;
                }
                ++i;
            }
        } else if (this.header != null) {
            variable = ((HttpServletRequest)this.pageContext.getRequest()).getHeader(this.header);
        } else if (this.name != null) {
            Object value = TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, this.scope);
            if (value != null) {
                variable = value.toString();
            }
        } else if (this.parameter != null) {
            variable = this.pageContext.getRequest().getParameter(this.parameter);
        } else {
            JspException e = new JspException(ConditionalTagBase.messages.getMessage("logic.selector"));
            TagUtils.getInstance().saveException(this.pageContext, e);
            throw e;
        }
        if (variable == null) {
            JspException e = new JspException(ConditionalTagBase.messages.getMessage("logic.variable", (Object)this.value));
            TagUtils.getInstance().saveException(this.pageContext, e);
            throw e;
        }
        boolean matched = false;
        if (this.location == null) {
            matched = variable.indexOf(this.value) >= 0;
        } else if (this.location.equals("start")) {
            matched = variable.startsWith(this.value);
        } else if (this.location.equals("end")) {
            matched = variable.endsWith(this.value);
        } else {
            JspException e = new JspException(ConditionalTagBase.messages.getMessage("logic.location", (Object)this.location));
            TagUtils.getInstance().saveException(this.pageContext, e);
            throw e;
        }
        return matched == desired;
    }
}

