/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidApplicationException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import mx4j.ImplementationException;
import mx4j.loading.ClassLoaderObjectInputStream;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.server.BaseClassLoaderRepository;
import mx4j.server.DefaultClassLoaderRepository;
import mx4j.server.DefaultMBeanRepository;
import mx4j.server.MBeanIntrospector;
import mx4j.server.MBeanMetaData;
import mx4j.server.MBeanPermission;
import mx4j.server.MBeanRepository;
import mx4j.server.interceptor.ContextClassLoaderMBeanServerInterceptor;
import mx4j.server.interceptor.InvokerMBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptorConfigurator;
import mx4j.server.interceptor.NotificationListenerMBeanServerInterceptor;
import mx4j.server.interceptor.SecurityMBeanServerInterceptor;
import mx4j.util.Utils;

public class MBeanServerImpl
implements MBeanServer {
    private String m_defaultDomain;
    private MBeanRepository m_repository;
    private MBeanServerDelegate m_delegate;
    private ObjectName m_delegateName;
    private MBeanIntrospector m_introspector;
    private MBeanServerInterceptorConfigurator m_invoker;
    private static long m_notifications;
    private BaseClassLoaderRepository m_classLoaderRepository;
    private static final String[] EMPTY_PARAMS;
    private static final Object[] EMPTY_ARGS;
    private static BaseClassLoaderRepository m_staticClassLoaderRepository;
    static /* synthetic */ Class class$mx4j$server$MBeanServerImpl;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public MBeanServerImpl(String defaultDomain) {
        SecurityManager sm;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Creating MBeanServer instance...");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking permission to create MBeanServer...");
            }
            sm.checkPermission(new MBeanServerPermission("newMBeanServer"));
        }
        if (defaultDomain == null) {
            defaultDomain = "";
        }
        this.m_defaultDomain = defaultDomain;
        if (logger.isEnabledFor(0)) {
            logger.trace("MBeanServer default domain is: '" + this.m_defaultDomain + "'");
        }
        this.m_repository = this.createMBeanRepository();
        this.m_classLoaderRepository = this.createClassLoaderRepository();
        this.m_introspector = new MBeanIntrospector();
        try {
            this.m_delegateName = new ObjectName("JMImplementation", "type", "MBeanServerDelegate");
        }
        catch (MalformedObjectNameException ignored) {
            // empty catch block
        }
        this.m_delegate = new MBeanServerDelegate();
        try {
            ObjectName invokerName = new ObjectName("JMImplementation:type=MBeanServerInterceptorConfigurator");
            this.m_invoker = new MBeanServerInterceptorConfigurator(this);
            ContextClassLoaderMBeanServerInterceptor ccl = new ContextClassLoaderMBeanServerInterceptor();
            NotificationListenerMBeanServerInterceptor notif = new NotificationListenerMBeanServerInterceptor();
            SecurityMBeanServerInterceptor sec = new SecurityMBeanServerInterceptor();
            InvokerMBeanServerInterceptor inv = new InvokerMBeanServerInterceptor(this);
            this.m_invoker.addPreInterceptor(ccl);
            this.m_invoker.addPreInterceptor(notif);
            this.m_invoker.addPostInterceptor(sec);
            this.m_invoker.addPostInterceptor(inv);
            this.m_invoker.start();
            this.privilegedRegisterMBean(this.m_invoker, invokerName);
            ObjectName cclName = new ObjectName("JMImplementation", "interceptor", "contextclassloader");
            ObjectName notifName = new ObjectName("JMImplementation", "interceptor", "notificationwrapper");
            ObjectName secName = new ObjectName("JMImplementation", "interceptor", "security");
            ObjectName invName = new ObjectName("JMImplementation", "interceptor", "invoker");
            this.privilegedRegisterMBean(ccl, cclName);
            this.privilegedRegisterMBean(notif, notifName);
            this.privilegedRegisterMBean(sec, secName);
            this.privilegedRegisterMBean(inv, invName);
        }
        catch (Exception x) {
            logger.error("MBeanServerInterceptorConfigurator cannot be registered", x);
            throw new ImplementationException();
        }
        try {
            this.privilegedRegisterMBean(this.m_delegate, this.m_delegateName);
        }
        catch (Exception x) {
            logger.error("MBeanServerDelegate cannot be registered", x);
            throw new ImplementationException();
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("MBeanServer instance created successfully");
        }
    }

    public static ClassLoaderRepository getStaticClassLoaderRepository() {
        return m_staticClassLoaderRepository;
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission("-#-[-]", "getClassLoaderRepository"));
        }
        return this.getBaseClassLoaderRepository();
    }

    private BaseClassLoaderRepository getBaseClassLoaderRepository() {
        return this.m_classLoaderRepository;
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            name = this.secureObjectName(name);
            sm.checkPermission(new MBeanPermission(Utils.createPermissionTargetName("-", "-", name), "getClassLoader"));
        }
        return this.findClassLoaderMBean(name);
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            name = this.secureObjectName(name);
            sm.checkPermission(new MBeanPermission(Utils.createPermissionTargetName("-", "-", name), "getClassLoaderFor"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(name);
        return metadata.classloader;
    }

    private ClassLoader findClassLoader(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl != null) {
                return cl;
            }
            return ClassLoader.getSystemClassLoader();
        }
        return this.findClassLoaderMBean(name);
    }

    private ClassLoader findClassLoaderMBean(ObjectName name) throws InstanceNotFoundException {
        MBeanMetaData metadata = this.findMBeanMetaData(name);
        if (metadata.mbean instanceof ClassLoader) {
            return (ClassLoader)metadata.mbean;
        }
        throw new InstanceNotFoundException(name.getCanonicalName());
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] bytes) throws InstanceNotFoundException, OperationsException, ReflectionException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid class name"));
        }
        ClassLoader cl = this.findClassLoader(loaderName);
        try {
            Class<?> cls = cl.loadClass(className);
            return this.deserializeImpl(cls.getClassLoader(), bytes);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public ObjectInputStream deserialize(String className, byte[] bytes) throws OperationsException, ReflectionException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid class name"));
        }
        try {
            Class cls = this.getClassLoaderRepository().loadClass(className);
            return this.deserializeImpl(cls.getClassLoader(), bytes);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] bytes) throws InstanceNotFoundException, OperationsException {
        ClassLoader cl = this.getClassLoaderFor(objectName);
        return this.deserializeImpl(cl, bytes);
    }

    private ObjectInputStream deserializeImpl(ClassLoader classloader, byte[] bytes) throws OperationsException {
        if (bytes == null || bytes.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid bytes"));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            return new ClassLoaderObjectInputStream(bais, classloader);
        }
        catch (IOException x) {
            throw new OperationsException(x.toString());
        }
    }

    private MBeanServerInterceptor getHeadInterceptor() {
        MBeanServerInterceptor head = this.m_invoker.getHeadInterceptor();
        if (head == null) {
            throw new IllegalStateException("No MBeanServer interceptor, probably the configurator has been stopped");
        }
        return head;
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private MBeanRepository createMBeanRepository() {
        block6: {
            String value;
            Logger logger = this.getLogger();
            String property = "mx4j.mbeanserver.repository";
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking for system property mx4j.mbeanserver.repository");
            }
            if ((value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("mx4j.mbeanserver.repository");
                }
            })) != null) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Property found for custom MBeanServer registry; class is: " + value);
                }
                try {
                    MBeanRepository registry = (MBeanRepository)Thread.currentThread().getContextClassLoader().loadClass(value).newInstance();
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Custom MBeanServer registry created successfully");
                    }
                    return registry;
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(0)) break block6;
                    logger.trace("Custom MBeanServer registry could not be created", x);
                }
            }
        }
        return new DefaultMBeanRepository();
    }

    private BaseClassLoaderRepository createClassLoaderRepository() {
        block6: {
            String value;
            Logger logger = this.getLogger();
            String property = "mx4j.mbeanserver.classloader.repository";
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking for system property mx4j.mbeanserver.classloader.repository");
            }
            if ((value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("mx4j.mbeanserver.classloader.repository");
                }
            })) != null) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Property found for custom ClassLoaderRepository; class is: " + value);
                }
                try {
                    BaseClassLoaderRepository repository = (BaseClassLoaderRepository)Thread.currentThread().getContextClassLoader().loadClass(value).newInstance();
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Custom ClassLoaderRepository created successfully");
                    }
                    return repository;
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(0)) break block6;
                    logger.trace("Custom ClassLoaderRepository could not be created", x);
                }
            }
        }
        return new DefaultClassLoaderRepository();
    }

    private MBeanRepository getMBeanRepository() {
        return this.m_repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanMetaData findMBeanMetaData(ObjectName objectName) throws InstanceNotFoundException {
        MBeanMetaData metadata = null;
        if (objectName != null) {
            MBeanRepository repository;
            objectName = this.normalizeObjectName(objectName);
            MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
            synchronized (mBeanRepository) {
                metadata = repository.get(objectName);
            }
        }
        if (metadata == null) {
            throw new InstanceNotFoundException("MBeanServer cannot find MBean with ObjectName " + objectName);
        }
        return metadata;
    }

    public void addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        listener = this.secureObjectName(listener);
        Object mbean = this.findMBeanMetaData((ObjectName)listener).mbean;
        if (!(mbean instanceof NotificationListener)) {
            throw new InstanceNotFoundException("ObjectName " + listener + " is not a NotificationListener");
        }
        this.addNotificationListener(observed, (NotificationListener)mbean, filter, handback);
    }

    public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
        }
        observed = this.secureObjectName(observed);
        MBeanMetaData metadata = this.findMBeanMetaData(observed);
        Object mbean = metadata.mbean;
        if (!(mbean instanceof NotificationBroadcaster)) {
            throw new InstanceNotFoundException("ObjectName " + observed + " is not a NotificationBroadcaster");
        }
        this.addNotificationListenerImpl(metadata, listener, filter, handback);
    }

    private void addNotificationListenerImpl(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.getHeadInterceptor().addNotificationListener(metadata, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        listener = this.secureObjectName(listener);
        Object mbean = this.findMBeanMetaData((ObjectName)listener).mbean;
        if (!(mbean instanceof NotificationListener)) {
            throw new InstanceNotFoundException("ObjectName " + listener + " is not a NotificationListener");
        }
        this.removeNotificationListener(observed, (NotificationListener)mbean);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("NotificationListener cannot be null");
        }
        observed = this.secureObjectName(observed);
        MBeanMetaData metadata = this.findMBeanMetaData(observed);
        Object mbean = metadata.mbean;
        if (!(mbean instanceof NotificationBroadcaster)) {
            throw new InstanceNotFoundException("ObjectName " + observed + " is not a NotificationBroadcaster");
        }
        this.removeNotificationListenerImpl(metadata, listener, null, null);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Object mbean = this.findMBeanMetaData((ObjectName)listener).mbean;
        if (!(mbean instanceof NotificationListener)) {
            throw new InstanceNotFoundException("ObjectName " + listener + " is not a NotificationListener");
        }
        this.removeNotificationListener(observed, (NotificationListener)mbean, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("NotificationListener cannot be null");
        }
        MBeanMetaData metadata = this.findMBeanMetaData(observed);
        Object mbean = metadata.mbean;
        if (!(mbean instanceof NotificationBroadcaster)) {
            throw new InstanceNotFoundException("ObjectName " + observed + " is not a NotificationBroadcaster");
        }
        this.removeNotificationListenerImpl(metadata, listener, filter, handback);
    }

    private void removeNotificationListenerImpl(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.getHeadInterceptor().removeNotificationListener(metadata, listener, filter, handback);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiate(className, null, null);
    }

    public Object instantiate(String className, Object[] args, String[] parameters) throws ReflectionException, MBeanException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name cannot be null or empty"));
        }
        try {
            Class cls = this.getBaseClassLoaderRepository().loadClass(className);
            return this.instantiateImpl((String)className, (ClassLoader)cls.getClassLoader(), null, (String[])parameters, (Object[])args).mbean;
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(className, loaderName, null, null);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name cannot be null or empty"));
        }
        if ((loaderName = this.secureObjectName(loaderName)) != null && loaderName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName for the ClassLoader cannot be a pattern ObjectName"));
        }
        ClassLoader cl = this.findClassLoader(loaderName);
        return this.instantiateImpl((String)className, (ClassLoader)cl, null, (String[])parameters, (Object[])args).mbean;
    }

    private MBeanMetaData instantiateImpl(String className, ClassLoader classloader, ObjectName name, String[] params, Object[] args) throws ReflectionException, MBeanException {
        if (params == null) {
            params = EMPTY_PARAMS;
        }
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if (classloader == null) {
            classloader = ClassLoader.getSystemClassLoader();
        }
        MBeanMetaData metadata = this.createMBeanMetaData();
        metadata.classloader = classloader;
        metadata.name = this.secureObjectName(name);
        this.getHeadInterceptor().instantiate(metadata, className, params, args);
        return metadata;
    }

    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, objectName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            Class cls = this.getBaseClassLoaderRepository().loadClass(className);
            MBeanMetaData metadata = this.instantiateImpl(className, cls.getClassLoader(), objectName, parameters, args);
            this.registerImpl(metadata, false);
            return metadata.instance;
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, objectName, loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        loaderName = this.secureObjectName(loaderName);
        ClassLoader cl = this.findClassLoader(loaderName);
        MBeanMetaData metadata = this.instantiateImpl(className, cl, objectName, parameters, args);
        this.registerImpl(metadata, false);
        return metadata.instance;
    }

    public ObjectInstance registerMBean(Object mbean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.registerMBeanImpl(mbean, objectName, false);
    }

    private ObjectInstance registerMBeanImpl(Object mbean, ObjectName objectName, boolean privileged) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (mbean == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean cannot be null"));
        }
        MBeanMetaData metadata = this.createMBeanMetaData();
        metadata.mbean = mbean;
        ClassLoader cl = mbean.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        metadata.classloader = cl;
        metadata.name = this.secureObjectName(objectName);
        this.registerImpl(metadata, privileged);
        return metadata.instance;
    }

    private MBeanMetaData createMBeanMetaData() {
        return new MBeanMetaData();
    }

    private ObjectInstance privilegedRegisterMBean(final Object mbean, final ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        try {
            return (ObjectInstance)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return MBeanServerImpl.this.registerMBeanImpl(mbean, name, true);
                }
            });
        }
        catch (PrivilegedActionException x) {
            Exception xx = x.getException();
            if (xx instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)xx;
            }
            if (xx instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)xx;
            }
            if (xx instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)xx;
            }
            throw new MBeanRegistrationException(xx);
        }
    }

    private void registerImpl(MBeanMetaData metadata, boolean privileged) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.m_introspector.introspect(metadata);
        if (!this.m_introspector.isMBeanCompliant(metadata)) {
            throw new NotCompliantMBeanException("MBean is not compliant");
        }
        MBeanServerInterceptor head = this.getHeadInterceptor();
        try {
            head.registration(metadata, 1);
            metadata.name = this.secureObjectName(metadata.name);
            this.register(metadata, privileged);
            head.registration(metadata, 2);
        }
        catch (Throwable x) {
            try {
                head.registration(metadata, 3);
            }
            catch (MBeanRegistrationException ignored) {
                // empty catch block
            }
            if (x instanceof SecurityException) {
                throw (SecurityException)x;
            }
            if (x instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)x;
            }
            if (x instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)x;
            }
            if (x instanceof Exception) {
                throw new MBeanRegistrationException((Exception)x);
            }
            if (x instanceof Error) {
                throw new MBeanRegistrationException(new RuntimeErrorException((Error)x));
            }
            throw new ImplementationException();
        }
        if (metadata.mbean instanceof ClassLoader) {
            ClassLoader cl = (ClassLoader)metadata.mbean;
            this.getBaseClassLoaderRepository().addClassLoader(cl);
            BaseClassLoaderRepository dlr = (BaseClassLoaderRepository)MBeanServerImpl.getStaticClassLoaderRepository();
            dlr.addClassLoader(cl);
        }
        metadata.instance = new ObjectInstance(metadata.name, metadata.info.getClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(MBeanMetaData metadata, boolean privileged) throws InstanceAlreadyExistsException {
        MBeanRepository repository;
        metadata.name = this.normalizeObjectName(metadata.name);
        ObjectName objectName = metadata.name;
        if (objectName == null || objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null or a pattern ObjectName"));
        }
        if (objectName.getDomain().equals("JMImplementation") && !privileged) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Domain 'JMImplementation' is reserved for the JMX Agent"));
        }
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            if (repository.get(objectName) != null) {
                throw new InstanceAlreadyExistsException(objectName.toString());
            }
            repository.put(objectName, metadata);
        }
        this.notify(objectName, "JMX.mbean.registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(ObjectName objectName, String notificationType) {
        long sequenceNumber = 0L;
        Class clazz = class$mx4j$server$MBeanServerImpl == null ? (class$mx4j$server$MBeanServerImpl = MBeanServerImpl.class$("mx4j.server.MBeanServerImpl")) : class$mx4j$server$MBeanServerImpl;
        synchronized (clazz) {
            sequenceNumber = m_notifications++;
        }
        this.m_delegate.sendNotification(new MBeanServerNotification(notificationType, (Object)this.m_delegateName, sequenceNumber, objectName));
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if ((objectName = this.secureObjectName(objectName)) == null || objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null or a pattern ObjectName"));
        }
        if (objectName.getDomain().equals("JMImplementation")) {
            throw new MBeanRegistrationException(new RuntimeOperationsException(new IllegalArgumentException("Domain 'JMImplementation' is reserved for the JMX Agent")));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        try {
            MBeanServerInterceptor head = this.getHeadInterceptor();
            head.registration(metadata, 4);
            this.unregister(metadata);
            this.getHeadInterceptor().registration(metadata, 5);
            if (metadata.mbean instanceof ClassLoader) {
                this.getBaseClassLoaderRepository().removeClassLoader((ClassLoader)metadata.mbean);
                BaseClassLoaderRepository dlr = (BaseClassLoaderRepository)MBeanServerImpl.getStaticClassLoaderRepository();
                dlr.removeClassLoader((ClassLoader)metadata.mbean);
            }
        }
        catch (MBeanRegistrationException x) {
            throw x;
        }
        catch (SecurityException x) {
            throw x;
        }
        catch (Exception x) {
            throw new MBeanRegistrationException(x);
        }
        catch (Error x) {
            throw new MBeanRegistrationException(new RuntimeErrorException(x));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(MBeanMetaData metadata) {
        MBeanRepository repository;
        ObjectName objectName = metadata.name;
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            repository.remove(objectName);
        }
        this.notify(objectName, "JMX.mbean.unregistered");
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        if (attribute == null || attribute.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.getHeadInterceptor().getAttribute(metadata, attribute);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null || attribute.getName().trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        this.getHeadInterceptor().setAttribute(metadata, attribute);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (attributes == null || attributes.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute list"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(Utils.createPermissionTargetName(metadata.info.getClassName(), "-", objectName), "getAttribute"));
        }
        return this.getHeadInterceptor().getAttributes(metadata, attributes);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute list"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(Utils.createPermissionTargetName(metadata.info.getClassName(), "-", objectName), "setAttribute"));
        }
        return this.getHeadInterceptor().setAttributes(metadata, attributes);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (methodName == null || methodName.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid operation name"));
        }
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if (parameters == null) {
            parameters = EMPTY_PARAMS;
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.getHeadInterceptor().invoke(metadata, methodName, parameters, args);
    }

    public String getDefaultDomain() {
        return this.m_defaultDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMBeanCount() {
        MBeanRepository repository;
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            return new Integer(repository.size());
        }
    }

    public boolean isRegistered(ObjectName objectName) {
        try {
            return this.findMBeanMetaData(objectName) != null;
        }
        catch (InstanceNotFoundException x) {
            return false;
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        MBeanInfo info = this.getHeadInterceptor().getMBeanInfo(metadata);
        if (info == null) {
            throw new IntrospectionException("MBeanInfo returned by the DynamicMBean " + objectName + " is null");
        }
        return info;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            objectName = this.secureObjectName(objectName);
            sm.checkPermission(new MBeanPermission(Utils.createPermissionTargetName("-", "-", objectName), "getObjectInstance"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return metadata.instance;
    }

    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid class name"));
        }
        objectName = this.secureObjectName(objectName);
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(Utils.createPermissionTargetName(metadata.info.getClassName(), "-", objectName), "isInstanceOf"));
        }
        try {
            Class<?> cls = metadata.classloader.loadClass(className);
            return cls.isInstance(metadata.mbean);
        }
        catch (ClassNotFoundException x) {
            return false;
        }
    }

    public Set queryMBeans(ObjectName patternName, QueryExp filter) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            patternName = this.secureObjectName(patternName);
            sm.checkPermission(new MBeanPermission("-#-[-]", "queryMBeans"));
        }
        Set match = this.queryObjectNames(patternName, filter, true);
        HashSet<ObjectInstance> set = new HashSet<ObjectInstance>();
        Iterator i = match.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            try {
                MBeanMetaData metadata = this.findMBeanMetaData(name);
                set.add(metadata.instance);
            }
            catch (InstanceNotFoundException ignored) {
                // empty catch block
            }
        }
        return set;
    }

    public Set queryNames(ObjectName patternName, QueryExp filter) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            patternName = this.secureObjectName(patternName);
            sm.checkPermission(new MBeanPermission("-#-[-]", "queryNames"));
        }
        return this.queryObjectNames(patternName, filter, false);
    }

    private Set queryObjectNames(ObjectName patternName, QueryExp filter, boolean instances) {
        Set scope = this.findMBeansByPattern(patternName);
        Set secureScope = this.filterMBeansBySecurity(scope, instances);
        Set match = this.filterMBeansByQuery(secureScope, filter);
        return match;
    }

    private Set findMBeansByPattern(ObjectName pattern) {
        if (pattern == null) {
            try {
                pattern = new ObjectName("*:*");
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
        }
        pattern = this.normalizeObjectName(pattern);
        String patternDomain = pattern.getDomain();
        Hashtable patternProps = pattern.getKeyPropertyList();
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        MBeanRepository repository = (MBeanRepository)this.getMBeanRepository().clone();
        Iterator i = repository.iterator();
        while (i.hasNext()) {
            MBeanMetaData metadata = (MBeanMetaData)i.next();
            ObjectName name = metadata.name;
            Hashtable props = name.getKeyPropertyList();
            String domain = name.getDomain();
            if (!Utils.wildcardMatch(patternDomain, domain)) continue;
            if (pattern.isPropertyPattern()) {
                if (patternProps.size() == 0) {
                    set.add(name);
                    continue;
                }
                boolean found = true;
                Iterator j = patternProps.entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry entry = j.next();
                    Object patternKey = entry.getKey();
                    Object patternValue = entry.getValue();
                    if (patternKey.equals("*")) continue;
                    if (!props.containsKey(patternKey)) {
                        found = false;
                        break;
                    }
                    Object value = props.get(patternKey);
                    if (value == null && patternValue == null || value != null && value.equals(patternValue)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                set.add(name);
                continue;
            }
            if (!props.entrySet().equals(patternProps.entrySet())) continue;
            set.add(name);
        }
        return set;
    }

    private Set filterMBeansBySecurity(Set mbeans, boolean instances) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return mbeans;
        }
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        Iterator i = mbeans.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            try {
                MBeanMetaData metadata = this.findMBeanMetaData(name);
                String className = metadata.info.getClassName();
                sm.checkPermission(new MBeanPermission(Utils.createPermissionTargetName(className, "-", name), instances ? "queryMBeans" : "queryNames"));
                set.add(name);
            }
            catch (InstanceNotFoundException ignored) {
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        return set;
    }

    private Set filterMBeansByQuery(Set scope, QueryExp filter) {
        if (filter == null) {
            return scope;
        }
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        Iterator i = scope.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            filter.setMBeanServer(this);
            try {
                if (!filter.apply(name)) continue;
                set.add(name);
            }
            catch (BadStringOperationException ignored) {
            }
            catch (BadBinaryOpValueExpException ignored) {
            }
            catch (BadAttributeValueExpException x) {
            }
            catch (InvalidApplicationException x) {
            }
            catch (SecurityException x) {
                // empty catch block
            }
        }
        return set;
    }

    private ObjectName normalizeObjectName(ObjectName name) {
        block6: {
            if (name == null) {
                return null;
            }
            String defaultDomain = this.getDefaultDomain();
            String domain = name.getDomain();
            if (domain.length() != 0 || defaultDomain.length() <= 0) break block6;
            StringBuffer buffer = new StringBuffer(this.getDefaultDomain()).append(":").append(name.getKeyPropertyListString());
            if (name.isPropertyPattern()) {
                if (name.getKeyPropertyList().size() > 0) {
                    buffer.append(",*");
                } else {
                    buffer.append("*");
                }
            }
            try {
                name = new ObjectName(buffer.toString());
            }
            catch (MalformedObjectNameException ignored) {}
        }
        return name;
    }

    private ObjectName secureObjectName(ObjectName name) {
        if (System.getSecurityManager() == null) {
            return name;
        }
        if (name == null || name.getClass() == (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName)) {
            return name;
        }
        try {
            return new ObjectName(name.getCanonicalName());
        }
        catch (MalformedObjectNameException x) {
            throw new SecurityException(x.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EMPTY_PARAMS = new String[0];
        EMPTY_ARGS = new Object[0];
        m_staticClassLoaderRepository = new DefaultClassLoaderRepository();
    }
}

