/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.javascript;

import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ScriptEditor;
import com.sun.star.script.provider.XScriptContext;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.ScopeProvider;

public class ScriptEditorForJavaScript
implements ScriptEditor {
    private static ScriptEditorForJavaScript theScriptEditorForJavaScript;
    private static String JSTEMPLATE;
    private static Main rhinoWindow;
    private URL scriptURL;
    private static Map BEING_EDITED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptEditorForJavaScript getEditor() {
        if (theScriptEditorForJavaScript == null) {
            Class clazz = ScriptEditorForJavaScript.class;
            synchronized (clazz) {
                if (theScriptEditorForJavaScript == null) {
                    theScriptEditorForJavaScript = new ScriptEditorForJavaScript();
                }
            }
        }
        return theScriptEditorForJavaScript;
    }

    public static ScriptEditorForJavaScript getEditor(URL uRL) {
        return (ScriptEditorForJavaScript)BEING_EDITED.get(uRL);
    }

    public boolean isModified() {
        return rhinoWindow.isModified(this.scriptURL);
    }

    public String getText() {
        return rhinoWindow.getText(this.scriptURL);
    }

    public String getURL() {
        return this.scriptURL.toString();
    }

    public String getTemplate() {
        return JSTEMPLATE;
    }

    public String getExtension() {
        return "js";
    }

    public void edit(XScriptContext xScriptContext, ScriptMetaData scriptMetaData) {
        try {
            String string = scriptMetaData.getParcelLocation();
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            string = string + scriptMetaData.getLanguageName();
            URL uRL = scriptMetaData.getSourceURL();
            if (rhinoWindow != null) {
                ScriptEditorForJavaScript scriptEditorForJavaScript = (ScriptEditorForJavaScript)BEING_EDITED.get(uRL);
                if (scriptEditorForJavaScript == null) {
                    scriptEditorForJavaScript = new ScriptEditorForJavaScript(xScriptContext, uRL);
                    scriptEditorForJavaScript.edit(xScriptContext, scriptMetaData);
                } else {
                    rhinoWindow.showScriptWindow(uRL);
                }
            } else {
                ScriptEditorForJavaScript scriptEditorForJavaScript = new ScriptEditorForJavaScript(xScriptContext, uRL);
            }
            rhinoWindow.toFront();
        }
        catch (IOException iOException) {
            LogUtils.DEBUG((String)("Caught exception: " + iOException));
            LogUtils.DEBUG((String)LogUtils.getTrace((Exception)iOException));
        }
    }

    private ScriptEditorForJavaScript() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptEditorForJavaScript(XScriptContext xScriptContext, URL uRL) {
        this.initUI();
        Scriptable scriptable = this.getScope(xScriptContext);
        rhinoWindow.openFile(uRL, scriptable, (Runnable)new closeHandler(uRL));
        this.scriptURL = uRL;
        Class clazz = ScriptEditorForJavaScript.class;
        synchronized (clazz) {
            BEING_EDITED.put(uRL, this);
        }
    }

    public Object execute() throws Exception {
        rhinoWindow.toFront();
        return rhinoWindow.runScriptWindow(this.scriptURL);
    }

    public void indicateErrorLine(int n) {
        rhinoWindow.toFront();
        rhinoWindow.highlighLineInScriptWindow(this.scriptURL, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        try {
            Class clazz = ScriptEditorForJavaScript.class;
            synchronized (clazz) {
                if (rhinoWindow != null) {
                    return;
                }
                final Main main = new Main("Rhino JavaScript Debugger");
                ScriptEditorForJavaScript.swingInvoke(new Runnable(){

                    public void run() {
                        main.pack();
                        main.setSize(640, 640);
                        main.setVisible(true);
                    }
                });
                main.setExitAction(new Runnable(){

                    public void run() {
                        main.clearAllBreakpoints();
                        main.dispose();
                        ScriptEditorForJavaScript.this.shutdown();
                    }
                });
                Context.addContextListener((ContextListener)main);
                main.setScopeProvider(new ScopeProvider(){

                    public Scriptable getScope() {
                        return org.mozilla.javascript.tools.shell.Main.getScope();
                    }
                });
                main.addWindowListener((WindowListener)new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        ScriptEditorForJavaScript.this.shutdown();
                    }
                });
                rhinoWindow = main;
            }
        }
        catch (Exception exception) {
            LogUtils.DEBUG((String)LogUtils.getTrace((Exception)exception));
        }
    }

    private static void swingInvoke(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            LogUtils.DEBUG((String)LogUtils.getTrace((Exception)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        rhinoWindow = null;
        this.scriptURL = null;
        Map map = BEING_EDITED;
        synchronized (map) {
            Iterator iterator = BEING_EDITED.keySet().iterator();
            Vector<URL> vector = new Vector<URL>();
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                vector.add(uRL);
            }
            for (int i = 0; i < vector.size(); ++i) {
                BEING_EDITED.remove(vector.elementAt(i));
            }
            vector = null;
        }
    }

    private Scriptable getScope(XScriptContext xScriptContext) {
        Context context = Context.enter();
        ImporterTopLevel importerTopLevel = new ImporterTopLevel(context);
        Scriptable scriptable = Context.toObject((Object)xScriptContext, (Scriptable)importerTopLevel);
        importerTopLevel.put("XSCRIPTCONTEXT", (Scriptable)importerTopLevel, (Object)scriptable);
        Scriptable scriptable2 = Context.toObject((Object)new Object[0], (Scriptable)importerTopLevel);
        importerTopLevel.put("ARGUMENTS", (Scriptable)importerTopLevel, (Object)scriptable2);
        Context.exit();
        return importerTopLevel;
    }

    static {
        BEING_EDITED = new HashMap();
        try {
            URL uRL = ScriptEditorForJavaScript.class.getResource("template.js");
            InputStream inputStream = uRL.openStream();
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            inputStream.close();
            JSTEMPLATE = stringBuffer.toString();
        }
        catch (IOException iOException) {
            JSTEMPLATE = "// JavaScript script";
        }
        catch (Exception exception) {
            JSTEMPLATE = "// JavaScript script";
        }
    }

    class closeHandler
    implements Runnable {
        URL url;

        closeHandler(URL uRL) {
            this.url = uRL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = BEING_EDITED;
            synchronized (map) {
                Object v = BEING_EDITED.remove(this.url);
            }
        }
    }
}

