/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PdbHeader;
import org.openoffice.xmerge.converter.palm.Record;

public final class PdbDecoder {
    public PalmDB parse(String string) throws IOException {
        Object object;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        PdbHeader pdbHeader = new PdbHeader();
        pdbHeader.read(randomAccessFile);
        Record[] recordArray = new Record[pdbHeader.numRecords];
        if (pdbHeader.numRecords != 0) {
            int n;
            object = new int[pdbHeader.numRecords];
            byte[] byArray = new byte[pdbHeader.numRecords];
            for (n = 0; n < pdbHeader.numRecords; ++n) {
                object[n] = randomAccessFile.readInt();
                int n2 = randomAccessFile.readInt();
                byArray[n] = (byte)(n2 >>> 24);
            }
            n = 0;
            byte[] byArray2 = null;
            int n3 = pdbHeader.numRecords - 1;
            for (int i = 0; i < n3; ++i) {
                randomAccessFile.seek(object[i]);
                n = object[i + 1] - object[i];
                byArray2 = new byte[n];
                randomAccessFile.readFully(byArray2);
                recordArray[i] = new Record(byArray2, byArray[i]);
            }
            randomAccessFile.seek(object[n3]);
            n = (int)randomAccessFile.length() - object[n3];
            byArray2 = new byte[n];
            randomAccessFile.readFully(byArray2);
            recordArray[n3] = new Record(byArray2, byArray[n3]);
        }
        randomAccessFile.close();
        object = new PalmDB(pdbHeader.pdbName, pdbHeader.creatorID, pdbHeader.typeID, pdbHeader.version, pdbHeader.attribute, recordArray);
        return object;
    }

    public PalmDB parse(byte[] byArray) throws IOException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        PdbHeader pdbHeader = new PdbHeader();
        pdbHeader.read(dataInputStream);
        Record[] recordArray = new Record[pdbHeader.numRecords];
        if (pdbHeader.numRecords != 0) {
            int n;
            object = new int[pdbHeader.numRecords];
            byte[] byArray2 = new byte[pdbHeader.numRecords];
            for (n = 0; n < pdbHeader.numRecords; ++n) {
                object[n] = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                byArray2[n] = (byte)(n2 >>> 24);
            }
            n = 0;
            byte[] byArray3 = null;
            int n3 = pdbHeader.numRecords - 1;
            for (int i = 0; i < n3; ++i) {
                dataInputStream.reset();
                dataInputStream.skip(object[i]);
                n = object[i + 1] - object[i];
                byArray3 = new byte[n];
                dataInputStream.readFully(byArray3);
                recordArray[i] = new Record(byArray3, byArray2[i]);
            }
            dataInputStream.reset();
            n = dataInputStream.available() - object[n3];
            dataInputStream.skip(object[n3]);
            byArray3 = new byte[n];
            dataInputStream.readFully(byArray3);
            recordArray[n3] = new Record(byArray3, byArray2[n3]);
        }
        object = new PalmDB(pdbHeader.pdbName, pdbHeader.creatorID, pdbHeader.typeID, pdbHeader.version, pdbHeader.attribute, recordArray);
        return object;
    }
}

