%% Generated by the Erlang ASN.1 BER_V2-compiler version, utilizing bit-syntax:1.4.4.12
%% Purpose: encoder and decoder to the types in mod SSL-PKIX

-module('SSL-PKIX').
-include("SSL-PKIX.hrl").
-define('RT_BER',asn1rt_ber_bin_v2).
-export([encoding_rule/0]).
-export([
'enc_Certificate'/2,
'enc_TBSCertificate'/2,
'enc_AttributeTypeAndValue'/2,
'enc_SubjectPublicKeyInfo'/2,
'enc_SubjectPublicKeyInfo-Any'/2,
'enc_SignatureAlgorithm'/2,
'enc_SignatureAlgorithm-Any'/2,
'enc_PublicKeyAlgorithm'/2,
'enc_KEA-PublicKey'/2,
'enc_FieldID'/2,
'enc_Characteristic-two'/2,
'enc_ExtensionAttributes'/2,
'enc_ExtensionAttribute'/2,
'enc_Extensions'/2,
'enc_Extension'/2,
'enc_ObjId'/2,
'enc_Boolean'/2,
'enc_Any'/2,
'enc_Extension-Any'/2
]).

-export([
'dec_Certificate'/2,
'dec_TBSCertificate'/2,
'dec_AttributeTypeAndValue'/2,
'dec_SubjectPublicKeyInfo'/2,
'dec_SubjectPublicKeyInfo-Any'/2,
'dec_SignatureAlgorithm'/2,
'dec_SignatureAlgorithm-Any'/2,
'dec_PublicKeyAlgorithm'/2,
'dec_KEA-PublicKey'/2,
'dec_FieldID'/2,
'dec_Characteristic-two'/2,
'dec_ExtensionAttributes'/2,
'dec_ExtensionAttribute'/2,
'dec_Extensions'/2,
'dec_Extension'/2,
'dec_ObjId'/2,
'dec_Boolean'/2,
'dec_Any'/2,
'dec_Extension-Any'/2
]).

-export([
'enc_name'/3,
'enc_surname'/3,
'enc_givenName'/3,
'enc_initials'/3,
'enc_generationQualifier'/3,
'enc_commonName'/3,
'enc_localityName'/3,
'enc_stateOrProvinceName'/3,
'enc_organizationName'/3,
'enc_organizationalUnitName'/3,
'enc_title'/3,
'enc_dnQualifier'/3,
'enc_countryName'/3,
'enc_serialNumber'/3,
'enc_pseudonym'/3,
'enc_domainComponent'/3,
'enc_emailAddress'/3,
'enc_dsa'/3,
'enc_dsa-with-sha1'/3,
'enc_md2-with-rsa-encryption'/3,
'enc_md5-with-rsa-encryption'/3,
'enc_sha1-with-rsa-encryption'/3,
'enc_rsa-encryption'/3,
'enc_dh'/3,
'enc_kea'/3,
'enc_ecdsa-with-sha1'/3,
'enc_field-prime-field'/3,
'enc_field-characteristic-two'/3,
'enc_gn-basis'/3,
'enc_tp-basis'/3,
'enc_pp-basis'/3,
'enc_ec-public-key'/3,
'enc_x400-common-name'/3,
'enc_x400-teletex-common-name'/3,
'enc_x400-teletex-personal-name'/3,
'enc_x400-pds-name'/3,
'enc_x400-physical-delivery-country-name'/3,
'enc_x400-postal-code'/3,
'enc_x400-physical-delivery-office-name'/3,
'enc_x400-physical-delivery-office-number'/3,
'enc_x400-extension-OR-address-components'/3,
'enc_x400-physical-delivery-personal-name'/3,
'enc_x400-physical-delivery-organization-name'/3,
'enc_x400-extension-physical-delivery-address-components'/3,
'enc_x400-unformatted-postal-address'/3,
'enc_x400-street-address'/3,
'enc_x400-post-office-box-address'/3,
'enc_x400-poste-restante-address'/3,
'enc_x400-unique-postal-name'/3,
'enc_x400-local-postal-attributes'/3,
'enc_x400-extended-network-address'/3,
'enc_x400-terminal-type'/3,
'enc_x400-teletex-domain-defined-attributes'/3,
'enc_authorityKeyIdentifier'/3,
'enc_subjectKeyIdentifier'/3,
'enc_keyUsage'/3,
'enc_privateKeyUsagePeriod'/3,
'enc_certificatePolicies'/3,
'enc_policyMappings'/3,
'enc_subjectAltName'/3,
'enc_issuerAltName'/3,
'enc_subjectDirectoryAttributes'/3,
'enc_basicConstraints'/3,
'enc_nameConstraints'/3,
'enc_policyConstraints'/3,
'enc_cRLDistributionPoints'/3,
'enc_extKeyUsage'/3,
'enc_inhibitAnyPolicy'/3,
'enc_freshestCRL'/3,
'enc_authorityInfoAccess'/3,
'enc_subjectInfoAccess'/3,
'enc_cRLNumber'/3,
'enc_issuingDistributionPoint'/3,
'enc_deltaCRLIndicator'/3,
'enc_cRLReasons'/3,
'enc_certificateIssuer'/3,
'enc_holdInstructionCode'/3,
'enc_invalidityDate'/3
]).

-export([
'dec_name'/3,
'dec_surname'/3,
'dec_givenName'/3,
'dec_initials'/3,
'dec_generationQualifier'/3,
'dec_commonName'/3,
'dec_localityName'/3,
'dec_stateOrProvinceName'/3,
'dec_organizationName'/3,
'dec_organizationalUnitName'/3,
'dec_title'/3,
'dec_dnQualifier'/3,
'dec_countryName'/3,
'dec_serialNumber'/3,
'dec_pseudonym'/3,
'dec_domainComponent'/3,
'dec_emailAddress'/3,
'dec_dsa'/3,
'dec_dsa-with-sha1'/3,
'dec_md2-with-rsa-encryption'/3,
'dec_md5-with-rsa-encryption'/3,
'dec_sha1-with-rsa-encryption'/3,
'dec_rsa-encryption'/3,
'dec_dh'/3,
'dec_kea'/3,
'dec_ecdsa-with-sha1'/3,
'dec_field-prime-field'/3,
'dec_field-characteristic-two'/3,
'dec_gn-basis'/3,
'dec_tp-basis'/3,
'dec_pp-basis'/3,
'dec_ec-public-key'/3,
'dec_x400-common-name'/3,
'dec_x400-teletex-common-name'/3,
'dec_x400-teletex-personal-name'/3,
'dec_x400-pds-name'/3,
'dec_x400-physical-delivery-country-name'/3,
'dec_x400-postal-code'/3,
'dec_x400-physical-delivery-office-name'/3,
'dec_x400-physical-delivery-office-number'/3,
'dec_x400-extension-OR-address-components'/3,
'dec_x400-physical-delivery-personal-name'/3,
'dec_x400-physical-delivery-organization-name'/3,
'dec_x400-extension-physical-delivery-address-components'/3,
'dec_x400-unformatted-postal-address'/3,
'dec_x400-street-address'/3,
'dec_x400-post-office-box-address'/3,
'dec_x400-poste-restante-address'/3,
'dec_x400-unique-postal-name'/3,
'dec_x400-local-postal-attributes'/3,
'dec_x400-extended-network-address'/3,
'dec_x400-terminal-type'/3,
'dec_x400-teletex-domain-defined-attributes'/3,
'dec_authorityKeyIdentifier'/3,
'dec_subjectKeyIdentifier'/3,
'dec_keyUsage'/3,
'dec_privateKeyUsagePeriod'/3,
'dec_certificatePolicies'/3,
'dec_policyMappings'/3,
'dec_subjectAltName'/3,
'dec_issuerAltName'/3,
'dec_subjectDirectoryAttributes'/3,
'dec_basicConstraints'/3,
'dec_nameConstraints'/3,
'dec_policyConstraints'/3,
'dec_cRLDistributionPoints'/3,
'dec_extKeyUsage'/3,
'dec_inhibitAnyPolicy'/3,
'dec_freshestCRL'/3,
'dec_authorityInfoAccess'/3,
'dec_subjectInfoAccess'/3,
'dec_cRLNumber'/3,
'dec_issuingDistributionPoint'/3,
'dec_deltaCRLIndicator'/3,
'dec_cRLReasons'/3,
'dec_certificateIssuer'/3,
'dec_holdInstructionCode'/3,
'dec_invalidityDate'/3
]).

-export([
'getenc_SupportedAttributeTypeAndValues'/2,
'getenc_SupportedSignatureAlgorithms'/2,
'getenc_SupportedPublicKeyAlgorithms'/2,
'getenc_SupportedFieldIds'/2,
'getenc_SupportedCharacteristicTwos'/2,
'getenc_SupportedExtensionAttributes'/2,
'getenc_SupportedExtensions'/2
]).

-export([
'getdec_SupportedAttributeTypeAndValues'/2,
'getdec_SupportedSignatureAlgorithms'/2,
'getdec_SupportedPublicKeyAlgorithms'/2,
'getdec_SupportedFieldIds'/2,
'getdec_SupportedCharacteristicTwos'/2,
'getdec_SupportedExtensionAttributes'/2,
'getdec_SupportedExtensions'/2
]).

-export([info/0]).


-export([encode/2,decode/2,encode_disp/2,decode_disp/2]).

encoding_rule() ->
   ber_bin_v2.

encode(Type,Data) ->
case catch encode_disp(Type,Data) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {Bytes,_Len} ->
    {ok,Bytes};
  Bytes ->
    {ok,Bytes}
end.

decode(Type,Data) ->
case catch decode_disp(Type,element(1,?RT_BER:decode(Data))
) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  Result ->
    {ok,Result}
end.

encode_disp('Certificate',Data) -> 'enc_Certificate'(Data);
encode_disp('TBSCertificate',Data) -> 'enc_TBSCertificate'(Data);
encode_disp('AttributeTypeAndValue',Data) -> 'enc_AttributeTypeAndValue'(Data);
encode_disp('SubjectPublicKeyInfo',Data) -> 'enc_SubjectPublicKeyInfo'(Data);
encode_disp('SubjectPublicKeyInfo-Any',Data) -> 'enc_SubjectPublicKeyInfo-Any'(Data);
encode_disp('SignatureAlgorithm',Data) -> 'enc_SignatureAlgorithm'(Data);
encode_disp('SignatureAlgorithm-Any',Data) -> 'enc_SignatureAlgorithm-Any'(Data);
encode_disp('PublicKeyAlgorithm',Data) -> 'enc_PublicKeyAlgorithm'(Data);
encode_disp('KEA-PublicKey',Data) -> 'enc_KEA-PublicKey'(Data);
encode_disp('FieldID',Data) -> 'enc_FieldID'(Data);
encode_disp('Characteristic-two',Data) -> 'enc_Characteristic-two'(Data);
encode_disp('ExtensionAttributes',Data) -> 'enc_ExtensionAttributes'(Data);
encode_disp('ExtensionAttribute',Data) -> 'enc_ExtensionAttribute'(Data);
encode_disp('Extensions',Data) -> 'enc_Extensions'(Data);
encode_disp('Extension',Data) -> 'enc_Extension'(Data);
encode_disp('ObjId',Data) -> 'enc_ObjId'(Data);
encode_disp('Boolean',Data) -> 'enc_Boolean'(Data);
encode_disp('Any',Data) -> 'enc_Any'(Data);
encode_disp('Extension-Any',Data) -> 'enc_Extension-Any'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('Certificate',Data) -> 'dec_Certificate'(Data);
decode_disp('TBSCertificate',Data) -> 'dec_TBSCertificate'(Data);
decode_disp('AttributeTypeAndValue',Data) -> 'dec_AttributeTypeAndValue'(Data);
decode_disp('SubjectPublicKeyInfo',Data) -> 'dec_SubjectPublicKeyInfo'(Data);
decode_disp('SubjectPublicKeyInfo-Any',Data) -> 'dec_SubjectPublicKeyInfo-Any'(Data);
decode_disp('SignatureAlgorithm',Data) -> 'dec_SignatureAlgorithm'(Data);
decode_disp('SignatureAlgorithm-Any',Data) -> 'dec_SignatureAlgorithm-Any'(Data);
decode_disp('PublicKeyAlgorithm',Data) -> 'dec_PublicKeyAlgorithm'(Data);
decode_disp('KEA-PublicKey',Data) -> 'dec_KEA-PublicKey'(Data);
decode_disp('FieldID',Data) -> 'dec_FieldID'(Data);
decode_disp('Characteristic-two',Data) -> 'dec_Characteristic-two'(Data);
decode_disp('ExtensionAttributes',Data) -> 'dec_ExtensionAttributes'(Data);
decode_disp('ExtensionAttribute',Data) -> 'dec_ExtensionAttribute'(Data);
decode_disp('Extensions',Data) -> 'dec_Extensions'(Data);
decode_disp('Extension',Data) -> 'dec_Extension'(Data);
decode_disp('ObjId',Data) -> 'dec_ObjId'(Data);
decode_disp('Boolean',Data) -> 'dec_Boolean'(Data);
decode_disp('Any',Data) -> 'dec_Any'(Data);
decode_disp('Extension-Any',Data) -> 'dec_Extension-Any'(Data);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).





info() ->
  [{vsn,'1.4.4.12'},   {module,'SSL-PKIX'},   {options,[ber_bin_v2,
 report_errors,
 {cwd,"/usr/obj/ports/erlang-11b.3/otp_src_R11B-3/lib/ssl/pkix"},
 {outdir,"/usr/obj/ports/erlang-11b.3/otp_src_R11B-3/lib/ssl/pkix"},
 noobj,
 optimize,
 compact_bit_string,
 der,
 {i,"."},
 {i,"/usr/obj/ports/erlang-11b.3/otp_src_R11B-3/lib/ssl/pkix"}]}].


%%================================
%%  Certificate
%%================================
'enc_Certificate'(Val) ->
    'enc_Certificate'(Val, [<<48>>]).

'enc_Certificate'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External SSL-PKIX:TBSCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSCertificate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External SSL-PKIX:SignatureAlgorithm
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignatureAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_bit_string([], Cindex3, [], [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Certificate'(Tlv) ->
   'dec_Certificate'(Tlv, [16]).

'dec_Certificate'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External SSL-PKIX:TBSCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSCertificate'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External SSL-PKIX:SignatureAlgorithm
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignatureAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = ?RT_BER:decode_compact_bit_string(V3,[],[],[3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'Certificate', Term1, Term2, Term3}.



%%================================
%%  TBSCertificate
%%================================
'enc_TBSCertificate'(Val) ->
    'enc_TBSCertificate'(Val, [<<48>>]).

'enc_TBSCertificate'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6, Cindex7, Cindex8, Cindex9, Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case catch asn1rt_check:check_int(0, Cindex1, [{v1,0},{v2,1},{v3,2}]) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_integer([], Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_integer([], Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute signature(3)   External SSL-PKIX:SignatureAlgorithm
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_SignatureAlgorithm'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(4)   External PKIX1Explicit88:Name
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'PKIX1Explicit88':'enc_Name'(Cindex4, []),

%%-------------------------------------------------
%% attribute validity(5)   External PKIX1Explicit88:Validity
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'PKIX1Explicit88':'enc_Validity'(Cindex5, [<<48>>]),

%%-------------------------------------------------
%% attribute subject(6)   External PKIX1Explicit88:Name
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'PKIX1Explicit88':'enc_Name'(Cindex6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External SSL-PKIX:SubjectPublicKeyInfo
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_SubjectPublicKeyInfo'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex8, [], [<<129>>])
       end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex9, [], [<<130>>])
       end,

%%-------------------------------------------------
%% attribute extensions(10)   External SSL-PKIX:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Extensions'(Cindex10, [<<48>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TBSCertificate'(Tlv) ->
   'dec_TBSCertificate'(Tlv, [16]).

'dec_TBSCertificate'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {?RT_BER:decode_integer(V1,[],[{v1,0},{v2,1},{v3,2}],[2]), TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_integer(V2,[],[2]),

%%-------------------------------------------------
%% attribute signature(3)   External SSL-PKIX:SignatureAlgorithm
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_SignatureAlgorithm'(V3, [16]),

%%-------------------------------------------------
%% attribute issuer(4)   External PKIX1Explicit88:Name
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'PKIX1Explicit88':'dec_Name'(V4, []),

%%-------------------------------------------------
%% attribute validity(5)   External PKIX1Explicit88:Validity
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'PKIX1Explicit88':'dec_Validity'(V5, [16]),

%%-------------------------------------------------
%% attribute subject(6)   External PKIX1Explicit88:Name
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'PKIX1Explicit88':'dec_Name'(V6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External SSL-PKIX:SubjectPublicKeyInfo
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_SubjectPublicKeyInfo'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131073,V8}|TempTlv9] ->
    {?RT_BER:decode_compact_bit_string(V8,[],[],[]), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131074,V9}|TempTlv10] ->
    {?RT_BER:decode_compact_bit_string(V9,[],[],[]), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute extensions(10)   External SSL-PKIX:Extensions OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131075,V10}|TempTlv11] ->
    {'dec_Extensions'(V10, [16]), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

case Tlv11 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv11}}}) % extra fields not allowed
end,
   {'TBSCertificate', Term1, Term2, Term3, Term4, Term5, Term6, Term7, Term8, Term9, Term10}.



%%================================
%%  AttributeTypeAndValue
%%================================
'enc_AttributeTypeAndValue'(Val) ->
    'enc_AttributeTypeAndValue'(Val, [<<48>>]).

'enc_AttributeTypeAndValue'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,
Objtype = 
   'getenc_SupportedAttributeTypeAndValues'(id, 
                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes1,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(TmpBytes1,[]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AttributeTypeAndValue'(Tlv) ->
   'dec_AttributeTypeAndValue'(Tlv, [16]).

'dec_AttributeTypeAndValue'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute type(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = ?RT_BER:decode_open_type(V2,[]),

DecObjtypeTerm1 =
   'getdec_SupportedAttributeTypeAndValues'(id, Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'AttributeTypeAndValue', Term1, Term2}.



%%================================
%%  SubjectPublicKeyInfo
%%================================
'enc_SubjectPublicKeyInfo'(Val) ->
    'enc_SubjectPublicKeyInfo'(Val, [<<48>>]).

'enc_SubjectPublicKeyInfo'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,
Objalgorithm = 
   'getenc_SupportedPublicKeyAlgorithms'(id, 
                                   element(2,Cindex1)),

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_SubjectPublicKeyInfo_algorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type typefieldPublicKeyType
%%-------------------------------------------------
   {TmpBytes1,_} = Objalgorithm('PublicKeyType', Cindex2, []),
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(TmpBytes1,[]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SubjectPublicKeyInfo_algorithm
%%================================
'enc_SubjectPublicKeyInfo_algorithm'(Val, TagIn) ->
   {_,Cindex1, Cindex2} = Val,
Objalgo = 
   'getenc_SupportedPublicKeyAlgorithms'(id, 
                                   Cindex1),

%%-------------------------------------------------
%% attribute algo(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes,_ } = Objalgo('Type', Cindex2, []),
   {TmpBytes1,TmpLen} = ?RT_BER:encode_open_type(TmpBytes,[]),
   {TmpBytes1, TmpLen}
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).
'dec_SubjectPublicKeyInfo_algorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute algo(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {?RT_BER:decode_open_type(V2,[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgoTerm1 =
   'getdec_SupportedPublicKeyAlgorithms'(id, Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgoTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'SubjectPublicKeyInfo_algorithm', Term1, Term2}.



'dec_SubjectPublicKeyInfo'(Tlv) ->
   'dec_SubjectPublicKeyInfo'(Tlv, [16]).

'dec_SubjectPublicKeyInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_SubjectPublicKeyInfo_algorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type typefieldPublicKeyType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = ?RT_BER:decode_open_type(V2,[]),

DecObjalgorithmTerm1 =
   'getdec_SupportedPublicKeyAlgorithms'(id, element(2,Term1)),
Term2 = 
   case (catch DecObjalgorithmTerm1('PublicKeyType', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'SubjectPublicKeyInfo', Term1, Term2}.



%%================================
%%  SubjectPublicKeyInfo-Any
%%================================
'enc_SubjectPublicKeyInfo-Any'(Val) ->
    'enc_SubjectPublicKeyInfo-Any'(Val, [<<48>>]).

'enc_SubjectPublicKeyInfo-Any'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1)   External SSL-PKIX:PublicKeyAlgorithm
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PublicKeyAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SubjectPublicKeyInfo-Any'(Tlv) ->
   'dec_SubjectPublicKeyInfo-Any'(Tlv, [16]).

'dec_SubjectPublicKeyInfo-Any'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute algorithm(1)   External SSL-PKIX:PublicKeyAlgorithm
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PublicKeyAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_open_type_as_binary(V2,[]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'SubjectPublicKeyInfo-Any', Term1, Term2}.



%%================================
%%  SignatureAlgorithm
%%================================
'enc_SignatureAlgorithm'(Val) ->
    'enc_SignatureAlgorithm'(Val, [<<48>>]).

'enc_SignatureAlgorithm'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,
Objalgorithm = 
   'getenc_SupportedSignatureAlgorithms'(id, 
                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes,_ } = Objalgorithm('Type', Cindex2, []),
   {TmpBytes1,TmpLen} = ?RT_BER:encode_open_type(TmpBytes,[]),
   {TmpBytes1, TmpLen}
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SignatureAlgorithm'(Tlv) ->
   'dec_SignatureAlgorithm'(Tlv, [16]).

'dec_SignatureAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute algorithm(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {?RT_BER:decode_open_type(V2,[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'getdec_SupportedSignatureAlgorithms'(id, Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'SignatureAlgorithm', Term1, Term2}.



%%================================
%%  SignatureAlgorithm-Any
%%================================
'enc_SignatureAlgorithm-Any'(Val) ->
    'enc_SignatureAlgorithm-Any'(Val, [<<48>>]).

'enc_SignatureAlgorithm-Any'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_open_type(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SignatureAlgorithm-Any'(Tlv) ->
   'dec_SignatureAlgorithm-Any'(Tlv, [16]).

'dec_SignatureAlgorithm-Any'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute parameters(2) with type ASN1_OPEN_TYPE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {?RT_BER:decode_open_type_as_binary(V2,[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'SignatureAlgorithm-Any', Term1, Term2}.



%%================================
%%  PublicKeyAlgorithm
%%================================
'enc_PublicKeyAlgorithm'(Val) ->
    'enc_PublicKeyAlgorithm'(Val, [<<48>>]).

'enc_PublicKeyAlgorithm'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,
Objalgorithm = 
   'getenc_SupportedPublicKeyAlgorithms'(id, 
                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes,_ } = Objalgorithm('Type', Cindex2, []),
   {TmpBytes1,TmpLen} = ?RT_BER:encode_open_type(TmpBytes,[]),
   {TmpBytes1, TmpLen}
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PublicKeyAlgorithm'(Tlv) ->
   'dec_PublicKeyAlgorithm'(Tlv, [16]).

'dec_PublicKeyAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute algorithm(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {?RT_BER:decode_open_type(V2,[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'getdec_SupportedPublicKeyAlgorithms'(id, Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'PublicKeyAlgorithm', Term1, Term2}.



%%================================
%%  KEA-PublicKey
%%================================
'enc_KEA-PublicKey'(Val) ->
    'enc_KEA-PublicKey'(Val, [<<2>>]).


'enc_KEA-PublicKey'({'KEA-PublicKey',Val}, TagIn) ->
   'enc_KEA-PublicKey'(Val, TagIn);

'enc_KEA-PublicKey'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn).


'dec_KEA-PublicKey'(Tlv) ->
   'dec_KEA-PublicKey'(Tlv, [2]).

'dec_KEA-PublicKey'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,[],TagIn).



%%================================
%%  FieldID
%%================================
'enc_FieldID'(Val) ->
    'enc_FieldID'(Val, [<<48>>]).

'enc_FieldID'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,
ObjfieldType = 
   'getenc_SupportedFieldIds'(id, 
                                   Cindex1),

%%-------------------------------------------------
%% attribute fieldType(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes1,_} = ObjfieldType('Type', Cindex2, []),
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(TmpBytes1,[]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_FieldID'(Tlv) ->
   'dec_FieldID'(Tlv, [16]).

'dec_FieldID'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute fieldType(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = ?RT_BER:decode_open_type(V2,[]),

DecObjfieldTypeTerm1 =
   'getdec_SupportedFieldIds'(id, Term1),
Term2 = 
   case (catch DecObjfieldTypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'FieldID', Term1, Term2}.



%%================================
%%  Characteristic-two
%%================================
'enc_Characteristic-two'(Val) ->
    'enc_Characteristic-two'(Val, [<<48>>]).

'enc_Characteristic-two'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,
Objbasis = 
   'getenc_SupportedCharacteristicTwos'(id, 
                                   Cindex2),

%%-------------------------------------------------
%% attribute m(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_integer([], Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute basis(2) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_object_identifier(Cindex2, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(3) with type typefieldType
%%-------------------------------------------------
   {TmpBytes1,_} = Objbasis('Type', Cindex3, []),
   {EncBytes3,EncLen3} = ?RT_BER:encode_open_type(TmpBytes1,[]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Characteristic-two'(Tlv) ->
   'dec_Characteristic-two'(Tlv, [16]).

'dec_Characteristic-two'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute m(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_integer(V1,[],[2]),

%%-------------------------------------------------
%% attribute basis(2) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_object_identifier(V2,[6]),

%%-------------------------------------------------
%% attribute parameters(3) with type typefieldType
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 

  Tmpterm1 = ?RT_BER:decode_open_type(V3,[]),

DecObjbasisTerm2 =
   'getdec_SupportedCharacteristicTwos'(id, Term2),
Term3 = 
   case (catch DecObjbasisTerm2('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'Characteristic-two', Term1, Term2, Term3}.



%%================================
%%  ExtensionAttributes
%%================================
'enc_ExtensionAttributes'(Val) ->
    'enc_ExtensionAttributes'(Val, [<<49>>]).


'enc_ExtensionAttributes'({'ExtensionAttributes',Val}, TagIn) ->
   'enc_ExtensionAttributes'(Val, TagIn);

'enc_ExtensionAttributes'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttributes_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtensionAttributes_components'([], AccBytes, AccLen) -> 
   {asn1rt_check:dynamicsort_SETOF(AccBytes),AccLen};

'enc_ExtensionAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ExtensionAttribute'(H, [<<48>>]),
   'enc_ExtensionAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ExtensionAttributes'(Tlv) ->
   'dec_ExtensionAttributes'(Tlv, [17]).

'dec_ExtensionAttributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_ExtensionAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ExtensionAttribute
%%================================
'enc_ExtensionAttribute'(Val) ->
    'enc_ExtensionAttribute'(Val, [<<48>>]).

'enc_ExtensionAttribute'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,
ObjextensionAttributeType = 
   'getenc_SupportedExtensionAttributes'(id, 
                                   Cindex1),

%%-------------------------------------------------
%% attribute extensionAttributeType(1) with type fixedtypevaluefieldidtypetagUNIVERSAL2IMPLICIT0INTEGERno
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_integer([], Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute extensionAttributeValue(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes1,_} = ObjextensionAttributeType('Type', Cindex2, []),
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(TmpBytes1,[<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ExtensionAttribute'(Tlv) ->
   'dec_ExtensionAttribute'(Tlv, [16]).

'dec_ExtensionAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute extensionAttributeType(1) with type fixedtypevaluefieldidtypetagUNIVERSAL2IMPLICIT0INTEGERno
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_integer(V1,[],[131072]),

%%-------------------------------------------------
%% attribute extensionAttributeValue(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = ?RT_BER:decode_open_type(V2,[131073]),

DecObjextensionAttributeTypeTerm1 =
   'getdec_SupportedExtensionAttributes'(id, Term1),
Term2 = 
   case (catch DecObjextensionAttributeTypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'ExtensionAttribute', Term1, Term2}.



%%================================
%%  Extensions
%%================================
'enc_Extensions'(Val) ->
    'enc_Extensions'(Val, [<<48>>]).


'enc_Extensions'({'Extensions',Val}, TagIn) ->
   'enc_Extensions'(Val, TagIn);

'enc_Extensions'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Extensions_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_Extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Extension'(H, [<<48>>]),
   'enc_Extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_Extensions'(Tlv) ->
   'dec_Extensions'(Tlv, [16]).

'dec_Extensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_Extension'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  Extension
%%================================
'enc_Extension'(Val) ->
    'enc_Extension'(Val, [<<48>>]).

'enc_Extension'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,
ObjextnID = 
   'getenc_SupportedExtensions'(id, 
                                   Cindex1),

%%-------------------------------------------------
%% attribute extnID(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case catch asn1rt_check:check_bool(false, Cindex2) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type typefieldType
%%-------------------------------------------------
   {TmpBytes1,_} = ObjextnID('Type', Cindex3, []),
   {EncBytes3,EncLen3} = ?RT_BER:encode_open_type(TmpBytes1,[]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Extension'(Tlv) ->
   'dec_Extension'(Tlv, [16]).

'dec_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute extnID(1) with type fixedtypevaluefieldidtypetagUNIVERSAL6IMPLICIT0OBJECT IDENTIFIERno
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {?RT_BER:decode_boolean(V2,[]), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type typefieldType
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 

  Tmpterm1 = ?RT_BER:decode_open_type(V3,[]),

DecObjextnIDTerm1 =
   'getdec_SupportedExtensions'(id, Term1),
Term3 = 
   case (catch DecObjextnIDTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'Extension', Term1, Term2, Term3}.



%%================================
%%  ObjId
%%================================
'enc_ObjId'(Val) ->
    'enc_ObjId'(Val, [<<6>>]).


'enc_ObjId'({'ObjId',Val}, TagIn) ->
   'enc_ObjId'(Val, TagIn);

'enc_ObjId'(Val, TagIn) ->
?RT_BER:encode_object_identifier(Val, TagIn).


'dec_ObjId'(Tlv) ->
   'dec_ObjId'(Tlv, [6]).

'dec_ObjId'(Tlv, TagIn) ->
?RT_BER:decode_object_identifier(Tlv,TagIn).



%%================================
%%  Boolean
%%================================
'enc_Boolean'(Val) ->
    'enc_Boolean'(Val, [<<1>>]).


'enc_Boolean'({'Boolean',Val}, TagIn) ->
   'enc_Boolean'(Val, TagIn);

'enc_Boolean'(Val, TagIn) ->
?RT_BER:encode_boolean(Val, TagIn).


'dec_Boolean'(Tlv) ->
   'dec_Boolean'(Tlv, [1]).

'dec_Boolean'(Tlv, TagIn) ->
?RT_BER:decode_boolean(Tlv,TagIn).



%%================================
%%  Any
%%================================
'enc_Any'(Val) ->
    'enc_Any'(Val, []).


'enc_Any'({'Any',Val}, TagIn) ->
   'enc_Any'(Val, TagIn);

'enc_Any'(Val, TagIn) ->
%% OPEN TYPE
?RT_BER:encode_open_type(Val, TagIn).


'dec_Any'(Tlv) ->
   'dec_Any'(Tlv, []).

'dec_Any'(Tlv, TagIn) ->
?RT_BER:decode_open_type_as_binary(Tlv,TagIn).



%%================================
%%  Extension-Any
%%================================
'enc_Extension-Any'(Val) ->
    'enc_Extension-Any'(Val, [<<48>>]).

'enc_Extension-Any'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case catch asn1rt_check:check_bool(false, Cindex2) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_open_type(Cindex3, []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Extension-Any'(Tlv) ->
   'dec_Extension-Any'(Tlv, [16]).

'dec_Extension-Any'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {?RT_BER:decode_boolean(V2,[]), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = ?RT_BER:decode_open_type_as_binary(V3,[]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'Extension-Any', Term1, Term2, Term3}.




%%================================
%%  name
%%================================
'enc_name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520name'(Val, []).


'dec_name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520name'(Tlv, []).

tlv_format(Bytes) when binary(Bytes) ->
  {Tlv,_}=?RT_BER:decode(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  surname
%%================================
'enc_surname'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520name'(Val, []).


'dec_surname'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520name'(Tlv, []).




%%================================
%%  givenName
%%================================
'enc_givenName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520name'(Val, []).


'dec_givenName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520name'(Tlv, []).




%%================================
%%  initials
%%================================
'enc_initials'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520name'(Val, []).


'dec_initials'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520name'(Tlv, []).




%%================================
%%  generationQualifier
%%================================
'enc_generationQualifier'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520name'(Val, []).


'dec_generationQualifier'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520name'(Tlv, []).




%%================================
%%  commonName
%%================================
'enc_commonName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520CommonName'(Val, []).


'dec_commonName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520CommonName'(Tlv, []).




%%================================
%%  localityName
%%================================
'enc_localityName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520LocalityName'(Val, []).


'dec_localityName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520LocalityName'(Tlv, []).




%%================================
%%  stateOrProvinceName
%%================================
'enc_stateOrProvinceName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520StateOrProvinceName'(Val, []).


'dec_stateOrProvinceName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520StateOrProvinceName'(Tlv, []).




%%================================
%%  organizationName
%%================================
'enc_organizationName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520OrganizationName'(Val, []).


'dec_organizationName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520OrganizationName'(Tlv, []).




%%================================
%%  organizationalUnitName
%%================================
'enc_organizationalUnitName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520OrganizationalUnitName'(Val, []).


'dec_organizationalUnitName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520OrganizationalUnitName'(Tlv, []).




%%================================
%%  title
%%================================
'enc_title'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520Title'(Val, []).


'dec_title'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520Title'(Tlv, []).




%%================================
%%  dnQualifier
%%================================
'enc_dnQualifier'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520dnQualifier'(Val, [<<19>>]).


'dec_dnQualifier'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520dnQualifier'(Tlv, [19]).




%%================================
%%  countryName
%%================================
'enc_countryName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520countryName'(Val, [<<19>>]).


'dec_countryName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520countryName'(Tlv, [19]).




%%================================
%%  serialNumber
%%================================
'enc_serialNumber'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520SerialNumber'(Val, [<<19>>]).


'dec_serialNumber'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520SerialNumber'(Tlv, [19]).




%%================================
%%  pseudonym
%%================================
'enc_pseudonym'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_X520Pseudonym'(Val, []).


'dec_pseudonym'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_X520Pseudonym'(Tlv, []).




%%================================
%%  domainComponent
%%================================
'enc_domainComponent'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_DomainComponent'(Val, [<<22>>]).


'dec_domainComponent'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_DomainComponent'(Tlv, [22]).




%%================================
%%  emailAddress
%%================================
'enc_emailAddress'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_EmailAddress'(Val, [<<22>>]).


'dec_emailAddress'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_EmailAddress'(Tlv, [22]).




%%================================
%%  dsa
%%================================
'enc_dsa'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_Dss-Parms'(Val, [<<48>>]);
'enc_dsa'('PublicKeyType', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_DSAPublicKey'(Val, [<<2>>]).


'dec_dsa'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_Dss-Parms'(Tlv, [16]);
'dec_dsa'('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_DSAPublicKey'(Tlv, [2]).




%%================================
%%  dsa-with-sha1
%%================================
'enc_dsa-with-sha1'('Type', Val, _RestPrimFieldName) ->
?RT_BER:encode_null(Val, [<<5>>]).


'dec_dsa-with-sha1'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
?RT_BER:decode_null(Tlv,[5]).




%%================================
%%  md2-with-rsa-encryption
%%================================
'enc_md2-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
?RT_BER:encode_null(Val, [<<5>>]).


'dec_md2-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
?RT_BER:decode_null(Tlv,[5]).




%%================================
%%  md5-with-rsa-encryption
%%================================
'enc_md5-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
?RT_BER:encode_null(Val, [<<5>>]).


'dec_md5-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
?RT_BER:decode_null(Tlv,[5]).




%%================================
%%  sha1-with-rsa-encryption
%%================================
'enc_sha1-with-rsa-encryption'('Type', Val, _RestPrimFieldName) ->
?RT_BER:encode_null(Val, [<<5>>]).


'dec_sha1-with-rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
?RT_BER:decode_null(Tlv,[5]).




%%================================
%%  rsa-encryption
%%================================
'enc_rsa-encryption'('Type', Val, _RestPrimFieldName) ->
?RT_BER:encode_null(Val, [<<5>>]);
'enc_rsa-encryption'('PublicKeyType', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_RSAPublicKey'(Val, [<<48>>]).


'dec_rsa-encryption'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
?RT_BER:decode_null(Tlv,[5]);
'dec_rsa-encryption'('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_RSAPublicKey'(Tlv, [16]).




%%================================
%%  dh
%%================================
'enc_dh'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_DomainParameters'(Val, [<<48>>]);
'enc_dh'('PublicKeyType', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_DHPublicKey'(Val, [<<2>>]).


'dec_dh'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_DomainParameters'(Tlv, [16]);
'dec_dh'('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_DHPublicKey'(Tlv, [2]).




%%================================
%%  kea
%%================================
'enc_kea'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_KEA-Parms-Id'(Val, [<<4>>]);
'enc_kea'('PublicKeyType', Val, _RestPrimFieldName) ->
   'enc_KEA-PublicKey'(Val, [<<2>>]).


'dec_kea'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_KEA-Parms-Id'(Tlv, [4]);
'dec_kea'('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_KEA-PublicKey'(Tlv, [2]).




%%================================
%%  ecdsa-with-sha1
%%================================
'enc_ecdsa-with-sha1'('Type', Val, _RestPrimFieldName) ->
?RT_BER:encode_null(Val, [<<5>>]).


'dec_ecdsa-with-sha1'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
?RT_BER:decode_null(Tlv,[5]).




%%================================
%%  field-prime-field
%%================================
'enc_field-prime-field'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_Prime-p'(Val, [<<2>>]).


'dec_field-prime-field'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_Prime-p'(Tlv, [2]).




%%================================
%%  field-characteristic-two
%%================================
'enc_field-characteristic-two'('Type', Val, _RestPrimFieldName) ->
   'enc_Characteristic-two'(Val, [<<48>>]).


'dec_field-characteristic-two'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_Characteristic-two'(Tlv, [16]).




%%================================
%%  gn-basis
%%================================
'enc_gn-basis'('Type', Val, _RestPrimFieldName) ->
?RT_BER:encode_null(Val, [<<5>>]).


'dec_gn-basis'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
?RT_BER:decode_null(Tlv,[5]).




%%================================
%%  tp-basis
%%================================
'enc_tp-basis'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_Trinomial'(Val, [<<2>>]).


'dec_tp-basis'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_Trinomial'(Tlv, [2]).




%%================================
%%  pp-basis
%%================================
'enc_pp-basis'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_Pentanomial'(Val, [<<48>>]).


'dec_pp-basis'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_Pentanomial'(Tlv, [16]).




%%================================
%%  ec-public-key
%%================================
'enc_ec-public-key'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_EcpkParameters'(Val, []);
'enc_ec-public-key'('PublicKeyType', Val, _RestPrimFieldName) ->
   'PKIX1Algorithms88':'enc_ECPoint'(Val, [<<4>>]).


'dec_ec-public-key'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_EcpkParameters'(Tlv, []);
'dec_ec-public-key'('PublicKeyType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Algorithms88':'dec_ECPoint'(Tlv, [4]).




%%================================
%%  x400-common-name
%%================================
'enc_x400-common-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_CommonName'(Val, [<<19>>]).


'dec_x400-common-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_CommonName'(Tlv, [19]).




%%================================
%%  x400-teletex-common-name
%%================================
'enc_x400-teletex-common-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_TeletexCommonName'(Val, [<<20>>]).


'dec_x400-teletex-common-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_TeletexCommonName'(Tlv, [20]).




%%================================
%%  x400-teletex-personal-name
%%================================
'enc_x400-teletex-personal-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_TeletexPersonalName'(Val, [<<49>>]).


'dec_x400-teletex-personal-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_TeletexPersonalName'(Tlv, [17]).




%%================================
%%  x400-pds-name
%%================================
'enc_x400-pds-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PDSName'(Val, [<<19>>]).


'dec_x400-pds-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PDSName'(Tlv, [19]).




%%================================
%%  x400-physical-delivery-country-name
%%================================
'enc_x400-physical-delivery-country-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PhysicalDeliveryCountryName'(Val, []).


'dec_x400-physical-delivery-country-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PhysicalDeliveryCountryName'(Tlv, []).




%%================================
%%  x400-postal-code
%%================================
'enc_x400-postal-code'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PostalCode'(Val, []).


'dec_x400-postal-code'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PostalCode'(Tlv, []).




%%================================
%%  x400-physical-delivery-office-name
%%================================
'enc_x400-physical-delivery-office-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PhysicalDeliveryOfficeName'(Val, [<<49>>]).


'dec_x400-physical-delivery-office-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PhysicalDeliveryOfficeName'(Tlv, [17]).




%%================================
%%  x400-physical-delivery-office-number
%%================================
'enc_x400-physical-delivery-office-number'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PhysicalDeliveryOfficeNumber'(Val, [<<49>>]).


'dec_x400-physical-delivery-office-number'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PhysicalDeliveryOfficeNumber'(Tlv, [17]).




%%================================
%%  x400-extension-OR-address-components
%%================================
'enc_x400-extension-OR-address-components'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_ExtensionORAddressComponents'(Val, [<<49>>]).


'dec_x400-extension-OR-address-components'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_ExtensionORAddressComponents'(Tlv, [17]).




%%================================
%%  x400-physical-delivery-personal-name
%%================================
'enc_x400-physical-delivery-personal-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PhysicalDeliveryPersonalName'(Val, [<<49>>]).


'dec_x400-physical-delivery-personal-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PhysicalDeliveryPersonalName'(Tlv, [17]).




%%================================
%%  x400-physical-delivery-organization-name
%%================================
'enc_x400-physical-delivery-organization-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PhysicalDeliveryOrganizationName'(Val, [<<49>>]).


'dec_x400-physical-delivery-organization-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PhysicalDeliveryOrganizationName'(Tlv, [17]).




%%================================
%%  x400-extension-physical-delivery-address-components
%%================================
'enc_x400-extension-physical-delivery-address-components'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_ExtensionPhysicalDeliveryAddressComponents'(Val, [<<49>>]).


'dec_x400-extension-physical-delivery-address-components'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_ExtensionPhysicalDeliveryAddressComponents'(Tlv, [17]).




%%================================
%%  x400-unformatted-postal-address
%%================================
'enc_x400-unformatted-postal-address'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_UnformattedPostalAddress'(Val, [<<49>>]).


'dec_x400-unformatted-postal-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_UnformattedPostalAddress'(Tlv, [17]).




%%================================
%%  x400-street-address
%%================================
'enc_x400-street-address'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_StreetAddress'(Val, [<<49>>]).


'dec_x400-street-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_StreetAddress'(Tlv, [17]).




%%================================
%%  x400-post-office-box-address
%%================================
'enc_x400-post-office-box-address'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PostOfficeBoxAddress'(Val, [<<49>>]).


'dec_x400-post-office-box-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PostOfficeBoxAddress'(Tlv, [17]).




%%================================
%%  x400-poste-restante-address
%%================================
'enc_x400-poste-restante-address'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_PosteRestanteAddress'(Val, [<<49>>]).


'dec_x400-poste-restante-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_PosteRestanteAddress'(Tlv, [17]).




%%================================
%%  x400-unique-postal-name
%%================================
'enc_x400-unique-postal-name'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_UniquePostalName'(Val, [<<49>>]).


'dec_x400-unique-postal-name'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_UniquePostalName'(Tlv, [17]).




%%================================
%%  x400-local-postal-attributes
%%================================
'enc_x400-local-postal-attributes'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_LocalPostalAttributes'(Val, [<<49>>]).


'dec_x400-local-postal-attributes'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_LocalPostalAttributes'(Tlv, [17]).




%%================================
%%  x400-extended-network-address
%%================================
'enc_x400-extended-network-address'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_ExtendedNetworkAddress'(Val, []).


'dec_x400-extended-network-address'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_ExtendedNetworkAddress'(Tlv, []).




%%================================
%%  x400-terminal-type
%%================================
'enc_x400-terminal-type'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_TerminalType'(Val, [<<2>>]).


'dec_x400-terminal-type'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_TerminalType'(Tlv, [2]).




%%================================
%%  x400-teletex-domain-defined-attributes
%%================================
'enc_x400-teletex-domain-defined-attributes'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Explicit88':'enc_TeletexDomainDefinedAttributes'(Val, [<<48>>]).


'dec_x400-teletex-domain-defined-attributes'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Explicit88':'dec_TeletexDomainDefinedAttributes'(Tlv, [16]).




%%================================
%%  authorityKeyIdentifier
%%================================
'enc_authorityKeyIdentifier'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_AuthorityKeyIdentifier'(Val, [<<48>>]).


'dec_authorityKeyIdentifier'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_AuthorityKeyIdentifier'(Tlv, [16]).




%%================================
%%  subjectKeyIdentifier
%%================================
'enc_subjectKeyIdentifier'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_SubjectKeyIdentifier'(Val, [<<4>>]).


'dec_subjectKeyIdentifier'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_SubjectKeyIdentifier'(Tlv, [4]).




%%================================
%%  keyUsage
%%================================
'enc_keyUsage'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_KeyUsage'(Val, [<<3>>]).


'dec_keyUsage'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_KeyUsage'(Tlv, [3]).




%%================================
%%  privateKeyUsagePeriod
%%================================
'enc_privateKeyUsagePeriod'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_PrivateKeyUsagePeriod'(Val, [<<48>>]).


'dec_privateKeyUsagePeriod'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_PrivateKeyUsagePeriod'(Tlv, [16]).




%%================================
%%  certificatePolicies
%%================================
'enc_certificatePolicies'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_CertificatePolicies'(Val, [<<48>>]).


'dec_certificatePolicies'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_CertificatePolicies'(Tlv, [16]).




%%================================
%%  policyMappings
%%================================
'enc_policyMappings'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_PolicyMappings'(Val, [<<48>>]).


'dec_policyMappings'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_PolicyMappings'(Tlv, [16]).




%%================================
%%  subjectAltName
%%================================
'enc_subjectAltName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_SubjectAltName'(Val, [<<48>>]).


'dec_subjectAltName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_SubjectAltName'(Tlv, [16]).




%%================================
%%  issuerAltName
%%================================
'enc_issuerAltName'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_IssuerAltName'(Val, [<<48>>]).


'dec_issuerAltName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_IssuerAltName'(Tlv, [16]).




%%================================
%%  subjectDirectoryAttributes
%%================================
'enc_subjectDirectoryAttributes'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_SubjectDirectoryAttributes'(Val, [<<48>>]).


'dec_subjectDirectoryAttributes'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_SubjectDirectoryAttributes'(Tlv, [16]).




%%================================
%%  basicConstraints
%%================================
'enc_basicConstraints'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_BasicConstraints'(Val, [<<48>>]).


'dec_basicConstraints'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_BasicConstraints'(Tlv, [16]).




%%================================
%%  nameConstraints
%%================================
'enc_nameConstraints'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_NameConstraints'(Val, [<<48>>]).


'dec_nameConstraints'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_NameConstraints'(Tlv, [16]).




%%================================
%%  policyConstraints
%%================================
'enc_policyConstraints'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_PolicyConstraints'(Val, [<<48>>]).


'dec_policyConstraints'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_PolicyConstraints'(Tlv, [16]).




%%================================
%%  cRLDistributionPoints
%%================================
'enc_cRLDistributionPoints'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_CRLDistributionPoints'(Val, [<<48>>]).


'dec_cRLDistributionPoints'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_CRLDistributionPoints'(Tlv, [16]).




%%================================
%%  extKeyUsage
%%================================
'enc_extKeyUsage'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_ExtKeyUsageSyntax'(Val, [<<48>>]).


'dec_extKeyUsage'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_ExtKeyUsageSyntax'(Tlv, [16]).




%%================================
%%  inhibitAnyPolicy
%%================================
'enc_inhibitAnyPolicy'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_InhibitAnyPolicy'(Val, [<<2>>]).


'dec_inhibitAnyPolicy'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_InhibitAnyPolicy'(Tlv, [2]).




%%================================
%%  freshestCRL
%%================================
'enc_freshestCRL'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_FreshestCRL'(Val, [<<48>>]).


'dec_freshestCRL'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_FreshestCRL'(Tlv, [16]).




%%================================
%%  authorityInfoAccess
%%================================
'enc_authorityInfoAccess'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_AuthorityInfoAccessSyntax'(Val, [<<48>>]).


'dec_authorityInfoAccess'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_AuthorityInfoAccessSyntax'(Tlv, [16]).




%%================================
%%  subjectInfoAccess
%%================================
'enc_subjectInfoAccess'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_SubjectInfoAccessSyntax'(Val, [<<48>>]).


'dec_subjectInfoAccess'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_SubjectInfoAccessSyntax'(Tlv, [16]).




%%================================
%%  cRLNumber
%%================================
'enc_cRLNumber'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_CRLNumber'(Val, [<<2>>]).


'dec_cRLNumber'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_CRLNumber'(Tlv, [2]).




%%================================
%%  issuingDistributionPoint
%%================================
'enc_issuingDistributionPoint'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_IssuingDistributionPoint'(Val, [<<48>>]).


'dec_issuingDistributionPoint'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_IssuingDistributionPoint'(Tlv, [16]).




%%================================
%%  deltaCRLIndicator
%%================================
'enc_deltaCRLIndicator'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_BaseCRLNumber'(Val, [<<2>>]).


'dec_deltaCRLIndicator'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_BaseCRLNumber'(Tlv, [2]).




%%================================
%%  cRLReasons
%%================================
'enc_cRLReasons'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_CRLReason'(Val, [<<10>>]).


'dec_cRLReasons'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_CRLReason'(Tlv, [10]).




%%================================
%%  certificateIssuer
%%================================
'enc_certificateIssuer'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_CertificateIssuer'(Val, [<<48>>]).


'dec_certificateIssuer'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_CertificateIssuer'(Tlv, [16]).




%%================================
%%  holdInstructionCode
%%================================
'enc_holdInstructionCode'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_HoldInstructionCode'(Val, [<<6>>]).


'dec_holdInstructionCode'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_HoldInstructionCode'(Tlv, [6]).




%%================================
%%  invalidityDate
%%================================
'enc_invalidityDate'('Type', Val, _RestPrimFieldName) ->
   'PKIX1Implicit88':'enc_InvalidityDate'(Val, [<<24>>]).


'dec_invalidityDate'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIX1Implicit88':'dec_InvalidityDate'(Tlv, [24]).




%%================================
%%  SupportedAttributeTypeAndValues
%%================================
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,44}) ->
    fun 'enc_generationQualifier'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,42}) ->
    fun 'enc_givenName'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,43}) ->
    fun 'enc_initials'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,41}) ->
    fun 'enc_name'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,4}) ->
    fun 'enc_surname'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,3}) ->
    fun 'enc_commonName'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,7}) ->
    fun 'enc_localityName'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,10}) ->
    fun 'enc_organizationName'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,8}) ->
    fun 'enc_stateOrProvinceName'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,6}) ->
    fun 'enc_countryName'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,46}) ->
    fun 'enc_dnQualifier'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,11}) ->
    fun 'enc_organizationalUnitName'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,12}) ->
    fun 'enc_title'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{0,9,2342,19200300,100,1,25}) ->
    fun 'enc_domainComponent'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{1,2,840,113549,1,9,1}) ->
    fun 'enc_emailAddress'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,65}) ->
    fun 'enc_pseudonym'/3;
'getenc_SupportedAttributeTypeAndValues'(id,{2,5,4,5}) ->
    fun 'enc_serialNumber'/3;
'getenc_SupportedAttributeTypeAndValues'(id, _) ->
   fun(C,V,_) -> exit({'Type not compatible with table constraint',{component,C},{value,V}}) end.

'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,44}) ->
    fun 'dec_generationQualifier'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,42}) ->
    fun 'dec_givenName'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,43}) ->
    fun 'dec_initials'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,41}) ->
    fun 'dec_name'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,4}) ->
    fun 'dec_surname'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,3}) ->
    fun 'dec_commonName'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,7}) ->
    fun 'dec_localityName'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,10}) ->
    fun 'dec_organizationName'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,8}) ->
    fun 'dec_stateOrProvinceName'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,6}) ->
    fun 'dec_countryName'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,46}) ->
    fun 'dec_dnQualifier'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,11}) ->
    fun 'dec_organizationalUnitName'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,12}) ->
    fun 'dec_title'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{0,9,2342,19200300,100,1,25}) ->
    fun 'dec_domainComponent'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{1,2,840,113549,1,9,1}) ->
    fun 'dec_emailAddress'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,65}) ->
    fun 'dec_pseudonym'/3;
'getdec_SupportedAttributeTypeAndValues'(id,{2,5,4,5}) ->
    fun 'dec_serialNumber'/3;
'getdec_SupportedAttributeTypeAndValues'(id, _) ->
  fun(C,V,_) -> exit({{component,C},{value,V}}) end.





%%================================
%%  SupportedSignatureAlgorithms
%%================================
'getenc_SupportedSignatureAlgorithms'(id,{1,2,840,10040,4,3}) ->
    fun 'enc_dsa-with-sha1'/3;
'getenc_SupportedSignatureAlgorithms'(id,{1,2,840,113549,1,1,2}) ->
    fun 'enc_md2-with-rsa-encryption'/3;
'getenc_SupportedSignatureAlgorithms'(id,{1,2,840,113549,1,1,4}) ->
    fun 'enc_md5-with-rsa-encryption'/3;
'getenc_SupportedSignatureAlgorithms'(id,{1,2,840,113549,1,1,5}) ->
    fun 'enc_sha1-with-rsa-encryption'/3;
'getenc_SupportedSignatureAlgorithms'(id,{1,2,840,10045,4,1}) ->
    fun 'enc_ecdsa-with-sha1'/3;
'getenc_SupportedSignatureAlgorithms'(id, _) ->
   fun(C,V,_) -> exit({'Type not compatible with table constraint',{component,C},{value,V}}) end.

'getdec_SupportedSignatureAlgorithms'(id,{1,2,840,10040,4,3}) ->
    fun 'dec_dsa-with-sha1'/3;
'getdec_SupportedSignatureAlgorithms'(id,{1,2,840,113549,1,1,2}) ->
    fun 'dec_md2-with-rsa-encryption'/3;
'getdec_SupportedSignatureAlgorithms'(id,{1,2,840,113549,1,1,4}) ->
    fun 'dec_md5-with-rsa-encryption'/3;
'getdec_SupportedSignatureAlgorithms'(id,{1,2,840,113549,1,1,5}) ->
    fun 'dec_sha1-with-rsa-encryption'/3;
'getdec_SupportedSignatureAlgorithms'(id,{1,2,840,10045,4,1}) ->
    fun 'dec_ecdsa-with-sha1'/3;
'getdec_SupportedSignatureAlgorithms'(id, _) ->
  fun(C,V,_) -> exit({{component,C},{value,V}}) end.





%%================================
%%  SupportedPublicKeyAlgorithms
%%================================
'getenc_SupportedPublicKeyAlgorithms'(id,{1,2,840,10046,2,1}) ->
    fun 'enc_dh'/3;
'getenc_SupportedPublicKeyAlgorithms'(id,{1,2,840,10040,4,1}) ->
    fun 'enc_dsa'/3;
'getenc_SupportedPublicKeyAlgorithms'(id,{1,2,840,10045,2,1}) ->
    fun 'enc_ec-public-key'/3;
'getenc_SupportedPublicKeyAlgorithms'(id,{2,16,840,1,101,2,1,1,22}) ->
    fun 'enc_kea'/3;
'getenc_SupportedPublicKeyAlgorithms'(id,{1,2,840,113549,1,1,1}) ->
    fun 'enc_rsa-encryption'/3;
'getenc_SupportedPublicKeyAlgorithms'(id, _) ->
   fun(C,V,_) -> exit({'Type not compatible with table constraint',{component,C},{value,V}}) end.

'getdec_SupportedPublicKeyAlgorithms'(id,{1,2,840,10046,2,1}) ->
    fun 'dec_dh'/3;
'getdec_SupportedPublicKeyAlgorithms'(id,{1,2,840,10040,4,1}) ->
    fun 'dec_dsa'/3;
'getdec_SupportedPublicKeyAlgorithms'(id,{1,2,840,10045,2,1}) ->
    fun 'dec_ec-public-key'/3;
'getdec_SupportedPublicKeyAlgorithms'(id,{2,16,840,1,101,2,1,1,22}) ->
    fun 'dec_kea'/3;
'getdec_SupportedPublicKeyAlgorithms'(id,{1,2,840,113549,1,1,1}) ->
    fun 'dec_rsa-encryption'/3;
'getdec_SupportedPublicKeyAlgorithms'(id, _) ->
  fun(C,V,_) -> exit({{component,C},{value,V}}) end.





%%================================
%%  SupportedFieldIds
%%================================
'getenc_SupportedFieldIds'(id,{1,2,840,10045,1,2}) ->
    fun 'enc_field-characteristic-two'/3;
'getenc_SupportedFieldIds'(id,{1,2,840,10045,1,1}) ->
    fun 'enc_field-prime-field'/3;
'getenc_SupportedFieldIds'(id, _) ->
   fun(C,V,_) -> exit({'Type not compatible with table constraint',{component,C},{value,V}}) end.

'getdec_SupportedFieldIds'(id,{1,2,840,10045,1,2}) ->
    fun 'dec_field-characteristic-two'/3;
'getdec_SupportedFieldIds'(id,{1,2,840,10045,1,1}) ->
    fun 'dec_field-prime-field'/3;
'getdec_SupportedFieldIds'(id, _) ->
  fun(C,V,_) -> exit({{component,C},{value,V}}) end.





%%================================
%%  SupportedCharacteristicTwos
%%================================
'getenc_SupportedCharacteristicTwos'(id,{1,2,840,10045,1,2,3,1}) ->
    fun 'enc_gn-basis'/3;
'getenc_SupportedCharacteristicTwos'(id,{1,2,840,10045,1,2,3,3}) ->
    fun 'enc_pp-basis'/3;
'getenc_SupportedCharacteristicTwos'(id,{1,2,840,10045,1,2,3,2}) ->
    fun 'enc_tp-basis'/3;
'getenc_SupportedCharacteristicTwos'(id, _) ->
   fun(C,V,_) -> exit({'Type not compatible with table constraint',{component,C},{value,V}}) end.

'getdec_SupportedCharacteristicTwos'(id,{1,2,840,10045,1,2,3,1}) ->
    fun 'dec_gn-basis'/3;
'getdec_SupportedCharacteristicTwos'(id,{1,2,840,10045,1,2,3,3}) ->
    fun 'dec_pp-basis'/3;
'getdec_SupportedCharacteristicTwos'(id,{1,2,840,10045,1,2,3,2}) ->
    fun 'dec_tp-basis'/3;
'getdec_SupportedCharacteristicTwos'(id, _) ->
  fun(C,V,_) -> exit({{component,C},{value,V}}) end.





%%================================
%%  SupportedExtensionAttributes
%%================================
'getenc_SupportedExtensionAttributes'(id,1) ->
    fun 'enc_x400-common-name'/3;
'getenc_SupportedExtensionAttributes'(id,2) ->
    fun 'enc_x400-teletex-common-name'/3;
'getenc_SupportedExtensionAttributes'(id,4) ->
    fun 'enc_x400-teletex-personal-name'/3;
'getenc_SupportedExtensionAttributes'(id,7) ->
    fun 'enc_x400-pds-name'/3;
'getenc_SupportedExtensionAttributes'(id,8) ->
    fun 'enc_x400-physical-delivery-country-name'/3;
'getenc_SupportedExtensionAttributes'(id,9) ->
    fun 'enc_x400-postal-code'/3;
'getenc_SupportedExtensionAttributes'(id,10) ->
    fun 'enc_x400-physical-delivery-office-name'/3;
'getenc_SupportedExtensionAttributes'(id,11) ->
    fun 'enc_x400-physical-delivery-office-number'/3;
'getenc_SupportedExtensionAttributes'(id,12) ->
    fun 'enc_x400-extension-OR-address-components'/3;
'getenc_SupportedExtensionAttributes'(id,13) ->
    fun 'enc_x400-physical-delivery-personal-name'/3;
'getenc_SupportedExtensionAttributes'(id,14) ->
    fun 'enc_x400-physical-delivery-organization-name'/3;
'getenc_SupportedExtensionAttributes'(id,15) ->
    fun 'enc_x400-extension-physical-delivery-address-components'/3;
'getenc_SupportedExtensionAttributes'(id,16) ->
    fun 'enc_x400-unformatted-postal-address'/3;
'getenc_SupportedExtensionAttributes'(id,17) ->
    fun 'enc_x400-street-address'/3;
'getenc_SupportedExtensionAttributes'(id,18) ->
    fun 'enc_x400-post-office-box-address'/3;
'getenc_SupportedExtensionAttributes'(id,19) ->
    fun 'enc_x400-poste-restante-address'/3;
'getenc_SupportedExtensionAttributes'(id,20) ->
    fun 'enc_x400-unique-postal-name'/3;
'getenc_SupportedExtensionAttributes'(id,21) ->
    fun 'enc_x400-local-postal-attributes'/3;
'getenc_SupportedExtensionAttributes'(id,22) ->
    fun 'enc_x400-extended-network-address'/3;
'getenc_SupportedExtensionAttributes'(id,23) ->
    fun 'enc_x400-terminal-type'/3;
'getenc_SupportedExtensionAttributes'(id,6) ->
    fun 'enc_x400-teletex-domain-defined-attributes'/3;
'getenc_SupportedExtensionAttributes'(id, _) ->
   fun(C,V,_) -> exit({'Type not compatible with table constraint',{component,C},{value,V}}) end.

'getdec_SupportedExtensionAttributes'(id,1) ->
    fun 'dec_x400-common-name'/3;
'getdec_SupportedExtensionAttributes'(id,2) ->
    fun 'dec_x400-teletex-common-name'/3;
'getdec_SupportedExtensionAttributes'(id,4) ->
    fun 'dec_x400-teletex-personal-name'/3;
'getdec_SupportedExtensionAttributes'(id,7) ->
    fun 'dec_x400-pds-name'/3;
'getdec_SupportedExtensionAttributes'(id,8) ->
    fun 'dec_x400-physical-delivery-country-name'/3;
'getdec_SupportedExtensionAttributes'(id,9) ->
    fun 'dec_x400-postal-code'/3;
'getdec_SupportedExtensionAttributes'(id,10) ->
    fun 'dec_x400-physical-delivery-office-name'/3;
'getdec_SupportedExtensionAttributes'(id,11) ->
    fun 'dec_x400-physical-delivery-office-number'/3;
'getdec_SupportedExtensionAttributes'(id,12) ->
    fun 'dec_x400-extension-OR-address-components'/3;
'getdec_SupportedExtensionAttributes'(id,13) ->
    fun 'dec_x400-physical-delivery-personal-name'/3;
'getdec_SupportedExtensionAttributes'(id,14) ->
    fun 'dec_x400-physical-delivery-organization-name'/3;
'getdec_SupportedExtensionAttributes'(id,15) ->
    fun 'dec_x400-extension-physical-delivery-address-components'/3;
'getdec_SupportedExtensionAttributes'(id,16) ->
    fun 'dec_x400-unformatted-postal-address'/3;
'getdec_SupportedExtensionAttributes'(id,17) ->
    fun 'dec_x400-street-address'/3;
'getdec_SupportedExtensionAttributes'(id,18) ->
    fun 'dec_x400-post-office-box-address'/3;
'getdec_SupportedExtensionAttributes'(id,19) ->
    fun 'dec_x400-poste-restante-address'/3;
'getdec_SupportedExtensionAttributes'(id,20) ->
    fun 'dec_x400-unique-postal-name'/3;
'getdec_SupportedExtensionAttributes'(id,21) ->
    fun 'dec_x400-local-postal-attributes'/3;
'getdec_SupportedExtensionAttributes'(id,22) ->
    fun 'dec_x400-extended-network-address'/3;
'getdec_SupportedExtensionAttributes'(id,23) ->
    fun 'dec_x400-terminal-type'/3;
'getdec_SupportedExtensionAttributes'(id,6) ->
    fun 'dec_x400-teletex-domain-defined-attributes'/3;
'getdec_SupportedExtensionAttributes'(id, _) ->
  fun(C,V,_) -> exit({{component,C},{value,V}}) end.





%%================================
%%  SupportedExtensions
%%================================
'getenc_SupportedExtensions'(id,{2,5,29,35}) ->
    fun 'enc_authorityKeyIdentifier'/3;
'getenc_SupportedExtensions'(id,{2,5,29,15}) ->
    fun 'enc_keyUsage'/3;
'getenc_SupportedExtensions'(id,{2,5,29,16}) ->
    fun 'enc_privateKeyUsagePeriod'/3;
'getenc_SupportedExtensions'(id,{2,5,29,14}) ->
    fun 'enc_subjectKeyIdentifier'/3;
'getenc_SupportedExtensions'(id,{2,5,29,32}) ->
    fun 'enc_certificatePolicies'/3;
'getenc_SupportedExtensions'(id,{2,5,29,33}) ->
    fun 'enc_policyMappings'/3;
'getenc_SupportedExtensions'(id,{2,5,29,17}) ->
    fun 'enc_subjectAltName'/3;
'getenc_SupportedExtensions'(id,{2,5,29,19}) ->
    fun 'enc_basicConstraints'/3;
'getenc_SupportedExtensions'(id,{2,5,29,18}) ->
    fun 'enc_issuerAltName'/3;
'getenc_SupportedExtensions'(id,{2,5,29,9}) ->
    fun 'enc_subjectDirectoryAttributes'/3;
'getenc_SupportedExtensions'(id,{2,5,29,31}) ->
    fun 'enc_cRLDistributionPoints'/3;
'getenc_SupportedExtensions'(id,{2,5,29,30}) ->
    fun 'enc_nameConstraints'/3;
'getenc_SupportedExtensions'(id,{2,5,29,36}) ->
    fun 'enc_policyConstraints'/3;
'getenc_SupportedExtensions'(id,{1,3,6,1,5,5,7,1,1}) ->
    fun 'enc_authorityInfoAccess'/3;
'getenc_SupportedExtensions'(id,{2,5,29,37}) ->
    fun 'enc_extKeyUsage'/3;
'getenc_SupportedExtensions'(id,{2,5,29,46}) ->
    fun 'enc_freshestCRL'/3;
'getenc_SupportedExtensions'(id,{2,5,29,54}) ->
    fun 'enc_inhibitAnyPolicy'/3;
'getenc_SupportedExtensions'(id,{2,5,29,20}) ->
    fun 'enc_cRLNumber'/3;
'getenc_SupportedExtensions'(id,{2,5,29,28}) ->
    fun 'enc_issuingDistributionPoint'/3;
'getenc_SupportedExtensions'(id,{1,3,6,1,5,5,7,1,11}) ->
    fun 'enc_subjectInfoAccess'/3;
'getenc_SupportedExtensions'(id,{2,5,29,21}) ->
    fun 'enc_cRLReasons'/3;
'getenc_SupportedExtensions'(id,{2,5,29,29}) ->
    fun 'enc_certificateIssuer'/3;
'getenc_SupportedExtensions'(id,{2,5,29,27}) ->
    fun 'enc_deltaCRLIndicator'/3;
'getenc_SupportedExtensions'(id,{2,5,29,23}) ->
    fun 'enc_holdInstructionCode'/3;
'getenc_SupportedExtensions'(id,{2,5,29,24}) ->
    fun 'enc_invalidityDate'/3;
'getenc_SupportedExtensions'(id, _) ->
   fun(C,V,_) -> exit({'Type not compatible with table constraint',{component,C},{value,V}}) end.

'getdec_SupportedExtensions'(id,{2,5,29,35}) ->
    fun 'dec_authorityKeyIdentifier'/3;
'getdec_SupportedExtensions'(id,{2,5,29,15}) ->
    fun 'dec_keyUsage'/3;
'getdec_SupportedExtensions'(id,{2,5,29,16}) ->
    fun 'dec_privateKeyUsagePeriod'/3;
'getdec_SupportedExtensions'(id,{2,5,29,14}) ->
    fun 'dec_subjectKeyIdentifier'/3;
'getdec_SupportedExtensions'(id,{2,5,29,32}) ->
    fun 'dec_certificatePolicies'/3;
'getdec_SupportedExtensions'(id,{2,5,29,33}) ->
    fun 'dec_policyMappings'/3;
'getdec_SupportedExtensions'(id,{2,5,29,17}) ->
    fun 'dec_subjectAltName'/3;
'getdec_SupportedExtensions'(id,{2,5,29,19}) ->
    fun 'dec_basicConstraints'/3;
'getdec_SupportedExtensions'(id,{2,5,29,18}) ->
    fun 'dec_issuerAltName'/3;
'getdec_SupportedExtensions'(id,{2,5,29,9}) ->
    fun 'dec_subjectDirectoryAttributes'/3;
'getdec_SupportedExtensions'(id,{2,5,29,31}) ->
    fun 'dec_cRLDistributionPoints'/3;
'getdec_SupportedExtensions'(id,{2,5,29,30}) ->
    fun 'dec_nameConstraints'/3;
'getdec_SupportedExtensions'(id,{2,5,29,36}) ->
    fun 'dec_policyConstraints'/3;
'getdec_SupportedExtensions'(id,{1,3,6,1,5,5,7,1,1}) ->
    fun 'dec_authorityInfoAccess'/3;
'getdec_SupportedExtensions'(id,{2,5,29,37}) ->
    fun 'dec_extKeyUsage'/3;
'getdec_SupportedExtensions'(id,{2,5,29,46}) ->
    fun 'dec_freshestCRL'/3;
'getdec_SupportedExtensions'(id,{2,5,29,54}) ->
    fun 'dec_inhibitAnyPolicy'/3;
'getdec_SupportedExtensions'(id,{2,5,29,20}) ->
    fun 'dec_cRLNumber'/3;
'getdec_SupportedExtensions'(id,{2,5,29,28}) ->
    fun 'dec_issuingDistributionPoint'/3;
'getdec_SupportedExtensions'(id,{1,3,6,1,5,5,7,1,11}) ->
    fun 'dec_subjectInfoAccess'/3;
'getdec_SupportedExtensions'(id,{2,5,29,21}) ->
    fun 'dec_cRLReasons'/3;
'getdec_SupportedExtensions'(id,{2,5,29,29}) ->
    fun 'dec_certificateIssuer'/3;
'getdec_SupportedExtensions'(id,{2,5,29,27}) ->
    fun 'dec_deltaCRLIndicator'/3;
'getdec_SupportedExtensions'(id,{2,5,29,23}) ->
    fun 'dec_holdInstructionCode'/3;
'getdec_SupportedExtensions'(id,{2,5,29,24}) ->
    fun 'dec_invalidityDate'/3;
'getdec_SupportedExtensions'(id, _) ->
  fun(C,V,_) -> exit({{component,C},{value,V}}) end.


