/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.core.BufferChangedEvent;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IBufferChangedListener;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class DocumentAdapter
implements IBuffer,
IDocumentListener {
    public static final IBuffer NULL = new NullBuffer();
    private static final boolean DEBUG_LINE_DELIMITERS = true;
    private IOpenable fOwner;
    private IFile fFile;
    private ITextFileBuffer fTextFileBuffer;
    private IDocument fDocument;
    private DocumentSetCommand fSetCmd = new DocumentSetCommand();
    private DocumentReplaceCommand fReplaceCmd = new DocumentReplaceCommand();
    private Set fLegalLineDelimiters;
    private List fBufferListeners = new ArrayList(3);
    private IStatus fStatus;

    public DocumentAdapter(IOpenable iOpenable, IFile iFile) {
        this.fOwner = iOpenable;
        this.fFile = iFile;
        this.initialize();
    }

    private void initialize() {
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        IPath iPath = this.fFile.getFullPath();
        try {
            iTextFileBufferManager.connect(iPath, (IProgressMonitor)new NullProgressMonitor());
            this.fTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(iPath);
            this.fDocument = this.fTextFileBuffer.getDocument();
        }
        catch (CoreException coreException) {
            this.fStatus = coreException.getStatus();
            this.fDocument = iTextFileBufferManager.createEmptyDocument(iPath);
        }
        this.fDocument.addPrenotifiedDocumentListener((IDocumentListener)this);
    }

    public IStatus getStatus() {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        if (this.fTextFileBuffer != null) {
            return this.fTextFileBuffer.getStatus();
        }
        return null;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void addBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        Assert.isNotNull((Object)iBufferChangedListener);
        if (!this.fBufferListeners.contains(iBufferChangedListener)) {
            this.fBufferListeners.add(iBufferChangedListener);
        }
    }

    public void removeBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        Assert.isNotNull((Object)iBufferChangedListener);
        this.fBufferListeners.remove(iBufferChangedListener);
    }

    public void append(char[] cArray) {
        this.append(new String(cArray));
    }

    public void append(String string) {
        this.validateLineDelimiters(string);
        this.fReplaceCmd.replace(this.fDocument.getLength(), 0, string);
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        IDocument iDocument = this.fDocument;
        this.fDocument = null;
        iDocument.removePrenotifiedDocumentListener((IDocumentListener)this);
        if (this.fTextFileBuffer != null) {
            ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
            try {
                iTextFileBufferManager.disconnect(this.fTextFileBuffer.getLocation(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            this.fTextFileBuffer = null;
        }
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, 0, 0, null));
        this.fBufferListeners.clear();
    }

    public char getChar(int n) {
        try {
            return this.fDocument.getChar(n);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public char[] getCharacters() {
        String string = this.getContents();
        return string == null ? null : string.toCharArray();
    }

    public String getContents() {
        return this.fDocument.get();
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public IOpenable getOwner() {
        return this.fOwner;
    }

    public String getText(int n, int n2) {
        try {
            return this.fDocument.get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public IResource getUnderlyingResource() {
        return this.fFile;
    }

    public boolean hasUnsavedChanges() {
        return this.fTextFileBuffer != null ? this.fTextFileBuffer.isDirty() : false;
    }

    public boolean isClosed() {
        return this.fDocument == null;
    }

    public boolean isReadOnly() {
        IResource iResource = this.getUnderlyingResource();
        return iResource == null ? true : iResource.isReadOnly();
    }

    public void replace(int n, int n2, char[] cArray) {
        this.replace(n, n2, new String(cArray));
    }

    public void replace(int n, int n2, String string) {
        this.validateLineDelimiters(string);
        this.fReplaceCmd.replace(n, n2, string);
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws RubyModelException {
        try {
            if (this.fTextFileBuffer != null) {
                this.fTextFileBuffer.commit(iProgressMonitor, bl);
            }
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException);
        }
    }

    public void setContents(char[] cArray) {
        this.setContents(new String(cArray));
    }

    public void setContents(String string) {
        int n = this.fDocument.getLength();
        if (string == null) {
            if (n != 0) {
                this.fSetCmd.set("");
            }
        } else {
            this.validateLineDelimiters(string);
            if (!string.equals(this.fDocument.get())) {
                this.fSetCmd.set(string);
            }
        }
    }

    private void validateLineDelimiters(String string) {
        int n;
        DefaultLineTracker defaultLineTracker;
        if (this.fLegalLineDelimiters == null) {
            defaultLineTracker = new HashSet();
            n = this.fDocument.getNumberOfLines() - 1;
            while (n >= 0) {
                try {
                    String string2 = this.fDocument.getLineDelimiter(n);
                    if (string2 != null) {
                        defaultLineTracker.add(string2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    RubyPlugin.log(badLocationException);
                }
                --n;
            }
            if (defaultLineTracker.isEmpty()) {
                return;
            }
            this.fLegalLineDelimiters = defaultLineTracker;
        }
        defaultLineTracker = new DefaultLineTracker();
        defaultLineTracker.set(string);
        n = defaultLineTracker.getNumberOfLines();
        if (n <= 1) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                String string3 = defaultLineTracker.getLineDelimiter(n2);
                if (string3 != null && !this.fLegalLineDelimiters.contains(string3)) {
                    StringBuffer stringBuffer = new StringBuffer("New line delimiter added to new code: ");
                    int n3 = 0;
                    while (n3 < string3.length()) {
                        stringBuffer.append(String.valueOf((int)string3.charAt(n3)));
                        ++n3;
                    }
                    RubyPlugin.log(new Exception(stringBuffer.toString()));
                }
            }
            catch (BadLocationException badLocationException) {
                RubyPlugin.log(badLocationException);
            }
            ++n2;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public void documentChanged(DocumentEvent documentEvent) {
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, documentEvent.getOffset(), documentEvent.getLength(), documentEvent.getText()));
    }

    private void fireBufferChanged(BufferChangedEvent bufferChangedEvent) {
        if (this.fBufferListeners != null && this.fBufferListeners.size() > 0) {
            Iterator iterator = new ArrayList(this.fBufferListeners).iterator();
            while (iterator.hasNext()) {
                ((IBufferChangedListener)iterator.next()).bufferChanged(bufferChangedEvent);
            }
        }
    }

    private static class NullBuffer
    implements IBuffer {
        NullBuffer() {
        }

        public void addBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        }

        public void append(char[] cArray) {
        }

        public void append(String string) {
        }

        public void close() {
        }

        public char getChar(int n) {
            return '\u0000';
        }

        public char[] getCharacters() {
            return null;
        }

        public String getContents() {
            return null;
        }

        public int getLength() {
            return 0;
        }

        public IOpenable getOwner() {
            return null;
        }

        public String getText(int n, int n2) {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return false;
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void removeBufferChangedListener(IBufferChangedListener iBufferChangedListener) {
        }

        public void replace(int n, int n2, char[] cArray) {
        }

        public void replace(int n, int n2, String string) {
        }

        public void save(IProgressMonitor iProgressMonitor, boolean bl) {
        }

        public void setContents(char[] cArray) {
        }

        public void setContents(String string) {
        }
    }

    protected class DocumentSetCommand
    implements Runnable {
        private String fContents;

        protected DocumentSetCommand() {
        }

        public void run() {
            DocumentAdapter.this.fDocument.set(this.fContents);
        }

        public void set(String string) {
            this.fContents = string;
            Display.getDefault().syncExec((Runnable)this);
        }
    }

    protected class DocumentReplaceCommand
    implements Runnable {
        private int fOffset;
        private int fLength;
        private String fText;

        protected DocumentReplaceCommand() {
        }

        public void run() {
            try {
                DocumentAdapter.this.fDocument.replace(this.fOffset, this.fLength, this.fText);
            }
            catch (BadLocationException badLocationException) {}
        }

        public void replace(int n, int n2, String string) {
            this.fOffset = n;
            this.fLength = n2;
            this.fText = string;
            Display.getDefault().syncExec((Runnable)this);
        }
    }
}

