/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.VersionInsensitiveBugComparator;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.model.MovedClassMap;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Update {
    private static final String USAGE;
    private HashMap<BugInstance, BugInstance> mapFromNewToOldBug = new HashMap();
    private HashSet<BugInstance> matchedOldBugs = new HashSet();
    boolean noPackageMoves = false;
    boolean preciseMatch = false;
    boolean precisePriorityMatch = false;
    VersionInsensitiveBugComparator versionInsensitiveBugComparator = new VersionInsensitiveBugComparator();
    VersionInsensitiveBugComparator fuzzyBugPatternMatcher = new VersionInsensitiveBugComparator();
    boolean verbose;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$workflow$Update;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Update() {
        this.fuzzyBugPatternMatcher.setExactBugPatternMatch(false);
        this.verbose = true;
    }

    public BugCollection mergeCollections(BugCollection origCollection, BugCollection newCollection, boolean copyDeadBugs) {
        BugInstance newBug;
        this.mapFromNewToOldBug.clear();
        this.matchedOldBugs.clear();
        BugCollection resultCollection = newCollection.createEmptyCollectionWithMetadata();
        long lastSequence = origCollection.getSequenceNumber();
        resultCollection.clearAppVersions();
        Iterator<AppVersion> i = origCollection.appVersionIterator();
        while (i.hasNext()) {
            AppVersion appVersion = i.next();
            resultCollection.addAppVersion((AppVersion)appVersion.clone());
        }
        AppVersion origCollectionVersion = new AppVersion(lastSequence);
        origCollectionVersion.setTimestamp(origCollection.getCurrentAppVersion().getTimestamp());
        origCollectionVersion.setReleaseName(origCollection.getCurrentAppVersion().getReleaseName());
        origCollectionVersion.setNumClasses(origCollection.getProjectStats().getNumClasses());
        origCollectionVersion.setCodeSize(origCollection.getProjectStats().getCodeSize());
        resultCollection.addAppVersion(origCollectionVersion);
        long currentSequence = origCollection.getSequenceNumber() + 1L;
        resultCollection.setSequenceNumber(currentSequence);
        int oldBugs = 0;
        if (copyDeadBugs) {
            for (BugInstance bug : origCollection.getCollection()) {
                if (bug.getLastVersion() == -1L) continue;
                ++oldBugs;
                BugInstance newBug2 = (BugInstance)bug.clone();
                resultCollection.add(newBug2, false);
            }
        }
        this.matchBugs(SortedBugCollection.BugInstanceComparator.instance, origCollection, newCollection);
        this.matchBugs(this.versionInsensitiveBugComparator, origCollection, newCollection);
        if (!this.preciseMatch) {
            this.matchBugs(this.fuzzyBugPatternMatcher, origCollection, newCollection);
        }
        if (!this.noPackageMoves) {
            VersionInsensitiveBugComparator movedBugComparator = new VersionInsensitiveBugComparator();
            MovedClassMap movedClassMap = new MovedClassMap(origCollection, newCollection).execute();
            if (!movedClassMap.isEmpty()) {
                movedBugComparator.setClassNameRewriter(movedClassMap);
                movedBugComparator.setComparePriorities(this.precisePriorityMatch);
                this.matchBugs(movedBugComparator, origCollection, newCollection);
                if (!this.preciseMatch) {
                    movedBugComparator.setExactBugPatternMatch(false);
                    this.matchBugs(movedBugComparator, origCollection, newCollection);
                }
            }
        }
        int newlyDeadBugs = 0;
        int persistantBugs = 0;
        int addedBugs = 0;
        int addedInNewCode = 0;
        int deadBugInDeadCode = 0;
        if (copyDeadBugs) {
            for (BugInstance bug : origCollection.getCollection()) {
                if (this.matchedOldBugs.contains(bug)) continue;
                if (bug.getLastVersion() == -1L) {
                    ++newlyDeadBugs;
                } else {
                    ++oldBugs;
                }
                newBug = (BugInstance)bug.clone();
                if (newBug.getLastVersion() == -1L) {
                    newBug.setLastVersion(lastSequence);
                    ClassAnnotation classBugFoundIn = bug.getPrimaryClass();
                    String className = classBugFoundIn.getClassName();
                    if (newCollection.getProjectStats().getClassStats(className) != null) {
                        newBug.setRemovedByChangeOfPersistingClass(true);
                    } else {
                        ++deadBugInDeadCode;
                    }
                }
                if (newBug.getFirstVersion() > newBug.getLastVersion()) {
                    throw new IllegalStateException(new StringBuffer().append("Illegal Version range: ").append(newBug.getFirstVersion()).append("..").append(newBug.getLastVersion()).toString());
                }
                resultCollection.add(newBug, false);
            }
        }
        for (BugInstance bug : newCollection.getCollection()) {
            newBug = (BugInstance)bug.clone();
            if (this.mapFromNewToOldBug.containsKey(bug)) {
                BugInstance origWarning = this.mapFromNewToOldBug.get(bug);
                if (!$assertionsDisabled && origWarning.getLastVersion() != -1L) {
                    throw new AssertionError();
                }
                Update.copyBugHistory(origWarning, newBug);
                BugDesignation designation = newBug.getUserDesignation();
                if (designation != null) {
                    designation.merge(origWarning.getUserDesignation());
                } else {
                    newBug.setUserDesignation(origWarning.getUserDesignation());
                }
                ++persistantBugs;
            } else {
                newBug.setFirstVersion(lastSequence + 1L);
                ++addedBugs;
                ClassAnnotation classBugFoundIn = bug.getPrimaryClass();
                String className = classBugFoundIn.getClassName();
                if (origCollection.getProjectStats().getClassStats(className) != null) {
                    newBug.setIntroducedByChangeOfExistingClass(true);
                } else {
                    ++addedInNewCode;
                }
            }
            if (!$assertionsDisabled && newBug.getLastVersion() != -1L) {
                throw new AssertionError();
            }
            if (newBug.getLastVersion() != -1L) {
                throw new IllegalStateException(new StringBuffer().append("Illegal Version range: ").append(newBug.getFirstVersion()).append("..").append(newBug.getLastVersion()).toString());
            }
            int oldSize = resultCollection.getCollection().size();
            resultCollection.add(newBug, false);
            int newSize = resultCollection.getCollection().size();
            if (newSize == oldSize + 1) continue;
            System.out.println(new StringBuffer().append("Failed to add bug #").append(newBug.getUniqueId()).append(" : ").append(newBug.getMessage()).toString());
        }
        return resultCollection;
    }

    public static String[] getFilePathParts(String filePath) {
        String regex = File.separatorChar == '\\' ? "\\\\" : File.separator;
        return filePath.split(regex);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        new Update().doit(args);
    }

    public void doit(String[] args) throws IOException, DocumentException {
        DetectorFactoryCollection.instance();
        UpdateCommandLine commandLine = new UpdateCommandLine();
        int argCount = commandLine.parse(args, 2, Integer.MAX_VALUE, USAGE);
        if (commandLine.outputFilename == null) {
            this.verbose = false;
        }
        String[] firstPathParts = Update.getFilePathParts(args[argCount]);
        int commonPrefix = firstPathParts.length;
        for (int i = argCount + 1; i <= args.length - 1; ++i) {
            commonPrefix = Math.min(commonPrefix, Update.lengthCommonPrefix(firstPathParts, Update.getFilePathParts(args[i])));
        }
        String origFilename = args[argCount++];
        Project project = new Project();
        BugCollection origCollection = new SortedBugCollection();
        if (this.verbose) {
            System.out.println(new StringBuffer().append("Starting with ").append(origFilename).toString());
        }
        origCollection.readXML(origFilename, project);
        if (commandLine.overrideRevisionNames || origCollection.getReleaseName() == null || origCollection.getReleaseName().length() == 0) {
            origCollection.setReleaseName(firstPathParts[commonPrefix]);
        }
        for (BugInstance bug : origCollection.getCollection()) {
            if (bug.getLastVersion() < 0L || bug.getFirstVersion() <= bug.getLastVersion()) continue;
            throw new IllegalStateException(new StringBuffer().append("Illegal Version range: ").append(bug.getFirstVersion()).append("..").append(bug.getLastVersion()).toString());
        }
        while (argCount <= args.length - 1) {
            SortedBugCollection newCollection = new SortedBugCollection();
            String newFilename = args[argCount++];
            if (this.verbose) {
                System.out.println(new StringBuffer().append("Merging ").append(newFilename).toString());
            }
            project = new Project();
            try {
                File f = new File(newFilename);
                if (f.length() == 0L) {
                    if (!this.verbose) continue;
                    System.out.println(new StringBuffer().append("Empty input file: ").append(f).toString());
                    continue;
                }
                newCollection.readXML(newFilename, project);
                if (commandLine.overrideRevisionNames || newCollection.getReleaseName() == null || newCollection.getReleaseName().length() == 0) {
                    newCollection.setReleaseName(Update.getFilePathParts(newFilename)[commonPrefix]);
                }
                origCollection = this.mergeCollections(origCollection, newCollection, true);
            }
            catch (IOException e) {
                if (this.verbose) {
                    System.out.println(e);
                    continue;
                }
                throw e;
            }
        }
        if (commandLine.outputFilename != null) {
            origCollection.writeXML(commandLine.outputFilename, project);
        } else {
            origCollection.writeXML(System.out, project);
        }
    }

    private static int lengthCommonPrefix(String[] string, String[] string2) {
        int maxLength = Math.min(string.length, string2.length);
        for (int result = 0; result < maxLength; ++result) {
            if (string[result].equals(string2[result])) continue;
            return result;
        }
        return maxLength;
    }

    private static void copyBugHistory(BugInstance src, BugInstance dest) {
        dest.setFirstVersion(src.getFirstVersion());
        dest.setLastVersion(src.getLastVersion());
        dest.setIntroducedByChangeOfExistingClass(src.isIntroducedByChangeOfExistingClass());
        dest.setRemovedByChangeOfPersistingClass(src.isRemovedByChangeOfPersistingClass());
    }

    private void matchBugs(Comparator<BugInstance> bugInstanceComparator, BugCollection origCollection, BugCollection newCollection) {
        LinkedList q;
        TreeMap<BugInstance, LinkedList<BugInstance>> set = new TreeMap<BugInstance, LinkedList<BugInstance>>(bugInstanceComparator);
        int oldBugs = 0;
        int newBugs = 0;
        int matchedBugs = 0;
        for (BugInstance bug : origCollection.getCollection()) {
            if (bug.getLastVersion() != -1L || this.matchedOldBugs.contains(bug)) continue;
            ++oldBugs;
            q = (LinkedList)set.get(bug);
            if (q == null) {
                q = new LinkedList();
                set.put(bug, q);
            }
            q.add(bug);
        }
        for (BugInstance bug : newCollection.getCollection()) {
            if (this.mapFromNewToOldBug.containsKey(bug)) continue;
            ++newBugs;
            q = (LinkedList)set.get(bug);
            if (q == null || q.isEmpty()) continue;
            ++matchedBugs;
            BugInstance matchedBug = (BugInstance)q.removeFirst();
            this.mapFromNewToOldBug.put(bug, matchedBug);
            this.matchedOldBugs.add(matchedBug);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$workflow$Update == null ? (class$edu$umd$cs$findbugs$workflow$Update = Update.class$("edu.umd.cs.findbugs.workflow.Update")) : class$edu$umd$cs$findbugs$workflow$Update).desiredAssertionStatus();
        USAGE = new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$workflow$Update == null ? (class$edu$umd$cs$findbugs$workflow$Update = Update.class$("edu.umd.cs.findbugs.workflow.Update")) : class$edu$umd$cs$findbugs$workflow$Update).getName()).append(" [options]  data1File data2File data3File ... ").toString();
    }

    class UpdateCommandLine
    extends CommandLine {
        boolean overrideRevisionNames = false;
        String outputFilename;

        UpdateCommandLine() {
            this.addSwitch("-overrideRevisionNames", "override revision names for each version with names computed filenames");
            this.addSwitch("-noPackageMoves", "if a class seems to have moved from one package to another, treat warnings in that class as two seperate warnings");
            this.addSwitch("-preciseMatch", "require bug patterns to match precisely");
            this.addSwitch("-precisePriorityMatch", "only consider two warnings to be the same if their priorities match exactly");
            this.addOption("-output", "output file", "explicit filename for merged results (standard out used if not specified)");
            this.addSwitch("-quiet", "don't generate any outout to standard out unless there is an error");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-overrideRevisionNames")) {
                this.overrideRevisionNames = optionExtraPart.length() == 0 ? true : TigerSubstitutes.parseBoolean(optionExtraPart);
            } else if (option.equals("-noPackageMoves")) {
                Update.this.noPackageMoves = optionExtraPart.length() == 0 ? true : TigerSubstitutes.parseBoolean(optionExtraPart);
            } else if (option.equals("-preciseMatch")) {
                Update.this.preciseMatch = true;
            } else if (option.equals("-precisePriorityMatch")) {
                Update.this.versionInsensitiveBugComparator.setComparePriorities(true);
                Update.this.fuzzyBugPatternMatcher.setComparePriorities(true);
                Update.this.precisePriorityMatch = true;
            } else if (option.equals("-quiet")) {
                Update.this.verbose = false;
            } else {
                throw new IllegalArgumentException("no option " + option);
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (!option.equals("-output")) {
                throw new IllegalArgumentException("Can't handle option " + option);
            }
            this.outputFilename = argument;
        }
    }
}

