/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.AnalysisCacheToRepositoryAdapter;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import java.io.IOException;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class JavaClassAnalysisEngine
implements IClassAnalysisEngine {
    private static final boolean DEBUG_MISSING_CLASSES = SystemProperties.getBoolean("findbugs.debug.missingclasses");

    public Object analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        try {
            ClassData classData = (ClassData)analysisCache.getClassAnalysis(ClassData.class, descriptor);
            JavaClass javaClass = new ClassParser(classData.getInputStream(), descriptor.toResourceName()).parse();
            javaClass.setRepository(Repository.getRepository());
            if (DEBUG_MISSING_CLASSES && !(javaClass.getRepository() instanceof AnalysisCacheToRepositoryAdapter)) {
                throw new IllegalStateException("this should not happen");
            }
            return javaClass;
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(descriptor.toResourceName(), e);
        }
    }

    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(JavaClass.class, this);
    }

    public boolean retainAnalysisResults() {
        return true;
    }

    public /* synthetic */ Object analyze(IAnalysisCache x0, Object x1) throws CheckedAnalysisException {
        return this.analyze(x0, (ClassDescriptor)x1);
    }
}

