/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.LocationWhereValueBecomesNull;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonCollector;
import edu.umd.cs.findbugs.ba.npe.RedundantBranch;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullDerefAndRedundantComparisonFinder {
    private static final boolean DEBUG = SystemProperties.getBoolean("fnd.debug");
    private static final boolean DEBUG_DEREFS = SystemProperties.getBoolean("fnd.derefs.debug");
    private ClassContext classContext;
    private Method method;
    private NullDerefAndRedundantComparisonCollector collector;
    private final boolean findGuaranteedDerefs;
    private List<RedundantBranch> redundantBranchList;
    private BitSet definitelySameBranchSet;
    private BitSet definitelyDifferentBranchSet;
    private BitSet undeterminedBranchSet;
    private BitSet lineMentionedMultipleTimes;
    private IsNullValueDataflow invDataflow;
    private ValueNumberDataflow vnaDataflow;
    private UnconditionalValueDerefDataflow uvdDataflow;
    private AssertionMethods assertionMethods;

    public NullDerefAndRedundantComparisonFinder(ClassContext classContext, Method method, NullDerefAndRedundantComparisonCollector collector) {
        this.classContext = classContext;
        this.method = method;
        this.collector = collector;
        this.findGuaranteedDerefs = classContext.getAnalysisContext().getBoolProperty(5);
        this.lineMentionedMultipleTimes = ClassContext.linesMentionedMultipleTimes(method);
        this.redundantBranchList = new LinkedList<RedundantBranch>();
        this.definitelySameBranchSet = new BitSet();
        this.definitelyDifferentBranchSet = new BitSet();
        this.undeterminedBranchSet = new BitSet();
        this.assertionMethods = classContext.getAssertionMethods();
    }

    public void execute() throws DataflowAnalysisException, CFGBuilderException {
        this.invDataflow = this.classContext.getIsNullValueDataflow(this.method);
        this.vnaDataflow = this.classContext.getValueNumberDataflow(this.method);
        if (this.findGuaranteedDerefs) {
            if (DEBUG_DEREFS) {
                System.out.println(new StringBuffer().append("Checking for guaranteed derefs in ").append(this.classContext.getCFG(this.method).getMethodName()).toString());
            }
            this.uvdDataflow = this.classContext.getUnconditionalValueDerefDataflow(this.method);
        }
        this.examineBasicBlocks();
        if (this.findGuaranteedDerefs) {
            this.examineNullValues();
        }
        this.examineRedundantBranches();
    }

    private void examineBasicBlocks() throws DataflowAnalysisException, CFGBuilderException {
        Iterator<BasicBlock> bbIter = this.invDataflow.getCFG().blockIterator();
        while (bbIter.hasNext()) {
            BasicBlock basicBlock = bbIter.next();
            if (basicBlock.isNullCheck()) {
                this.analyzeNullCheck(this.classContext, this.method, this.invDataflow, basicBlock);
                continue;
            }
            if (basicBlock.isEmpty()) continue;
            InstructionHandle lastHandle = basicBlock.getLastInstruction();
            Instruction last = lastHandle.getInstruction();
            switch (last.getOpcode()) {
                case 165: 
                case 166: {
                    this.analyzeRefComparisonBranch(basicBlock, lastHandle);
                    break;
                }
                case 198: 
                case 199: {
                    this.analyzeIfNullBranch(basicBlock, lastHandle);
                }
            }
        }
    }

    private void examineNullValues() throws CFGBuilderException, DataflowAnalysisException {
        Set<LocationWhereValueBecomesNull> locationWhereValueBecomesNullSet = ((IsNullValueAnalysis)this.invDataflow.getAnalysis()).getLocationWhereValueBecomesNullSet();
        if (DEBUG_DEREFS) {
            System.out.println(new StringBuffer().append("----------------------- examineNullValues ").append(locationWhereValueBecomesNullSet.size()).toString());
        }
        HashMap<ValueNumber, SortedSet<Location>> bugLocationMap = new HashMap<ValueNumber, SortedSet<Location>>();
        HashMap<ValueNumber, NullValueUnconditionalDeref> nullValueGuaranteedDerefMap = new HashMap<ValueNumber, NullValueUnconditionalDeref>();
        Iterator<Location> i = this.classContext.getCFG(this.method).locationIterator();
        while (i.hasNext()) {
            Instruction in;
            Location location = i.next();
            if (DEBUG_DEREFS) {
                System.out.println(new StringBuffer().append("At location ").append(location).toString());
            }
            if ((in = location.getHandle().getInstruction()) instanceof InvokeInstruction && this.assertionMethods.isAssertionCall((InvokeInstruction)in)) {
                if (!DEBUG_DEREFS) continue;
                System.out.println("Skipping because it is an assertion method ");
                continue;
            }
            this.checkForUnconditionallyDereferencedNullValues(location, bugLocationMap, nullValueGuaranteedDerefMap, (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location), this.invDataflow.getFactAtLocation(location), (UnconditionalValueDerefSet)this.uvdDataflow.getFactAfterLocation(location));
        }
        HashSet npeIfStatementCovered = new HashSet(nullValueGuaranteedDerefMap.keySet());
        Iterator i2 = this.classContext.getCFG(this.method).edgeIterator();
        while (i2.hasNext()) {
            Edge edge = (Edge)i2.next();
            if (edge.isExceptionEdge()) continue;
            if (DEBUG_DEREFS) {
                System.out.println(new StringBuffer().append("On edge ").append(edge.formatAsString(false)).toString());
            }
            ValueNumberFrame valueNumberFrame = (ValueNumberFrame)this.vnaDataflow.getResultFact((BasicBlock)edge.getSource());
            IsNullValueFrame invFact = (IsNullValueFrame)this.invDataflow.getFactOnEdge(edge);
            UnconditionalValueDerefSet uvdFact = (UnconditionalValueDerefSet)this.uvdDataflow.getFactOnEdge(edge);
            Location location = Location.getLastLocation((BasicBlock)edge.getSource());
            if (location == null) continue;
            Instruction in = location.getHandle().getInstruction();
            if (in instanceof InvokeInstruction && this.assertionMethods.isAssertionCall((InvokeInstruction)in)) {
                if (!DEBUG_DEREFS) continue;
                System.out.println("Skipping because it is an assertion method ");
                continue;
            }
            this.checkForUnconditionallyDereferencedNullValues(location, bugLocationMap, nullValueGuaranteedDerefMap, valueNumberFrame, invFact, uvdFact);
        }
        HashMap<ValueNumber, HashSet<Location>> nullValueAssignmentMap = new HashMap<ValueNumber, HashSet<Location>>();
        for (LocationWhereValueBecomesNull locationWhereValueBecomesNull : locationWhereValueBecomesNullSet) {
            HashSet<Location> locationSet;
            if (DEBUG_DEREFS) {
                System.out.println(new StringBuffer().append("OOO ").append(locationWhereValueBecomesNull).toString());
            }
            if ((locationSet = (HashSet<Location>)nullValueAssignmentMap.get(locationWhereValueBecomesNull.getValueNumber())) == null) {
                locationSet = new HashSet<Location>();
                nullValueAssignmentMap.put(locationWhereValueBecomesNull.getValueNumber(), locationSet);
            }
            locationSet.add(locationWhereValueBecomesNull.getLocation());
            if (!DEBUG_DEREFS) continue;
            System.out.println(new StringBuffer().append(locationWhereValueBecomesNull.getValueNumber()).append(" becomes null at ").append(locationWhereValueBecomesNull.getLocation()).toString());
        }
        for (Map.Entry entry : nullValueGuaranteedDerefMap.entrySet()) {
            ValueNumber valueNumber = (ValueNumber)entry.getKey();
            Set<Location> derefLocationSet = ((NullValueUnconditionalDeref)entry.getValue()).getDerefLocationSet();
            Set assignedNullLocationSet = (Set)nullValueAssignmentMap.get(valueNumber);
            if (assignedNullLocationSet == null) {
                if (DEBUG_DEREFS) {
                    String where = new StringBuffer().append(this.classContext.getJavaClass().getClassName()).append(".").append(this.method.getName()).append(":").append(this.method.getSignature()).toString();
                    System.out.println(new StringBuffer().append("Problem at ").append(where).toString());
                    for (Location loc : derefLocationSet) {
                        System.out.println(new StringBuffer().append("Dereference at ").append(loc).toString());
                    }
                }
                assignedNullLocationSet = Collections.EMPTY_SET;
            }
            this.collector.foundGuaranteedNullDeref(assignedNullLocationSet, derefLocationSet, (SortedSet)bugLocationMap.get(valueNumber), this.vnaDataflow, valueNumber, ((NullValueUnconditionalDeref)entry.getValue()).isAlwaysOnExceptionPath(), npeIfStatementCovered.contains(valueNumber));
        }
    }

    private void checkForUnconditionallyDereferencedNullValues(Location thisLocation, Map<ValueNumber, SortedSet<Location>> bugLocations, Map<ValueNumber, NullValueUnconditionalDeref> nullValueGuaranteedDerefMap, ValueNumberFrame vnaFrame, IsNullValueFrame invFrame, UnconditionalValueDerefSet derefSet) {
        if (DEBUG_DEREFS) {
            System.out.println(new StringBuffer().append("vna *** ").append(vnaFrame).toString());
            System.out.println(new StringBuffer().append("inv *** ").append(invFrame).toString());
            System.out.println(new StringBuffer().append("deref * ").append(derefSet).toString());
        }
        if (!vnaFrame.isValid() || !invFrame.isValid() || vnaFrame.getNumSlots() != invFrame.getNumSlots()) {
            return;
        }
        for (int j = 0; j < invFrame.getNumSlots(); ++j) {
            ValueNumber valueNumber;
            IsNullValue isNullValue = (IsNullValue)invFrame.getValue(j);
            if (!isNullValue.isDefinitelyNull() || !derefSet.isUnconditionallyDereferenced(valueNumber = (ValueNumber)vnaFrame.getValue(j))) continue;
            this.noteUnconditionallyDereferencedNullValue(thisLocation, bugLocations, nullValueGuaranteedDerefMap, derefSet, isNullValue, valueNumber);
        }
        for (Map.Entry<ValueNumber, IsNullValue> entry : invFrame.getKnownValueMapEntrySet()) {
            if (!entry.getValue().isDefinitelyNull() || !derefSet.isUnconditionallyDereferenced(entry.getKey())) continue;
            this.noteUnconditionallyDereferencedNullValue(thisLocation, bugLocations, nullValueGuaranteedDerefMap, derefSet, entry.getValue(), entry.getKey());
        }
    }

    private void noteUnconditionallyDereferencedNullValue(Location thisLocation, Map<ValueNumber, SortedSet<Location>> bugLocations, Map<ValueNumber, NullValueUnconditionalDeref> nullValueGuaranteedDerefMap, UnconditionalValueDerefSet derefSet, IsNullValue isNullValue, ValueNumber valueNumber) {
        NullValueUnconditionalDeref thisNullValueDeref;
        if (DEBUG) {
            System.out.println(new StringBuffer().append("%%% HIT for value number ").append(valueNumber).append(" @ ").append(thisLocation).toString());
        }
        if ((thisNullValueDeref = nullValueGuaranteedDerefMap.get(valueNumber)) == null) {
            thisNullValueDeref = new NullValueUnconditionalDeref();
            nullValueGuaranteedDerefMap.put(valueNumber, thisNullValueDeref);
        }
        thisNullValueDeref.add(isNullValue, derefSet.getUnconditionalDerefLocationSet(valueNumber));
        if (thisLocation != null) {
            SortedSet<Location> locationsForThisBug = bugLocations.get(valueNumber);
            if (locationsForThisBug == null) {
                locationsForThisBug = new TreeSet<Location>();
                bugLocations.put(valueNumber, locationsForThisBug);
            }
            locationsForThisBug.add(thisLocation);
        }
    }

    private void examineRedundantBranches() {
        for (RedundantBranch redundantBranch : this.redundantBranchList) {
            int lineNumber;
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Redundant branch: ").append(redundantBranch).toString());
            }
            boolean confused = this.undeterminedBranchSet.get(lineNumber = redundantBranch.lineNumber) || this.definitelySameBranchSet.get(lineNumber) && this.definitelyDifferentBranchSet.get(lineNumber);
            boolean reportIt = true;
            if (this.lineMentionedMultipleTimes.get(lineNumber) && confused) {
                reportIt = false;
            }
            if (redundantBranch.location.getBasicBlock().isInJSRSubroutine() && confused) {
                reportIt = false;
            }
            if (!reportIt) continue;
            this.collector.foundRedundantNullCheck(redundantBranch.location, redundantBranch);
        }
    }

    private void analyzeRefComparisonBranch(BasicBlock basicBlock, InstructionHandle lastHandle) throws DataflowAnalysisException {
        boolean definitelyDifferent;
        Location location = new Location(lastHandle, basicBlock);
        IsNullValueFrame frame = this.invDataflow.getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        if (frame.getStackDepth() < 2) {
            throw new DataflowAnalysisException(new StringBuffer().append("Stack underflow at ").append(lastHandle).toString());
        }
        int lineNumber = NullDerefAndRedundantComparisonFinder.getLineNumber(this.method, lastHandle);
        if (lineNumber < 0) {
            return;
        }
        int numSlots = frame.getNumSlots();
        IsNullValue top = (IsNullValue)frame.getValue(numSlots - 1);
        IsNullValue topNext = (IsNullValue)frame.getValue(numSlots - 2);
        boolean definitelySame = top.isDefinitelyNull() && topNext.isDefinitelyNull();
        boolean bl = definitelyDifferent = top.isDefinitelyNull() && topNext.isDefinitelyNotNull() || top.isDefinitelyNotNull() && topNext.isDefinitelyNull();
        if (definitelySame || definitelyDifferent) {
            if (definitelySame) {
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Line ").append(lineNumber).append(" always same").toString());
                }
                this.definitelySameBranchSet.set(lineNumber);
            }
            if (definitelyDifferent) {
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Line ").append(lineNumber).append(" always different").toString());
                }
                this.definitelyDifferentBranchSet.set(lineNumber);
            }
            RedundantBranch redundantBranch = new RedundantBranch(location, lineNumber, top, topNext);
            boolean wantSame = lastHandle.getInstruction().getOpcode() == 165;
            int infeasibleEdgeType = wantSame == definitelySame ? 0 : 1;
            Edge infeasibleEdge = this.invDataflow.getCFG().getOutgoingEdgeWithType(basicBlock, infeasibleEdgeType);
            redundantBranch.setInfeasibleEdge(infeasibleEdge);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Adding redundant branch: ").append(redundantBranch).toString());
            }
            this.redundantBranchList.add(redundantBranch);
        } else {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Line ").append(lineNumber).append(" undetermined").toString());
            }
            this.undeterminedBranchSet.set(lineNumber);
        }
    }

    private void analyzeIfNullBranch(BasicBlock basicBlock, InstructionHandle lastHandle) throws DataflowAnalysisException {
        Location location = new Location(lastHandle, basicBlock);
        IsNullValueFrame frame = this.invDataflow.getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        IsNullValue top = (IsNullValue)frame.getTopValue();
        int lineNumber = NullDerefAndRedundantComparisonFinder.getLineNumber(this.method, lastHandle);
        if (lineNumber < 0) {
            return;
        }
        if (!top.isDefinitelyNull() && !top.isDefinitelyNotNull()) {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Line ").append(lineNumber).append(" undetermined").toString());
            }
            this.undeterminedBranchSet.set(lineNumber);
            return;
        }
        short opcode = lastHandle.getInstruction().getOpcode();
        boolean definitelySame = top.isDefinitelyNull();
        if (opcode != 198) {
            boolean bl = definitelySame = !definitelySame;
        }
        if (definitelySame) {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Line ").append(lineNumber).append(" always same").toString());
            }
            this.definitelySameBranchSet.set(lineNumber);
        } else {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Line ").append(lineNumber).append(" always different").toString());
            }
            this.definitelyDifferentBranchSet.set(lineNumber);
        }
        RedundantBranch redundantBranch = new RedundantBranch(location, lineNumber, top);
        boolean wantNull = opcode == 198;
        int infeasibleEdgeType = wantNull == top.isDefinitelyNull() ? 0 : 1;
        Edge infeasibleEdge = this.invDataflow.getCFG().getOutgoingEdgeWithType(basicBlock, infeasibleEdgeType);
        redundantBranch.setInfeasibleEdge(infeasibleEdge);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Adding redundant branch: ").append(redundantBranch).toString());
        }
        this.redundantBranchList.add(redundantBranch);
    }

    private void analyzeNullCheck(ClassContext classContext, Method method, IsNullValueDataflow invDataflow, BasicBlock basicBlock) throws DataflowAnalysisException, CFGBuilderException {
        InstructionHandle exceptionThrowerHandle = basicBlock.getExceptionThrower();
        Instruction exceptionThrower = exceptionThrowerHandle.getInstruction();
        IsNullValueFrame frame = (IsNullValueFrame)invDataflow.getStartFact(basicBlock);
        if (!frame.isValid()) {
            return;
        }
        IsNullValue refValue = (IsNullValue)frame.getInstance(exceptionThrower, classContext.getConstantPoolGen());
        if (DEBUG) {
            System.out.println(new StringBuffer().append("For basic block ").append(basicBlock).append(" value is ").append(refValue).toString());
        }
        if (!refValue.mightBeNull()) {
            return;
        }
        ValueNumberFrame vnaFrame = (ValueNumberFrame)classContext.getValueNumberDataflow(method).getStartFact(basicBlock);
        if (!vnaFrame.isValid()) {
            return;
        }
        ValueNumber valueNumber = (ValueNumber)vnaFrame.getInstance(exceptionThrower, classContext.getConstantPoolGen());
        Location location = new Location(exceptionThrowerHandle, basicBlock);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Warning: VN ").append(valueNumber).append(" invf: ").append(frame).append(" @ ").append(location).toString());
        }
        this.collector.foundNullDeref(classContext, location, valueNumber, refValue, vnaFrame);
    }

    private static int getLineNumber(Method method, InstructionHandle handle) {
        LineNumberTable table = method.getCode().getLineNumberTable();
        if (table == null) {
            return -1;
        }
        return table.getSourceLine(handle.getPosition());
    }

    static {
        if (DEBUG) {
            System.out.println("fnd.debug enabled");
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullValueUnconditionalDeref {
        private boolean alwaysOnExceptionPath = true;
        private Set<Location> derefLocationSet = new HashSet<Location>();

        public void add(IsNullValue isNullValue, Set<Location> unconditionalDerefLocationSet) {
            if (!isNullValue.isException()) {
                this.alwaysOnExceptionPath = false;
            }
            this.derefLocationSet.addAll(unconditionalDerefLocationSet);
        }

        public Set<Location> getDerefLocationSet() {
            return this.derefLocationSet;
        }

        public boolean isAlwaysOnExceptionPath() {
            return this.alwaysOnExceptionPath;
        }
    }
}

