/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureParser {
    private final String signature;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$SignatureParser;

    public SignatureParser(String signature) {
        if (!signature.startsWith("(")) {
            throw new IllegalArgumentException(new StringBuffer().append("Bad method signature: ").append(signature).toString());
        }
        this.signature = signature;
    }

    public Iterator<String> parameterSignatureIterator() {
        return new ParameterSignatureIterator();
    }

    public String getReturnTypeSignature() {
        int endOfParams = this.signature.lastIndexOf(41);
        if (endOfParams < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Bad method signature: ").append(this.signature).toString());
        }
        return this.signature.substring(endOfParams + 1);
    }

    public int getNumParameters() {
        int count = 0;
        Iterator<String> i = this.parameterSignatureIterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public static int getNumParametersForInvocation(InvokeInstruction inv, ConstantPoolGen cpg) {
        SignatureParser sigParser = new SignatureParser(inv.getSignature(cpg));
        return sigParser.getNumParameters();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$SignatureParser == null ? (class$edu$umd$cs$findbugs$ba$SignatureParser = SignatureParser.class$("edu.umd.cs.findbugs.ba.SignatureParser")) : class$edu$umd$cs$findbugs$ba$SignatureParser).getName()).append(" '<method signature>'").toString());
            System.exit(1);
        }
        SignatureParser parser = new SignatureParser(args[0]);
        Iterator<String> i = parser.parameterSignatureIterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
        System.out.println(new StringBuffer().append(parser.getNumParameters()).append(" parameter(s)").toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterSignatureIterator
    implements Iterator<String> {
        private int index = 1;

        private ParameterSignatureIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < SignatureParser.this.signature.length() && SignatureParser.this.signature.charAt(this.index) != ')';
        }

        @Override
        public String next() {
            boolean done;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuffer result = new StringBuffer();
            do {
                done = true;
                char ch = SignatureParser.this.signature.charAt(this.index);
                switch (ch) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        result.append(SignatureParser.this.signature.charAt(this.index));
                        ++this.index;
                        break;
                    }
                    case 'L': {
                        int semi = SignatureParser.this.signature.indexOf(59, this.index + 1);
                        if (semi < 0) {
                            throw new IllegalStateException(new StringBuffer().append("Invalid method signature: ").append(SignatureParser.this.signature).toString());
                        }
                        result.append(SignatureParser.this.signature.substring(this.index, semi + 1));
                        this.index = semi + 1;
                        break;
                    }
                    case '[': {
                        result.append('[');
                        ++this.index;
                        done = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(new StringBuffer().append("Invalid method signature: ").append(SignatureParser.this.signature).toString());
                    }
                }
            } while (!done);
            return result.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }
}

