/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ReverseDFSOrder;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import java.util.Iterator;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataflow<Fact, AnalysisType extends DataflowAnalysis<Fact>> {
    private CFG cfg;
    private AnalysisType analysis;
    private BlockOrder blockOrder;
    private boolean isForwards;
    private int numIterations;
    static final boolean DEBUG;
    private static final int MAX_ITERS;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$Dataflow;

    public Dataflow(CFG cfg, AnalysisType analysis) {
        this.cfg = cfg;
        this.analysis = analysis;
        this.blockOrder = analysis.getBlockOrder(cfg);
        this.isForwards = analysis.isForwards();
        this.numIterations = 0;
        Iterator<BasicBlock> i = cfg.blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            Object result = analysis.getResultFact(block);
            if (block == this.logicalEntryBlock()) {
                try {
                    analysis.initEntryFact(result);
                }
                catch (DataflowAnalysisException e) {
                    analysis.initResultFact(result);
                }
                continue;
            }
            analysis.initResultFact(result);
        }
    }

    private String getFullyQualifiedMethodName() {
        MethodGen methodGen = this.cfg.getMethodGen();
        String methodName = methodGen == null ? this.cfg.getMethodName() : SignatureConverter.convertMethodSignature(methodGen);
        return methodName;
    }

    public void execute() throws DataflowAnalysisException {
        boolean change;
        if (DEBUG) {
            String shortAnalysisName = this.analysis.getClass().getName();
            int pkgEnd = shortAnalysisName.lastIndexOf(46);
            if (pkgEnd >= 0) {
                shortAnalysisName = shortAnalysisName.substring(pkgEnd + 1);
            }
            System.out.println(new StringBuffer().append("Executing ").append(shortAnalysisName).append(" on ").append(this.getFullyQualifiedMethodName()).toString());
        }
        int timestamp = 0;
        do {
            change = false;
            ++this.numIterations;
            if (DEBUG) {
                System.out.println("----------------------------------------------------------------------");
                System.out.println(new StringBuffer().append(this.getClass().getName()).append(" iteration: ").append(this.numIterations).append(", timestamp: ").append(timestamp).toString());
                System.out.println("----------------------------------------------------------------------");
            }
            if (this.numIterations >= MAX_ITERS) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)new StringBuffer().append("Too many iterations (").append(this.numIterations).append(") in dataflow when analyzing ").append(this.getFullyQualifiedMethodName()).toString());
                }
                break;
            }
            this.analysis.startIteration();
            if (DEBUG && this.blockOrder instanceof ReverseDFSOrder) {
                ReverseDFSOrder rBlockOrder = (ReverseDFSOrder)this.blockOrder;
                System.out.println(new StringBuffer().append("Entry point is: ").append(this.logicalEntryBlock()).toString());
                System.out.println("Basic block order: ");
                Iterator<BasicBlock> i = this.blockOrder.blockIterator();
                while (i.hasNext()) {
                    BasicBlock block = i.next();
                    if (!DEBUG) continue;
                    Dataflow.debug(block, new StringBuffer().append("rBlockOrder ").append(rBlockOrder.rdfs.getDiscoveryTime(block)).append("\n").toString());
                }
            }
            Iterator<BasicBlock> i = this.blockOrder.blockIterator();
            while (i.hasNext()) {
                BasicBlock block = i.next();
                if (DEBUG) {
                    Dataflow.debug(block, "start\n");
                }
                Object start = this.analysis.getStartFact(block);
                boolean needToRecompute = false;
                Object result = this.analysis.getResultFact(block);
                int originalResultTimestamp = this.analysis.getLastUpdateTimestamp(result);
                if (block == this.logicalEntryBlock()) {
                    this.analysis.makeFactTop(start);
                    this.analysis.initEntryFact(start);
                    if (DEBUG) {
                        Dataflow.debug(block, new StringBuffer().append("Init entry fact ==> ").append(start).append("\n").toString());
                    }
                    needToRecompute = true;
                } else {
                    int predLastUpdated;
                    Object predFact;
                    BasicBlock logicalPred;
                    Edge edge;
                    int lastCalculated = this.analysis.getLastUpdateTimestamp(start);
                    Iterator<Edge> predEdgeIter = this.logicalPredecessorEdgeIterator(block);
                    int predCount = 0;
                    while (predEdgeIter.hasNext()) {
                        edge = predEdgeIter.next();
                        logicalPred = this.isForwards ? (BasicBlock)edge.getSource() : (BasicBlock)edge.getTarget();
                        predFact = this.analysis.getResultFact(logicalPred);
                        predLastUpdated = this.analysis.getLastUpdateTimestamp(predFact);
                        if (this.analysis.isTop(predFact)) continue;
                        ++predCount;
                        if (predLastUpdated < lastCalculated) continue;
                        needToRecompute = true;
                        if (!DEBUG) break;
                        System.out.println(new StringBuffer().append("Need to recompute. My timestamp = ").append(lastCalculated).append(", pred timestamp = ").append(predLastUpdated).append(", pred fact = ").append(predFact).toString());
                        break;
                    }
                    if (predCount == 0) {
                        needToRecompute = true;
                    }
                    if (!needToRecompute) {
                        if (!DEBUG) continue;
                        Dataflow.debug(block, "Skipping: predecessors haven't changed");
                        System.out.println(new StringBuffer().append(" curr timestamp: ").append(timestamp).toString());
                        System.out.println(new StringBuffer().append(" last timestamp: ").append(lastCalculated).toString());
                        predEdgeIter = this.logicalPredecessorEdgeIterator(block);
                        while (predEdgeIter.hasNext()) {
                            edge = predEdgeIter.next();
                            logicalPred = this.isForwards ? (BasicBlock)edge.getSource() : (BasicBlock)edge.getTarget();
                            predFact = this.analysis.getResultFact(logicalPred);
                            predLastUpdated = this.analysis.getLastUpdateTimestamp(predFact);
                            System.out.println(new StringBuffer().append(" pred timestamp: ").append(predLastUpdated).toString());
                        }
                        System.out.println(new StringBuffer().append("Fact: ").append(start).toString());
                        continue;
                    }
                    if (needToRecompute) {
                        this.analysis.makeFactTop(start);
                        predEdgeIter = this.logicalPredecessorEdgeIterator(block);
                        while (predEdgeIter.hasNext()) {
                            edge = predEdgeIter.next();
                            logicalPred = this.isForwards ? (BasicBlock)edge.getSource() : (BasicBlock)edge.getTarget();
                            predFact = this.analysis.getResultFact(logicalPred);
                            Object edgeFact = this.analysis.createFact();
                            this.analysis.copy(predFact, edgeFact);
                            this.analysis.edgeTransfer(edge, edgeFact);
                            if (DEBUG && !this.analysis.same(edgeFact, predFact)) {
                                Dataflow.debug(block, logicalPred, edge, new StringBuffer().append("Edge transfer ").append(predFact).append(" ==> ").append(edgeFact).toString());
                            }
                            if (DEBUG) {
                                Dataflow.debug(block, logicalPred, edge, new StringBuffer().append("\n  Meet ").append(start).append("\n   with ").append(edgeFact).append("\n   pred last updated at ").append(this.analysis.getLastUpdateTimestamp(predFact)).append("\n").toString());
                            }
                            this.analysis.meetInto(edgeFact, edge, start);
                            this.analysis.setLastUpdateTimestamp(start, timestamp);
                            int pos = -1;
                            if (block.getFirstInstruction() != null) {
                                pos = block.getFirstInstruction().getPosition();
                            }
                            if (!DEBUG) continue;
                            System.out.println(new StringBuffer().append(" [").append(pos).append("]==> ").append(start).append(" @ ").append(timestamp).append(" \n").toString());
                        }
                    }
                }
                if (DEBUG) {
                    Dataflow.debug(block, new StringBuffer().append("start fact is ").append(start).append("\n").toString());
                }
                boolean resultWasTop = this.analysis.isTop(result);
                Object origResult = null;
                if (!resultWasTop) {
                    origResult = this.analysis.createFact();
                    this.analysis.copy(result, origResult);
                }
                this.analysis.transfer(block, null, start, result);
                if (DEBUG && SystemProperties.getBoolean("dataflow.blockdebug")) {
                    Dataflow.debug(block, "Dumping flow values for block:\n");
                    BasicBlock.InstructionIterator ii = block.instructionIterator();
                    while (ii.hasNext()) {
                        InstructionHandle handle = (InstructionHandle)ii.next();
                        Object tmpResult = this.analysis.createFact();
                        this.analysis.transfer(block, handle, start, tmpResult);
                        System.out.println(new StringBuffer().append("\t").append(handle).append(" ").append(tmpResult).toString());
                    }
                }
                if (DEBUG) {
                    Dataflow.debug(block, new StringBuffer().append("orig result is ").append(origResult).append("\n").toString());
                }
                boolean thisResultChanged = false;
                if (resultWasTop) {
                    thisResultChanged = !this.analysis.isTop(result);
                } else {
                    boolean bl = thisResultChanged = !this.analysis.same(result, origResult);
                }
                if (thisResultChanged) {
                    ++timestamp;
                    if (DEBUG) {
                        Dataflow.debug(block, new StringBuffer().append("result changed at timestamp ").append(timestamp).append("\n").toString());
                    }
                    if (DEBUG && !needToRecompute) {
                        System.out.println("I thought I didn't need to recompute");
                    }
                    change = true;
                    this.analysis.setLastUpdateTimestamp(result, timestamp);
                } else {
                    this.analysis.setLastUpdateTimestamp(result, originalResultTimestamp);
                }
                if (!DEBUG) continue;
                Dataflow.debug(block, new StringBuffer().append("result is ").append(result).append(" @ timestamp ").append(this.analysis.getLastUpdateTimestamp(result)).append("\n").toString());
            }
            this.analysis.finishIteration();
        } while (change);
    }

    private static String blockId(BasicBlock bb) {
        InstructionHandle handle = bb.getFirstInstruction();
        if (handle == null) {
            return new StringBuffer().append("").append(bb.getId()).toString();
        }
        return new StringBuffer().append(bb.getId()).append(":").append(handle.getPosition()).append(" ").append(handle.getInstruction()).toString();
    }

    private static void debug(BasicBlock bb, String msg) {
        System.out.print(new StringBuffer().append("Dataflow (block ").append(Dataflow.blockId(bb)).append("): ").append(msg).toString());
    }

    private static void debug(BasicBlock bb, BasicBlock pred, Edge edge, String msg) {
        System.out.print(new StringBuffer().append("Dataflow (block ").append(Dataflow.blockId(bb)).append(", predecessor ").append(Dataflow.blockId(pred)).append(" [").append(Edge.edgeTypeToString(edge.getType())).append("]): ").append(msg).toString());
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public Fact getStartFact(BasicBlock block) {
        return this.analysis.getStartFact(block);
    }

    public Fact getResultFact(BasicBlock block) {
        return this.analysis.getResultFact(block);
    }

    public AnalysisType getAnalysis() {
        return this.analysis;
    }

    public CFG getCFG() {
        return this.cfg;
    }

    private Iterator<Edge> logicalPredecessorEdgeIterator(BasicBlock block) {
        return this.isForwards ? this.cfg.incomingEdgeIterator(block) : this.cfg.outgoingEdgeIterator(block);
    }

    private BasicBlock logicalEntryBlock() {
        return this.isForwards ? this.cfg.getEntry() : this.cfg.getExit();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$ba$Dataflow == null ? (class$edu$umd$cs$findbugs$ba$Dataflow = Dataflow.class$("edu.umd.cs.findbugs.ba.Dataflow")) : class$edu$umd$cs$findbugs$ba$Dataflow).desiredAssertionStatus();
        DEBUG = SystemProperties.getBoolean("dataflow.debug");
        MAX_ITERS = SystemProperties.getInteger("dataflow.maxiters", 100);
    }
}

