/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageStats
implements XMLWriteable {
    public static final String ELEMENT_NAME = "PackageStats";
    public static final int ALL_ERRORS = 0;
    private final String packageName;
    private int[] nBugs = new int[]{0, 0, 0, 0, 0};
    private int size;
    private SortedMap<String, ClassStats> packageMembers = new TreeMap<String, ClassStats>();

    public PackageStats(String packageName) {
        this.packageName = packageName;
    }

    public Collection<ClassStats> getClassStats() {
        return this.packageMembers.values();
    }

    public int getTotalBugs() {
        return this.nBugs[0];
    }

    public int size() {
        return this.size;
    }

    public int getBugsAtPriority(int p) {
        return this.nBugs[p];
    }

    private ClassStats getClassStats(String name) {
        ClassStats result = (ClassStats)this.packageMembers.get(name);
        if (result == null) {
            result = new ClassStats(name);
            this.packageMembers.put(name, result);
        }
        return result;
    }

    public ClassStats getClassStatsOrNull(String name) {
        ClassStats result = (ClassStats)this.packageMembers.get(name);
        return result;
    }

    public void addError(BugInstance bug) {
        if (bug.getPriority() >= this.nBugs.length) {
            return;
        }
        int n = bug.getPriority();
        this.nBugs[n] = this.nBugs[n] + 1;
        this.nBugs[0] = this.nBugs[0] + 1;
        this.getClassStats(bug.getPrimaryClass().getClassName()).addError(bug);
    }

    public void addClass(String name, boolean isInterface, int size) {
        ClassStats classStats = this.getClassStats(name);
        classStats.setInterface(isInterface);
        classStats.setSize(size);
        this.size += size;
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.startTag(ELEMENT_NAME);
        xmlOutput.addAttribute("package", this.packageName);
        xmlOutput.addAttribute("total_bugs", String.valueOf(this.nBugs[0]));
        xmlOutput.addAttribute("total_types", String.valueOf(this.packageMembers.size()));
        xmlOutput.addAttribute("total_size", String.valueOf(this.size));
        PackageStats.writeBugPriorities(xmlOutput, this.nBugs);
        xmlOutput.stopTag(false);
        for (ClassStats classStats : this.packageMembers.values()) {
            classStats.writeXML(xmlOutput);
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }

    public static void writeBugPriorities(XMLOutput xmlOutput, int[] bugs) throws IOException {
        int i = bugs.length;
        while (--i > 0) {
            if (bugs[i] <= 0) continue;
            xmlOutput.addAttribute(new StringBuffer().append("priority_").append(i).toString(), String.valueOf(bugs[i]));
        }
    }

    public void clearBugCounts() {
        for (int i = 0; i < this.nBugs.length; ++i) {
            this.nBugs[i] = 0;
        }
        for (ClassStats classStats : this.packageMembers.values()) {
            classStats.clearBugCounts();
        }
    }

    public static class ClassStats
    implements XMLWriteable,
    Cloneable {
        private String name;
        private boolean isInterface;
        private int[] nBugs = new int[]{0, 0, 0, 0, 0};
        private int size;

        public ClassStats(String name) {
            this.name = name;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void setInterface(boolean isInterface) {
            this.isInterface = isInterface;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void addError(BugInstance bug) {
            int n = bug.getPriority();
            this.nBugs[n] = this.nBugs[n] + 1;
            this.nBugs[0] = this.nBugs[0] + 1;
        }

        public int getTotalBugs() {
            return this.nBugs[0];
        }

        public int getBugsAtPriority(int p) {
            return this.nBugs[p];
        }

        public int size() {
            return this.size;
        }

        public String getName() {
            return this.name;
        }

        public void writeXML(XMLOutput xmlOutput) throws IOException {
            xmlOutput.startTag("ClassStats");
            xmlOutput.addAttribute("class", this.name);
            xmlOutput.addAttribute("interface", String.valueOf(this.isInterface));
            xmlOutput.addAttribute("size", String.valueOf(this.size));
            xmlOutput.addAttribute("bugs", String.valueOf(this.nBugs[0]));
            PackageStats.writeBugPriorities(xmlOutput, this.nBugs);
            xmlOutput.stopTag(true);
        }

        public void clearBugCounts() {
            for (int i = 0; i < this.nBugs.length; ++i) {
                this.nBugs[i] = 0;
            }
        }
    }
}

