/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.gui.AnnotatedString;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;

public class L10N {
    private static final boolean DEBUG = SystemProperties.getBoolean("i18n.debug");
    private static final boolean GENERATE_MISSING_KEYS = SystemProperties.getBoolean("i18n.generateMissingKeys");
    private static ResourceBundle bundle;
    private static ResourceBundle bundle_en;
    private static PrintWriter extraProperties;

    private L10N() {
    }

    private static String lookup(ResourceBundle b, String key) {
        if (b == null || key == null) {
            throw new MissingResourceException(null, null, null);
        }
        return b.getString(key);
    }

    public static String getLocalString(String key, String defaultString) {
        if (key == null) {
            return "TRANSLATE(" + defaultString + ")";
        }
        try {
            return L10N.lookup(bundle, key);
        }
        catch (MissingResourceException mre) {
            try {
                String en = L10N.lookup(bundle_en, key);
                if (DEBUG) {
                    return "TRANSLATE(" + en + ")";
                }
                return en;
            }
            catch (MissingResourceException mre2) {
                if (extraProperties != null) {
                    extraProperties.println(key + "=" + defaultString);
                    extraProperties.flush();
                }
                String en = "Default(" + defaultString + ")";
                if (DEBUG) {
                    return "TRANSLATE(" + en + ")";
                }
                return en;
            }
        }
    }

    public static void localiseButton(AbstractButton button, String key, String defaultString, boolean setMnemonic) {
        int mnemonic;
        AnnotatedString as = new AnnotatedString(L10N.getLocalString(key, defaultString));
        button.setText(as.toString());
        if (setMnemonic && (mnemonic = as.getMnemonic()) != 0) {
            button.setMnemonic(mnemonic);
            button.setDisplayedMnemonicIndex(as.getMnemonicIndex());
        }
    }

    static {
        try {
            if (GENERATE_MISSING_KEYS) {
                try {
                    extraProperties = new PrintWriter(new FileWriter("/tmp/extra.properties"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            bundle = ResourceBundle.getBundle("edu.umd.cs.findbugs.gui.bundle.findbugs");
            bundle_en = ResourceBundle.getBundle("edu.umd.cs.findbugs.gui.bundle.findbugs", Locale.ENGLISH);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

