/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import edu.umd.cs.findbugs.BugInstance;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MarkerReporter
implements IWorkspaceRunnable {
    BugInstance bug;
    IResource resource;
    int startLine;

    public MarkerReporter(BugInstance bug, IResource resource, int startLine) {
        this.startLine = startLine;
        this.bug = bug;
        this.resource = resource;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        IMarker marker = this.resource.createMarker("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker");
        marker.setAttribute("lineNumber", this.startLine);
        marker.setAttribute("BUGTYPE", (Object)this.bug.getType());
        marker.setAttribute("message", (Object)this.bug.getMessage());
        marker.setAttribute("severity", 1);
        if (this.bug.getPriority() == 1) {
            marker.setAttribute("priority", 2);
        } else if (this.bug.getPriority() == 2) {
            marker.setAttribute("priority", 1);
        } else {
            marker.setAttribute("priority", 0);
        }
        String uniqueId = this.bug.getInstanceHash();
        if (uniqueId != null) {
            marker.setAttribute("FINDBUGS_UNIQUE_ID", (Object)uniqueId);
        }
    }
}

