/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.nature;

import de.tobject.findbugs.reporter.MarkerUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class FindBugsNature
implements IProjectNature {
    public static boolean DEBUG;
    private IProject project;

    public void configure() throws CoreException {
        if (DEBUG) {
            System.out.println("Adding findbugs to the project build spec.");
        }
        this.addToBuildSpec("edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder");
    }

    public void deconfigure() throws CoreException {
        if (DEBUG) {
            System.out.println("Removing findbugs from the project build spec.");
        }
        this.removeFromBuildSpec("edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder");
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        MarkerUtil.removeMarkers(this.getProject());
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].getBuilderName().equals(builderID)) continue;
            ICommand[] newCommands = new ICommand[commands.length - 1];
            System.arraycopy(commands, 0, newCommands, 0, i);
            System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
            return;
        }
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand findBugsCommand = this.getFindBugsCommand(description);
        if (findBugsCommand == null) {
            ICommand newCommand = description.newCommand();
            newCommand.setBuilderName(builderID);
            this.setFindBugsCommand(description, newCommand);
        }
    }

    private ICommand getFindBugsCommand(IProjectDescription description) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].getBuilderName().equals("edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder")) continue;
            return commands[i];
        }
        return null;
    }

    private void setFindBugsCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldFindBugsCommand = this.getFindBugsCommand(description);
        if (oldFindBugsCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = newCommand;
        } else {
            int max = oldCommands.length;
            for (int i = 0; i < max; ++i) {
                if (oldCommands[i] != oldFindBugsCommand) continue;
                oldCommands[i] = newCommand;
                break;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

