/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodObserver;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.util.BCELComparator;

public class MethodGen
extends FieldGenOrMethodGen {
    private String class_name;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private boolean strip_attributes;
    private List variable_vec = new ArrayList();
    private List line_number_vec = new ArrayList();
    private List exception_vec = new ArrayList();
    private List throws_vec = new ArrayList();
    private List code_attrs_vec = new ArrayList();
    private static BCELComparator _cmp = new BCELComparator(){

        public boolean equals(Object o1, Object o2) {
            MethodGen THIS = (MethodGen)o1;
            MethodGen THAT = (MethodGen)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        public int hashCode(Object o) {
            MethodGen THIS = (MethodGen)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private List observers;

    public MethodGen(int access_flags, Type return_type, Type[] arg_types, String[] arg_names, String method_name, String class_name, InstructionList il, ConstantPoolGen cp) {
        this.setAccessFlags(access_flags);
        this.setType(return_type);
        this.setArgumentTypes(arg_types);
        this.setArgumentNames(arg_names);
        this.setName(method_name);
        this.setClassName(class_name);
        this.setInstructionList(il);
        this.setConstantPool(cp);
        boolean abstract_ = this.isAbstract() || this.isNative();
        InstructionHandle start = null;
        InstructionHandle end = null;
        if (!abstract_) {
            start = il.getStart();
            end = il.getEnd();
            if (!this.isStatic() && class_name != null) {
                this.addLocalVariable("this", ObjectType.getInstance(class_name), start, end);
            }
        }
        if (arg_types != null) {
            int size = arg_types.length;
            int i = 0;
            while (i < size) {
                if (Type.VOID == arg_types[i]) {
                    throw new ClassGenException("'void' is an illegal argument type for a method");
                }
                ++i;
            }
            if (arg_names != null) {
                if (size != arg_names.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + arg_names.length);
                }
            } else {
                arg_names = new String[size];
                i = 0;
                while (i < size) {
                    arg_names[i] = "arg" + i;
                    ++i;
                }
                this.setArgumentNames(arg_names);
            }
            if (!abstract_) {
                i = 0;
                while (i < size) {
                    this.addLocalVariable(arg_names[i], arg_types[i], start, end);
                    ++i;
                }
            }
        }
    }

    public MethodGen(Method m, String class_name, ConstantPoolGen cp) {
        this(m.getAccessFlags(), Type.getReturnType(m.getSignature()), Type.getArgumentTypes(m.getSignature()), null, m.getName(), class_name, (m.getAccessFlags() & 0x500) == 0 ? new InstructionList(m.getCode().getCode()) : null, cp);
        Attribute[] attributes = m.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            Attribute a = attributes[i];
            if (a instanceof Code) {
                InstructionHandle end;
                Code c = (Code)a;
                this.setMaxStack(c.getMaxStack());
                this.setMaxLocals(c.getMaxLocals());
                CodeException[] ces = c.getExceptionTable();
                if (ces != null) {
                    int j = 0;
                    while (j < ces.length) {
                        CodeException ce = ces[j];
                        int type = ce.getCatchType();
                        ObjectType c_type = null;
                        if (type > 0) {
                            String cen = m.getConstantPool().getConstantString(type, (byte)7);
                            c_type = ObjectType.getInstance(cen);
                        }
                        int end_pc = ce.getEndPC();
                        int length = m.getCode().getCode().length;
                        if (length == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(ce.getStartPC()), end, this.il.findHandle(ce.getHandlerPC()), c_type);
                        ++j;
                    }
                }
                Attribute[] c_attributes = c.getAttributes();
                int j = 0;
                while (j < c_attributes.length) {
                    a = c_attributes[j];
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln = ((LineNumberTable)a).getLineNumberTable();
                        int k = 0;
                        while (k < ln.length) {
                            LineNumber l = ln[k];
                            InstructionHandle ih = this.il.findHandle(l.getStartPC());
                            if (ih != null) {
                                this.addLineNumber(ih, l.getLineNumber());
                            }
                            ++k;
                        }
                    } else if (a instanceof LocalVariableTable) {
                        LocalVariable[] lv = ((LocalVariableTable)a).getLocalVariableTable();
                        this.removeLocalVariables();
                        int k = 0;
                        while (k < lv.length) {
                            LocalVariable l = lv[k];
                            InstructionHandle start = this.il.findHandle(l.getStartPC());
                            end = this.il.findHandle(l.getStartPC() + l.getLength());
                            if (start == null) {
                                start = this.il.getStart();
                            }
                            if (end == null) {
                                end = this.il.getEnd();
                            }
                            this.addLocalVariable(l.getName(), Type.getType(l.getSignature()), l.getIndex(), start, end);
                            ++k;
                        }
                    } else {
                        this.addCodeAttribute(a);
                    }
                    ++j;
                }
            } else if (a instanceof ExceptionTable) {
                String[] names = ((ExceptionTable)a).getExceptionNames();
                int j = 0;
                while (j < names.length) {
                    this.addException(names[j]);
                    ++j;
                }
            } else {
                this.addAttribute(a);
            }
            ++i;
        }
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end) {
        byte t = type.getType();
        if (t != 16) {
            LocalVariableGen l;
            int i;
            int add = type.getSize();
            if (slot + add > this.max_locals) {
                this.max_locals = slot + add;
            }
            if ((i = this.variable_vec.indexOf(l = new LocalVariableGen(slot, name, type, start, end))) >= 0) {
                this.variable_vec.set(i, l);
            } else {
                this.variable_vec.add(l);
            }
            return l;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String name, Type type, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, this.max_locals, start, end);
    }

    public void removeLocalVariable(LocalVariableGen l) {
        this.variable_vec.remove(l);
    }

    public void removeLocalVariables() {
        this.variable_vec.clear();
    }

    private static final void sort(LocalVariableGen[] vars, int l, int r) {
        int i = l;
        int j = r;
        int m = vars[(l + r) / 2].getIndex();
        while (true) {
            if (vars[i].getIndex() < m) {
                ++i;
                continue;
            }
            while (m < vars[j].getIndex()) {
                --j;
            }
            if (i <= j) {
                LocalVariableGen h = vars[i];
                vars[i] = vars[j];
                vars[j] = h;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            MethodGen.sort(vars, l, j);
        }
        if (i < r) {
            MethodGen.sort(vars, i, r);
        }
    }

    public LocalVariableGen[] getLocalVariables() {
        int size = this.variable_vec.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.variable_vec.toArray(lg);
        int i = 0;
        while (i < size) {
            if (lg[i].getStart() == null) {
                lg[i].setStart(this.il.getStart());
            }
            if (lg[i].getEnd() == null) {
                lg[i].setEnd(this.il.getEnd());
            }
            ++i;
        }
        if (size > 1) {
            MethodGen.sort(lg, 0, size - 1);
        }
        return lg;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        int i = 0;
        while (i < size) {
            lv[i] = lg[i].getLocalVariable(cp);
            ++i;
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int src_line) {
        LineNumberGen l = new LineNumberGen(ih, src_line);
        this.line_number_vec.add(l);
        return l;
    }

    public void removeLineNumber(LineNumberGen l) {
        this.line_number_vec.remove(l);
    }

    public void removeLineNumbers() {
        this.line_number_vec.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.toArray(lg);
        return lg;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen cp) {
        int size = this.line_number_vec.size();
        LineNumber[] ln = new LineNumber[size];
        try {
            int i = 0;
            while (i < size) {
                ln[i] = ((LineNumberGen)this.line_number_vec.get(i)).getLineNumber();
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exception_vec.add(c);
        return c;
    }

    public void removeExceptionHandler(CodeExceptionGen c) {
        this.exception_vec.remove(c);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.toArray(cg);
        return cg;
    }

    private CodeException[] getCodeExceptions() {
        int size = this.exception_vec.size();
        CodeException[] c_exc = new CodeException[size];
        try {
            int i = 0;
            while (i < size) {
                CodeExceptionGen c = (CodeExceptionGen)this.exception_vec.get(i);
                c_exc[i] = c.getCodeException(this.cp);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return c_exc;
    }

    public void addException(String class_name) {
        this.throws_vec.add(class_name);
    }

    public void removeException(String c) {
        this.throws_vec.remove(c);
    }

    public void removeExceptions() {
        this.throws_vec.clear();
    }

    public String[] getExceptions() {
        String[] e = new String[this.throws_vec.size()];
        this.throws_vec.toArray(e);
        return e;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen cp) {
        int size = this.throws_vec.size();
        int[] ex = new int[size];
        try {
            int i = 0;
            while (i < size) {
                ex[i] = cp.addClass((String)this.throws_vec.get(i));
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public void addCodeAttribute(Attribute a) {
        this.code_attrs_vec.add(a);
    }

    public void removeCodeAttribute(Attribute a) {
        this.code_attrs_vec.remove(a);
    }

    public void removeCodeAttributes() {
        this.code_attrs_vec.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributes = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.toArray(attributes);
        return attributes;
    }

    public Method getMethod() {
        String signature = this.getSignature();
        int name_index = this.cp.addUtf8(this.name);
        int signature_index = this.cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            lvt = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(lvt);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            lnt = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        int i = 0;
        while (i < code_attrs.length) {
            attrs_len += code_attrs[i].getLength() + 6;
            ++i;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract() && !this.isNative()) {
            Attribute[] attributes = this.getAttributes();
            int i2 = 0;
            while (i2 < attributes.length) {
                Attribute a = attributes[i2];
                if (a instanceof Code) {
                    this.removeAttribute(a);
                }
                ++i2;
            }
            code = new Code(this.cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.max_stack, this.max_locals, byte_code, c_exc, code_attrs, this.cp.getConstantPool());
            this.addAttribute(code);
        }
        ExceptionTable et = null;
        if (this.throws_vec.size() > 0) {
            et = this.getExceptionTable(this.cp);
            this.addAttribute(et);
        }
        Method m = new Method(this.access_flags, name_index, signature_index, this.getAttributes(), this.cp.getConstantPool());
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        return m;
    }

    /*
     * Unable to fully structure code
     */
    public void removeNOPs() {
        if (this.il != null) {
            ih = this.il.getStart();
            while (ih != null) {
                block7: {
                    next = ih.next;
                    if (next != null && ih.getInstruction() instanceof NOP) {
                        try {
                            this.il.delete(ih);
                            break block7;
                        }
                        catch (TargetLostException e) {
                            targets = e.getTargets();
                            i = 0;
                            ** while (i < targets.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            targeters = targets[i].getTargeters();
                            j = 0;
                            while (j < targeters.length) {
                                targeters[j].updateTarget(targets[i], next);
                                ++j;
                            }
                            ++i;
                            continue;
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setMaxLocals(int m) {
        this.max_locals = m;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int m) {
        this.max_stack = m;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String class_name) {
        this.class_name = class_name;
    }

    public void setReturnType(Type return_type) {
        this.setType(return_type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] arg_types) {
        this.arg_types = arg_types;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(int i, Type type) {
        this.arg_types[i] = type;
    }

    public Type getArgumentType(int i) {
        return this.arg_types[i];
    }

    public void setArgumentNames(String[] arg_names) {
        this.arg_names = arg_names;
    }

    public String[] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(int i, String name) {
        this.arg_names[i] = name;
    }

    public String getArgumentName(int i) {
        return this.arg_names[i];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList il) {
        this.il = il;
    }

    public String getSignature() {
        return Type.getMethodSignature(this.type, this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max;
            int n = max = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                int i = 0;
                while (i < this.arg_types.length) {
                    max += this.arg_types[i].getSize();
                    ++i;
                }
            }
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                int index;
                Instruction ins = ih.getInstruction();
                if ((ins instanceof LocalVariableInstruction || ins instanceof RET || ins instanceof IINC) && (index = ((IndexedInstruction)((Object)ins)).getIndex() + ((TypedInstruction)((Object)ins)).getType(this.cp).getSize()) > max) {
                    max = index;
                }
                ih = ih.getNext();
            }
            this.max_locals = max;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripAttributes(boolean flag) {
        this.strip_attributes = flag;
    }

    public static int getMaxStack(ConstantPoolGen cp, InstructionList il, CodeExceptionGen[] et) {
        BranchStack branchTargets = new BranchStack();
        int i = 0;
        while (i < et.length) {
            InstructionHandle handler_pc = et[i].getHandlerPC();
            if (handler_pc != null) {
                branchTargets.push(handler_pc, 1);
            }
            ++i;
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            Instruction instruction = ih.getInstruction();
            short opcode = instruction.getOpcode();
            int delta = instruction.produceStack(cp) - instruction.consumeStack(cp);
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    Select select = (Select)branch;
                    InstructionHandle[] targets = select.getTargets();
                    int i2 = 0;
                    while (i2 < targets.length) {
                        branchTargets.push(targets[i2], stackDepth);
                        ++i2;
                    }
                    ih = null;
                } else if (!(branch instanceof IfInstruction)) {
                    if (opcode == 168 || opcode == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public void addObserver(MethodObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(o);
    }

    public void removeObserver(MethodObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator e = this.observers.iterator();
            while (e.hasNext()) {
                ((MethodObserver)e.next()).notify(this);
            }
        }
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        String signature = Type.getMethodSignature(this.type, this.arg_types);
        signature = Utility.methodSignatureToString(signature, this.name, access, true, this.getLocalVariableTable(this.cp));
        StringBuffer buf = new StringBuffer(signature);
        if (this.throws_vec.size() > 0) {
            Iterator e = this.throws_vec.iterator();
            while (e.hasNext()) {
                buf.append("\n\t\tthrows ").append(e.next());
            }
        }
        return buf.toString();
    }

    public MethodGen copy(String class_name, ConstantPoolGen cp) {
        Method m = ((MethodGen)this.clone()).getMethod();
        MethodGen mg = new MethodGen(m, class_name, this.cp);
        if (this.cp != cp) {
            mg.setConstantPool(cp);
            mg.getInstructionList().replaceConstantPool(this.cp, cp);
        }
        return mg;
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator comparator) {
        _cmp = comparator;
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle target, int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }

    static final class BranchStack {
        Stack branchTargets = new Stack();
        Hashtable visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(InstructionHandle target, int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = (BranchTarget)this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        private final BranchTarget visit(InstructionHandle target, int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private final boolean visited(InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }
}

