/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTProgram;
import Mini.MiniParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;

public class MiniC
implements Constants {
    private static Vector errors = null;
    private static Vector warnings = null;
    private static String file = null;
    private static int pass = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] argv) {
        String[] file_name = new String[argv.length];
        int files = 0;
        MiniParser parser = null;
        String base_name = null;
        boolean byte_code = true;
        try {
            int i = 0;
            while (i < argv.length) {
                if (argv[i].charAt(0) == '-') {
                    if (argv[i].equals("-java")) {
                        byte_code = false;
                    } else {
                        if (!argv[i].equals("-bytecode")) throw new Exception("Unknown option: " + argv[i]);
                        byte_code = true;
                    }
                } else {
                    file_name[files++] = argv[i];
                }
                ++i;
            }
            if (files == 0) {
                System.err.println("Nothing to compile.");
            }
            int j = 0;
            while (j < files) {
                errors = new Vector();
                warnings = new Vector();
                pass = 0;
                if (j == 0) {
                    parser = new MiniParser(new FileInputStream(file_name[0]));
                } else {
                    MiniParser.ReInit(new FileInputStream(file_name[j]));
                }
                int index = file_name[j].lastIndexOf(46);
                base_name = index > 0 ? file_name[j].substring(0, index) : file_name[j];
                index = base_name.lastIndexOf(File.separatorChar);
                if (index > 0) {
                    base_name = base_name.substring(index + 1);
                }
                file = file_name[j];
                System.out.println("Parsing ...");
                MiniParser.Program();
                ASTProgram program = (ASTProgram)MiniParser.jjtree.rootNode();
                System.out.println("Pass 1: Optimizing parse tree ...");
                pass = 1;
                program = program.traverse();
                if (errors.size() == 0) {
                    System.out.println("Pass 2: Type checking (I) ...");
                    pass = 2;
                    program.eval(2);
                }
                if (errors.size() == 0) {
                    System.out.println("Pass 3: Type checking (II) ...");
                    pass = 3;
                    program.eval(3);
                }
                int i2 = 0;
                while (i2 < errors.size()) {
                    System.out.println(errors.elementAt(i2));
                    ++i2;
                }
                i2 = 0;
                while (i2 < warnings.size()) {
                    System.out.println(warnings.elementAt(i2));
                    ++i2;
                }
                if (errors.size() == 0) {
                    if (byte_code) {
                        System.out.println("Pass 5: Generating byte code ...");
                        ClassGen class_gen = new ClassGen(base_name, "java.lang.Object", file_name[j], 49, null);
                        ConstantPoolGen cp = class_gen.getConstantPool();
                        program.byte_code(class_gen, cp);
                        JavaClass clazz = class_gen.getJavaClass();
                        clazz.dump(String.valueOf(base_name) + ".class");
                    } else {
                        System.out.println("Pass 5: Generating Java code ...");
                        PrintWriter out = new PrintWriter(new FileOutputStream(String.valueOf(base_name) + ".java"));
                        program.code(out, base_name);
                        out.close();
                        System.out.println("Pass 6: Compiling Java code ...");
                        String[] args = new String[]{"javac", String.valueOf(base_name) + ".java"};
                        try {
                            Process p = Runtime.getRuntime().exec(args);
                            p.waitFor();
                        }
                        catch (Exception e) {
                            System.out.println(e);
                        }
                    }
                }
                if (errors.size() > 0 || warnings.size() > 0) {
                    System.out.println(String.valueOf(errors.size()) + " errors and " + warnings.size() + " warnings.");
                }
                ++j;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static final void addError(int line, int column, String err) {
        if (pass != 2) {
            errors.addElement(String.valueOf(file) + ":" + MiniC.fillup(line, 3) + "," + MiniC.fillup(column, 2) + ": " + err);
        }
    }

    static final void addWarning(int line, int column, String err) {
        warnings.addElement("Warning: " + file + ":" + MiniC.fillup(line, 3) + "," + MiniC.fillup(column, 3) + ": " + err);
    }

    static final String fillup(int n, int len) {
        String str = Integer.toString(n);
        int diff = len - str.length();
        if (diff > 0) {
            char[] chs = new char[diff];
            int i = 0;
            while (i < diff) {
                chs[i] = 32;
                ++i;
            }
            return String.valueOf(new String(chs)) + str;
        }
        return str;
    }

    static final void addWarning(String err) {
        warnings.addElement(err);
    }
}

