/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTExpr;
import Mini.ASTIdent;
import Mini.EnvEntry;
import org.apache.bcel.Constants;

public class Function
implements Constants,
EnvEntry {
    private ASTIdent name;
    private ASTIdent[] args;
    private ASTExpr body;
    private boolean reserved;
    private int line;
    private int column;
    private String fun_name;
    private int no_args;

    public Function(ASTIdent name, ASTIdent[] args) {
        this(name, args, false);
    }

    public Function(ASTIdent name, ASTIdent[] args, boolean reserved) {
        this.name = name;
        this.args = args;
        this.reserved = reserved;
        this.fun_name = name.getName();
        this.line = name.getLine();
        this.column = name.getColumn();
        this.setArgs(args);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.no_args) {
            buf.append(this.args[i].getName());
            if (i < this.no_args - 1) {
                buf.append(", ");
            }
            ++i;
        }
        String prefix = "Function " + this.fun_name + "(" + buf.toString() + ")";
        if (!this.reserved) {
            return String.valueOf(prefix) + " declared at line " + this.line + ", column " + this.column;
        }
        return String.valueOf(prefix) + " <predefined function>";
    }

    public int getNoArgs() {
        return this.no_args;
    }

    public ASTIdent getName() {
        return this.name;
    }

    public String getHashKey() {
        return this.fun_name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public ASTIdent getArg(int i) {
        return this.args[i];
    }

    public ASTIdent[] getArgs() {
        return this.args;
    }

    public void setArgs(ASTIdent[] args) {
        this.args = args;
        this.no_args = args == null ? 0 : args.length;
    }
}

