/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTExpr;
import Mini.ASTIdent;
import Mini.EnvEntry;
import Mini.Environment;
import Mini.Function;
import Mini.MiniC;
import Mini.MiniParser;
import Mini.MiniParserTreeConstants;
import Mini.Node;
import Mini.SimpleNode;
import Mini.Variable;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.InstructionFinder;

public class ASTFunDecl
extends SimpleNode
implements MiniParserTreeConstants,
Constants {
    private ASTIdent name;
    private ASTIdent[] argv;
    private ASTExpr body;
    private int type = 15;
    private int line;
    private int column;
    private boolean is_simple;
    private boolean is_recursive;
    private int max_depth;
    private Environment env;
    private static final InstructionFinder.CodeConstraint my_constraint = new InstructionFinder.CodeConstraint(){

        public boolean checkCode(InstructionHandle[] match) {
            BranchInstruction if_icmp = (BranchInstruction)match[0].getInstruction();
            GOTO goto_ = (GOTO)match[2].getInstruction();
            return if_icmp.getTarget() == match[3] && goto_.getTarget() == match[4];
        }
    };
    static int size;
    static int max_size;

    ASTFunDecl(int id2) {
        super(id2);
    }

    ASTFunDecl(MiniParser p, int id2) {
        super(p, id2);
    }

    public static Node jjtCreate(MiniParser p, int id2) {
        return new ASTFunDecl(p, id2);
    }

    ASTFunDecl(ASTIdent name, ASTIdent[] argv, ASTExpr body, int type) {
        this(1);
        this.name = name;
        this.argv = argv;
        this.body = body;
        this.type = type;
    }

    public void closeNode() {
        this.name = (ASTIdent)this.children[0];
        this.body = (ASTExpr)this.children[this.children.length - 1];
        this.argv = new ASTIdent[this.children.length - 2];
        int i = 1;
        while (i < this.children.length - 1) {
            this.argv[i - 1] = (ASTIdent)this.children[i];
            ++i;
        }
        this.children = null;
    }

    public ASTFunDecl traverse(Environment env) {
        this.env = env;
        int i = 0;
        while (i < this.argv.length) {
            EnvEntry entry = env.get(this.argv[i].getName());
            if (entry != null) {
                MiniC.addError(this.argv[i].getLine(), this.argv[i].getColumn(), "Redeclaration of " + entry + ".");
            } else {
                env.put(new Variable(this.argv[i]));
            }
            ++i;
        }
        try {
            Function fun = (Function)env.get(this.name.getName());
            fun.setArgs(this.argv);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.body = this.body.traverse(env);
        return this;
    }

    public int eval(int pass) {
        int expected = this.name.getType();
        this.type = this.body.eval(expected);
        if (expected != 15 && this.type != expected) {
            MiniC.addError(this.line, this.column, "Function f ist not of type " + TYPE_NAMES[expected] + " as previously assumed, but " + TYPE_NAMES[this.type]);
        }
        this.name.setType(this.type);
        this.is_simple = this.body.isSimple();
        if (pass == 2 && this.type == 15) {
            this.is_recursive = true;
        }
        return this.type;
    }

    public void code(PrintWriter out) {
        boolean main = false;
        boolean ignore = false;
        String fname = this.name.getName();
        if (fname.equals("main")) {
            out.println("  public static void main(String[] _argv) {");
            main = true;
        } else if (fname.equals("READ") || fname.equals("WRITE")) {
            ignore = true;
        } else {
            out.print("  public static final int " + fname + "(");
            int i = 0;
            while (i < this.argv.length) {
                out.print("int " + this.argv[i].getName());
                if (i < this.argv.length - 1) {
                    out.print(", ");
                }
                ++i;
            }
            out.println(")\n    throws IOException\n  {");
        }
        if (!ignore) {
            StringBuffer buf = new StringBuffer();
            this.body.code(buf);
            out.println(ASTFunDecl.getVarDecls());
            String expr = buf.toString();
            if (main) {
                out.println("    try {");
            }
            out.println(expr);
            if (main) {
                out.println("    } catch(Exception e) { System.err.println(e); }\n  }\n");
            } else {
                out.println("\n    return " + ASTFunDecl.pop() + ";\n  }\n");
            }
        }
        ASTFunDecl.reset();
    }

    public void byte_code(ClassGen class_gen, ConstantPoolGen cp) {
        MethodGen method = null;
        boolean main = false;
        boolean ignore = false;
        String class_name = class_gen.getClassName();
        String fname = this.name.getName();
        InstructionList il = new InstructionList();
        Type[] args = new Type[]{new ArrayType(Type.STRING, 1)};
        String[] arg_names = new String[]{"$argv"};
        if (fname.equals("main")) {
            method = new MethodGen(9, Type.VOID, args, arg_names, "main", class_name, il, cp);
            main = true;
        } else if (fname.equals("READ") || fname.equals("WRITE")) {
            ignore = true;
        } else {
            int size = this.argv.length;
            arg_names = new String[size];
            args = new Type[size];
            int i = 0;
            while (i < size) {
                args[i] = Type.INT;
                arg_names[i] = this.argv[i].getName();
                ++i;
            }
            method = new MethodGen(26, Type.INT, args, arg_names, fname, class_name, il, cp);
            LocalVariableGen[] lv = method.getLocalVariables();
            int i2 = 0;
            while (i2 < size) {
                Variable entry = (Variable)this.env.get(arg_names[i2]);
                entry.setLocalVariable(lv[i2]);
                ++i2;
            }
            method.addException("java.io.IOException");
        }
        if (!ignore) {
            this.body.byte_code(il, method, cp);
            if (main) {
                ObjectType e_type = ObjectType.getInstance("java.lang.Exception");
                InstructionHandle start = il.getStart();
                LocalVariableGen exc = method.addLocalVariable("$e", e_type, null, null);
                int slot = exc.getIndex();
                il.append(InstructionConstants.POP);
                ASTFunDecl.pop();
                InstructionHandle end = il.append(InstructionConstants.RETURN);
                InstructionHandle handler = il.append(new ASTORE(slot));
                il.append(new GETSTATIC(cp.addFieldref("java.lang.System", "err", "Ljava/io/PrintStream;")));
                il.append(new ALOAD(slot));
                ASTFunDecl.push(2);
                il.append(new INVOKEVIRTUAL(cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/Object;)V")));
                ASTFunDecl.pop(2);
                InstructionHandle end_handler = il.append(InstructionConstants.RETURN);
                method.addExceptionHandler(start, end, handler, e_type);
                exc.setStart(handler);
                exc.setEnd(end_handler);
            } else {
                il.append(InstructionConstants.IRETURN);
            }
            method.removeNOPs();
            ASTFunDecl.optimizeIFs(il);
            method.setMaxStack(max_size);
            class_gen.addMethod(method.getMethod());
        }
        il.dispose();
        ASTFunDecl.reset();
    }

    /*
     * Unable to fully structure code
     */
    private static final void optimizeIFs(InstructionList il) {
        f = new InstructionFinder(il);
        pat = "IF_ICMP ICONST_1 GOTO ICONST_0 IFEQ Instruction";
        it = f.search(pat, ASTFunDecl.my_constraint);
        block2: while (it.hasNext()) {
            match = (InstructionHandle[])it.next();
            ifeq = (BranchInstruction)match[4].getInstruction();
            if_icmp = (BranchHandle)match[0];
            if_icmp.setTarget(ifeq.getTarget());
            try {
                il.delete(match[1], match[4]);
                continue;
            }
            catch (TargetLostException e) {
                targets = e.getTargets();
                System.err.println(targets[0]);
                i = 0;
                ** while (i < targets.length)
            }
lbl-1000:
            // 1 sources

            {
                targeters = targets[i].getTargeters();
                j = 0;
                while (j < targeters.length) {
                    if (targets[i] != match[4] || targeters[j] != match[2]) {
                        System.err.println("Ooops: " + e);
                    }
                    ++j;
                }
                ++i;
                continue;
lbl26:
                // 1 sources

            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(jjtNodeName[this.id]) + " " + this.name + "(");
        int i = 0;
        while (i < this.argv.length) {
            buf.append(this.argv[i].getName());
            if (i < this.argv.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public boolean isrecursive() {
        return this.is_recursive;
    }

    public boolean isSimple() {
        return this.is_simple;
    }

    public ASTIdent getName() {
        return this.name;
    }

    public int getNoArgs() {
        return this.argv.length;
    }

    public ASTIdent[] getArgs() {
        return this.argv;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public void setPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        int i = 0;
        while (i < this.argv.length) {
            this.argv[i].dump(String.valueOf(prefix) + " ");
            ++i;
        }
        this.body.dump(String.valueOf(prefix) + " ");
    }

    static final void reset() {
        max_size = 0;
        size = 0;
    }

    private static final String getVarDecls() {
        StringBuffer buf = new StringBuffer("    int ");
        int i = 0;
        while (i < max_size) {
            buf.append("_s" + i);
            if (i < max_size - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(";\n");
        return buf.toString();
    }

    static final void pop(int s) {
        size -= s;
    }

    static final void push(int s) {
        if ((size += s) > max_size) {
            max_size = size;
        }
    }

    static final void push() {
        ASTFunDecl.push(1);
    }

    static final void push(StringBuffer buf, String str) {
        buf.append("    _s" + size + " = " + str + ";\n");
        ASTFunDecl.push(1);
    }

    static final String pop() {
        return "_s" + --size;
    }
}

