/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Method;

public class FindNonShortCircuit
extends BytecodeScanningDetector
implements StatelessDetector {
    int stage1 = 0;
    int stage2 = 0;
    int distance = 0;
    int operator;
    boolean sawDanger;
    boolean sawNullTestOld;
    boolean sawNullTestVeryOld;
    boolean sawNullTest;
    boolean sawDangerOld;
    boolean sawArrayIndex;
    boolean sawArrayIndexOld;
    boolean sawNumericTest;
    boolean sawNumericTestOld;
    boolean sawNumericTestVeryOld;
    boolean sawArrayDanger;
    boolean sawArrayDangerOld;
    private BugReporter bugReporter;
    OpcodeStack stack = new OpcodeStack();
    int prevOpcode;

    public FindNonShortCircuit(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.stage1 = 0;
        this.stage2 = 0;
        this.distance = 1000000;
        this.sawArrayDangerOld = false;
        this.sawArrayDanger = false;
        this.sawDangerOld = false;
        this.sawDanger = false;
        this.sawNullTestVeryOld = false;
        this.sawNullTestOld = false;
        this.sawNullTest = false;
        this.sawNumericTestVeryOld = false;
        this.sawNumericTestOld = false;
        this.sawNumericTest = false;
        this.prevOpcode = 0;
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        ++this.distance;
        this.scanForBooleanValue(seen);
        this.scanForDanger(seen);
        this.scanForShortCircuit(seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        this.prevOpcode = seen;
    }

    private void scanForDanger(int seen) {
        switch (seen) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.sawArrayDanger = true;
                this.sawDanger = true;
                break;
            }
            case 108: 
            case 112: 
            case 180: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 190: {
                this.sawDanger = true;
                break;
            }
        }
    }

    private void scanForShortCircuit(int seen) {
        switch (seen) {
            case 126: 
            case 128: {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                if (item0.getConstant() == null && item1.getConstant() == null && this.distance < 4) {
                    this.operator = seen;
                    this.stage2 = 1;
                    break;
                }
                this.stage2 = 0;
                break;
            }
            case 153: 
            case 154: {
                if (this.stage2 == 1) {
                    this.reportBug();
                }
                this.stage2 = 0;
                break;
            }
            case 172: 
            case 179: 
            case 181: {
                if (this.operator == 126 && this.stage2 == 1) {
                    this.reportBug();
                }
                this.stage2 = 0;
                break;
            }
            default: {
                this.stage2 = 0;
            }
        }
    }

    private void reportBug() {
        int priority = 3;
        if (this.sawDangerOld) {
            priority = this.sawNullTestVeryOld ? 1 : (this.sawNumericTestVeryOld && this.sawArrayDangerOld ? 1 : 2);
        }
        this.bugReporter.reportBug(new BugInstance((Detector)this, "NS_NON_SHORT_CIRCUIT", priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.getPC()));
    }

    private void scanForBooleanValue(int seen) {
        switch (seen) {
            case 4: {
                this.stage1 = 1;
                switch (this.prevOpcode) {
                    case 198: 
                    case 199: {
                        this.sawNullTest = true;
                        break;
                    }
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        this.sawNumericTest = true;
                    }
                }
                break;
            }
            case 167: {
                if (this.stage1 == 1) {
                    this.stage1 = 2;
                    break;
                }
                this.stage1 = 0;
                break;
            }
            case 3: {
                if (this.stage1 == 2) {
                    this.sawBooleanValue();
                }
                this.stage1 = 0;
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                String sig = this.getSigConstantOperand();
                if (sig.endsWith(")Z")) {
                    this.sawBooleanValue();
                }
                this.stage1 = 0;
                break;
            }
            default: {
                this.stage1 = 0;
            }
        }
    }

    private void sawBooleanValue() {
        this.sawDangerOld = this.sawDanger;
        this.sawArrayDangerOld = this.sawArrayDanger;
        this.sawNullTestVeryOld = this.sawNullTestOld;
        this.sawNullTestOld = this.sawNullTest;
        this.sawNumericTestVeryOld = this.sawNumericTestOld;
        this.sawNumericTestOld = this.sawNumericTest;
        this.sawNumericTest = false;
        this.sawDanger = false;
        this.sawArrayDanger = false;
        this.distance = 0;
        this.stage1 = 0;
    }
}

