/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.CachedResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CachedRowSet
implements ResultSet,
Serializable {
    private static final Logger logger = Logger.getLogger((Class)(class$ca$sqlpower$sql$CachedRowSet == null ? (class$ca$sqlpower$sql$CachedRowSet = CachedRowSet.class$("ca.sqlpower.sql.CachedRowSet")) : class$ca$sqlpower$sql$CachedRowSet));
    private int rownum = -1;
    protected List data;
    private Object[] curRow;
    private int curCol = -1;
    protected CachedResultSetMetaData rsmd;
    static /* synthetic */ Class class$ca$sqlpower$sql$CachedRowSet;

    public void populate(ResultSet rs) throws SQLException {
        this.rsmd = new CachedResultSetMetaData(rs.getMetaData(), true);
        int rowNum = 0;
        ArrayList<Object[]> newData = new ArrayList<Object[]>();
        int colCount = this.rsmd.getColumnCount();
        while (rs.next()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Populating Row " + rowNum));
            }
            Object[] row = new Object[colCount];
            for (int i = 0; i < colCount; ++i) {
                Object o = rs.getObject(i + 1);
                if (o == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("   Col " + i + ": null"));
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("   Col " + i + ": " + o + " (" + o.getClass() + ")"));
                    }
                    if (o instanceof BigDecimal) {
                        BigDecimal bd = (BigDecimal)o;
                        o = bd.scale() > 0 ? (Number)new Double(bd.doubleValue()) : (Number)new Long(bd.longValue());
                    }
                }
                row[i] = o;
            }
            newData.add(row);
            ++rowNum;
        }
        this.data = newData;
    }

    public CachedRowSet createShared() throws SQLException {
        return this.createSharedSorted(null);
    }

    public CachedRowSet createSharedSorted(RowComparator c) throws SQLException {
        CachedRowSet newRowSet = new CachedRowSet();
        newRowSet.rsmd = this.rsmd;
        if (c != null) {
            logger.info((Object)"\u001b[34mCREATING NEW ARRAYLIST\u001b[0m");
            newRowSet.data = new ArrayList(this.data);
            Collections.sort(newRowSet.data, c);
        } else {
            newRowSet.data = this.data;
        }
        return newRowSet;
    }

    public int size() {
        return this.data.size();
    }

    public List getData() {
        return this.data;
    }

    public int getColumnIndex(String columnName) throws SQLException {
        int idx = -1;
        for (int i = 0; i < this.rsmd.getColumnCount(); ++i) {
            if (!this.rsmd.getColumnName(i + 1).equalsIgnoreCase(columnName)) continue;
            idx = i + 1;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getColumnIndex(" + columnName + ") returns " + idx));
        }
        return idx;
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        if (this.curRow == null || this.curCol < 0) {
            throw new SQLException("You haven't accessed a value with a getXXX() method yet!");
        }
        return this.curRow[this.curCol] == null;
    }

    public String getString(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return null;
        }
        return this.curRow[columnIndex - 1].toString();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.curRow[columnIndex - 1];
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0;
        }
        return ((Number)this.curRow[columnIndex - 1]).byteValue();
    }

    public short getShort(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0;
        }
        return ((Number)this.curRow[columnIndex - 1]).shortValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0;
        }
        return ((Number)this.curRow[columnIndex - 1]).intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0L;
        }
        return ((Number)this.curRow[columnIndex - 1]).longValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0.0f;
        }
        return ((Number)this.curRow[columnIndex - 1]).floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0.0;
        }
        return ((Number)this.curRow[columnIndex - 1]).doubleValue();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public Date getDate(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return null;
        }
        java.util.Date uDate = (java.util.Date)this.curRow[columnIndex - 1];
        return new Date(uDate.getTime());
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return null;
        }
        return (Time)this.curRow[columnIndex - 1];
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return null;
        }
        return (Timestamp)this.curRow[columnIndex - 1];
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        return this.curRow[columnIndex - 1];
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new UnsupportedOperationException("This CachedRowSet does not support user-defined type mappings.");
    }

    public Ref getRef(int i) throws SQLException {
        this.curCol = i - 1;
        return (Ref)this.curRow[i - 1];
    }

    public Blob getBlob(int i) throws SQLException {
        this.curCol = i - 1;
        return (Blob)this.curRow[i - 1];
    }

    public Clob getClob(int i) throws SQLException {
        this.curCol = i - 1;
        return (Clob)this.curRow[i - 1];
    }

    public Array getArray(int i) throws SQLException {
        this.curCol = i - 1;
        return (Array)this.curRow[i - 1];
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    public URL getURL(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[this.curCol] == null) {
            return null;
        }
        if (this.curRow[this.curCol] instanceof URL) {
            return (URL)this.curRow[this.curCol];
        }
        try {
            return new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw new SQLException("Not a URL: <" + this.getString(columnIndex) + ">");
        }
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(columnName);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(columnName);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(columnName);
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    public int findColumn(String columnName) throws SQLException {
        int index = this.getColumnIndex(columnName);
        if (index == -1) {
            throw new SQLException("No such column '" + columnName + "' in this result set.");
        }
        return index;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.data == null) {
            throw new SQLException("This CachedRowSet is not populated yet");
        }
        return this.rownum == -1;
    }

    public boolean isAfterLast() throws SQLException {
        if (this.data == null) {
            throw new SQLException("This CachedRowSet is not populated yet");
        }
        return this.rownum >= this.data.size();
    }

    public boolean isFirst() throws SQLException {
        if (this.data == null) {
            throw new SQLException("This CachedRowSet is not populated yet");
        }
        return this.rownum == 0;
    }

    public boolean isLast() throws SQLException {
        if (this.data == null) {
            throw new SQLException("This CachedRowSet is not populated yet");
        }
        return this.rownum == this.data.size() - 1;
    }

    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    public void afterLast() throws SQLException {
        this.absolute(this.data.size());
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public int getRow() throws SQLException {
        if (this.rownum < 0) {
            return 0;
        }
        return this.rownum + 1;
    }

    public boolean absolute(int row) throws SQLException {
        if (this.data == null) {
            throw new SQLException("This CachedRowSet is not populated yet");
        }
        this.curCol = -1;
        this.curRow = null;
        this.rownum = row < 0 ? this.data.size() + row : row - 1;
        if (this.rownum < 0) {
            this.rownum = -1;
            return false;
        }
        if (this.rownum >= this.data.size()) {
            this.rownum = this.data.size();
            return false;
        }
        if (this.data.size() > 0) {
            this.curRow = (Object[])this.data.get(this.rownum);
            return true;
        }
        return false;
    }

    public boolean next() throws SQLException {
        return this.relative(1);
    }

    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    public boolean relative(int rows) throws SQLException {
        if (this.data == null) {
            throw new SQLException("This CachedRowSet is not populated yet.");
        }
        this.curCol = -1;
        this.curRow = null;
        this.rownum += rows;
        if (this.rownum < 0) {
            this.rownum = -1;
            return false;
        }
        if (this.rownum >= this.data.size()) {
            this.rownum = this.data.size();
            return false;
        }
        this.curRow = (Object[])this.data.get(this.rownum);
        return true;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new UnsupportedOperationException("Fetch direction is always FORWARD.");
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException("This CachedRowSet does not have a reference to the Statement object.");
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Updates are not supported by CachedRowSet");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return this.data.size();
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.curRow[columnIndex - 1] = null;
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.curRow[columnIndex - 1] = x ? Boolean.TRUE : Boolean.FALSE;
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.curRow[columnIndex - 1] = new Byte(x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.curRow[columnIndex - 1] = new Short(x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.curRow[columnIndex - 1] = new Integer(x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.curRow[columnIndex - 1] = new Long(x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.curRow[columnIndex - 1] = new Float(x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.curRow[columnIndex - 1] = new Double(x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported!");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported!");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported!");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (this.curRow == null) {
            throw new SQLException("Not on a valid row");
        }
        this.curRow[columnIndex - 1] = x;
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnName), x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RowComparator
    implements Comparator,
    Serializable {
        private ArrayList sortCols = new ArrayList();

        public void addSortColumn(int columnIndex, boolean ascending) {
            this.sortCols.add(new SortCol(columnIndex, ascending));
        }

        public int compare(Object row1, Object row2) {
            Object[] r1 = (Object[])row1;
            Object[] r2 = (Object[])row2;
            int diff = 0;
            Iterator it = this.sortCols.iterator();
            while (it.hasNext()) {
                SortCol sc = (SortCol)it.next();
                if (r1 == null && r2 == null) {
                    diff = 0;
                } else if (r1 == null) {
                    diff = -1;
                } else if (r2 == null) {
                    diff = 1;
                } else if (r1[sc.columnIndex - 1] instanceof Number && r2[sc.columnIndex - 1] instanceof Number) {
                    double d2;
                    double d1 = ((Number)r1[sc.columnIndex - 1]).doubleValue();
                    diff = d1 < (d2 = ((Number)r2[sc.columnIndex - 1]).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
                } else if (r1[sc.columnIndex - 1] instanceof String && r2[sc.columnIndex - 1] instanceof String) {
                    String s1 = (String)r1[sc.columnIndex - 1];
                    String s2 = (String)r2[sc.columnIndex - 1];
                    diff = s1.compareToIgnoreCase(s2);
                } else {
                    diff = ((Comparable)r1[sc.columnIndex - 1]).compareTo(r2[sc.columnIndex - 1]);
                }
                if (diff == 0) continue;
                if (sc.ascending) break;
                diff = 0 - diff;
                break;
            }
            return diff;
        }

        public boolean isEmpty() {
            return this.sortCols.isEmpty();
        }

        private static class SortCol
        implements Serializable {
            public int columnIndex;
            public boolean ascending;

            public SortCol(int columnIndex, boolean ascending) {
                this.columnIndex = columnIndex;
                this.ascending = ascending;
            }
        }
    }
}

