/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.validation;

import ca.sqlpower.validation.RegExValidator;
import ca.sqlpower.validation.Status;
import junit.framework.TestCase;

public class RegExValidatorTest
extends TestCase {
    public void testValidateDigits() {
        RegExValidator val = new RegExValidator("\\d+");
        RegExValidatorTest.assertEquals((Object)((Object)Status.OK), (Object)((Object)val.validate("0").getStatus()));
        RegExValidatorTest.assertEquals((Object)((Object)Status.OK), (Object)((Object)val.validate("42").getStatus()));
        RegExValidatorTest.assertFalse((Status.OK == val.validate("").getStatus() ? 1 : 0) != 0);
        RegExValidatorTest.assertFalse((Status.OK == val.validate("123 112").getStatus() ? 1 : 0) != 0);
        RegExValidatorTest.assertFalse((Status.OK == val.validate("123 ").getStatus() ? 1 : 0) != 0);
        RegExValidatorTest.assertFalse((Status.OK == val.validate(" 123").getStatus() ? 1 : 0) != 0);
        RegExValidatorTest.assertFalse((Status.OK == val.validate("abcde").getStatus() ? 1 : 0) != 0);
        RegExValidatorTest.assertFalse((Status.OK == val.validate("abc123").getStatus() ? 1 : 0) != 0);
    }

    public void testCaseSensitive() {
        RegExValidator val = new RegExValidator("[a-z]*", "must be all lowercase", true);
        RegExValidatorTest.assertEquals((Object)((Object)Status.OK), (Object)((Object)val.validate("abc").getStatus()));
        RegExValidatorTest.assertFalse((Status.OK == val.validate("ABC").getStatus() ? 1 : 0) != 0);
    }

    public void testCaseInsensitive() {
        RegExValidator val = new RegExValidator("[a-z]*", "must be all lowercase", false);
        RegExValidatorTest.assertEquals((Object)((Object)Status.OK), (Object)((Object)val.validate("abc").getStatus()));
        RegExValidatorTest.assertEquals((Object)((Object)Status.OK), (Object)((Object)val.validate("ABC").getStatus()));
    }
}

