/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.undo;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.undo.UndoManager;
import junit.framework.TestCase;

public class TestSQLObjectChildrenInsert
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testFolderInsert() {
    }

    public void testDatabaseInsert() throws ArchitectException {
        SQLDatabase db = new SQLDatabase();
        UndoManager undoManager = new UndoManager(db);
        db.setPlayPenDatabase(true);
        SQLTable table1 = new SQLTable(db, "table1", "remark1", "TABLE", true);
        SQLTable table2 = new SQLTable(db, "table2", "remark2", "TABLE", true);
        SQLTable table3 = new SQLTable(db, "table3", "remark3", "TABLE", true);
        SQLTable table4 = new SQLTable(db, "table4", "remark4", "TABLE", true);
        db.addChild(table1);
        db.addChild(table2);
        db.addChild(table3);
        db.addChild(table4);
        db.removeChild(2);
        undoManager.undo();
        TestSQLObjectChildrenInsert.assertEquals((String)"There should be 4 children", (int)4, (int)db.getChildCount());
        TestSQLObjectChildrenInsert.assertEquals((String)"The first table is in the wrong position", (Object)table1, (Object)db.getChild(0));
        TestSQLObjectChildrenInsert.assertEquals((String)"The Second table is in the wrong position", (Object)table2, (Object)db.getChild(1));
        TestSQLObjectChildrenInsert.assertEquals((String)"The Third table is in the wrong position", (Object)table3, (Object)db.getChild(2));
        TestSQLObjectChildrenInsert.assertEquals((String)"The Fourth table is in the wrong position", (Object)table4, (Object)db.getChild(3));
        undoManager.redo();
        TestSQLObjectChildrenInsert.assertEquals((String)"There should be 3 children", (int)3, (int)db.getChildCount());
        TestSQLObjectChildrenInsert.assertEquals((String)"The first table is in the wrong position", (Object)table1, (Object)db.getChild(0));
        TestSQLObjectChildrenInsert.assertEquals((String)"The Second table is in the wrong position", (Object)table2, (Object)db.getChild(1));
        TestSQLObjectChildrenInsert.assertEquals((String)"The Third table is in the wrong position", (Object)table4, (Object)db.getChild(2));
    }
}

