/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.etl.PLUtils;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.CommonCloseAction;
import ca.sqlpower.architect.swingui.EngineExecPanel;
import ca.sqlpower.architect.swingui.JDefaultButton;
import ca.sqlpower.architect.swingui.PLExportPanel;
import ca.sqlpower.architect.swingui.ProgressWatcher;
import ca.sqlpower.architect.swingui.QuickStartWizard;
import ca.sqlpower.architect.swingui.WizardDialog;
import ca.sqlpower.security.PLSecurityException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPLTransAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ExportPLTransAction.class);
    private final JFrame owner;
    private ArchitectFrame architectFrame = ArchitectFrame.getMainInstance();
    private List<SQLTable> tables;
    private PLExport plexp;
    private JDialog d;
    private JProgressBar plCreateTxProgressBar;
    private JLabel plCreateTxLabel;

    public ExportPLTransAction(JFrame owner) {
        super("PL Transaction Export...", ASUtils.createIcon("PLTransExport", "PL Transaction Export", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "PL Transaction Export");
        this.owner = owner;
    }

    public void setExportingTables(List<SQLTable> exportingTables) {
        logger.debug((Object)("setExportingTables(): got new list of tables to export: " + exportingTables));
        this.tables = new ArrayList<SQLTable>(exportingTables);
    }

    public synchronized void setupDialog() {
        logger.debug((Object)"running setupDialog()");
        if (this.plexp == null) {
            throw new NullPointerException("setupDialog: plexp was null");
        }
        this.plexp.setTargetDataSource(ArchitectFrame.getMainInstance().getProject().getTargetDatabase().getDataSource());
        this.d = new JDialog((Frame)this.owner, "Export ETL Transactions to PL Repository");
        if (this.plexp.getFolderName() == null || this.plexp.getFolderName().trim().length() == 0) {
            this.plexp.setFolderName(PLUtils.toPLIdentifier(String.valueOf(this.architectFrame.getProject().getName()) + "_FOLDER"));
        }
        if (this.plexp.getJobId() == null || this.plexp.getJobId().trim().length() == 0) {
            this.plexp.setJobId(PLUtils.toPLIdentifier(String.valueOf(this.architectFrame.getProject().getName()) + "_JOB"));
        }
        JPanel plp = new JPanel(new BorderLayout(12, 12));
        plp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        final PLExportPanel plPanel = new PLExportPanel();
        plPanel.setPLExport(this.plexp);
        plp.add((Component)plPanel, "Center");
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2, 25, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!plPanel.applyChanges()) {
                    return;
                }
                try {
                    List targetDBWarnings = ExportPLTransAction.this.listMissingTargetTables(ExportPLTransAction.this.tables);
                    if (!targetDBWarnings.isEmpty()) {
                        JList<Object> warnings = new JList<Object>(targetDBWarnings.toArray());
                        JPanel cp = new JPanel(new BorderLayout());
                        cp.add((Component)new JLabel("<html>The target database schema is not identical to your Architect schema.<br><br>Here are the differences:</html>"), "North");
                        cp.add((Component)new JScrollPane(warnings), "Center");
                        cp.add((Component)new JLabel("Do you want to continue anyway?"), "South");
                        int choice = JOptionPane.showConfirmDialog(ExportPLTransAction.this.owner, cp, "Target Database Structure Warning", 0, 2);
                        if (choice != 0) {
                            return;
                        }
                    }
                    ExportTxProcess etp = new ExportTxProcess(ExportPLTransAction.this.plexp, ExportPLTransAction.this.tables, ExportPLTransAction.this.d, ExportPLTransAction.this.plCreateTxProgressBar, ExportPLTransAction.this.plCreateTxLabel);
                    new Thread(etp).start();
                }
                catch (SQLException esql) {
                    JOptionPane.showMessageDialog(ExportPLTransAction.this.architectFrame, "Can't export Transaction: " + esql.getMessage());
                    logger.error((Object)"Got exception while exporting Trans", (Throwable)esql);
                    return;
                }
                catch (ArchitectException arex) {
                    JOptionPane.showMessageDialog(ExportPLTransAction.this.architectFrame, "Can't export Transaction: " + arex.getMessage());
                    logger.error((Object)"Got exception while exporting Trans", (Throwable)arex);
                    return;
                }
            }
        });
        buttonPanel.add(okButton);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                plPanel.discardChanges();
                ExportPLTransAction.this.d.dispose();
            }
        };
        cancelAction.putValue("Name", "Cancel");
        ASUtils.makeJDialogCancellable(this.d, cancelAction);
        this.d.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(cancelAction);
        buttonPanel.add(cancelButton);
        JPanel progressPanel = new JPanel(new FlowLayout(0));
        this.plCreateTxProgressBar = new JProgressBar();
        this.plCreateTxProgressBar.setStringPainted(true);
        progressPanel.add(this.plCreateTxProgressBar);
        this.plCreateTxLabel = new JLabel("Exporting PL Transactions...");
        progressPanel.add(this.plCreateTxLabel);
        progressPanel.setPreferredSize(progressPanel.getPreferredSize());
        this.plCreateTxProgressBar.setVisible(false);
        this.plCreateTxLabel.setVisible(false);
        bottomPanel.add(progressPanel);
        bottomPanel.add(buttonPanel);
        plp.add((Component)bottomPanel, "South");
        this.d.setContentPane(plp);
        this.d.pack();
        this.d.setLocationRelativeTo(this.owner);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.plexp = this.architectFrame.getProject().getPLExport();
        this.setupDialog();
        this.d.setVisible(true);
    }

    public List listMissingTargetTables(List targetTables) throws SQLException, ArchitectException {
        LinkedList<String> missingTables = new LinkedList<String>();
        for (SQLTable t : targetTables) {
            String tableStatus = this.checkTargetTable(t);
            if (tableStatus == null) continue;
            missingTables.add(tableStatus);
        }
        return missingTables;
    }

    private String checkTargetTable(SQLTable t) throws SQLException, ArchitectException {
        GenericDDLGenerator ddlg = ArchitectFrame.getMainInstance().getProject().getDDLGenerator();
        logger.debug((Object)("DDLG class is: " + ddlg.getClass().getName()));
        String tableName = ddlg.toIdentifier(t.getName());
        ArrayList<String> ourColumns = new ArrayList<String>();
        for (SQLColumn c : t.getColumns()) {
            ourColumns.add(ddlg.toIdentifier(c.getName()).toLowerCase());
        }
        ArrayList<String> actualColumns = new ArrayList<String>();
        Connection con = null;
        ResultSet rs = null;
        try {
            con = t.getParentDatabase().getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            logger.debug((Object)("Fetching columns of " + this.plexp.getTargetSchema() + "." + tableName));
            rs = dbmd.getColumns(null, this.plexp.getTargetSchema(), tableName, null);
            while (rs.next()) {
                actualColumns.add(rs.getString(4).toLowerCase());
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Could not close result set", (Throwable)ex);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Could not close connection", (Throwable)ex);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   ourColumns = " + ourColumns));
            logger.debug((Object)("actualColumns = " + actualColumns));
        }
        if (actualColumns.isEmpty()) {
            return "Target table \"" + tableName + "\" does not exist";
        }
        if (actualColumns.containsAll(ourColumns)) {
            return null;
        }
        return "Target table \"" + tableName + "\" exists but is missing columns";
    }

    public List<SQLTable> getExportingTables() {
        return this.tables;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExportTxProcess
    extends ArchitectSwingWorker {
        PLExport plExport;
        final JDialog d;
        private Runnable nextProcess;
        private List<SQLTable> exportTables;

        public ExportTxProcess(PLExport plExport, List<SQLTable> exportTables, JDialog parentDialog, JProgressBar progressBar, JLabel label) {
            this.plExport = plExport;
            this.exportTables = exportTables;
            logger.debug((Object)("Creating new ExportTxProcess for tables: " + exportTables));
            this.d = parentDialog;
            label.setText("Exporting Meta Data...");
            new ProgressWatcher(progressBar, plExport, label);
        }

        @Override
        public void doStuff() {
            if (this.isCanceled()) {
                return;
            }
            try {
                this.plExport.export(this.exportTables);
                if (this.plExport.getRunPLEngine()) {
                    logger.debug((Object)"Running PL Engine");
                    File plEngine = new File(ExportPLTransAction.this.architectFrame.getUserSettings().getETLUserSettings().getString("ETLUserSettings.PROP_PL_ENGINE_PATH", ""));
                    File plDir = plEngine.getParentFile();
                    File engineExe = new File(plDir, PLUtils.getEngineExecutableName(this.plExport.getRepositoryDataSource()));
                    final StringBuffer commandLine = new StringBuffer(1000);
                    commandLine.append(engineExe.getPath());
                    commandLine.append(" USER_PROMPT=N");
                    commandLine.append(" JOB=").append(this.plExport.getJobId());
                    commandLine.append(" USER=").append(PLUtils.getEngineConnectString(this.plExport.getRepositoryDataSource()));
                    commandLine.append(" DEBUG=N SEND_EMAIL=N SKIP_PACKAGES=N CALC_DETAIL_STATS=N COMMIT_FREQ=100 APPEND_TO_JOB_LOG_IND=N");
                    commandLine.append(" APPEND_TO_JOB_ERR_IND=N");
                    commandLine.append(" SHOW_PROGRESS=100");
                    commandLine.append(" SHOW_PROGRESS=10");
                    logger.debug((Object)commandLine.toString());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                Process proc = Runtime.getRuntime().exec(commandLine.toString());
                                JDialog pld = new JDialog((Dialog)ExportTxProcess.this.d, "Power*Loader Engine");
                                EngineExecPanel eep = new EngineExecPanel(commandLine.toString(), proc);
                                pld.setContentPane(eep);
                                CommonCloseAction closeAction = new CommonCloseAction(pld);
                                JButton abortButton = new JButton(eep.getAbortAction());
                                JDefaultButton closeButton = new JDefaultButton(closeAction);
                                JCheckBox scrollLockCheckBox = new JCheckBox(eep.getScrollBarLockAction());
                                JPanel buttonPanel = new JPanel(new FlowLayout(1));
                                buttonPanel.add(abortButton);
                                buttonPanel.add(closeButton);
                                buttonPanel.add(scrollLockCheckBox);
                                eep.add((Component)buttonPanel, "South");
                                pld.getRootPane().setDefaultButton(closeButton);
                                pld.pack();
                                pld.setLocationRelativeTo(ExportTxProcess.this.d);
                                pld.setVisible(true);
                            }
                            catch (IOException ie) {
                                JOptionPane.showMessageDialog(ExportTxProcess.this.d, "Unexpected Exception running Engine:\n" + ie);
                                logger.error((Object)"IOException while trying to run engine.", (Throwable)ie);
                            }
                        }
                    });
                }
            }
            catch (PLSecurityException ex) {
                PLSecurityException fex = ex;
                SwingUtilities.invokeLater(new Runnable((Exception)((Object)fex)){
                    private final /* synthetic */ Exception val$fex;
                    {
                        this.val$fex = exception;
                    }

                    public void run() {
                        JOptionPane.showMessageDialog(ExportTxProcess.this.d, "Can't export Transaction: " + this.val$fex.getMessage());
                        logger.error((Object)"Got exception while exporting Trans", (Throwable)this.val$fex);
                    }
                });
            }
            catch (SQLException esql) {
                final SQLException fesql = esql;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ExportTxProcess.this.d, "Can't export Transaction: " + fesql.getMessage());
                        logger.error((Object)"Got exception while exporting Trans", (Throwable)fesql);
                    }
                });
            }
            catch (ArchitectException arex) {
                final ArchitectException farex = arex;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ExportTxProcess.this.d, "Can't export Transaction: " + farex.getMessage());
                        logger.error((Object)"Got exception while exporting Trans", (Throwable)farex);
                    }
                });
            }
        }

        @Override
        public void cleanup() throws Exception {
            if (!(this.d instanceof WizardDialog)) {
                this.d.dispose();
            } else {
                if (this.nextProcess != null) {
                    new Thread(this.nextProcess).start();
                }
                WizardDialog wd = (WizardDialog)this.d;
                ((QuickStartWizard)wd.getWizard()).UpdateTextArea();
            }
        }
    }
}

