/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.SwingUIProject;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.Point;
import junit.framework.TestCase;

public class TestPlayPen
extends TestCase {
    ArchitectFrame af;
    private PlayPen pp;
    private SQLDatabase ppdb;

    protected void setUp() throws Exception {
        super.setUp();
        this.af = ArchitectFrame.getMainInstance();
        this.af.setProject(new SwingUIProject("Undo Project"), false);
        this.pp = this.af.getProject().getPlayPen();
        this.ppdb = this.pp.getDatabase();
    }

    public void testUndoAddTable() throws ArchitectException {
        SQLTable t = new SQLTable(this.ppdb, "test_me", "", "TABLE", true);
        TablePane tp = new TablePane(t, this.pp);
        this.ppdb.addChild(t);
        this.pp.addTablePane(tp, new Point(99, 98));
        TestPlayPen.assertNotNull((Object)this.pp.findTablePane(t));
        this.af.getUndoManager().undo();
        TestPlayPen.assertNull((Object)this.pp.findTablePane(t));
    }

    public void testRedoAddTable() throws ArchitectException {
        SQLTable t = new SQLTable(this.ppdb, "test_me", "", "TABLE", true);
        TablePane tp = new TablePane(t, this.pp);
        this.ppdb.addChild(t);
        this.pp.addTablePane(tp, new Point(99, 98));
        TestPlayPen.assertNotNull((Object)this.ppdb.getTableByName("test_me"));
        TestPlayPen.assertNotNull((Object)this.pp.findTablePane(t));
        System.out.println("Undo action is " + this.af.getUndoManager().getUndoPresentationName());
        this.af.getUndoManager().undo();
        System.out.println("After undo, undo action is " + this.af.getUndoManager().getUndoPresentationName());
        TestPlayPen.assertNull((Object)this.ppdb.getTableByName("test_me"));
        TestPlayPen.assertNull((Object)this.pp.findTablePane(t));
        this.af.getUndoManager().redo();
        tp = this.pp.findTablePane(t);
        TestPlayPen.assertNotNull((String)"Table pane didn't come back!", (Object)tp);
        TestPlayPen.assertEquals((String)"Table came back, but in wrong location", (Object)new Point(99, 98), (Object)tp.getLocation());
    }

    public void testImportTableCopyHijacksProperly() throws ArchitectException {
        SQLDatabase sourceDB = new SQLDatabase();
        SQLTable sourceParentTable = new SQLTable(sourceDB, true);
        sourceParentTable.setName("parent");
        sourceParentTable.addColumn(new SQLColumn(sourceParentTable, "key", 16, 1, 0));
        sourceParentTable.getColumn(0).setPrimaryKeySeq(0);
        sourceDB.addChild(sourceParentTable);
        SQLTable sourceChildTable = new SQLTable(sourceDB, true);
        sourceChildTable.setName("child");
        sourceChildTable.addColumn(new SQLColumn(sourceChildTable, "key", 16, 1, 0));
        sourceDB.addChild(sourceChildTable);
        SQLRelationship sourceRel = new SQLRelationship();
        sourceRel.attachRelationship(sourceParentTable, sourceChildTable, true);
        this.pp.importTableCopy(sourceChildTable, new Point(10, 10));
        this.pp.importTableCopy(sourceParentTable, new Point(10, 10));
        this.pp.importTableCopy(sourceParentTable, new Point(10, 10));
        int relCount = 0;
        int tabCount = 0;
        int otherCount = 0;
        int i = 0;
        while (i < this.pp.getPlayPenContentPane().getComponentCount()) {
            PlayPenComponent ppc = this.pp.getPlayPenContentPane().getComponent(i);
            if (ppc instanceof Relationship) {
                ++relCount;
            } else if (ppc instanceof TablePane) {
                ++tabCount;
            } else {
                ++otherCount;
            }
            ++i;
        }
        TestPlayPen.assertEquals((String)"Expected three tables in pp", (int)3, (int)tabCount);
        TestPlayPen.assertEquals((String)"Expected two relationships in pp", (int)2, (int)relCount);
        TestPlayPen.assertEquals((String)"Found junk in playpen", (int)0, (int)otherCount);
        TablePane importedChild = this.pp.findTablePaneByName("child");
        TestPlayPen.assertEquals((String)"Incorrect reference count on imported child col", (int)3, (int)importedChild.getModel().getColumn(0).getReferenceCount());
    }
}

