/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.layout.BasicTreeAutoLayout;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.RelationshipUI;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AutoLayoutAction;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import junit.framework.TestCase;

public class TestAutoLayoutAction
extends TestCase {
    private BasicTreeAutoLayout layout;
    private AutoLayoutAction layoutAction;

    protected void setUp() throws Exception {
        super.setUp();
        PlayPen pp = ArchitectFrame.getMainInstance().getProject().getPlayPen();
        this.layoutAction = new AutoLayoutAction();
        this.layout = new BasicTreeAutoLayout();
        pp.repaint();
        this.layoutAction.setPlayPen(pp);
        this.layoutAction.setLayout(this.layout);
        this.layoutAction.setAnimationEnabled(false);
    }

    public void testIcon() {
        TestAutoLayoutAction.assertNotNull((Object)this.layoutAction.getValue("SmallIcon"));
    }

    public void testNoOverlaps() throws ArchitectException {
        PlayPen pp = this.layoutAction.getPlayPen();
        SQLDatabase ppdb = pp.getDatabase();
        SQLTable t1 = new SQLTable(ppdb, "This is the name of the first table", "", "TABLE", true);
        SQLTable t2 = new SQLTable(ppdb, "This table is way cooler than the first one", "", "TABLE", true);
        TablePane tp1 = new TablePane(t1, pp);
        TablePane tp2 = new TablePane(t2, pp);
        pp.addTablePane(tp1, new Point(10, 10));
        pp.addTablePane(tp2, new Point(20, 20));
        TestAutoLayoutAction.assertTrue((boolean)tp1.getBounds().intersects(tp2.getBounds()));
        this.layoutAction.actionPerformed(new ActionEvent((Object)this, 0, null));
        TestAutoLayoutAction.assertFalse((boolean)tp1.getBounds().intersects(tp2.getBounds()));
    }

    public void testNoCrossingLinesEasy() throws ArchitectException {
        PlayPen pp = this.layoutAction.getPlayPen();
        SQLDatabase ppdb = pp.getDatabase();
        SQLTable[] tables = new SQLTable[4];
        TablePane[] tablePanes = new TablePane[tables.length];
        int i = 0;
        while (i < tables.length) {
            tables[i] = new SQLTable(ppdb, "Table " + i, "", "TABLE", true);
            tablePanes[i] = new TablePane(tables[i], pp);
            ++i;
        }
        pp.addTablePane(tablePanes[0], new Point(100, 0));
        pp.addTablePane(tablePanes[1], new Point(300, 100));
        pp.addTablePane(tablePanes[2], new Point(150, 200));
        pp.addTablePane(tablePanes[3], new Point(0, 100));
        SQLRelationship sr1 = new SQLRelationship();
        sr1.attachRelationship(tables[0], tables[2], false);
        SQLRelationship sr2 = new SQLRelationship();
        sr2.attachRelationship(tables[1], tables[3], false);
        pp.setVisible(true);
        Relationship r1 = new Relationship(pp, sr1);
        Relationship r2 = new Relationship(pp, sr2);
        pp.addRelationship(r1);
        pp.addRelationship(r2);
        Graphics2D g = new BufferedImage(1, 1, 1).createGraphics();
        r1.paint(g);
        r2.paint(g);
        TestAutoLayoutAction.assertTrue((boolean)((RelationshipUI)r1.getUI()).intersectsShape(((RelationshipUI)r2.getUI()).getShape()));
        Rectangle b = new Rectangle();
        int i2 = 0;
        while (i2 < tablePanes.length) {
            tablePanes[i2].getBounds(b);
            if (tablePanes[i2] != r1.getPkTable() && tablePanes[i2] != r1.getFkTable()) {
                TestAutoLayoutAction.assertFalse((String)("Table " + i2 + " crosses r1"), (boolean)((RelationshipUI)r1.getUI()).intersects(b));
            }
            if (tablePanes[i2] != r2.getPkTable() && tablePanes[i2] != r2.getFkTable()) {
                TestAutoLayoutAction.assertFalse((String)("Table " + i2 + " crosses r2"), (boolean)((RelationshipUI)r2.getUI()).intersects(b));
            }
            ++i2;
        }
        this.layoutAction.actionPerformed(new ActionEvent((Object)this, 0, null));
        r1.paint(g);
        r2.paint(g);
        g.dispose();
        TestAutoLayoutAction.assertFalse((boolean)((RelationshipUI)r1.getUI()).intersectsShape(((RelationshipUI)r2.getUI()).getShape()));
        i2 = 0;
        while (i2 < tablePanes.length) {
            tablePanes[i2].getBounds(b);
            if (tablePanes[i2] != r1.getPkTable() && tablePanes[i2] != r1.getFkTable()) {
                TestAutoLayoutAction.assertFalse((String)("Table " + i2 + " crosses r1"), (boolean)((RelationshipUI)r1.getUI()).intersects(b));
            }
            if (tablePanes[i2] != r2.getPkTable() && tablePanes[i2] != r2.getFkTable()) {
                TestAutoLayoutAction.assertFalse((String)("Table " + i2 + " crosses r2"), (boolean)((RelationshipUI)r2.getUI()).intersects(b));
            }
            ++i2;
        }
    }
}

