/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileColumn;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.swingui.ProfileGraphPanel;
import ca.sqlpower.architect.swingui.table.ProfileTableModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class ProfilePanel
extends JPanel {
    static Logger logger = Logger.getLogger(ProfilePanel.class);
    private JComboBox tableSelector;
    private JList columnSelector;
    private ChartTypes chartType = ChartTypes.PIE;
    private JPanel controlsArea;
    private ProfileGraphPanel displayPanel;
    private final JProgressBar progressBar = new JProgressBar();
    private JTable viewTable;
    private JTabbedPane tabPane;
    private ProfileTableModel tableModel;
    private TableModelListener listener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            ProfilePanel.this.resetTableSelectorModel();
        }
    };

    public ProfilePanel(ProfileManager pm) {
        this.displayPanel = new ProfileGraphPanel(this, 0, pm);
        this.setup();
    }

    private void setup() {
        this.progressBar.setVisible(false);
        FormLayout controlsLayout = new FormLayout("4dlu,fill:min(150dlu;default):grow, 4dlu", "default, 4dlu, fill:min(200dlu;default):grow,4dlu,default");
        CellConstraints cc = new CellConstraints();
        this.setLayout(new BorderLayout());
        this.controlsArea = logger.isDebugEnabled() ? new FormDebugPanel(controlsLayout) : new JPanel((LayoutManager)controlsLayout);
        this.controlsArea.setLayout(new BoxLayout(this.controlsArea, 1));
        this.tableSelector = new JComboBox();
        this.tableSelector.addActionListener(new ActionListener(){

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(ActionEvent e) {
                SQLTable t = (SQLTable)ProfilePanel.this.tableSelector.getSelectedItem();
                if (t == null) {
                    return;
                }
                try {
                    ArrayList<SQLColumn> columns = new ArrayList<SQLColumn>();
                    for (ProfileResult profileResult : ProfilePanel.this.tableModel.getResultList()) {
                        SQLColumn column;
                        SQLTable t2;
                        if (!(profileResult instanceof ColumnProfileResult) || t != (t2 = (column = (SQLColumn)profileResult.getProfiledObject()).getParentTable()) || columns.contains(column)) continue;
                        columns.add(column);
                    }
                    Object var4_7 = null;
                    if (ProfilePanel.this.columnSelector.getSelectedIndex() >= 0) {
                        SQLColumn sQLColumn = (SQLColumn)ProfilePanel.this.columnSelector.getSelectedValues()[0];
                    }
                    ProfilePanel.this.columnSelector.setModel(new DefaultComboBoxModel<Object>(columns.toArray()));
                    if (columns.size() > 0) {
                        void var4_9;
                        if (var4_9 != null && columns.contains(var4_9)) {
                            ProfilePanel.this.columnSelector.setSelectedValue(var4_9, true);
                        } else {
                            ProfilePanel.this.columnSelector.setSelectedIndex(0);
                        }
                    }
                }
                catch (Exception evt) {
                    JOptionPane.showMessageDialog(null, "Error in profile", "Error", 0);
                    evt.printStackTrace();
                }
            }
        });
        this.columnSelector = new JList();
        this.columnSelector.setSelectionMode(0);
        this.columnSelector.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SQLColumn col = (SQLColumn)ProfilePanel.this.columnSelector.getSelectedValue();
                if (col == null) {
                    logger.debug((Object)"Null selection in columnSelector.ListSelectionListener");
                    return;
                }
                ProfilePanel.this.displayPanel.displayProfile((SQLTable)ProfilePanel.this.tableSelector.getSelectedItem(), col);
            }
        });
        this.columnSelector.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SQLColumn col = (SQLColumn)ProfilePanel.this.columnSelector.getSelectedValue();
                    int i = 0;
                    while (i < ProfilePanel.this.viewTable.getRowCount()) {
                        if (col == ProfilePanel.this.viewTable.getValueAt(i, ProfilePanel.this.viewTable.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()))) {
                            ProfilePanel.this.viewTable.setRowSelectionInterval(i, i);
                            break;
                        }
                        ++i;
                    }
                    ProfilePanel.this.tabPane.setSelectedIndex(0);
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        PanelBuilder pb = new PanelBuilder(controlsLayout, this.controlsArea);
        pb.setDefaultDialogBorder();
        pb.add((Component)this.tableSelector, cc.xy(2, 1));
        pb.add((Component)new JScrollPane(this.columnSelector), cc.xy(2, 3));
        pb.add((Component)this.progressBar, cc.xy(2, 5));
        this.add((Component)this.controlsArea, "West");
        this.displayPanel.setChartType(this.chartType);
        this.add((Component)this.displayPanel.getDisplayArea(), "Center");
    }

    public ChartTypes getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartTypes chartType) {
        this.chartType = chartType;
    }

    public JList getColumnSelector() {
        return this.columnSelector;
    }

    public void setColumnSelector(JList columnSelector) {
        this.columnSelector = columnSelector;
    }

    public JComboBox getTableSelector() {
        return this.tableSelector;
    }

    public void setTableSelector(JComboBox tableSelector) {
        this.tableSelector = tableSelector;
    }

    public JTable getViewTable() {
        return this.viewTable;
    }

    public void setViewTable(JTable viewTable) {
        this.viewTable = viewTable;
    }

    public JTabbedPane getTabPane() {
        return this.tabPane;
    }

    public void setTabPane(JTabbedPane tabPane) {
        this.tabPane = tabPane;
    }

    public ProfileTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(ProfileTableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.listener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.listener);
        }
        this.resetTableSelectorModel();
    }

    public void resetTableSelectorModel() {
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
        SQLTable selectedTable = null;
        if (this.tableSelector.getSelectedIndex() >= 0) {
            selectedTable = (SQLTable)this.tableSelector.getSelectedObjects()[0];
        }
        for (ProfileResult profileResult : this.tableModel.getResultList()) {
            SQLTable t = ((SQLColumn)profileResult.getProfiledObject()).getParentTable();
            if (tables.contains(t)) continue;
            tables.add(t);
        }
        this.tableSelector.setModel(new DefaultComboBoxModel<Object>(tables.toArray()));
        if (this.tableSelector.getModel().getSize() > 0) {
            if (selectedTable != null && tables.contains(selectedTable)) {
                this.tableSelector.setSelectedItem(selectedTable);
            } else {
                this.tableSelector.setSelectedIndex(0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChartTypes {
        BAR,
        PIE;

    }
}

