/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EngineExecPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(EngineExecPanel.class);
    protected Process proc;
    protected JScrollPane jsp;
    protected JTextArea output;
    protected JScrollBar jsb;
    protected Thread iss;
    protected Thread ess;
    private Font font;
    boolean scrollBarLock;
    protected Action abortAction;
    protected Action scrollBarLockAction;

    public Action getScrollBarLockAction() {
        return this.scrollBarLockAction;
    }

    public Action getAbortAction() {
        return this.abortAction;
    }

    public EngineExecPanel(String header, Process pr) {
        super(new BorderLayout());
        this.proc = pr;
        this.scrollBarLock = false;
        this.abortAction = new AbstractAction("Abort"){

            public void actionPerformed(ActionEvent e) {
                EngineExecPanel.this.proc.destroy();
                if (EngineExecPanel.this.output != null && EngineExecPanel.this.output.isEnabled()) {
                    EngineExecPanel.this.output.append("Aborted ...");
                    EngineExecPanel.this.output.setEnabled(false);
                }
            }
        };
        this.abortAction.setEnabled(true);
        this.scrollBarLockAction = new AbstractAction("Scroll Lock"){

            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                EngineExecPanel.this.scrollBarLock = cb.isSelected();
            }
        };
        this.font = new Font("Courier New", 0, 12);
        this.output = new JTextArea(25, 120);
        this.output.append(header);
        this.output.append("\n\n");
        this.output.setFont(this.font);
        this.jsp = new JScrollPane(this.output);
        this.jsb = this.jsp.getVerticalScrollBar();
        this.add((Component)this.jsp, "Center");
        BufferedInputStream pis = new BufferedInputStream(this.proc.getInputStream());
        BufferedInputStream pes = new BufferedInputStream(this.proc.getErrorStream());
        this.iss = new Thread(new StreamSink(pis));
        this.ess = new Thread(new StreamSink(pes));
        this.iss.setPriority(1);
        this.ess.setPriority(10);
        this.iss.start();
        this.ess.start();
        Runnable buttonEnabler = new Runnable(){

            public void run() {
                EngineExecPanel.this.waitForProcessCompletion();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        (this).EngineExecPanel.this.abortAction.setEnabled(false);
                    }
                });
            }
        };
        new Thread(buttonEnabler).start();
    }

    public void waitForProcessCompletion() {
        try {
            this.iss.join();
            this.ess.join();
        }
        catch (InterruptedException ex) {
            logger.error((Object)"Interrupted while waiting for engine", (Throwable)ex);
        }
        this.output.append("Execution halted");
    }

    class StreamSink
    implements Runnable {
        protected InputStream is;

        public StreamSink(InputStream is) {
            this.is = is;
        }

        public void run() {
            StringBuffer msg = new StringBuffer();
            try {
                int ch;
                while ((ch = this.is.read()) >= 0) {
                    msg.append(String.valueOf((char)ch));
                    if (ch != 10) continue;
                    EngineExecPanel.this.output.append(msg.toString());
                    if (!(EngineExecPanel.this.scrollBarLock || EngineExecPanel.this.jsb != null && EngineExecPanel.this.jsb.getValueIsAdjusting())) {
                        EngineExecPanel.this.output.setCaretPosition(EngineExecPanel.this.output.getText().length());
                    }
                    msg.delete(0, msg.length());
                }
                if (msg.length() > 0) {
                    EngineExecPanel.this.output.append(msg.toString());
                    EngineExecPanel.this.output.setCaretPosition(EngineExecPanel.this.output.getText().length());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

