/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProfileResult<T extends SQLObject>
implements Comparable<ProfileResult> {
    private T profiledObject;
    private long createEndTime = -1L;
    private long createStartTime = -1L;
    private Exception ex;
    private boolean error;

    public ProfileResult(T profiledObject) {
        if (profiledObject == null) {
            throw new NullPointerException("The profiled object has to be non-null");
        }
        this.profiledObject = profiledObject;
    }

    public T getProfiledObject() {
        return this.profiledObject;
    }

    public long getCreateStartTime() {
        return this.createStartTime;
    }

    public void setCreateStartTime(long createStartTime) {
        this.createStartTime = createStartTime;
    }

    public long getTimeToCreate() {
        return this.createEndTime - this.createStartTime;
    }

    public void setCreateEndTime(long createEndTime) {
        this.createEndTime = createEndTime;
    }

    public long getCreateEndTime() {
        return this.createEndTime;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public Exception getException() {
        return this.ex;
    }

    public void setException(Exception ex) {
        this.ex = ex;
    }

    @Override
    public final int compareTo(ProfileResult o) {
        T opo;
        T po = this.getProfiledObject();
        if (po == (opo = o.getProfiledObject())) {
            return 0;
        }
        SQLObject so1 = ArchitectUtils.getAncestor(po, SQLDatabase.class);
        SQLObject so2 = ArchitectUtils.getAncestor(opo, SQLDatabase.class);
        int diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = ArchitectUtils.getAncestor(po, SQLCatalog.class);
        so2 = ArchitectUtils.getAncestor(opo, SQLCatalog.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = ArchitectUtils.getAncestor(po, SQLSchema.class);
        so2 = ArchitectUtils.getAncestor(opo, SQLSchema.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = ArchitectUtils.getAncestor(po, SQLTable.class);
        so2 = ArchitectUtils.getAncestor(opo, SQLTable.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = ArchitectUtils.getAncestor(po, SQLColumn.class);
        so2 = ArchitectUtils.getAncestor(opo, SQLColumn.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        if (this.createEndTime > o.createEndTime) {
            return 1;
        }
        if (this.createEndTime < o.createEndTime) {
            return -1;
        }
        if (this.createStartTime > o.createStartTime) {
            return 1;
        }
        if (this.createStartTime < o.createStartTime) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        ProfileResult o = (ProfileResult)obj;
        return this.compareTo(o) == 0;
    }

    public final int hashCode() {
        int hash = 17;
        T po = this.getProfiledObject();
        SQLObject so = ArchitectUtils.getAncestor(po, SQLDatabase.class);
        if (so != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = ArchitectUtils.getAncestor(po, SQLCatalog.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = ArchitectUtils.getAncestor(po, SQLSchema.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = ArchitectUtils.getAncestor(po, SQLTable.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = ArchitectUtils.getAncestor(po, SQLColumn.class)) != null) {
            hash *= so.getName().hashCode();
        }
        hash = (int)((long)hash * this.createEndTime);
        hash = (int)((long)hash * this.createStartTime);
        return hash;
    }
}

