/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileChangeEvent;
import ca.sqlpower.architect.profile.ProfileChangeListener;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.Monitorable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileManager
implements Monitorable {
    private static final Logger logger = Logger.getLogger(ProfileManager.class);
    private final Map<SQLObject, ProfileResult> results = new HashMap<SQLObject, ProfileResult>();
    private boolean findingMin = true;
    private boolean findingMax = true;
    private boolean findingAvg = true;
    private boolean findingMinLength = true;
    private boolean findingMaxLength = true;
    private boolean findingAvgLength = true;
    private boolean findingDistinctCount = true;
    private boolean findingNullCount = true;
    private boolean findingTopTen = true;
    private Integer jobSize;
    private Object monitorableMutex = new Object();
    private int progress;
    private boolean finished;
    private String currentProfilingTable;
    private boolean userCancel;
    private int topNCount = 10;
    List<ProfileChangeListener> listeners = new ArrayList<ProfileChangeListener>();

    public void putResult(ProfileResult profileResult) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[instance " + this.hashCode() + "]" + " Adding new profile result for " + ((SQLObject)profileResult.getProfiledObject()).getName() + " existing profile count: " + this.results.size()));
        }
        this.results.put((SQLObject)profileResult.getProfiledObject(), profileResult);
    }

    public ProfileResult getResult(SQLObject sqlObject) {
        return this.results.get(sqlObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createProfiles(Collection<SQLTable> tables, JLabel workingOn) throws SQLException, ArchitectException {
        Object object = this.monitorableMutex;
        synchronized (object) {
            int objCount = 0;
            for (SQLTable t : tables) {
                ++objCount;
                objCount += t.getColumns().size();
            }
            this.jobSize = new Integer(objCount);
            this.finished = false;
            this.progress = 0;
            this.userCancel = false;
            logger.debug((Object)("Job Size:" + this.jobSize + "    progress=" + this.progress));
        }
        try {
            for (SQLTable t : tables) {
                Object object2 = this.monitorableMutex;
                synchronized (object2) {
                    this.currentProfilingTable = t.getName();
                    if (workingOn != null) {
                        workingOn.setText("Profiling: " + this.currentProfilingTable);
                    }
                    if (this.userCancel) {
                        break;
                    }
                }
                this.doTableProfile(t);
                object2 = this.monitorableMutex;
                synchronized (object2) {
                    ++this.progress;
                    if (this.userCancel) {
                        break;
                    }
                    logger.debug((Object)("Job Size:" + this.jobSize + "    progress=" + this.progress));
                }
            }
        }
        catch (Throwable throwable) {
            Object object3 = this.monitorableMutex;
            synchronized (object3) {
                this.finished = true;
                this.jobSize = null;
            }
            this.fireProfileAddedEvent(new ProfileChangeEvent(this, null));
            throw throwable;
        }
        Object object4 = this.monitorableMutex;
        synchronized (object4) {
            this.finished = true;
            this.jobSize = null;
        }
        this.fireProfileAddedEvent(new ProfileChangeEvent(this, null));
    }

    public synchronized void createProfiles(Collection<SQLTable> tables) throws SQLException, ArchitectException {
        this.createProfiles(tables, null);
    }

    private void doTableProfile(SQLTable table) throws SQLException, ArchitectException {
        SQLDatabase db = table.getParentDatabase();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String lastSQL = null;
        TableProfileResult tableResult = new TableProfileResult(table);
        tableResult.setCreateStartTime(System.currentTimeMillis());
        try {
            try {
                conn = db.getConnection();
                String databaseIdentifierQuoteString = null;
                databaseIdentifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT COUNT(*) AS ROW__COUNT");
                sql.append("\nFROM ");
                sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
                stmt = conn.createStatement();
                stmt.setEscapeProcessing(false);
                lastSQL = sql.toString();
                rs = stmt.executeQuery(lastSQL);
                if (rs.next()) {
                    tableResult.setRowCount(rs.getInt("ROW__COUNT"));
                }
                rs.close();
                rs = null;
            }
            catch (SQLException ex) {
                logger.error((Object)("Error in SQL query: " + lastSQL), (Throwable)ex);
                tableResult.setError(true);
                tableResult.setException(ex);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up statement", (Throwable)ex);
            }
            tableResult.setCreateEndTime(System.currentTimeMillis());
            this.putResult(tableResult);
            this.doColumnProfile(table.getColumns(), conn);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up connection", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doColumnProfile(List<SQLColumn> columns, Connection conn) throws SQLException, ArchitectException {
        Statement stmt = null;
        ResultSet rs = null;
        String lastSQL = null;
        try {
            if (columns.size() == 0) {
                return;
            }
            SQLColumn col1 = columns.get(0);
            DDLGenerator ddlg = null;
            try {
                ddlg = DDLUtils.createDDLGenerator(col1.getParentTable().getParentDatabase().getDataSource());
            }
            catch (InstantiationException e1) {
                throw new ArchitectException("problem running Profile Manager", e1);
            }
            catch (IllegalAccessException e1) {
                throw new ArchitectException("problem running Profile Manager", e1);
            }
            stmt = conn.createStatement();
            stmt.setEscapeProcessing(false);
            for (SQLColumn col : columns) {
                Object object = this.monitorableMutex;
                synchronized (object) {
                    if (this.userCancel) {
                        this.remove(col.getParentTable());
                        return;
                    }
                }
                ProfileFunctionDescriptor pfd = ddlg.getProfileFunctionMap().get(col.getSourceDataTypeName());
                ColumnProfileResult colResult = null;
                long profileStartTime = System.currentTimeMillis();
                if (pfd == null) {
                    logger.debug((Object)(String.valueOf(col.getName()) + " Unknown DataType:(" + col.getSourceDataTypeName() + ")."));
                    pfd = this.discoverProfileFunctionDescriptor(col, ddlg, conn);
                }
                try {
                    try {
                        colResult = this.execProfileFunction(pfd, col, ddlg, conn);
                    }
                    catch (Exception ex) {
                        colResult = new ColumnProfileResult(col);
                        colResult.setCreateStartTime(profileStartTime);
                        colResult.setError(true);
                        colResult.setException(ex);
                        colResult.setCreateEndTime(System.currentTimeMillis());
                        logger.error((Object)("Error in Column Profiling: " + lastSQL), (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    this.putResult(colResult);
                    throw throwable;
                }
                this.putResult(colResult);
                Object object2 = this.monitorableMutex;
                synchronized (object2) {
                    ++this.progress;
                    if (this.userCancel) {
                        this.remove(col.getParentTable());
                        return;
                    }
                }
            }
            return;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up statement", (Throwable)ex);
            }
        }
    }

    private ProfileFunctionDescriptor discoverProfileFunctionDescriptor(SQLColumn col, DDLGenerator ddlg, Connection conn) {
        ProfileFunctionDescriptor pfd = new ProfileFunctionDescriptor(col.getSourceDataTypeName(), col.getType(), false, false, false, false, false, false, false, false);
        logger.debug((Object)("Discovering profile functions for column " + col));
        try {
            pfd.setCountDist(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"countDist worked");
        }
        catch (Exception e) {
            logger.debug((Object)"countDist failed", (Throwable)e);
            pfd.setCountDist(false);
        }
        try {
            pfd.setMaxValue(true);
            pfd.setMinValue(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"min/max worked");
        }
        catch (Exception e) {
            logger.debug((Object)"min/max failed", (Throwable)e);
            pfd.setMaxValue(false);
            pfd.setMinValue(false);
        }
        try {
            pfd.setAvgValue(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"avg worked");
        }
        catch (Exception e) {
            logger.debug((Object)"avg failed", (Throwable)e);
            pfd.setAvgValue(false);
        }
        try {
            pfd.setMaxLength(true);
            pfd.setMinLength(true);
            pfd.setAvgLength(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"min/max/avg length worked");
        }
        catch (Exception e) {
            logger.debug((Object)"min/max/avg length failed", (Throwable)e);
            pfd.setMaxLength(false);
            pfd.setMinLength(false);
            pfd.setAvgLength(false);
        }
        try {
            pfd.setSumDecode(true);
            this.execProfileFunction(pfd, col, ddlg, conn);
            logger.debug((Object)"sumDecode worked");
        }
        catch (Exception e) {
            logger.debug((Object)"sumDecode failed", (Throwable)e);
            pfd.setSumDecode(false);
        }
        return pfd;
    }

    public void clear() {
        this.results.clear();
        this.fireProfileRemovedEvent(new ProfileChangeEvent(this, null));
    }

    public void remove(SQLObject sqo) throws ArchitectException {
        this.results.remove(sqo);
        if (sqo instanceof SQLTable) {
            for (SQLColumn col : ((SQLTable)sqo).getColumns()) {
                this.results.remove(col);
            }
        } else if (sqo instanceof SQLColumn) {
            SQLTable table = ((SQLColumn)sqo).getParentTable();
            boolean allColumnDeleted = true;
            for (SQLColumn col : table.getColumns()) {
                if (this.getResult(col) == null) continue;
                allColumnDeleted = false;
                break;
            }
            if (allColumnDeleted) {
                this.results.remove(table);
            }
        }
        this.fireProfileRemovedEvent(new ProfileChangeEvent(this, null));
    }

    private ColumnProfileResult execProfileFunction(ProfileFunctionDescriptor pfd, SQLColumn col, DDLGenerator ddlg, Connection conn) throws SQLException {
        long createStartTime = System.currentTimeMillis();
        boolean i = false;
        StringBuffer sql = new StringBuffer();
        Statement stmt = null;
        ResultSet rs = null;
        String lastSQL = null;
        String columnName = null;
        String databaseIdentifierQuoteString = null;
        ColumnProfileResult colResult = new ColumnProfileResult(col);
        colResult.setCreateStartTime(createStartTime);
        SQLTable table = col.getParentTable();
        try {
            databaseIdentifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
            sql.append("SELECT 1");
            int tryCount = 0;
            if (this.findingDistinctCount && pfd.isCountDist()) {
                sql.append(",\n COUNT(DISTINCT ");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS DISTINCTCOUNT_0");
                ++tryCount;
            }
            if (this.findingMin && pfd.isMinValue()) {
                sql.append(",\n MIN(");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS MINVALUE_0");
                ++tryCount;
            }
            if (this.findingMax && pfd.isMaxValue()) {
                sql.append(",\n MAX(");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS MAXVALUE_0");
                ++tryCount;
            }
            if (this.findingAvg && pfd.isAvgValue()) {
                sql.append(",\n ");
                sql.append(ddlg.getAverageSQLFunctionName(String.valueOf(databaseIdentifierQuoteString) + col.getName() + databaseIdentifierQuoteString));
                sql.append(" AS AVGVALUE_0");
                ++tryCount;
            }
            if (this.findingMinLength && pfd.isMinLength()) {
                sql.append(",\n MIN(");
                sql.append(ddlg.getStringLengthSQLFunctionName(String.valueOf(databaseIdentifierQuoteString) + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS MINLENGTH_0");
                ++tryCount;
            }
            if (this.findingMaxLength && pfd.isMaxLength()) {
                sql.append(",\n MAX(");
                sql.append(ddlg.getStringLengthSQLFunctionName(String.valueOf(databaseIdentifierQuoteString) + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS MAXLENGTH_0");
                ++tryCount;
            }
            if (this.findingAvgLength && pfd.isAvgLength()) {
                sql.append(",\n AVG(");
                sql.append(ddlg.getStringLengthSQLFunctionName(String.valueOf(databaseIdentifierQuoteString) + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS AVGLENGTH_0");
                ++tryCount;
            }
            if (this.findingNullCount && pfd.isSumDecode()) {
                sql.append(",\n SUM(");
                sql.append(ddlg.caseWhenNull(String.valueOf(databaseIdentifierQuoteString) + col.getName() + databaseIdentifierQuoteString, "1"));
                sql.append(") AS NULLCOUNT_0");
                ++tryCount;
            }
            if (tryCount > 0) {
                sql.append("\n FROM ");
                sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
                stmt = conn.createStatement();
                stmt.setEscapeProcessing(false);
                lastSQL = sql.toString();
                rs = stmt.executeQuery(lastSQL);
                if (rs.next()) {
                    if (this.findingDistinctCount && pfd.isCountDist()) {
                        columnName = "DISTINCTCOUNT_0";
                        colResult.setDistinctValueCount(rs.getInt(columnName));
                    }
                    if (this.findingMin && pfd.isMinValue()) {
                        columnName = "MINVALUE_0";
                        colResult.setMinValue(rs.getObject(columnName));
                    }
                    if (this.findingMax && pfd.isMaxValue()) {
                        columnName = "MAXVALUE_0";
                        colResult.setMaxValue(rs.getObject(columnName));
                    }
                    if (this.findingAvg && pfd.isAvgValue()) {
                        columnName = "AVGVALUE_0";
                        colResult.setAvgValue(rs.getObject(columnName));
                    }
                    if (this.findingMinLength && pfd.isMinLength()) {
                        columnName = "MINLENGTH_0";
                        colResult.setMinLength(rs.getInt(columnName));
                    }
                    if (this.findingMaxLength && pfd.isMaxLength()) {
                        columnName = "MAXLENGTH_0";
                        colResult.setMaxLength(rs.getInt(columnName));
                    }
                    if (this.findingAvgLength && pfd.isAvgLength()) {
                        columnName = "AVGLENGTH_0";
                        colResult.setAvgLength(rs.getDouble(columnName));
                    }
                    if (this.findingNullCount && pfd.isSumDecode()) {
                        columnName = "NULLCOUNT_0";
                        colResult.setNullCount(rs.getInt(columnName));
                    }
                } else {
                    throw new IllegalStateException("Query executed, but returns no rows:\n" + lastSQL + "\nColumn Name: " + columnName);
                }
                rs.close();
                rs = null;
            }
            if (this.findingTopTen && pfd.isCountDist()) {
                sql = new StringBuffer();
                sql.append("SELECT ").append(databaseIdentifierQuoteString);
                sql.append(col.getName()).append(databaseIdentifierQuoteString);
                sql.append(" AS MYVALUE, COUNT(*) AS COUNT1 FROM ");
                sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
                sql.append(" GROUP BY ").append(databaseIdentifierQuoteString);
                sql.append(col.getName()).append(databaseIdentifierQuoteString);
                sql.append(" ORDER BY COUNT1 DESC");
                lastSQL = sql.toString();
                rs = stmt.executeQuery(lastSQL);
                int n = 0;
                while (rs.next() && n < this.topNCount) {
                    colResult.addValueCount(rs.getObject("MYVALUE"), rs.getInt("COUNT1"));
                    ++n;
                }
                rs.close();
                rs = null;
            }
            colResult.setCreateEndTime(System.currentTimeMillis());
            ColumnProfileResult columnProfileResult = colResult;
            return columnProfileResult;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProgress() throws ArchitectException {
        Object object = this.monitorableMutex;
        synchronized (object) {
            return this.progress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getJobSize() throws ArchitectException {
        Object object = this.monitorableMutex;
        synchronized (object) {
            return this.jobSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStarted() throws ArchitectException {
        Object object = this.monitorableMutex;
        synchronized (object) {
            return this.jobSize != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() throws ArchitectException {
        Object object = this.monitorableMutex;
        synchronized (object) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        Object object = this.monitorableMutex;
        synchronized (object) {
            return this.currentProfilingTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCancelled(boolean cancelled) {
        Object object = this.monitorableMutex;
        synchronized (object) {
            this.userCancel = cancelled;
        }
    }

    public boolean isFindingAvg() {
        return this.findingAvg;
    }

    public void setFindingAvg(boolean findingAvg) {
        this.findingAvg = findingAvg;
    }

    public boolean isFindingAvgLength() {
        return this.findingAvgLength;
    }

    public void setFindingAvgLength(boolean findingAvgLength) {
        this.findingAvgLength = findingAvgLength;
    }

    public boolean isFindingDistinctCount() {
        return this.findingDistinctCount;
    }

    public void setFindingDistinctCount(boolean findingDistinctCount) {
        this.findingDistinctCount = findingDistinctCount;
    }

    public boolean isFindingMax() {
        return this.findingMax;
    }

    public void setFindingMax(boolean findingMax) {
        this.findingMax = findingMax;
    }

    public boolean isFindingMaxLength() {
        return this.findingMaxLength;
    }

    public void setFindingMaxLength(boolean findingMaxLength) {
        this.findingMaxLength = findingMaxLength;
    }

    public boolean isFindingMin() {
        return this.findingMin;
    }

    public void setFindingMin(boolean findingMin) {
        this.findingMin = findingMin;
    }

    public boolean isFindingMinLength() {
        return this.findingMinLength;
    }

    public void setFindingMinLength(boolean findingMinLength) {
        this.findingMinLength = findingMinLength;
    }

    public boolean isFindingNullCount() {
        return this.findingNullCount;
    }

    public void setFindingNullCount(boolean findingNullCount) {
        this.findingNullCount = findingNullCount;
    }

    public int getTopNCount() {
        return this.topNCount;
    }

    public void setTopNCount(int topNCount) {
        this.topNCount = topNCount;
    }

    public void setTopNCount(String topNCount) {
        this.topNCount = Integer.valueOf(topNCount);
    }

    public Map<SQLObject, ProfileResult> getResults() {
        return this.results;
    }

    public void addProfileChangeListener(ProfileChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeProfileChangeListener(ProfileChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireProfileAddedEvent(ProfileChangeEvent event) {
        for (ProfileChangeListener listener : this.listeners) {
            listener.profileAdded(event);
        }
    }

    private void fireProfileRemovedEvent(ProfileChangeEvent event) {
        for (ProfileChangeListener listener : this.listeners) {
            listener.profileRemoved(event);
        }
    }
}

