/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.etl.ETLUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import junit.framework.TestCase;

public class TestETLUtils
extends TestCase {
    private SQLDatabase sdb1;
    private SQLTable st1;
    private SQLTable st2;
    private SQLTable st3;
    private SQLDatabase tdb;
    private SQLTable tt1;
    private SQLTable tt2;
    private SQLTable tt3;

    protected void setUp() throws Exception {
        super.setUp();
        this.sdb1 = new SQLDatabase();
        this.st1 = new SQLTable(this.sdb1, "st1", null, "TABLE", true);
        this.st1.addColumn(new SQLColumn(this.st1, "st1_col1", 12, 3, 4));
        this.st1.addColumn(new SQLColumn(this.st1, "st1_col2", 12, 3, 4));
        this.st1.addColumn(new SQLColumn(this.st1, "st1_col3", 12, 3, 4));
        this.sdb1.addChild(this.st1);
        this.st2 = new SQLTable(this.sdb1, "st2", null, "TABLE", true);
        this.st2.addColumn(new SQLColumn(this.st2, "st2_col1", 12, 3, 4));
        this.st2.addColumn(new SQLColumn(this.st2, "st2_col2", 12, 3, 4));
        this.st2.addColumn(new SQLColumn(this.st2, "st2_col3", 12, 3, 4));
        this.sdb1.addChild(this.st2);
        this.st3 = new SQLTable(this.sdb1, "st3", null, "TABLE", true);
        this.st3.addColumn(new SQLColumn(this.st3, "st3_col1", 12, 3, 4));
        this.st3.addColumn(new SQLColumn(this.st3, "st3_col2", 12, 3, 4));
        this.st3.addColumn(new SQLColumn(this.st3, "st3_col3", 12, 3, 4));
        this.sdb1.addChild(this.st3);
        this.tdb = new SQLDatabase();
        this.tt1 = new SQLTable(this.sdb1, "tt1", null, "TABLE", true);
        this.tt1.addColumn(new SQLColumn(this.tt1, "tt1_col1", 12, 3, 4));
        this.tt1.getColumn(0).setSourceColumn(this.st1.getColumn(0));
        this.tt1.addColumn(new SQLColumn(this.tt1, "tt1_col2", 12, 3, 4));
        this.tt1.getColumn(1).setSourceColumn(this.st1.getColumn(1));
        this.tt1.addColumn(new SQLColumn(this.tt1, "tt1_col3", 12, 3, 4));
        this.tt1.getColumn(2).setSourceColumn(this.st1.getColumn(2));
        this.tdb.addChild(this.tt1);
        this.tt2 = new SQLTable(this.sdb1, "tt2", null, "TABLE", true);
        this.tt2.addColumn(new SQLColumn(this.tt2, "tt2_col1", 12, 3, 4));
        this.tt2.addColumn(new SQLColumn(this.tt2, "tt2_col2", 12, 3, 4));
        this.tt2.addColumn(new SQLColumn(this.tt2, "tt2_col3", 12, 3, 4));
        this.tdb.addChild(this.tt2);
        this.tt3 = new SQLTable(this.sdb1, "tt3", null, "TABLE", true);
        this.tt3.addColumn(new SQLColumn(this.tt3, "tt3_col1", 12, 3, 4));
        this.tt3.addColumn(new SQLColumn(this.tt3, "tt3_col2", 12, 3, 4));
        this.tt3.addColumn(new SQLColumn(this.tt3, "tt3_col3", 12, 3, 4));
        this.tt3.getColumn(0).setSourceColumn(this.st1.getColumn(0));
        this.tt3.getColumn(1).setSourceColumn(this.st2.getColumn(1));
        this.tdb.addChild(this.tt3);
    }

    public void testFindMappingsNormal() throws Exception {
        ArrayList<SQLTable> target = new ArrayList<SQLTable>();
        target.add(this.tt1);
        Map<SQLTable, Collection<SQLTable>> mappings = ETLUtils.findTableLevelMappings(target);
        TestETLUtils.assertEquals((int)1, (int)mappings.size());
        TestETLUtils.assertNotNull((Object)mappings.containsKey(this.st1));
        TestETLUtils.assertEquals((int)1, (int)mappings.get(this.st1).size());
        TestETLUtils.assertTrue((boolean)mappings.get(this.st1).contains(this.tt1));
    }

    public void testFindMappingsNoSource() throws Exception {
        ArrayList<SQLTable> target = new ArrayList<SQLTable>();
        target.add(this.tt2);
        Map<SQLTable, Collection<SQLTable>> mappings = ETLUtils.findTableLevelMappings(target);
        TestETLUtils.assertEquals((int)1, (int)mappings.size());
        TestETLUtils.assertNotNull((Object)mappings.containsKey(null));
        TestETLUtils.assertTrue((boolean)mappings.get(null).contains(this.tt2));
    }

    public void testFindMappingsMultiSource() throws Exception {
        ArrayList<SQLTable> target = new ArrayList<SQLTable>();
        target.add(this.tt3);
        Map<SQLTable, Collection<SQLTable>> mappings = ETLUtils.findTableLevelMappings(target);
        TestETLUtils.assertEquals((int)3, (int)mappings.size());
        TestETLUtils.assertNotNull((Object)mappings.containsKey(this.st1));
        TestETLUtils.assertEquals((int)1, (int)mappings.get(this.st1).size());
        TestETLUtils.assertTrue((boolean)mappings.get(this.st1).contains(this.tt3));
        TestETLUtils.assertNotNull((Object)mappings.containsKey(this.st2));
        TestETLUtils.assertEquals((int)1, (int)mappings.get(this.st2).size());
        TestETLUtils.assertTrue((boolean)mappings.get(this.st2).contains(this.tt3));
        TestETLUtils.assertNotNull((Object)mappings.containsKey(null));
        TestETLUtils.assertEquals((int)1, (int)mappings.get(null).size());
        TestETLUtils.assertTrue((boolean)mappings.get(null).contains(this.tt3));
    }
}

