/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.diff;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.diff.CompareSQL;
import ca.sqlpower.architect.diff.DiffChunk;
import ca.sqlpower.architect.diff.DiffType;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class CompareSQLTest
extends TestCase {
    SQLTable table1;
    SQLTable table2;
    SQLTable table3;
    SQLTable tableNoColumn1;
    SQLColumn c1;
    SQLColumn c1Dupl;
    SQLColumn c2;
    SQLColumn c2LookAlike;
    SQLColumn c3;
    SQLColumn c4;
    SQLColumn c5;
    SQLColumn c6;
    List<SQLTable> listWithATable;

    protected void setUp() throws Exception {
        this.tableNoColumn1 = new SQLTable(null, "table1", "...", SQLTable.class.toString(), true);
        this.table1 = new SQLTable(null, "tableWithColumn1", "actually r1", SQLTable.class.toString(), true);
        this.c1 = new SQLColumn(this.table1, "Column1", 0, 2, 3);
        this.c2 = new SQLColumn(this.table1, "Column2", 4, 5, 0);
        this.table1.addColumn(this.c1);
        this.table1.addColumn(this.c2);
        this.table2 = new SQLTable(null, "tableWithColumn2", "actually r2", SQLTable.class.toString(), true);
        this.c3 = new SQLColumn(this.table2, "Column3", 0, 2, 3);
        this.c4 = new SQLColumn(this.table2, "Column3a", 0, 2, 3);
        this.table2.addColumn(this.c3);
        this.table2.addColumn(this.c4);
        this.table3 = new SQLTable(null, "tableWithColumn3", "actually r3", SQLTable.class.toString(), true);
        this.c5 = new SQLColumn(this.table3, "Column3a", 0, 2, 3);
        this.c6 = new SQLColumn(this.table3, "Column4", 0, 2, 3);
        this.table3.addColumn(this.c5);
        this.table3.addColumn(this.c6);
        this.listWithATable = new ArrayList<SQLTable>();
        this.listWithATable.add(this.tableNoColumn1);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetProgress() {
    }

    public void testEmptyPlayPenCompareSQL() {
    }

    public void testDiffListWithTablesOnly() throws ArchitectException {
        ArrayList<SQLTable> list1 = new ArrayList<SQLTable>();
        CompareSQL compare1 = new CompareSQL(list1, list1);
        List<DiffChunk<SQLObject>> nullChecker = compare1.generateTableDiffs();
        CompareSQLTest.assertEquals((int)0, (int)nullChecker.size());
        CompareSQL compareWorker = new CompareSQL(this.listWithATable, list1);
        List<DiffChunk<SQLObject>> tableAndNull = compareWorker.generateTableDiffs();
        CompareSQLTest.assertEquals((int)1, (int)tableAndNull.size());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.LEFTONLY), (Object)((Object)tableAndNull.get(0).getType()));
        CompareSQLTest.assertEquals((String)"table1", (String)tableAndNull.get(0).getData().getName());
        CompareSQL compareWorker1 = new CompareSQL(this.listWithATable, this.listWithATable);
        List<DiffChunk<SQLObject>> exactlySameTable = compareWorker1.generateTableDiffs();
        CompareSQLTest.assertEquals((int)1, (int)exactlySameTable.size());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)exactlySameTable.get(0).getType()));
        CompareSQLTest.assertEquals((String)"table1", (String)tableAndNull.get(0).getData().getName());
        SQLTable tableNoColumn2 = new SQLTable(null, "table2", "...", SQLTable.class.toString(), true);
        SQLTable tableNoColumn3 = new SQLTable(null, "table3", "...", SQLTable.class.toString(), true);
        this.listWithATable.add(tableNoColumn3);
        list1.add(this.tableNoColumn1);
        list1.add(tableNoColumn2);
        CompareSQL compareWorker2 = new CompareSQL(this.listWithATable, list1);
        List<DiffChunk<SQLObject>> differentProp = compareWorker2.generateTableDiffs();
        CompareSQLTest.assertEquals((int)3, (int)differentProp.size());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)differentProp.get(0).getType()));
        CompareSQLTest.assertEquals((String)"table1", (String)differentProp.get(0).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.RIGHTONLY), (Object)((Object)differentProp.get(1).getType()));
        CompareSQLTest.assertEquals((String)"table2", (String)differentProp.get(1).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.LEFTONLY), (Object)((Object)differentProp.get(2).getType()));
        CompareSQLTest.assertEquals((String)"table3", (String)differentProp.get(2).getData().getName());
    }

    public void testDiffListWithTableHavingColumn() throws ArchitectException {
        ArrayList<SQLTable> tableList1 = new ArrayList<SQLTable>();
        ArrayList<SQLTable> tableList2 = new ArrayList<SQLTable>();
        tableList1.add(this.table1);
        CompareSQL worker1 = new CompareSQL(tableList1, tableList2);
        List<DiffChunk<SQLObject>> tableWithColumnAndNothing = worker1.generateTableDiffs();
        CompareSQLTest.assertEquals((int)1, (int)tableWithColumnAndNothing.size());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.LEFTONLY), (Object)((Object)tableWithColumnAndNothing.get(0).getType()));
        CompareSQLTest.assertEquals(SQLTable.class, tableWithColumnAndNothing.get(0).getData().getClass());
        CompareSQLTest.assertEquals((String)"tableWithColumn1", (String)tableWithColumnAndNothing.get(0).getData().getName());
        CompareSQL worker2 = new CompareSQL(tableList1, tableList1);
        List<DiffChunk<SQLObject>> sameTablesWithColumns = worker2.generateTableDiffs();
        CompareSQLTest.assertEquals((int)3, (int)sameTablesWithColumns.size());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)sameTablesWithColumns.get(0).getType()));
        CompareSQLTest.assertEquals(SQLTable.class, sameTablesWithColumns.get(0).getData().getClass());
        CompareSQLTest.assertEquals((String)"tableWithColumn1", (String)sameTablesWithColumns.get(0).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)sameTablesWithColumns.get(1).getType()));
        CompareSQLTest.assertEquals(SQLColumn.class, sameTablesWithColumns.get(1).getData().getClass());
        CompareSQLTest.assertEquals((String)"Column1", (String)sameTablesWithColumns.get(1).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)sameTablesWithColumns.get(2).getType()));
        CompareSQLTest.assertEquals(SQLColumn.class, sameTablesWithColumns.get(2).getData().getClass());
        CompareSQLTest.assertEquals((String)"Column2", (String)sameTablesWithColumns.get(2).getData().getName());
        SQLTable table1NoColumn = new SQLTable(null, "tableWithColumn1", "it's lying!", SQLTable.class.toString(), true);
        ArrayList<SQLTable> tempList = new ArrayList<SQLTable>();
        tempList.add(table1NoColumn);
        CompareSQL worker3 = new CompareSQL(tempList, tableList1);
        List<DiffChunk<SQLObject>> diffTest = worker3.generateTableDiffs();
        CompareSQLTest.assertEquals((int)3, (int)diffTest.size());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)diffTest.get(0).getType()));
        CompareSQLTest.assertEquals(SQLTable.class, diffTest.get(0).getData().getClass());
        CompareSQLTest.assertEquals((String)"tableWithColumn1", (String)diffTest.get(0).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.RIGHTONLY), (Object)((Object)diffTest.get(1).getType()));
        CompareSQLTest.assertEquals(SQLColumn.class, diffTest.get(1).getData().getClass());
        CompareSQLTest.assertEquals((String)"Column1", (String)diffTest.get(1).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.RIGHTONLY), (Object)((Object)diffTest.get(2).getType()));
        CompareSQLTest.assertEquals(SQLColumn.class, diffTest.get(2).getData().getClass());
        CompareSQLTest.assertEquals((String)"Column2", (String)diffTest.get(2).getData().getName());
        SQLTable table1LookAlike = new SQLTable(null, "tableWithColumn1", "actually r1lookAlike", SQLTable.class.toString(), true);
        this.c1Dupl = new SQLColumn(table1LookAlike, "Column1", 0, 2, 3);
        this.c2LookAlike = new SQLColumn(table1LookAlike, "Column2", 1, 3, 5);
        table1LookAlike.addColumn(this.c1Dupl);
        table1LookAlike.addColumn(this.c2LookAlike);
        tableList1.add(this.table2);
        tableList2.add(table1LookAlike);
        tableList2.add(this.table3);
        CompareSQL worker4 = new CompareSQL(tableList1, tableList2);
        List<DiffChunk<SQLObject>> manyProperties = worker4.generateTableDiffs();
        System.out.println("-/|\\-" + manyProperties + "-/|\\-");
        CompareSQLTest.assertEquals((int)5, (int)manyProperties.size());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)manyProperties.get(0).getType()));
        CompareSQLTest.assertEquals(SQLTable.class, manyProperties.get(0).getData().getClass());
        CompareSQLTest.assertEquals((String)"tableWithColumn1", (String)manyProperties.get(0).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)manyProperties.get(1).getType()));
        CompareSQLTest.assertEquals(SQLColumn.class, manyProperties.get(1).getData().getClass());
        CompareSQLTest.assertEquals((String)"Column1", (String)manyProperties.get(1).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.MODIFIED), (Object)((Object)manyProperties.get(2).getType()));
        CompareSQLTest.assertEquals(SQLColumn.class, manyProperties.get(2).getData().getClass());
        CompareSQLTest.assertEquals((String)"Column2", (String)manyProperties.get(2).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.LEFTONLY), (Object)((Object)manyProperties.get(3).getType()));
        CompareSQLTest.assertEquals(SQLTable.class, manyProperties.get(3).getData().getClass());
        CompareSQLTest.assertEquals((String)"tableWithColumn2", (String)manyProperties.get(3).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.RIGHTONLY), (Object)((Object)manyProperties.get(4).getType()));
        CompareSQLTest.assertEquals(SQLTable.class, manyProperties.get(4).getData().getClass());
        CompareSQLTest.assertEquals((String)"tableWithColumn3", (String)manyProperties.get(4).getData().getName());
    }

    public void testTableWithRelationShip() throws ArchitectException {
        SQLTable newTable1 = this.table1;
        SQLTable newTable2 = this.table2;
        SQLRelationship relation1 = new SQLRelationship();
        relation1.attachRelationship(this.table1, this.table2, false);
        relation1.addMapping(newTable1.getColumn(0), newTable2.getColumn(1));
        relation1.setName("relation1");
        ArrayList<SQLTable> newList1 = new ArrayList<SQLTable>();
        ArrayList<SQLTable> newList2 = new ArrayList<SQLTable>();
        newList1.add(newTable1);
        newList1.add(newTable2);
        CompareSQL worker1 = new CompareSQL(newList1, newList2);
        List<DiffChunk<SQLObject>> diffList = worker1.generateTableDiffs();
        CompareSQLTest.assertEquals((int)3, (int)diffList.size());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.LEFTONLY), (Object)((Object)diffList.get(0).getType()));
        CompareSQLTest.assertEquals(SQLTable.class, diffList.get(0).getData().getClass());
        CompareSQLTest.assertEquals((String)"tableWithColumn1", (String)diffList.get(0).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.LEFTONLY), (Object)((Object)diffList.get(1).getType()));
        CompareSQLTest.assertEquals(SQLTable.class, diffList.get(1).getData().getClass());
        CompareSQLTest.assertEquals((String)"tableWithColumn2", (String)diffList.get(1).getData().getName());
        CompareSQLTest.assertEquals((Object)((Object)DiffType.LEFTONLY), (Object)((Object)diffList.get(2).getType()));
        CompareSQLTest.assertEquals(SQLRelationship.class, diffList.get(2).getData().getClass());
        CompareSQLTest.assertEquals((String)"relation1", (String)diffList.get(2).getData().getName());
    }

    public void testRelationshipsWithSameMappings() throws ArchitectException {
        SQLTable newTable1L = this.makeTable(4);
        SQLTable newTable2L = this.makeTable(6);
        SQLRelationship relationL = new SQLRelationship();
        relationL.addMapping(newTable1L.getColumn(0), newTable2L.getColumn(1));
        relationL.setName("relation1");
        relationL.attachRelationship(newTable1L, newTable2L, false);
        ArrayList<SQLTable> tableListL = new ArrayList<SQLTable>();
        tableListL.add(newTable1L);
        tableListL.add(newTable2L);
        SQLTable newTable1R = this.makeTable(4);
        SQLTable newTable2R = this.makeTable(6);
        SQLRelationship relationR = new SQLRelationship();
        relationR.addMapping(newTable1R.getColumn(0), newTable2R.getColumn(1));
        relationR.setName("relation1");
        relationR.attachRelationship(newTable1R, newTable2R, false);
        ArrayList<SQLTable> tableListR = new ArrayList<SQLTable>();
        tableListR.add(newTable1R);
        tableListR.add(newTable2R);
        CompareSQL cs = new CompareSQL(tableListL, tableListR);
        List<DiffChunk<SQLObject>> diffs = cs.generateTableDiffs();
        for (DiffChunk<SQLObject> chunk : diffs) {
            CompareSQLTest.assertEquals((String)"Left side == Right side. Diff list should be all same", (Object)((Object)DiffType.SAME), (Object)((Object)chunk.getType()));
        }
    }

    public void testRelationshipsWithDifferentNames() throws ArchitectException {
        SQLTable newTable1L = this.makeTable(4);
        SQLTable newTable2L = this.makeTable(6);
        SQLRelationship relationL = new SQLRelationship();
        relationL.addMapping(newTable1L.getColumn(0), newTable2L.getColumn(1));
        relationL.setName("relation1");
        relationL.attachRelationship(newTable1L, newTable2L, false);
        ArrayList<SQLTable> tableListL = new ArrayList<SQLTable>();
        tableListL.add(newTable1L);
        tableListL.add(newTable2L);
        SQLTable newTable1R = this.makeTable(4);
        SQLTable newTable2R = this.makeTable(6);
        SQLRelationship relationR = new SQLRelationship();
        relationR.addMapping(newTable1R.getColumn(0), newTable2R.getColumn(1));
        relationR.setName("not_relation1");
        relationR.attachRelationship(newTable1R, newTable2R, false);
        ArrayList<SQLTable> tableListR = new ArrayList<SQLTable>();
        tableListR.add(newTable1R);
        tableListR.add(newTable2R);
        CompareSQL cs = new CompareSQL(tableListL, tableListR);
        List<DiffChunk<SQLObject>> diffs = cs.generateTableDiffs();
        for (DiffChunk<SQLObject> chunk : diffs) {
            if (chunk.getData().getClass().equals(SQLRelationship.class)) {
                CompareSQLTest.assertEquals((String)"The relationships have different names", (Object)((Object)DiffType.SAME), (Object)((Object)chunk.getType()));
                continue;
            }
            CompareSQLTest.assertEquals((String)"Diff list should be all same for non-relationship SQLObjects", (Object)((Object)DiffType.SAME), (Object)((Object)chunk.getType()));
        }
    }

    public void testRelationshipsWithDifferentMappings() throws ArchitectException {
        SQLTable newTable1L = this.makeTable(4);
        SQLTable newTable2L = this.makeTable(6);
        SQLRelationship relationL = new SQLRelationship();
        newTable1L.getColumn(0).setPrimaryKeySeq(1);
        relationL.addMapping(newTable1L.getColumn(0), newTable2L.getColumn(2));
        relationL.setName("relation1");
        relationL.attachRelationship(newTable1L, newTable2L, false);
        ArrayList<SQLTable> tableListL = new ArrayList<SQLTable>();
        tableListL.add(newTable1L);
        tableListL.add(newTable2L);
        SQLTable newTable1R = this.makeTable(4);
        SQLTable newTable2R = this.makeTable(6);
        SQLRelationship relationR = new SQLRelationship();
        newTable1R.getColumn(0).setPrimaryKeySeq(1);
        relationR.addMapping(newTable1R.getColumn(0), newTable2R.getColumn(1));
        relationR.setName("relation1");
        relationR.attachRelationship(newTable1R, newTable2R, false);
        ArrayList<SQLTable> tableListR = new ArrayList<SQLTable>();
        tableListR.add(newTable1R);
        tableListR.add(newTable2R);
        CompareSQL cs = new CompareSQL(tableListL, tableListR);
        List<DiffChunk<SQLObject>> diffs = cs.generateTableDiffs();
        boolean foundColMapDiff = false;
        for (DiffChunk<SQLObject> chunk : diffs) {
            if (chunk.getData().getClass().equals(SQLRelationship.class)) {
                foundColMapDiff = true;
                CompareSQLTest.assertNotSame((String)"The mappings have different columns", (Object)((Object)DiffType.SAME), (Object)((Object)chunk.getType()));
                continue;
            }
            CompareSQLTest.assertEquals((String)"Diff list should be all same for non-mapping SQLObjects", (Object)((Object)DiffType.SAME), (Object)((Object)chunk.getType()));
        }
        CompareSQLTest.assertTrue((String)"No column mapping diffs found!", (boolean)foundColMapDiff);
    }

    public void testKeyChanged() throws ArchitectException {
        ArrayList<SQLTable> list1 = new ArrayList<SQLTable>();
        SQLTable t1 = this.makeTable(4);
        list1.add(t1);
        SQLColumn c = t1.getColumn(2);
        c.setPrimaryKeySeq(new Integer(0));
        ArrayList<SQLTable> list2 = new ArrayList<SQLTable>();
        SQLTable t2 = this.makeTable(4);
        list2.add(t2);
        CompareSQL sqlComparator = new CompareSQL(list1, list2);
        List<DiffChunk<SQLObject>> diffs = sqlComparator.generateTableDiffs();
        boolean first_table = true;
        for (DiffChunk<SQLObject> dc : diffs) {
            if (dc.getData().getClass().equals(SQLTable.class)) {
                if (first_table) {
                    CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)dc.getType()));
                } else {
                    CompareSQLTest.assertEquals((Object)((Object)DiffType.KEY_CHANGED), (Object)((Object)dc.getType()));
                }
                first_table = false;
                continue;
            }
            if (!dc.getData().getClass().equals(SQLColumn.class)) continue;
            if (dc.getData().getName().equals(c.getName())) {
                CompareSQLTest.assertEquals((Object)((Object)DiffType.MODIFIED), (Object)((Object)dc.getType()));
                continue;
            }
            CompareSQLTest.assertEquals((Object)((Object)DiffType.SAME), (Object)((Object)dc.getType()));
        }
    }

    private SQLTable makeTable(int i) throws ArchitectException {
        SQLTable t = new SQLTable(null, "table_" + i, "remark on this", "TABLE", true);
        int j = 0;
        while (j < i) {
            t.addColumn(new SQLColumn(t, "column_" + j, 4, 3, 0));
            ++j;
        }
        return t;
    }

    public void testIsFinished() {
    }

    public void testSetLeftDiff() {
    }

    public void testSetRightDiff() {
    }
}

