/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.ddl.NameChangeWarning;
import ca.sqlpower.architect.ddl.TypeMapWarning;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDDLGenerator
implements DDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 1.46 $";
    private static final Logger logger = Logger.getLogger(GenericDDLGenerator.class);
    protected boolean allowConnection = true;
    protected File file;
    private StringBuffer ddl;
    private List<DDLStatement> ddlStatements;
    protected static final String EOL = System.getProperty("line.separator");
    protected Map typeMap;
    protected Connection con;
    protected Map topLevelNames;
    protected List warnings = new ArrayList();
    protected String targetCatalog;
    protected String targetSchema;
    protected Map<String, ProfileFunctionDescriptor> profileFunctionMap;

    @Override
    public boolean isReservedWord(String word) {
        return false;
    }

    public GenericDDLGenerator() throws SQLException {
        this.ddlStatements = new ArrayList<DDLStatement>();
        this.ddl = new StringBuffer(500);
        this.println("");
        this.topLevelNames = new HashMap();
        this.createTypeMap();
        this.createProfileFunctionMap();
    }

    public StringBuffer generateDDL(SQLDatabase source) throws SQLException, ArchitectException {
        List<DDLStatement> statements = this.generateDDLStatements(source);
        this.ddl = new StringBuffer(4000);
        this.writeHeader();
        this.writeCreateDB(source);
        this.writeDDLTransactionBegin();
        for (DDLStatement ddlStmt : statements) {
            this.ddl.append(ddlStmt.getSQLText());
            this.println(this.getStatementTerminator());
        }
        this.writeDDLTransactionEnd();
        return this.ddl;
    }

    @Override
    public List<DDLStatement> generateDDLStatements(SQLDatabase source) throws SQLException, ArchitectException {
        this.warnings = new ArrayList();
        this.ddlStatements = new ArrayList<DDLStatement>();
        this.ddl = new StringBuffer(500);
        this.topLevelNames = new HashMap();
        try {
            this.con = this.allowConnection ? source.getConnection() : null;
            this.createTypeMap();
            for (SQLTable t : source.getChildren()) {
                this.addTable(t);
                this.writePrimaryKey(t);
            }
            for (SQLTable t : source.getChildren()) {
                this.writeExportedRelationships(t);
            }
        }
        finally {
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close connection", (Throwable)ex);
            }
        }
        return this.ddlStatements;
    }

    public final void endStatement(DDLStatement.StatementType type, SQLObject sqlObject) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("endStatement: " + this.ddl.toString()));
        }
        this.ddlStatements.add(new DDLStatement(sqlObject, type, this.ddl.toString(), this.getStatementTerminator(), this.getTargetCatalog(), this.getTargetSchema()));
        this.ddl = new StringBuffer(500);
        this.println("");
    }

    public void writeHeader() {
        this.println("-- Created by SQLPower Generic DDL Generator $Revision: 1.46 $ --");
    }

    @Override
    public String getStatementTerminator() {
        return ";";
    }

    public void writeDDLTransactionBegin() {
    }

    public void writeDDLTransactionEnd() {
    }

    public void writeCreateDB(SQLDatabase db) {
        this.println("-- Would Create Database " + db.getName() + " here. --");
    }

    @Override
    public void dropRelationship(SQLRelationship r) {
        this.print("\n ALTER TABLE ");
        this.print(this.toQualifiedName(r.getFkTable()));
        this.print(" DROP CONSTRAINT ");
        this.print(r.getName());
        this.endStatement(DDLStatement.StatementType.DROP, r);
    }

    @Override
    public void addRelationship(SQLRelationship r) {
        SQLColumn c;
        this.print("\n ALTER TABLE ");
        this.print(this.toQualifiedName(r.getFkTable()));
        this.print(" ADD CONSTRAINT ");
        this.print(r.getName());
        this.print(" FOREIGN KEY ( ");
        HashMap<String, SQLColumn> colNameMap = new HashMap<String, SQLColumn>();
        boolean firstColumn = true;
        for (SQLRelationship.ColumnMapping cm : r.getMappings()) {
            c = cm.getFkColumn();
            if (colNameMap.get(c.getName()) != null) continue;
            if (firstColumn) {
                firstColumn = false;
                this.print(this.createPhysicalName(colNameMap, c));
            } else {
                this.print(", " + this.createPhysicalName(colNameMap, c));
            }
            colNameMap.put(c.getName(), c);
        }
        this.print(" ) REFERENCES ");
        this.print(this.toQualifiedName(r.getPkTable()));
        this.print(" ( ");
        colNameMap = new HashMap();
        firstColumn = true;
        for (SQLRelationship.ColumnMapping cm : r.getMappings()) {
            c = cm.getPkColumn();
            if (colNameMap.get(c.getName()) != null) continue;
            if (firstColumn) {
                firstColumn = false;
                this.print(this.createPhysicalName(colNameMap, c));
            } else {
                this.print(", " + this.createPhysicalName(colNameMap, c));
            }
            colNameMap.put(c.getName(), c);
        }
        this.print(" )");
        this.endStatement(DDLStatement.StatementType.CREATE, r);
    }

    @Override
    public void addColumn(SQLColumn c) {
        HashMap colNameMap = new HashMap();
        this.print("\n ALTER TABLE ");
        this.print(this.toQualifiedName(c.getParentTable()));
        this.print(" ADD COLUMN ");
        this.print(this.columnDefinition(c, colNameMap));
        this.endStatement(DDLStatement.StatementType.CREATE, c);
    }

    @Override
    public void dropColumn(SQLColumn c) {
        HashMap colNameMap = new HashMap();
        this.print("\n ALTER TABLE ");
        this.print(this.toQualifiedName(c.getParentTable()));
        this.print(" DROP COLUMN ");
        this.print(this.createPhysicalName(colNameMap, c));
        this.endStatement(DDLStatement.StatementType.DROP, c);
    }

    @Override
    public void modifyColumn(SQLColumn c) {
        HashMap colNameMap = new HashMap();
        SQLTable t = c.getParentTable();
        this.print("\n ALTER TABLE ");
        this.print(this.toQualifiedName(t));
        this.print(" ALTER COLUMN ");
        this.print(this.columnDefinition(c, colNameMap));
        this.endStatement(DDLStatement.StatementType.MODIFY, c);
    }

    @Override
    public void dropTable(SQLTable t) {
        this.print(this.makeDropTableSQL(t.getName()));
        this.endStatement(DDLStatement.StatementType.DROP, t);
    }

    protected String columnDefinition(SQLColumn c, Map colNameMap) {
        StringBuffer def = new StringBuffer();
        def.append(this.createPhysicalName(colNameMap, c));
        def.append(" ");
        def.append(this.columnType(c));
        def.append(" ");
        def.append(this.columnNullability(c));
        return def.toString();
    }

    protected String columnNullability(SQLColumn c) {
        GenericTypeDescriptor td = this.failsafeGetTypeDescriptor(c);
        if (c.isDefinitelyNullable()) {
            if (!td.isNullable()) {
                throw new UnsupportedOperationException("The data type " + td.getName() + " is not nullable on the target database platform.");
            }
            return "NULL";
        }
        return "NOT NULL";
    }

    @Override
    public String columnType(SQLColumn c) {
        StringBuffer def = new StringBuffer();
        GenericTypeDescriptor td = this.failsafeGetTypeDescriptor(c);
        def.append(td.getName());
        if (td.getHasPrecision()) {
            def.append("(" + c.getPrecision());
            if (td.getHasScale()) {
                def.append("," + c.getScale());
            }
            def.append(")");
        }
        return def.toString();
    }

    public String getColumnDataTypeName(SQLColumn c) {
        StringBuffer def = new StringBuffer();
        GenericTypeDescriptor td = this.failsafeGetTypeDescriptor(c);
        def.append(td.getName());
        if (td.getHasPrecision()) {
            def.append("(" + c.getPrecision());
            if (td.getHasScale()) {
                def.append("," + c.getScale());
            }
            def.append(")");
        }
        return def.toString();
    }

    protected GenericTypeDescriptor failsafeGetTypeDescriptor(SQLColumn c) {
        GenericTypeDescriptor td = (GenericTypeDescriptor)this.typeMap.get(new Integer(c.getType()));
        if (td == null) {
            td = (GenericTypeDescriptor)this.typeMap.get(this.getDefaultType());
            if (td == null) {
                throw new NullPointerException("Current type map does not have entry for default datatype!");
            }
            GenericTypeDescriptor oldType = new GenericTypeDescriptor(c.getSourceDataTypeName(), c.getType(), c.getPrecision(), null, null, c.getNullable(), false, false);
            oldType.determineScaleAndPrecision();
            this.warnings.add(new TypeMapWarning(c, "Unknown Target Type", oldType, td));
        }
        return td;
    }

    @Override
    public void addTable(SQLTable t) throws SQLException, ArchitectException {
        HashMap colNameMap = new HashMap();
        this.createPhysicalName(this.topLevelNames, t);
        this.print("\nCREATE TABLE ");
        this.print(this.toQualifiedName(t));
        this.println(" (");
        boolean firstCol = true;
        for (SQLColumn c : t.getColumns()) {
            if (!firstCol) {
                this.println(",");
            }
            this.print("                ");
            this.print(this.columnDefinition(c, colNameMap));
            firstCol = false;
        }
        this.println("");
        this.print(")");
        this.endStatement(DDLStatement.StatementType.CREATE, t);
    }

    protected Object getDefaultType() {
        return 12;
    }

    protected void writePrimaryKey(SQLTable t) throws ArchitectException {
        boolean firstCol = true;
        for (SQLColumn col : t.getColumns()) {
            if (col.getPrimaryKeySeq() == null) break;
            if (firstCol) {
                this.createPhysicalPrimaryKeyName(this.topLevelNames, t);
                this.println("");
                this.print("ALTER TABLE ");
                this.print(this.toQualifiedName(t));
                this.print(" ADD CONSTRAINT ");
                this.print(t.getPhysicalPrimaryKeyName());
                this.println("");
                this.print("PRIMARY KEY (");
                firstCol = false;
            } else {
                this.print(", ");
            }
            this.print(col.getPhysicalName());
        }
        if (!firstCol) {
            this.print(")");
            this.endStatement(DDLStatement.StatementType.ADD_PK, t);
        }
    }

    protected void writeExportedRelationships(SQLTable t) throws ArchitectException {
        for (SQLRelationship rel : t.getExportedKeys()) {
            this.createPhysicalName(this.topLevelNames, rel);
            this.println("");
            this.print("ALTER TABLE ");
            this.print(this.toQualifiedName(rel.getFkTable()));
            this.print(" ADD CONSTRAINT ");
            this.print(rel.getPhysicalName());
            this.println("");
            this.print("FOREIGN KEY (");
            StringBuffer pkCols = new StringBuffer();
            StringBuffer fkCols = new StringBuffer();
            boolean firstCol = true;
            for (SQLRelationship.ColumnMapping cmap : rel.getChildren()) {
                if (!firstCol) {
                    pkCols.append(", ");
                    fkCols.append(", ");
                }
                pkCols.append(cmap.getPkColumn().getPhysicalName());
                fkCols.append(cmap.getFkColumn().getPhysicalName());
                firstCol = false;
            }
            this.print(fkCols.toString());
            this.println(")");
            this.print("REFERENCES ");
            this.print(this.toQualifiedName(rel.getPkTable()));
            this.print(" (");
            this.print(pkCols.toString());
            this.print(")");
            this.endStatement(DDLStatement.StatementType.ADD_FK, t);
        }
    }

    @Override
    public void selectTable(SQLTable t, String selectList, String whereClause) {
        this.setTargetCatalog(t.getCatalogName());
        this.setTargetSchema(t.getSchemaName());
        this.print("SELECT ");
        if (selectList != null && selectList.length() > 0) {
            this.print(selectList);
        } else {
            this.print("*");
        }
        this.print(" FROM ");
        this.print(this.toQualifiedName(t));
        if (whereClause != null && whereClause.length() > 0) {
            this.print(" WHERE ");
            this.print(whereClause);
        }
        this.endStatement(DDLStatement.StatementType.SELECT, t);
    }

    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        if (this.con == null || !this.allowConnection) {
            this.typeMap.put(new Integer(-5), new GenericTypeDescriptor("BIGINT", -5, 38L, null, null, 1, false, false));
            this.typeMap.put(new Integer(-2), new GenericTypeDescriptor("BINARY", -2, 2000L, "0x", null, 1, true, false));
            this.typeMap.put(new Integer(-7), new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, false, false));
            this.typeMap.put(new Integer(2004), new GenericTypeDescriptor("BLOB", 2004, Integer.MAX_VALUE, "0x", null, 1, true, false));
            this.typeMap.put(new Integer(1), new GenericTypeDescriptor("CHAR", 1, 8000L, "'", "'", 1, true, false));
            this.typeMap.put(new Integer(2005), new GenericTypeDescriptor("CLOB", 2005, Integer.MAX_VALUE, "'", "'", 1, true, false));
            this.typeMap.put(new Integer(91), new GenericTypeDescriptor("DATE", 91, 23L, "'", "'", 1, false, false));
            this.typeMap.put(new Integer(3), new GenericTypeDescriptor("DECIMAL", 3, 38L, null, null, 1, true, true));
            this.typeMap.put(new Integer(8), new GenericTypeDescriptor("DOUBLE", 8, 38L, null, null, 1, false, false));
            this.typeMap.put(new Integer(6), new GenericTypeDescriptor("FLOAT", 6, 38L, null, null, 1, false, false));
            this.typeMap.put(new Integer(4), new GenericTypeDescriptor("INTEGER", 4, 10L, null, null, 1, false, false));
            this.typeMap.put(new Integer(-4), new GenericTypeDescriptor("LONGVARBINARY", -4, Integer.MAX_VALUE, "0x", null, 1, true, false));
            this.typeMap.put(new Integer(-1), new GenericTypeDescriptor("LONGVARCHAR", -1, Integer.MAX_VALUE, "'", "'", 1, true, false));
            this.typeMap.put(new Integer(2), new GenericTypeDescriptor("NUMERIC", 2, 38L, null, null, 1, true, true));
            this.typeMap.put(new Integer(7), new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
            this.typeMap.put(new Integer(5), new GenericTypeDescriptor("SMALLINT", 5, 5L, null, null, 1, false, false));
            this.typeMap.put(new Integer(92), new GenericTypeDescriptor("TIME", 92, 23L, "'", "'", 1, false, false));
            this.typeMap.put(new Integer(93), new GenericTypeDescriptor("TIMESTAMP", 93, 23L, "'", "'", 1, false, false));
            this.typeMap.put(new Integer(-6), new GenericTypeDescriptor("TINYINT", -6, 3L, null, null, 1, false, false));
            this.typeMap.put(new Integer(-3), new GenericTypeDescriptor("VARBINARY", -3, 8000L, null, null, 1, true, false));
            this.typeMap.put(new Integer(12), new GenericTypeDescriptor("VARCHAR", 12, 8000L, "'", "'", 1, true, false));
        } else {
            DatabaseMetaData dbmd = this.con.getMetaData();
            ResultSet rs = dbmd.getTypeInfo();
            while (rs.next()) {
                GenericTypeDescriptor td = new GenericTypeDescriptor(rs);
                this.typeMap.put(new Integer(td.getDataType()), td);
            }
            rs.close();
        }
    }

    protected void createProfileFunctionMap() {
        this.profileFunctionMap = new HashMap<String, ProfileFunctionDescriptor>();
        this.profileFunctionMap.put("BIGINT", new ProfileFunctionDescriptor("BIGINT", -5, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("BINARY", new ProfileFunctionDescriptor("BINARY", -2, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("BIT", new ProfileFunctionDescriptor("BIT", -7, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("BLOB", new ProfileFunctionDescriptor("BLOB", 2004, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("CHAR", new ProfileFunctionDescriptor("CHAR", 1, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("CLOB", new ProfileFunctionDescriptor("CLOB", 2005, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("DATE", new ProfileFunctionDescriptor("DATE", 91, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("DECIMAL", new ProfileFunctionDescriptor("DECIMAL", 3, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("DOUBLE", new ProfileFunctionDescriptor("DOUBLE", 8, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("FLOAT", new ProfileFunctionDescriptor("FLOAT", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("INTEGER", new ProfileFunctionDescriptor("INTEGER", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("LONGVARBINARY", new ProfileFunctionDescriptor("LONGVARBINARY", -4, false, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("LONGVARCHAR", new ProfileFunctionDescriptor("LONGVARCHAR", -1, false, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("NUMERIC", new ProfileFunctionDescriptor("NUMERIC", 2, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("REAL", new ProfileFunctionDescriptor("REAL", 7, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("SMALLINT", new ProfileFunctionDescriptor("SMALLINT", 5, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("TIME", new ProfileFunctionDescriptor("TIME", 92, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("TIMESTAMP", new ProfileFunctionDescriptor("TIMESTAMP", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("TINYINT", new ProfileFunctionDescriptor("TINYINT", -6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("VARBINARY", new ProfileFunctionDescriptor("VARBINARY", -3, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("VARCHAR", new ProfileFunctionDescriptor("VARCHAR", 12, true, true, true, false, true, true, true, true));
    }

    protected void println(String text) {
        this.ddl.append(text).append(EOL);
    }

    protected void print(String text) {
        this.ddl.append(text);
    }

    @Override
    public String toIdentifier(String name) {
        if (name == null) {
            return null;
        }
        return name.replace(' ', '_');
    }

    public String toQualifiedName(SQLTable t) {
        return this.toQualifiedName(t.getPhysicalName());
    }

    public String toQualifiedName(String tname) {
        String catalog = this.getTargetCatalog();
        String schema = this.getTargetSchema();
        return DDLUtils.toQualifiedName(catalog, schema, tname);
    }

    @Override
    public boolean getAllowConnection() {
        return this.allowConnection;
    }

    @Override
    public void setAllowConnection(boolean argAllowConnection) {
        this.allowConnection = argAllowConnection;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File argFile) {
        this.file = argFile;
    }

    @Override
    public Map getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map argTypeMap) {
        this.typeMap = argTypeMap;
    }

    @Override
    public Map<String, ProfileFunctionDescriptor> getProfileFunctionMap() {
        return this.profileFunctionMap;
    }

    public void setProfileFunctionMap(Map profileFunctionMap) {
        this.profileFunctionMap = profileFunctionMap;
    }

    public Connection getCon() {
        return this.con;
    }

    public void setCon(Connection argCon) {
        this.con = argCon;
    }

    @Override
    public List getWarnings() {
        return this.warnings;
    }

    @Override
    public String getTargetCatalog() {
        return this.targetCatalog;
    }

    @Override
    public void setTargetCatalog(String argTargetCatalog) {
        this.targetCatalog = argTargetCatalog;
    }

    @Override
    public String getTargetSchema() {
        return this.targetSchema;
    }

    @Override
    public void setTargetSchema(String argTargetSchema) {
        this.targetSchema = argTargetSchema;
    }

    @Override
    public String getCatalogTerm() {
        return null;
    }

    @Override
    public String getSchemaTerm() {
        return null;
    }

    protected String createPhysicalName(Map dupCheck, SQLObject so) {
        logger.debug((Object)("transform identifier source: " + so.getPhysicalName()));
        so.setPhysicalName(this.toIdentifier(so.getName()));
        if (this.isReservedWord(so.getPhysicalName())) {
            this.warnings.add(new NameChangeWarning(so, "Name is a reserved word", so.getPhysicalName()));
            return so.getPhysicalName();
        }
        int pointIndex = so.getPhysicalName().lastIndexOf(46);
        if (!so.getName().substring(pointIndex + 1, pointIndex + 2).matches("[a-zA-Z]")) {
            this.warnings.add(new NameChangeWarning(so, "Name starts with a non-alpha character", so.getPhysicalName()));
            return so.getPhysicalName();
        }
        logger.debug((Object)("transform identifier result: " + so.getPhysicalName()));
        if (dupCheck.get(so.getPhysicalName()) == null) {
            dupCheck.put(so.getPhysicalName(), so);
        } else {
            this.warnings.add(new NameChangeWarning(so, "Duplicate Name", so.getName()));
        }
        return so.getPhysicalName();
    }

    public String createPhysicalPrimaryKeyName(Map dupCheck, SQLTable t) {
        logger.debug((Object)("getting physical primary key name, logical=" + t.getPrimaryKeyName() + ",physical=" + t.getPhysicalPrimaryKeyName()));
        String temp = null;
        temp = this.toIdentifier(t.getPrimaryKeyName());
        logger.debug((Object)("transform key identifier result: " + temp));
        t.setPhysicalPrimaryKeyName(temp);
        if (dupCheck.get(t.getPhysicalPrimaryKeyName()) == null) {
            dupCheck.put(t.getPhysicalPrimaryKeyName(), t);
        } else {
            this.warnings.add(new NameChangeWarning(t, "Duplicate Primary Key Name", t.getPrimaryKeyName()));
        }
        return t.getPhysicalPrimaryKeyName();
    }

    @Override
    public String makeDropTableSQL(String table) {
        return "DROP TABLE " + this.toQualifiedName(table);
    }

    @Override
    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "ALTER TABLE " + this.toQualifiedName(fkTable) + " DROP FOREIGN KEY " + fkName;
    }

    @Override
    public List<DDLStatement> getDdlStatements() {
        return this.ddlStatements;
    }

    @Override
    public void dropPrimaryKey(SQLTable t) {
        this.print("ALTER TABLE " + this.toQualifiedName(t.getName()) + " DROP PRIMARY KEY " + t.getPrimaryKeyName());
        this.endStatement(DDLStatement.StatementType.DROP, t);
    }

    @Override
    public void addPrimaryKey(SQLTable t) throws ArchitectException {
        HashMap colNameMap = new HashMap();
        StringBuffer sqlStatement = new StringBuffer();
        boolean first = true;
        sqlStatement.append("ALTER TABLE " + this.toQualifiedName(t.getName()) + " ADD PRIMARY KEY (");
        for (SQLColumn c : t.getColumns()) {
            if (!c.isPrimaryKey()) continue;
            if (!first) {
                sqlStatement.append(",");
            } else {
                first = false;
            }
            sqlStatement.append(this.createPhysicalName(colNameMap, c));
        }
        sqlStatement.append(")");
        if (!first) {
            this.print(sqlStatement.toString());
            this.endStatement(DDLStatement.StatementType.CREATE, t);
        }
    }

    @Override
    public String caseWhenNull(String expression, String then) {
        StringBuffer sql = new StringBuffer();
        sql.append("CASE WHEN ");
        sql.append(expression);
        sql.append(" IS NULL THEN ");
        sql.append(then);
        sql.append(" END");
        return sql.toString();
    }

    @Override
    public String getStringLengthSQLFunctionName(String expression) {
        return "LENGTH(" + expression + ")";
    }

    @Override
    public String getAverageSQLFunctionName(String expression) {
        return "AVG(" + expression + ")";
    }

    @Override
    public void addIndex(SQLIndex index) throws ArchitectException {
        if (index.getType() == SQLIndex.IndexType.STATISTIC) {
            return;
        }
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        if (index.getType() == SQLIndex.IndexType.CLUSTERED) {
            this.print("CLUSTERED ");
        }
        this.print("INDEX ");
        this.print(this.toQualifiedName(index.getName()));
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParentTable()));
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren()) {
            if (!first) {
                this.print(", ");
            }
            this.print(c.getName());
            first = false;
        }
        this.print(" )\n");
        this.endStatement(DDLStatement.StatementType.CREATE, index);
    }
}

