/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DB2DDLGenerator;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.OracleDDLGenerator;
import ca.sqlpower.architect.ddl.PostgresDDLGenerator;
import ca.sqlpower.architect.ddl.SQLServerDDLGenerator;
import ca.sqlpower.architect.swingui.ASUtils;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLUtils {
    private static final Logger logger = Logger.getLogger(DDLUtils.class);

    private DDLUtils() {
    }

    public static String toQualifiedName(SQLTable table) {
        return DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName());
    }

    public static String toQualifiedName(String catalog, String schema, String name) {
        StringBuffer qualName = new StringBuffer();
        if (catalog != null && catalog.length() > 0) {
            qualName.append(catalog);
            qualName.append(".");
        }
        if (schema != null && schema.length() > 0) {
            qualName.append(schema);
            qualName.append(".");
        }
        qualName.append(name);
        logger.debug((Object)String.format("%s.%s.%s -> %s", catalog, schema, name, qualName));
        return qualName.toString();
    }

    public static String toQualifiedName(String catalog, String schema, String name, String openQuote, String closeQuote) {
        String newCatalog = null;
        String newSchema = null;
        String newName = null;
        if (catalog != null && catalog.length() > 0) {
            newCatalog = openQuote != null && openQuote.length() > 0 && closeQuote != null && closeQuote.length() > 0 ? String.valueOf(openQuote) + catalog + closeQuote : (openQuote != null && openQuote.length() > 0 ? String.valueOf(openQuote) + catalog : catalog);
        }
        if (schema != null && schema.length() > 0) {
            newSchema = openQuote != null && openQuote.length() > 0 && closeQuote != null && closeQuote.length() > 0 ? String.valueOf(openQuote) + schema + closeQuote : (openQuote != null && openQuote.length() > 0 ? String.valueOf(openQuote) + schema : schema);
        }
        newName = openQuote != null && openQuote.length() > 0 && closeQuote != null && closeQuote.length() > 0 ? String.valueOf(openQuote) + name + closeQuote : (openQuote != null && openQuote.length() > 0 ? String.valueOf(openQuote) + name : name);
        return DDLUtils.toQualifiedName(newCatalog, newSchema, newName);
    }

    public static Vector<ASUtils.LabelValueBean> getDDLTypes() {
        Vector<ASUtils.LabelValueBean> dbTypeList = new Vector<ASUtils.LabelValueBean>();
        dbTypeList.add(ASUtils.lvb("SQL 92", GenericDDLGenerator.class));
        dbTypeList.add(ASUtils.lvb("DB2", DB2DDLGenerator.class));
        dbTypeList.add(ASUtils.lvb("Oracle 8i/9i", OracleDDLGenerator.class));
        dbTypeList.add(ASUtils.lvb("PostgreSQL", PostgresDDLGenerator.class));
        dbTypeList.add(ASUtils.lvb("SQLServer 2000", SQLServerDDLGenerator.class));
        return dbTypeList;
    }

    public static DDLGenerator createDDLGenerator(ArchitectDataSource ads) throws InstantiationException, IllegalAccessException {
        Class generatorClass = (Class)ArchitectUtils.getDriverDDLGeneratorMap().get(ads.getDriverClass());
        if (generatorClass == null) {
            return null;
        }
        return (DDLGenerator)generatorClass.newInstance();
    }
}

